# Документация EleganPlot 📚

Добро пожаловать в документацию библиотеки **EleganPlot**! Здесь вы найдёте подробные руководства по всем возможностям библиотеки.

## 📖 Полные руководства

### [Руководство по эффектам свечения (glow_line)](GLOW_LINE_GUIDE.md)
![Пример свечения](images/Glow.png)

Узнайте, как создавать линии с эффектом свечения:
- Основные параметры
- Функции затухания (linear, exponential, gaussian и др.)
- Режимы прозрачности
- Цветовые схемы
- Примеры использования

---

### [Руководство по градиентным фонам (gradient_subplots)](GRADIENT_BACKGROUND_GUIDE.md)
![Градиентный фон](images/test_gradient_bg.png)

Создание графиков с красивым градиентным фоном:
- Основное использование
- Настройка параметров
- Готовые цветовые схемы
- Комбинирование с другими методами
- Сохранение графиков

---

### [Система кастомных методов](CUSTOM_METHODS.md)
![Кастомные методы](images/gradient_bar.png)

Расширение функциональности EleganPlot:
- Использование готовых методов
- Создание собственных методов
- Декораторы и реестр методов
- Параметры gradient_fill
- Лучшие практики

---

### [Руководство по комбинированию методов](COMBINATION_GUIDE.md)
![Комбинирование методов](images/demo_output.png)

Комбинация различных эффектов для создания сложных визуализаций:
- Базовое комбинирование glow_line + gradient_plot
- Принципы комбинирования
- Популярные комбинации
- Создание кастомных комбинированных методов
- Оптимизация производительности

---

## 🎨 Галерея визуализаций

### [Галерея примеров](GALLERY.md)

Коллекция примеров визуализаций с кодом:
- Эффекты свечения (Glow)
- Градиентные фоны
- Градиентные заливки
- Комбинированные эффекты
- Готовые цветовые схемы

---

## 🚀 Быстрые справки

### [Быстрый старт: gradient_subplots](GRADIENT_SUBPLOTS_QUICKSTART.md)
![Примеры](images/Simple.png)

Краткая шпаргалка по использованию gradient_subplots:
- Базовое использование
- Кастомизация цветов
- Все параметры
- Комбинация с другими методами
- Готовые цветовые схемы

---

### [Итоги: gradient_subplots](GRADIENT_SUBPLOTS_SUMMARY.md)

Сводка возможностей метода gradient_subplots:
- Что было сделано
- Основное использование
- Созданные файлы
- Готовые цветовые схемы
- Статус проекта

---

## 📊 Примеры изображений

В папке `images/` находятся примеры визуализаций:

| Изображение | Описание |
|-------------|----------|
| `Glow.png` | Пример эффекта свечения линии |
| `test_gradient_bg.png` | График с градиентным фоном |
| `gradient_bar.png` | Градиентная заливка столбчатых диаграмм |
| `gradien_bar.png` | Несколько кривых с градиентом |
| `gradien_bar_ru.png` | Пример с русскими подписями |
| `demo_output.png` | Комбинация различных методов |
| `Simple.png` | Простой пример использования |

---

## 🔗 Быстрая навигация

### По темам

**Эффекты:**
- [Эффект свечения (glow_line)](GLOW_LINE_GUIDE.md)
- [Градиентные заливки (gradient_plot)](CUSTOM_METHODS.md#параметры-gradient_fill)
- [Градиентные фоны (gradient_subplots)](GRADIENT_BACKGROUND_GUIDE.md)

**Методы:**
- [Кастомные методы](CUSTOM_METHODS.md)
- [Комбинирование методов](COMBINATION_GUIDE.md)

**Справки:**
- [Быстрый старт: gradient_subplots](GRADIENT_SUBPLOTS_QUICKSTART.md)
- [Итоги: gradient_subplots](GRADIENT_SUBPLOTS_SUMMARY.md)

---

## 🎯 Рекомендуемый порядок изучения

1. **Начинающие:**
   - [Быстрый старт: gradient_subplots](GRADIENT_SUBPLOTS_QUICKSTART.md)
   - [Руководство по градиентным фонам](GRADIENT_BACKGROUND_GUIDE.md)

2. **Продвинутые:**
   - [Руководство по эффектам свечения](GLOW_LINE_GUIDE.md)
   - [Система кастомных методов](CUSTOM_METHODS.md)

3. **Эксперты:**
   - [Руководство по комбинированию методов](COMBINATION_GUIDE.md)
   - Создание собственных методов и расширений

---

## 💡 Полезные ссылки

- [README проекта](../README.md)
- [Примеры кода](../examples/)
- [Исходный код](../src/eleganplot/)
- [Структура документации](STRUCTURE.md) - описание всех файлов

---

**EleganPlot** — делаем визуализацию данных элегантной! ✨

