"""Utilities for implementing choices."""

from nautobot.circuits.choices import CircuitTerminationSideChoices
from nautobot.core.choices import (
    ButtonActionColorChoices,
    ButtonActionIconChoices,
    ChoiceSet,
    ColorChoices,
    unpack_grouped_choices,
)
from nautobot.dcim.choices import (
    CableLengthUnitChoices,
    CableTypeChoices,
    ConsolePortTypeChoices,
    DeviceFaceChoices,
    DeviceRedundancyGroupFailoverStrategyChoices,
    InterfaceModeChoices,
    InterfaceRedundancyGroupProtocolChoices,
    InterfaceTypeChoices,
    PortTypeChoices,
    PowerFeedBreakerPoleChoices,
    PowerFeedPhaseChoices,
    PowerFeedStatusChoices,
    PowerFeedSupplyChoices,
    PowerFeedTypeChoices,
    PowerOutletFeedLegChoices,
    PowerOutletTypeChoices,
    PowerPanelTypeChoices,
    PowerPathChoices,
    PowerPortTypeChoices,
    RackDimensionUnitChoices,
    RackElevationDetailRenderChoices,
    RackTypeChoices,
    RackWidthChoices,
    SoftwareImageFileHashingAlgorithmChoices,
    SoftwareImageFileStatusChoices,
    SoftwareVersionStatusChoices,
    SubdeviceRoleChoices,
)
from nautobot.extras.choices import (
    BannerClassChoices,
    ButtonClassChoices,
    CustomFieldFilterLogicChoices,
    CustomFieldTypeChoices,
    CustomLinkButtonClassChoices,
    DynamicGroupOperatorChoices,
    JobExecutionType,
    JobResultStatusChoices,
    LogLevelChoices,
    ObjectChangeActionChoices,
    ObjectChangeEventContextChoices,
    RelationshipRequiredSideChoices,
    RelationshipSideChoices,
    RelationshipTypeChoices,
    SecretsGroupAccessTypeChoices,
    SecretsGroupSecretTypeChoices,
    WebhookHttpMethodChoices,
)
from nautobot.ipam.choices import (
    IPAddressRoleChoices,
    IPAddressTypeChoices,
    IPAddressVersionChoices,
    PrefixTypeChoices,
    ServiceProtocolChoices,
)

__all__ = (
    "BannerClassChoices",
    "ButtonActionColorChoices",
    "ButtonActionIconChoices",
    "ButtonClassChoices",
    "CableLengthUnitChoices",
    "CableTypeChoices",
    "ChoiceSet",
    "CircuitTerminationSideChoices",
    "ColorChoices",
    "ConsolePortTypeChoices",
    "CustomFieldFilterLogicChoices",
    "CustomFieldTypeChoices",
    "CustomLinkButtonClassChoices",
    "DeviceFaceChoices",
    "DeviceRedundancyGroupFailoverStrategyChoices",
    "DynamicGroupOperatorChoices",
    "IPAddressRoleChoices",
    "IPAddressTypeChoices",
    "IPAddressVersionChoices",
    "InterfaceModeChoices",
    "InterfaceRedundancyGroupProtocolChoices",
    "InterfaceTypeChoices",
    "JobExecutionType",
    "JobResultStatusChoices",
    "LogLevelChoices",
    "ObjectChangeActionChoices",
    "ObjectChangeEventContextChoices",
    "PortTypeChoices",
    "PowerFeedBreakerPoleChoices",
    "PowerFeedPhaseChoices",
    "PowerFeedStatusChoices",
    "PowerFeedSupplyChoices",
    "PowerFeedTypeChoices",
    "PowerOutletFeedLegChoices",
    "PowerOutletTypeChoices",
    "PowerPanelTypeChoices",
    "PowerPathChoices",
    "PowerPortTypeChoices",
    "PrefixTypeChoices",
    "RackDimensionUnitChoices",
    "RackElevationDetailRenderChoices",
    "RackTypeChoices",
    "RackWidthChoices",
    "RelationshipRequiredSideChoices",
    "RelationshipSideChoices",
    "RelationshipTypeChoices",
    "SecretsGroupAccessTypeChoices",
    "SecretsGroupSecretTypeChoices",
    "ServiceProtocolChoices",
    "SoftwareImageFileHashingAlgorithmChoices",
    "SoftwareImageFileStatusChoices",
    "SoftwareVersionStatusChoices",
    "SubdeviceRoleChoices",
    "WebhookHttpMethodChoices",
    "unpack_grouped_choices",
)
