"""Nautobot Jobs API."""

from nautobot.core.celery import register_jobs
from nautobot.core.celery.encoders import NautobotKombuJSONEncoder
from nautobot.core.jobs import GitRepositoryDryRun, GitRepositorySync
from nautobot.extras.jobs import (
    BaseJob,
    BooleanVar,
    ChoiceVar,
    DatabaseFileField,
    DryRunVar,
    enqueue_job_hooks,
    FileVar,
    get_job,
    get_jobs,
    IntegerVar,
    IPAddressVar,
    IPAddressWithMaskVar,
    IPNetworkVar,
    is_job,
    is_variable,
    Job,
    JobButtonReceiver,
    JobHookReceiver,
    JSONVar,
    MultiChoiceVar,
    MultiObjectVar,
    ObjectVar,
    RunJobTaskFailed,
    ScriptVariable,
    StringVar,
    TextVar,
)

__all__ = (
    "BaseJob",
    "BooleanVar",
    "ChoiceVar",
    "DatabaseFileField",
    "DryRunVar",
    "FileVar",
    "GitRepositoryDryRun",
    "GitRepositorySync",
    "IPAddressVar",
    "IPAddressWithMaskVar",
    "IPNetworkVar",
    "IntegerVar",
    "JSONVar",
    "Job",
    "JobButtonReceiver",
    "JobHookReceiver",
    "MultiChoiceVar",
    "MultiObjectVar",
    "NautobotKombuJSONEncoder",
    "ObjectVar",
    "RunJobTaskFailed",
    "ScriptVariable",
    "StringVar",
    "TextVar",
    "enqueue_job_hooks",
    "get_job",
    "get_jobs",
    "is_job",
    "is_variable",
    "register_jobs",
)
