# Generated by Django 3.2.16 on 2022-10-28 17:25

import uuid

import django.core.serializers.json
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers

import nautobot.core.models.fields
import nautobot.extras.models.mixins
import nautobot.extras.models.statuses


class Migration(migrations.Migration):
    dependencies = [
        ("extras", "0051_add_job_task_queues"),
        ("dcim", "0017_locationtype_nestable"),
    ]

    operations = [
        migrations.AddField(
            model_name="device",
            name="device_redundancy_group_priority",
            field=models.PositiveSmallIntegerField(
                blank=True, null=True, validators=[django.core.validators.MinValueValidator(1)]
            ),
        ),
        migrations.CreateModel(
            name="DeviceRedundancyGroup",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                (
                    "slug",
                    nautobot.core.models.fields.AutoSlugField(
                        blank=True, max_length=100, populate_from="name", unique=True
                    ),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("failover_strategy", models.CharField(blank=True, max_length=50)),
                ("comments", models.TextField(blank=True)),
                (
                    "secrets_group",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="extras.secretsgroup",
                    ),
                ),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="dcim_deviceredundancygroup_related",
                        to="extras.status",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "ordering": ("name",),
            },
            bases=(
                models.Model,
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
            ),
        ),
        migrations.AddField(
            model_name="device",
            name="device_redundancy_group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="members",
                to="dcim.deviceredundancygroup",
            ),
        ),
    ]
