# Generated by Django 3.1.14 on 2022-03-19 23:21

from django.db import migrations

from nautobot.extras.management import clear_status_choices, populate_status_choices


def populate_device_redundancy_group_status(apps, schema_editor):
    """Create/link default Status records for the DeviceRedundancyGroup content-type."""
    populate_status_choices(apps, schema_editor, models=["dcim.DeviceRedundancyGroup"])


def clear_device_redundancy_group_status(apps, schema_editor):
    """De-link/delete all Status records from the DeviceRedundancyGroup content-type."""
    clear_status_choices(apps, schema_editor, models=["dcim.DeviceRedundancyGroup"])


class Migration(migrations.Migration):
    dependencies = [
        ("dcim", "0018_device_redundancy_group"),
    ]

    operations = [
        migrations.RunPython(populate_device_redundancy_group_status, clear_device_redundancy_group_status),
    ]
