# Generated by Django 4.2.15 on 2024-09-19 21:07

import uuid

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion

import nautobot.core.models.fields
import nautobot.extras.models.mixins
import nautobot.extras.models.statuses


class Migration(migrations.Migration):
    dependencies = [
        ("tenancy", "0009_update_all_charfields_max_length_to_255"),
        ("ipam", "0049_vrf_data_migration"),
        ("extras", "0119_remove_task_queues_from_job_and_queue_from_scheduled_job"),
        ("dcim", "0062_module_data_migration"),
    ]

    operations = [
        migrations.CreateModel(
            name="InterfaceVDCAssignment",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                    ),
                ),
                (
                    "interface",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="virtual_device_context_assignments",
                        to="dcim.interface",
                    ),
                ),
            ],
            options={
                "ordering": ["virtual_device_context", "interface"],
            },
        ),
        migrations.CreateModel(
            name="VirtualDeviceContext",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("identifier", models.PositiveSmallIntegerField(blank=True, null=True)),
                ("description", models.CharField(blank=True, max_length=255)),
                (
                    "device",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="virtual_device_contexts",
                        to="dcim.device",
                    ),
                ),
                (
                    "interfaces",
                    models.ManyToManyField(
                        blank=True,
                        related_name="virtual_device_contexts",
                        through="dcim.InterfaceVDCAssignment",
                        to="dcim.interface",
                    ),
                ),
                (
                    "primary_ip4",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="ip4_vdcs",
                        to="ipam.ipaddress",
                    ),
                ),
                (
                    "primary_ip6",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="ip6_vdcs",
                        to="ipam.ipaddress",
                    ),
                ),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        on_delete=django.db.models.deletion.PROTECT, to="extras.status"
                    ),
                ),
                (
                    "role",
                    nautobot.extras.models.roles.RoleField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="extras.role",
                    ),
                ),
                (
                    "tags",
                    nautobot.core.models.fields.TagsField(through="extras.TaggedItem", to="extras.Tag"),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="virtual_device_contexts",
                        to="tenancy.tenant",
                    ),
                ),
            ],
            options={
                "ordering": ("name",),
                "unique_together": {("device", "name"), ("device", "identifier")},
            },
            bases=(
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
                models.Model,
            ),
        ),
        migrations.AddField(
            model_name="interfacevdcassignment",
            name="virtual_device_context",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="interface_assignments",
                to="dcim.virtualdevicecontext",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="interfacevdcassignment",
            unique_together={("virtual_device_context", "interface")},
        ),
    ]
