# Generated by Django 4.2.19 on 2025-03-18 17:22

import uuid

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion

import nautobot.core.models.fields
import nautobot.extras.models.mixins


class Migration(migrations.Migration):
    dependencies = [
        ("extras", "0122_add_graphqlquery_owner_content_type"),
        ("dcim", "0069_softwareimagefile_external_integration"),
    ]

    operations = [
        migrations.AddField(
            model_name="modulebay",
            name="requires_first_party_modules",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="modulebaytemplate",
            name="requires_first_party_modules",
            field=models.BooleanField(default=False),
        ),
        migrations.CreateModel(
            name="ModuleFamily",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                ("description", models.CharField(blank=True, max_length=255)),
                ("tags", nautobot.core.models.fields.TagsField(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name_plural": "module families",
                "ordering": ["name"],
            },
            bases=(
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
                models.Model,
            ),
        ),
        migrations.AddField(
            model_name="modulebay",
            name="module_family",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="module_bays",
                to="dcim.modulefamily",
            ),
        ),
        migrations.AddField(
            model_name="modulebaytemplate",
            name="module_family",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="module_bay_templates",
                to="dcim.modulefamily",
            ),
        ),
        migrations.AddField(
            model_name="moduletype",
            name="module_family",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="module_types",
                to="dcim.modulefamily",
            ),
        ),
    ]
