# Generated by Django 3.2.18 on 2023-03-14 18:07

import uuid

from django.db import migrations, models
import django.db.models.deletion

import nautobot.extras.models.mixins


class Migration(migrations.Migration):
    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("extras", "0056_objectchange_add_reverse_time_idx"),
    ]

    operations = [
        migrations.AddField(
            model_name="job",
            name="is_job_button_receiver",
            field=models.BooleanField(default=False, editable=False),
        ),
        migrations.CreateModel(
            name="JobButton",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(max_length=100, unique=True)),
                ("text", models.CharField(max_length=500)),
                ("weight", models.PositiveSmallIntegerField(default=100)),
                ("group_name", models.CharField(blank=True, max_length=50)),
                ("button_class", models.CharField(default="default", max_length=30)),
                ("confirmation", models.BooleanField(default=True)),
                ("content_types", models.ManyToManyField(related_name="job_buttons", to="contenttypes.ContentType")),
                (
                    "job",
                    models.ForeignKey(
                        limit_choices_to={"is_job_button_receiver": True},
                        on_delete=django.db.models.deletion.CASCADE,
                        to="extras.job",
                    ),
                ),
            ],
            options={
                "ordering": ["group_name", "weight", "name"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.NotesMixin),
        ),
    ]
