# Generated by Django 3.2.24 on 2024-02-27 16:09

from django.db import migrations

import nautobot.extras.management


def populate_default_status_and_role_choices_for_contact_associations(apps, schema_editor):
    """Create/link default Status and Role records for ContactAssociation content-type"""
    nautobot.extras.management.populate_status_choices(apps, schema_editor, models=["extras.ContactAssociation"])
    nautobot.extras.management.populate_role_choices(apps, schema_editor, models=["extras.ContactAssociation"])


def clear_default_status_and_role_choices_for_contact_associations(apps, schema_editor):
    """De-link/delete all Status and Role records from the ContactAssociation content-type."""
    nautobot.extras.management.clear_status_choices(apps, schema_editor, models=["extras.ContactAssociation"])
    nautobot.extras.management.clear_role_choices(apps, schema_editor, models=["extras.ContactAssociation"])


class Migration(migrations.Migration):
    dependencies = [
        ("contenttypes", "0001_initial"),
        ("extras", "0105_update_all_charfields_max_length_to_255"),
    ]

    operations = [
        migrations.RunPython(
            populate_default_status_and_role_choices_for_contact_associations,
            clear_default_status_and_role_choices_for_contact_associations,
        ),
    ]
