# Generated by Django 4.2.13 on 2024-05-30 17:31

import uuid

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion

import nautobot.core.models.fields
import nautobot.extras.models.groups
import nautobot.extras.models.mixins
import nautobot.extras.utils


class Migration(migrations.Migration):
    dependencies = [
        ("tenancy", "0009_update_all_charfields_max_length_to_255"),
        ("contenttypes", "0002_remove_content_type_name"),
        ("extras", "0108_jobbutton_enabled"),
    ]

    operations = [
        migrations.AddField(
            model_name="dynamicgroup",
            name="group_type",
            field=models.CharField(default="dynamic-filter", max_length=16),
        ),
        migrations.AddField(
            model_name="dynamicgroup",
            name="tags",
            field=nautobot.core.models.fields.TagsField(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.AddField(
            model_name="dynamicgroup",
            name="tenant",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="managed_dynamic_groups",
                to="tenancy.tenant",
            ),
        ),
        migrations.AlterField(
            model_name="dynamicgroup",
            name="content_type",
            field=models.ForeignKey(
                limit_choices_to=nautobot.extras.utils.FeatureQuery("dynamic_groups"),
                on_delete=django.db.models.deletion.CASCADE,
                related_name="dynamic_groups",
                to="contenttypes.contenttype",
            ),
        ),
        migrations.CreateModel(
            name="StaticGroupAssociation",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("associated_object_id", models.UUIDField(db_index=True)),
                (
                    "associated_object_type",
                    models.ForeignKey(
                        limit_choices_to=nautobot.extras.utils.FeatureQuery("dynamic_groups"),
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="static_group_associations",
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "dynamic_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="static_group_associations",
                        to="extras.dynamicgroup",
                    ),
                ),
            ],
            options={
                "ordering": ["dynamic_group", "associated_object_type", "associated_object_id"],
                "indexes": [
                    models.Index(fields=["dynamic_group", "associated_object_id"], name="extras_sga_double"),
                    models.Index(
                        fields=["associated_object_type_id", "associated_object_id"],
                        name="extras_sga_associated_object",
                    ),
                ],
                "unique_together": {("dynamic_group", "associated_object_type", "associated_object_id")},
            },
            bases=(
                nautobot.extras.models.mixins.NotesMixin,
                models.Model,
            ),
            managers=[
                ("objects", nautobot.extras.models.groups.StaticGroupAssociationDefaultManager()),
                ("all_objects", nautobot.extras.models.groups.StaticGroupAssociationManager()),
            ],
        ),
    ]
