# Generated by Django 3.2.23 on 2024-01-03 17:59
import uuid

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ("dcim", "0052_fix_interface_redundancy_group_created"),
        ("ipam", "0039_alter_ipaddresstointerface_ip_address"),
    ]

    operations = [
        migrations.CreateModel(
            name="VLANLocationAssignment",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="vlan_assignments", to="dcim.location"
                    ),
                ),
                (
                    "vlan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="location_assignments", to="ipam.vlan"
                    ),
                ),
            ],
            options={
                "unique_together": {("vlan", "location")},
                "ordering": ["vlan", "location"],
            },
        ),
        migrations.CreateModel(
            name="PrefixLocationAssignment",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="prefix_assignments",
                        to="dcim.location",
                    ),
                ),
                (
                    "prefix",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="location_assignments",
                        to="ipam.prefix",
                    ),
                ),
            ],
            options={
                "unique_together": {("prefix", "location")},
                "ordering": ["prefix", "location"],
            },
        ),
        migrations.AddField(
            model_name="prefix",
            name="locations",
            field=models.ManyToManyField(
                blank=True, related_name="prefixes", through="ipam.PrefixLocationAssignment", to="dcim.Location"
            ),
        ),
        migrations.AddField(
            model_name="vlan",
            name="locations",
            field=models.ManyToManyField(
                blank=True, related_name="vlans", through="ipam.VLANLocationAssignment", to="dcim.Location"
            ),
        ),
    ]
