# Generated by Django 3.2.16 on 2022-11-23 12:27

from django.db import migrations

from nautobot.extras.utils import migrate_role_data


def migrate_data_from_legacy_role_to_new_role(apps, schema):
    """Migrate DeviceRole data from legacy_role to new_role."""
    model = apps.get_model("virtualization", "VirtualMachine")
    from_role_model = apps.get_model("dcim", "DeviceRole")
    to_role_model = apps.get_model("extras", "Role")
    migrate_role_data(
        model_to_migrate=model,
        from_role_field_name="legacy_role",
        from_role_model=from_role_model,
        to_role_field_name="new_role",
        to_role_model=to_role_model,
    )


def reverse_role_data_migrate(apps, schema):
    """Migrate DeviceRole data from new_role to legacy_role."""
    model = apps.get_model("virtualization", "VirtualMachine")
    from_role_model = apps.get_model("extras", "Role")
    to_role_model = apps.get_model("dcim", "DeviceRole")
    migrate_role_data(
        model_to_migrate=model,
        from_role_field_name="new_role",
        from_role_model=from_role_model,
        to_role_field_name="legacy_role",
        to_role_model=to_role_model,
    )


class Migration(migrations.Migration):
    dependencies = [
        ("dcim", "0001_initial_part_1"),
        ("extras", "0061_role_and_alter_status"),
        ("virtualization", "0012_alter_virtualmachine_role_add_new_role"),
    ]

    operations = [
        migrations.RunPython(migrate_data_from_legacy_role_to_new_role, reverse_role_data_migrate),
    ]
