# AI-Mem Workspace Configuration

## Project Information
- Workspace: ai-mem
- Shared memory enabled: Yes
- Templates: use cookiecutter for *-template directories
- Git repository: ai-mem\n- Current branch: main\n

## Two main Roots
- claude-dot-md-template - these have agents, commands and other claude code artifacts - they are cookiecutter artifacts and tools for this concern
- shared-thoughts-template - these have the new thoughts constructs that are a main focus of implementations for this project see the current implementation for the latest notes on how to extend this.

## Memory Management
- Use `ai-mem sync` to synchronize with shared memory
- Use `ai-mem status` to check workspace status
- Use `ai-mem search` to find content across memory

## Shared Thoughts
Access team thoughts via: @thoughts/shared/



# AI Memory Integration

This project uses AI-Mem for memory management across repositories.

## Available Repositories
- ai-mem: C:\Users\vaski\projects\ai-mem\thoughts
- agent-spy: No thoughts found
- agent-zero: No thoughts found
- agenticinsights.com: No thoughts found
- ai-mem: C:\Users\vaski\projects\ai-mem\thoughts
- claude-code-docs: No thoughts found
- codebase-context-site: No thoughts found
- codebase-context-spec: No thoughts found
- continuous-image-gen: No thoughts found
- dotcontext: No thoughts found
- fbotsimple: No thoughts found
- killerapp: No thoughts found
- learn-semver: No thoughts found
- ocr: No thoughts found
- ai-prompts: No thoughts found
- vm-sdk-js: No thoughts found
- vmms: No thoughts found
- orchestr8: No thoughts found
- pipecat: No thoughts found
- pipecat-examples: No thoughts found
- pipecat-flows: No thoughts found
- resume-generator: No thoughts found
- UI-TARS-desktop: No thoughts found
- vaskin-context: No thoughts found
- voice-ui-kit: No thoughts found
- voicefuse-mvp: No thoughts found

## Memory Commands
- `/setup-memory` - Configure AI memory for this project
- `/browse-memories` - Search and explore thoughts across repositories
- `ai-mem search "query"` - Full-text search across all memories
- `ai-mem quick-start --web` - Launch visual memory browser
- `ai-mem dashboard` - Open web interface

## Shared Thoughts Location
Shared thoughts: `C:\Users\vaski\ai-mem-shared`

## Workflow Integration  
- Research documents: `thoughts/shared/research/`
- Implementation plans: `thoughts/shared/plans/` 
- PR discussions: `thoughts/shared/prs/`
- User notes: `thoughts/killerapp/`

## Quick Start
Run `ai-mem quick-start --web` to set up AI-Mem and launch the visual interface.
