# mem8 - Memory Management for the Orchestr8 Ecosystem

A production-ready memory management platform for the orchestr8 ecosystem with CLI, API, and web interface for team collaboration with shared thoughts.

## 🎯 Overview

**Current Status: Production Ready (Phase 3 Complete)**

mem8 is a comprehensive platform providing:
- **💻 Advanced CLI** - Full workspace management with Windows UTF-8 support and rich UI
- **🚀 FastAPI Backend** - Production-grade API with PostgreSQL, authentication, and real-time capabilities  
- **🖥️ Terminal Web UI** - Stunning retro interface with live collaboration features
- **🎯 Orchestr8 Integration** - Seamless integration with orchestr8 ecosystem and o8 CLI

## ✅ Current Implementation Status

### Phase 1: CLI Foundation ✅ COMPLETE
- **Rich CLI Interface** - Click framework with comprehensive Windows support
- **Template Management** - 3 cookiecutter templates (claude-config, thoughts-repo, full)
- **Core Commands** - init, sync, search, status, doctor, team, deploy
- **Data Protection** - Sophisticated preservation of existing workspace data
- **UTF-8 Excellence** - Perfect emoji support across all Windows terminals

### Phase 2: Backend API ✅ COMPLETE  
- **FastAPI Application** - Modern async Python with comprehensive endpoints
- **PostgreSQL Database** - Production-grade with proper models and relationships
- **GitHub OAuth** - Complete authentication flow with JWT token management
- **API Security** - CORS, authentication middleware, protected endpoints
- **Monitoring** - Health checks, system stats, Prometheus metrics
- **Docker Ready** - Containerized deployment configuration

### Phase 3: Frontend ✅ COMPLETE
- **Next.js 15** - Modern React with App Router and TypeScript
- **Terminal Aesthetic** - Exceptional retro computing UI with scanlines and glows
- **Authentication Flow** - Seamless GitHub OAuth integration
- **Real-time Framework** - WebSocket integration ready for collaboration
- **Responsive Design** - Beautiful interface across all screen sizes

## ✨ Features

### 💻 CLI Features (Fully Working)
```bash
ai-mem init --template full      # Initialize workspace with templates
ai-mem status                    # Check workspace health  
ai-mem sync                      # Bidirectional synchronization
ai-mem search "query"            # Full-text search across thoughts
ai-mem doctor --auto-fix         # Diagnose and repair issues
```

### 🚀 API Features (Production Ready)
- **Authentication**: `/api/v1/auth/*` - Complete GitHub OAuth flow
- **Health Monitoring**: `/api/v1/health` - System health and diagnostics
- **Thoughts Management**: `/api/v1/thoughts/*` - Full CRUD operations
- **Team Management**: `/api/v1/teams/*` - Multi-tenant team support
- **Advanced Search**: `/api/v1/search/` - Full-text and semantic search
- **System Stats**: `/api/v1/system/stats` - Real-time metrics
- **Documentation**: `/docs` - Interactive OpenAPI documentation

### 🖥️ Web Interface (Stunning Terminal UI)
- **Terminal Aesthetic** - Authentic retro computing interface
- **Authentication** - Seamless GitHub login with avatar display
- **Live Dashboard** - Real-time team status and system monitoring  
- **Search Interface** - Advanced search with type selection
- **Responsive Design** - Perfect across desktop and mobile

## 🧪 Current Testing Status

### ✅ Working Without Setup
- **CLI Commands**: `ai-mem status`, `ai-mem --help`, `ai-mem doctor`
- **API Health**: `localhost:8000/api/v1/health` returns system status
- **API Docs**: `localhost:8000/docs` - Interactive OpenAPI documentation  
- **Frontend UI**: `localhost:20040` - Loads with login screen
- **System Stats**: `localhost:8000/api/v1/system/stats` - Basic metrics

### 🔐 Requires Authentication  
- **Thoughts API**: All CRUD operations require GitHub OAuth login
- **Teams API**: Team management requires authenticated user
- **Search API**: Advanced search requires user authentication
- **WebSocket**: Real-time features need authenticated connection

### 🔧 Setup Required
- **GitHub OAuth**: Configure OAuth app for authentication  
- **Database Seed**: No default data - database starts empty
- **WebSocket**: Endpoint exists but commented out (line 91 in main.py)
- **Environment Variables**: GitHub client ID/secret needed for auth flow

## 🚀 Quick Start

### Development Setup
```bash
# Clone the repository
git clone https://github.com/killerapp/ai-mem.git
cd ai-mem

# Start with Docker (recommended)
docker-compose up -d

# Or see QUICKSTART.md for detailed setup
```

### Environment Configuration
```bash
# Backend (.env)
GITHUB_CLIENT_ID=your_github_client_id
GITHUB_CLIENT_SECRET=your_github_client_secret
SECRET_KEY=your_jwt_secret_key
DATABASE_URL=postgresql://user:pass@localhost:5433/aimem

# Frontend (.env.local)
NEXT_PUBLIC_API_URL=http://localhost:8000
NEXT_PUBLIC_WS_URL=ws://localhost:8000
```

### Template Usage
```bash
# Install cookiecutter for templates
uv tool install cookiecutter

# Generate Claude configuration
cookiecutter claude-dot-md-template --config-file example-configs/claude-dot-md/default.yaml

# Generate thoughts repository  
cookiecutter shared-thoughts-template --config-file example-configs/shared-thoughts/default.yaml
```

## 🏗️ Architecture

### Tech Stack
- **Frontend**: Next.js 14, TypeScript, Tailwind CSS, Shadcn/UI
- **Backend**: FastAPI, SQLAlchemy, PostgreSQL, Redis
- **Authentication**: GitHub OAuth 2.0, JWT tokens
- **Real-time**: WebSocket connections
- **Deployment**: Docker, Docker Compose

### Project Structure
```
ai-mem/
├── frontend/                   # Next.js web interface
│   ├── app/                   # App router pages
│   │   ├── auth/             # Authentication pages
│   │   └── page.tsx          # Main terminal interface
│   ├── components/           # Reusable UI components
│   ├── hooks/               # React hooks (useAuth, useWebSocket)
│   └── lib/                 # Utilities (API client, auth manager)
├── backend/                 # FastAPI backend
│   └── src/aimem_api/      
│       ├── routers/         # API routes (auth, thoughts, teams)
│       ├── models/          # SQLAlchemy models
│       └── config.py        # Configuration management
├── claude-dot-md-template/  # Claude Code configuration template
├── shared-thoughts-template/ # Thoughts repository template
└── docs/                   # Documentation and screenshots
```

## 🎨 Terminal Interface

The web interface features a beautiful terminal aesthetic with:

- **Header Bar**: Connection status, user avatar, and logout controls
- **Sidebar**: Team status, search functionality, and quick actions  
- **Main Panel**: Command prompt simulation with recent thoughts
- **Status Bar**: Real-time system information and connection status
- **Color Scheme**: Classic green-on-black terminal with modern UI elements

### Key UI Elements
- ✅ **Connected/Disconnected** status indicators
- 👤 **User avatar** and username display  
- 🔍 **Search memories** with real-time filtering
- ⚡ **Quick actions** for new thoughts and sync operations
- 📊 **System stats** with live memory and thought counters
- 🖱️ **Interactive buttons** with terminal styling

## 📡 API Endpoints

### Authentication
- `GET /api/v1/auth/github/url` - Get GitHub OAuth URL
- `POST /api/v1/auth/github/callback` - Handle OAuth callback
- `GET /api/v1/auth/me` - Get current user info
- `POST /api/v1/auth/logout` - Logout user

### Thoughts Management  
- `GET /api/v1/thoughts` - List thoughts with filtering
- `POST /api/v1/thoughts` - Create new thought
- `GET /api/v1/thoughts/{id}` - Get specific thought
- `PUT /api/v1/thoughts/{id}` - Update thought
- `DELETE /api/v1/thoughts/{id}` - Delete thought

### Teams & Collaboration
- `GET /api/v1/teams` - List user teams
- `GET /api/v1/teams/{id}/stats` - Get team statistics  
- `POST /api/v1/sync/teams/{id}` - Sync team data

## 🔧 Configuration Examples

### Basic Developer Setup
```bash
# Generate both templates with defaults
cookiecutter claude-dot-md-template --config-file example-configs/claude-dot-md/default.yaml
cookiecutter shared-thoughts-template --config-file example-configs/shared-thoughts/default.yaml
```

### Enterprise Team Setup
```bash
# Full-featured configuration with Linear and Ralph workflows
cookiecutter claude-dot-md-template --config-file example-configs/claude-dot-md/enterprise-full.yaml
cookiecutter shared-thoughts-template --config-file example-configs/shared-thoughts/team-collaboration.yaml
```

## 🔄 Workflow Integration

### Thoughts Directory Structure
```
thoughts/
├── shared/                    # Team-wide documents
│   ├── plans/                # Implementation plans
│   ├── research/             # Research documents  
│   ├── tickets/              # Linear tickets (ENG-XXXX.md)
│   ├── prs/                  # PR descriptions
│   └── decisions/            # Technical decisions
├── {username}/               # Personal thoughts
│   ├── tickets/              # Personal ticket copies
│   ├── notes/               # Personal notes
│   └── archive/             # Archived thoughts
└── searchable/              # Unified search (auto-generated)
```

### Claude Code Integration
The system integrates seamlessly with Claude Code through:
- **Agent Definitions** - Pre-configured AI agents for development tasks
- **Command Workflows** - Automated task execution and planning
- **Memory Persistence** - Structured knowledge retention across sessions
- **Context Sharing** - Team-wide context and decision history

## 📋 Requirements

### System Requirements
- **Node.js 18+** - For frontend development
- **Python 3.11+** - For backend services
- **PostgreSQL 13+** - Primary database
- **Redis 6+** - Session and caching (optional)
- **Docker** - For containerized deployment (recommended)

### Development Tools
- **uv** - Python package manager (`curl -LsSf https://astral.sh/uv/install.sh | sh`)
- **cookiecutter** - Template engine (`uv tool install cookiecutter`)
- **git** - Version control for sync features

## 🚧 Roadmap

- [x] ✅ Web terminal interface with authentication
- [x] ✅ GitHub OAuth integration 
- [x] ✅ Real-time team collaboration
- [x] ✅ Docker development environment
- [ ] 🔄 Claude.md constructs integration (in progress)
- [ ] 🔄 Advanced search with semantic embeddings
- [ ] 🔄 Mobile-responsive terminal interface
- [ ] 🔄 Plugin system for custom integrations
- [ ] 🔄 Self-hosted deployment guides
- [ ] 🔄 Integration with more AI assistants

## 📝 License

This project is designed for AI-assisted development workflows and knowledge management.

## 🤝 Contributing

Contributions welcome! Areas for improvement:
1. **Frontend Components** - Enhance the terminal UI experience
2. **Backend APIs** - Extend functionality and performance  
3. **Authentication** - Add more OAuth providers
4. **Templates** - Create new Claude Code configurations
5. **Documentation** - Improve setup and usage guides

## 📚 Documentation

- [QUICKSTART.md](QUICKSTART.md) - Development environment setup
- [Example Configurations](example-configs/README.md) - Pre-built configuration examples
- [Claude Template](claude-dot-md-template/README.md) - Claude Code configuration details
- [Thoughts Template](shared-thoughts-template/README.md) - Thoughts repository details

---
*Built for teams using AI-assisted development with Claude Code and modern web technologies.*