# gmx_ffconv
gmx_ffconv is a semi-automated, all-atom force field converter for GROMACS.
It has been developed to be fast and user-friendly, and doesn't require users to known any programming.  
gmx_ffconv requires users to provide included topology files for the molecules they want to convert in the current and new force field, it does not generate or interpolate force field parameters.
```bash
# Usage: 
gmx_ffconv ffmap -h  
usage: gmx_ffconv ffmap [-h] -itp1 ITP1 -itp2 ITP2 -name NAME [--duplicate]
                        [--all_mappings] [--validate]
                        [--consistent_naming CONSISTENT_NAMING]

optional arguments:
  -h, --help            show this help message and exit
  -itp1 ITP1            First ITP file (path), corresponding to force field
                        used in .gro file
  -itp2 ITP2            Second ITP file (path)
  -name NAME            Name of the molecule, does not need to match itp files
  --duplicate           Skip graph matching, create a mapping where everything
                        is kept in same order. Only useful when part of the
                        coordinate file needs reordering.
  --all_mappings        Obtain all mappings, not recommended
  --validate            Carry out conversion in both directions
  --consistent_naming CONSISTENT_NAMING
                        CSV file containing atom name equivalencies in both
                        force fields 


usage: gmx_ffconv groconv [-h] -name NAME [NAME ...] -nmol NMOL [NMOL ...]  
                          -coordfile COORDFILE [-mapping_dir MAPPING_DIR]  
                          -output OUTPUT [--validate] [--norename]  

optional arguments:  
  -h, --help            show this help message and exit  
  -name NAME [NAME ...]
                        Molecule names separated by spaces  
  -nmol NMOL [NMOL ...]
                        Molecule counts separated by spaces  
  -coordfile COORDFILE  Input .gro file  
  -mapping_dir MAPPING_DIR
                        Directory containing mapping CSV files  
  -output OUTPUT        Output .gro file name  
  --validate            Generate back-converted structure  
  --norename            Do not rename the reordered gro  
```
# Installation instructions:


The recommended way of installing gmx_ffconv is with pip:
```bash
pip install gmx_ffconv 
```
 
[![PyPI version](https://img.shields.io/pypi/v/gmx_ffconv?label=PyPI)](https://pypi.org/project/gmx_ffconv/)
Alternatively
The easiest way to install gmx_ffconv is to clone the github, cd in gmx_ffconv and running
```bash
pip install . 
```
Note, it is considered good practice to perform this in a virtual environment.

Possible issues:

If the installation contains a message about installing an UNKNOWN package, please update your pip version. 



## Tips and tricks 
(1) If you are working on very large molecules, the default memory stack allocation can lead to a segfault error. This can easily be fixed by running
in the same terminal before invoking gmx ffconv.
```bash
ulimit -s unlimited
```
(2) When building a database of mappings, for example from AMBER’s Lipid21 to CHARMM36m, storing the folder with the included topology files for the new force field inside the mappings directory enables groconv to find them without having to manually provide paths.

(3) Using custom restraints: While most restraints (such as ones in the included topology files) are likely to be supported, in the case that the restraints file was generated using the old coordinate file, a new one must be generated using the new force field. Generating position restraints is easy, but for users that want to work with complex restraints that can't be easily regenerated, there is an easy fix. In the Scripts folder is included a Python script, which converts NMR restraint files (distance, dihedral and orientation) to match the new force field. The general approach consists of simply renaming atom indices using the order specified in the mapping csv.

# *Example:*

The files are provided in “Tutorial” in folder Example1 

Example 1: Small membrane 
 
A membrane containing 24 DOPE,24 DPPC,24 CHL, 6 K+, 6 Cl- and 2709 TIP3P molecules was generated by CHARMM-GUI’s Membrane builder using CHARMM36m. The target force field is AMBER (Lipid21) . The water model is kept as TIP3, and the ions are standard for the water model.  

First, mappings for each molecule must be found. These commands can be run at the same time by the use of &. 

```bash
# DPPC
gmx_ffconv ffmap -itp1 toppar_CHARMM/DPPC.itp -itp2 toppar_AMBER/PPPC.itp -name DPPC

# Cholesterol
gmx_ffconv ffmap -itp1 toppar_CHARMM/CHL1.itp -itp2 toppar_AMBER/CHL.itp -name CHL

# DOPE
gmx_ffconv ffmap -itp1 toppar_CHARMM/DOPE.itp -itp2 toppar_AMBER/OOPE.itp -name DOPE

# TIP3
gmx_ffconv ffmap -itp1 toppar_CHARMM/TIP3.itp -itp2 toppar_AMBER/TP3.itp -name TIP3P

# Potassium
gmx_ffconv ffmap -itp1 toppar_CHARMM/POT.itp -itp2 toppar_AMBER/K+.itp -name POT

# Chloride
gmx_ffconv ffmap -itp1 toppar_CHARMM/CLA.itp -itp2 toppar_AMBER/Cl-.itp -name CLA 
```

These should have generated multiple mapping files, a mapping file per molecule type named mapping_{NAME}.csv.

Now, that all mappings are obtained, the new coordinate file can be obtained via groconv
```bash
gmx_ffconv groconv -coordfile CHARMM_MEMB.gro -name DOPE DPPC CHL POT CLA TIP3P -nmol 24 24 24 6 6 2709 -output AMBER_MEMB_from_CHARMM.gro
```
We can now compare the AMBER_MEMB_from_CHARMM.gro to AMBER_MEMB_FF.gro, which will match in energy values if the conversion has been successful. This file is provided in the AMBER_REF folder with the necessary files.

# Citation 

If you find my tool useful, please cite:  
Jasmine E. Aaltonen, gmx_ffconv: A Fast, User-Friendly Semi-Automated All-Atom Force Field Converter for GROMACS, under review (2025)  
[![DOI](https://zenodo.org/badge/998544959.svg)](https://zenodo.org/badge/latestdoi/998544959)


