/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.PairwiseEquivalence;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public final class Equivalences {
    private Equivalences() {
    }

    public static Equivalence<Object> equals() {
        return Impl.EQUALS;
    }

    public static Equivalence<Object> identity() {
        return Impl.IDENTITY;
    }

    @GwtCompatible(serializable=true)
    public static <T> Equivalence<Iterable<T>> pairwise(Equivalence<? super T> elementEquivalence) {
        return new PairwiseEquivalence<T>(elementEquivalence);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Impl implements Equivalence<Object>
    {
        EQUALS{

            public boolean equivalent(@Nullable Object a2, @Nullable Object b2) {
                return a2 == null ? b2 == null : a2.equals(b2);
            }

            public int hash(@Nullable Object o2) {
                return o2 == null ? 0 : o2.hashCode();
            }
        }
        ,
        IDENTITY{

            public boolean equivalent(@Nullable Object a2, @Nullable Object b2) {
                return a2 == b2;
            }

            public int hash(@Nullable Object o2) {
                return System.identityHashCode(o2);
            }
        };

    }
}

