/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.BoolPointer;
import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.CLongPointer;
import com.googlecode.javacpp.CharPointer;
import com.googlecode.javacpp.DoublePointer;
import com.googlecode.javacpp.FloatPointer;
import com.googlecode.javacpp.FunctionPointer;
import com.googlecode.javacpp.IntPointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.LongPointer;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacpp.ShortPointer;
import com.googlecode.javacpp.SizeTPointer;
import com.googlecode.javacpp.annotation.Adapter;
import com.googlecode.javacpp.annotation.Allocator;
import com.googlecode.javacpp.annotation.ArrayAllocator;
import com.googlecode.javacpp.annotation.ByPtr;
import com.googlecode.javacpp.annotation.ByPtrPtr;
import com.googlecode.javacpp.annotation.ByPtrRef;
import com.googlecode.javacpp.annotation.ByRef;
import com.googlecode.javacpp.annotation.ByVal;
import com.googlecode.javacpp.annotation.Cast;
import com.googlecode.javacpp.annotation.Const;
import com.googlecode.javacpp.annotation.Convention;
import com.googlecode.javacpp.annotation.Function;
import com.googlecode.javacpp.annotation.Index;
import com.googlecode.javacpp.annotation.MemberGetter;
import com.googlecode.javacpp.annotation.MemberSetter;
import com.googlecode.javacpp.annotation.Name;
import com.googlecode.javacpp.annotation.Namespace;
import com.googlecode.javacpp.annotation.NoDeallocator;
import com.googlecode.javacpp.annotation.NoOffset;
import com.googlecode.javacpp.annotation.Opaque;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.Properties;
import com.googlecode.javacpp.annotation.Raw;
import com.googlecode.javacpp.annotation.ValueGetter;
import com.googlecode.javacpp.annotation.ValueSetter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
implements Closeable {
    public static final String JNI_VERSION = "JNI_VERSION_1_6";
    private static final Logger logger = Logger.getLogger(Generator.class.getName());
    private java.util.Properties properties;
    private File file;
    private PrintWriter writer;
    private PrintWriter out;
    private LinkedListRegister<String> functionDefinitions;
    private LinkedListRegister<String> functionPointers;
    private LinkedListRegister<Class> deallocators;
    private LinkedListRegister<Class> arrayDeallocators;
    private LinkedListRegister<Class> jclasses;
    private LinkedListRegister<Class> jclassesInit;
    private HashMap<Class, LinkedList<String>> members;

    public Generator(java.util.Properties properties, String filename) {
        this(properties, new File(filename));
    }

    public Generator(java.util.Properties properties, File file) {
        this.properties = properties;
        this.file = file;
        this.writer = null;
    }

    public Generator(java.util.Properties properties, PrintWriter writer) {
        this.properties = properties;
        this.file = null;
        this.writer = writer;
    }

    public boolean generate(Class<?> ... classes) throws FileNotFoundException {
        this.out = new PrintWriter(new Writer(){

            public void close() {
            }

            public void flush() {
            }

            public void write(char[] cbuf, int off, int len) {
            }
        });
        this.functionDefinitions = new LinkedListRegister();
        this.functionPointers = new LinkedListRegister();
        this.deallocators = new LinkedListRegister();
        this.arrayDeallocators = new LinkedListRegister();
        this.jclasses = new LinkedListRegister();
        this.jclassesInit = new LinkedListRegister();
        this.members = new HashMap();
        if (this.doClasses(classes)) {
            this.out = this.writer != null ? this.writer : new PrintWriter(this.file);
            this.doClasses(classes);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.close();
        }
    }

    private boolean doClasses(Class<?> ... classes) {
        this.out.println("/* DO NOT EDIT THIS FILE - IT IS MACHINE GENERATED */");
        this.out.println();
        String define = this.properties.getProperty("generator.define");
        if (define != null && define.length() > 0) {
            for (String s : define.split("\u0000")) {
                this.out.println("#define " + s);
            }
            this.out.println();
        }
        this.out.println("#ifdef _WIN32");
        this.out.println("    #define _JAVASOFT_JNI_MD_H_");
        this.out.println();
        this.out.println("    #define JNIEXPORT __declspec(dllexport)");
        this.out.println("    #define JNIIMPORT __declspec(dllimport)");
        this.out.println("    #define JNICALL __stdcall");
        this.out.println();
        this.out.println("    typedef int jint;");
        this.out.println("    typedef long long jlong;");
        this.out.println("    typedef signed char jbyte;");
        this.out.println("#endif");
        this.out.println("#include <jni.h>");
        this.out.println("#ifdef ANDROID");
        this.out.println("    #include <android/log.h>");
        this.out.println("    #define NewWeakGlobalRef(o) NewGlobalRef(o)");
        this.out.println("    #define DeleteWeakGlobalRef(o) DeleteGlobalRef(o)");
        this.out.println("#endif");
        this.out.println();
        String[] include = new String[]{this.properties.getProperty("generator.include"), this.properties.getProperty("generator.cinclude")};
        for (int i2 = 0; i2 < include.length; ++i2) {
            if (include[i2] == null || include[i2].length() <= 0) continue;
            if (i2 == 1) {
                this.out.println("extern \"C\" {");
            }
            for (String s : include[i2].split("\u0000")) {
                char[] chars = s.toCharArray();
                this.out.print("#include ");
                char c2 = chars[0];
                if (c2 != '<' && c2 != '\"') {
                    this.out.print('\"');
                }
                this.out.print(chars);
                c2 = chars[chars.length - 1];
                if (c2 != '>' && c2 != '\"') {
                    this.out.print('\"');
                }
                this.out.println();
            }
            if (i2 == 1) {
                this.out.println("}");
            }
            this.out.println();
        }
        this.out.println("#include <stddef.h>");
        this.out.println("#ifndef _WIN32");
        this.out.println("    #include <stdint.h>");
        this.out.println("#endif");
        this.out.println("#include <stdio.h>");
        this.out.println("#include <stdlib.h>");
        this.out.println("#include <string.h>");
        this.out.println("#include <exception>");
        this.out.println("#include <vector>");
        this.out.println();
        this.out.println("#define jlong_to_ptr(a) ((void*)(uintptr_t)(a))");
        this.out.println("#define ptr_to_jlong(a) ((jlong)(uintptr_t)(a))");
        this.out.println();
        this.out.println("#if defined(_MSC_VER)");
        this.out.println("    #define noinline __declspec(noinline)");
        this.out.println("#elif defined(__GNUC__)");
        this.out.println("    #define noinline __attribute__((noinline))");
        this.out.println("#else");
        this.out.println("    #define noinline");
        this.out.println("#endif");
        this.out.println();
        for (String s : this.functionDefinitions) {
            this.out.println(s);
        }
        this.out.println();
        for (String s : this.functionPointers) {
            this.out.println("static jobject " + s + " = NULL;");
        }
        this.out.println();
        for (Class c3 : this.deallocators) {
            String name = "JavaCPP_" + Generator.mangle(c3.getName());
            String type = FunctionPointer.class.isAssignableFrom(c3) ? name + "*" : Generator.getCPPTypeName(c3)[0];
            this.out.println("static void " + name + "_deallocate(" + type + " address) { delete address; }");
        }
        for (Class c4 : this.arrayDeallocators) {
            String name = "JavaCPP_" + Generator.mangle(c4.getName());
            String type = FunctionPointer.class.isAssignableFrom(c4) ? name + "*" : Generator.getCPPTypeName(c4)[0];
            this.out.println("static void " + name + "_deallocateArray(" + type + " address) { delete[] address; }");
        }
        this.out.println();
        this.out.println("static JavaVM* JavaCPP_vm = NULL;");
        this.out.println("static const char* JavaCPP_classNames[" + this.jclasses.size() + "] = {");
        Iterator classIterator = this.jclasses.iterator();
        int maxMemberSize = 0;
        while (classIterator.hasNext()) {
            LinkedList<String> m2;
            Class c5 = (Class)classIterator.next();
            this.out.print("        \"" + c5.getName().replace('.', '/') + "\"");
            if (classIterator.hasNext()) {
                this.out.println(",");
            }
            if ((m2 = this.members.get(c5)) == null || m2.size() <= maxMemberSize) continue;
            maxMemberSize = m2.size();
        }
        this.out.println(" };");
        this.out.println("static jclass JavaCPP_classes[" + this.jclasses.size() + "] = { NULL };");
        this.out.println("static jmethodID JavaCPP_initMethodID = NULL;");
        this.out.println("static jfieldID JavaCPP_addressFieldID = NULL;");
        this.out.println("static jfieldID JavaCPP_positionFieldID = NULL;");
        this.out.println("static jfieldID JavaCPP_capacityFieldID = NULL;");
        this.out.println();
        this.out.println("static inline void JavaCPP_log(const char* format, ...) {");
        this.out.println("   va_list ap;");
        this.out.println("   va_start(ap, format);");
        this.out.println("#ifdef ANDROID");
        this.out.println("    __android_log_print(ANDROID_LOG_ERROR, \"javacpp\", format, ap);");
        this.out.println("#else");
        this.out.println("    fprintf(stderr, format, ap);");
        this.out.println("#endif");
        this.out.println("    va_end(ap);");
        this.out.println("}");
        this.out.println();
        this.out.println("static noinline jclass JavaCPP_getClass(JNIEnv* e, int i) {");
        this.out.println("    if (JavaCPP_classes[i] == NULL && e->PushLocalFrame(1) == 0) {");
        this.out.println("        jclass c = e->FindClass(JavaCPP_classNames[i]);");
        this.out.println("        if (c == NULL || e->ExceptionCheck()) {");
        this.out.println("            JavaCPP_log(\"Error loading class %s.\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("        JavaCPP_classes[i] = (jclass)e->NewWeakGlobalRef(c);");
        this.out.println("        if (JavaCPP_classes[i] == NULL || e->ExceptionCheck()) {");
        this.out.println("            JavaCPP_log(\"Error creating global reference of class %s.\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("        e->PopLocalFrame(NULL);");
        this.out.println("    }");
        this.out.println("    return JavaCPP_classes[i];");
        this.out.println("}");
        this.out.println();
        this.out.println("static noinline void JavaCPP_handleException(JNIEnv* e) {");
        this.out.println("    try {");
        this.out.println("        throw;");
        this.out.println("    } catch (std::exception& ex) {");
        this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(RuntimeException.class) + "), ex.what());");
        this.out.println("    } catch (...) {");
        this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(RuntimeException.class) + "), \"Unknown exception.\");");
        this.out.println("    }");
        this.out.println("}");
        this.out.println();
        this.out.println("template <class P> static inline P JavaCPP_dereference(JNIEnv* e, P* pointer) {");
        this.out.println("    if (pointer == NULL) {");
        this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(NullPointerException.class) + "), \"Return pointer address is NULL.\");");
        this.out.println("        return P();");
        this.out.println("    }");
        this.out.println("    return *pointer;");
        this.out.println("}");
        this.out.println();
        this.out.println("template<class P, class T = P> class VectorAdapter {");
        this.out.println("public:");
        this.out.println("    VectorAdapter(P* pointer, typename std::vector<T>::size_type capacity) : pointer(pointer), capacity(capacity),");
        this.out.println("        vec2(pointer ? std::vector<T>(pointer, pointer + capacity) : std::vector<T>()), vec(vec2) { }");
        this.out.println("    VectorAdapter(const std::vector<T>& vec) : pointer(0), capacity(0), vec((std::vector<T>&)vec) { }");
        this.out.println("    void assign(P* pointer, typename std::vector<T>::size_type capacity) {");
        this.out.println("        this->pointer = pointer;");
        this.out.println("        this->capacity = capacity;");
        this.out.println("        vec.assign(pointer, pointer + capacity);");
        this.out.println("    }");
        this.out.println("    static void deallocate(P* pointer) { delete[] pointer; }");
        this.out.println("    operator P*() {");
        this.out.println("        if (vec.size() > capacity) {");
        this.out.println("            pointer = new P[vec.size()];");
        this.out.println("            capacity = vec.size();");
        this.out.println("        }");
        this.out.println("        if (pointer) {");
        this.out.println("            std::copy(vec.begin(), vec.end(), pointer);");
        this.out.println("        }");
        this.out.println("        return pointer;");
        this.out.println("    }");
        this.out.println("    operator const P*()        { return &vec[0]; }");
        this.out.println("    operator std::vector<T>&() { return vec; }");
        this.out.println("    operator std::vector<T>*() { return pointer ? &vec : 0; }");
        this.out.println("    P* pointer;");
        this.out.println("    typename std::vector<T>::size_type capacity;");
        this.out.println("    std::vector<T> vec2;");
        this.out.println("    std::vector<T>& vec;");
        this.out.println("};");
        this.out.println();
        this.out.println("extern \"C\" {");
        this.out.println();
        this.out.println("JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM* vm, void* reserved) {");
        this.out.println("    JNIEnv* e;");
        this.out.println("    if (vm->GetEnv((void**)&e, JNI_VERSION_1_6) != JNI_OK) {");
        this.out.println("        JavaCPP_log(\"Could not get JNIEnv for JNI_VERSION_1_6 inside JNI_OnLoad().\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    if (JavaCPP_vm == vm) {");
        this.out.println("        return e->GetVersion();");
        this.out.println("    }");
        this.out.println("    JavaCPP_vm = vm;");
        this.out.println("    const char* members[" + this.jclasses.size() + "][" + maxMemberSize + "] = {");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            Iterator memberIterator;
            this.out.print("            { ");
            LinkedList<String> m3 = this.members.get(classIterator.next());
            Iterator iterator = memberIterator = m3 == null ? null : m3.iterator();
            while (memberIterator != null && memberIterator.hasNext()) {
                this.out.print("\"" + (String)memberIterator.next() + "\"");
                if (!memberIterator.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print(" }");
            if (!classIterator.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(" };");
        this.out.println("    int offsets[" + this.jclasses.size() + "][" + maxMemberSize + "] = {");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            Iterator memberIterator;
            this.out.print("            { ");
            Class c6 = (Class)classIterator.next();
            LinkedList<String> m4 = this.members.get(c6);
            Iterator iterator = memberIterator = m4 == null ? null : m4.iterator();
            while (memberIterator != null && memberIterator.hasNext()) {
                String[] typeName = Generator.getCPPTypeName(c6);
                String valueTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                String memberName = (String)memberIterator.next();
                if ("sizeof".equals(memberName)) {
                    if ("void".equals(valueTypeName)) {
                        valueTypeName = "void*";
                    }
                    this.out.print("sizeof(" + valueTypeName + ")");
                } else {
                    this.out.print("offsetof(" + valueTypeName + "," + memberName + ")");
                }
                if (!memberIterator.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print(" }");
            if (!classIterator.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(" };");
        this.out.print("    int memberOffsetSizes[" + this.jclasses.size() + "] = { ");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            LinkedList<String> m5 = this.members.get(classIterator.next());
            this.out.print(m5 == null ? 0 : m5.size());
            if (!classIterator.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.println(" };");
        this.out.println("    jmethodID putMemberOffsetMethodID = e->GetStaticMethodID(JavaCPP_getClass(e, " + this.jclasses.register(Loader.class) + "), \"putMemberOffset\", \"(Ljava/lang/String;Ljava/lang/String;I)V\");");
        this.out.println("    if (putMemberOffsetMethodID == NULL || e->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting putMemberOffset method ID of Loader class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    for (int i = 0; i < " + this.jclasses.size() + " && !e->ExceptionCheck(); i++) {");
        this.out.println("        for (int j = 0; j < memberOffsetSizes[i] && !e->ExceptionCheck(); j++) {");
        this.out.println("            if (e->PushLocalFrame(2) == 0) {");
        this.out.println("                jvalue args[3];");
        this.out.println("                args[0].l = e->NewStringUTF(JavaCPP_classNames[i]);");
        this.out.println("                args[1].l = e->NewStringUTF(members[i][j]);");
        this.out.println("                args[2].i = offsets[i][j];");
        this.out.println("                e->CallStaticVoidMethodA(JavaCPP_getClass(e, " + this.jclasses.register(Loader.class) + "), putMemberOffsetMethodID, args);");
        this.out.println("                e->PopLocalFrame(NULL);");
        this.out.println("            }");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    JavaCPP_initMethodID = e->GetMethodID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"init\", \"(JIJ)V\");");
        this.out.println("    if (JavaCPP_initMethodID == NULL || e->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting init method ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    JavaCPP_addressFieldID = e->GetFieldID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"address\", \"J\");");
        this.out.println("    if (JavaCPP_addressFieldID == NULL || e->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting address field ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    JavaCPP_positionFieldID = e->GetFieldID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"position\", \"I\");");
        this.out.println("    if (JavaCPP_positionFieldID == NULL || e->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting position field ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    JavaCPP_capacityFieldID = e->GetFieldID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"capacity\", \"I\");");
        this.out.println("    if (JavaCPP_capacityFieldID == NULL || e->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting capacity field ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("#ifdef ANDROID");
        for (Class c7 : this.jclassesInit) {
            if (c7 == Pointer.class) continue;
            this.out.println("    if (JavaCPP_getClass(e, " + this.jclasses.indexOf(c7) + ") == NULL) {");
            this.out.println("        return 0;");
            this.out.println("    }");
        }
        this.out.println("#endif");
        this.out.println("    return e->GetVersion();");
        this.out.println("}");
        this.out.println();
        this.out.println("JNIEXPORT void JNICALL JNI_OnUnload(JavaVM* vm, void* reserved) {");
        this.out.println("    JNIEnv* e;");
        this.out.println("    if (vm->GetEnv((void**)&e, JNI_VERSION_1_6) != JNI_OK) {");
        this.out.println("        JavaCPP_log(\"Could not get JNIEnv for JNI_VERSION_1_6 inside JNI_OnUnLoad().\");");
        this.out.println("        return;");
        this.out.println("    }");
        for (String s : this.functionPointers) {
            this.out.println("    e->DeleteGlobalRef(" + s + ");");
            this.out.println("    " + s + " = NULL;");
        }
        this.out.println("    for (int i = 0; i < " + this.jclasses.size() + "; i++) {");
        this.out.println("        e->DeleteWeakGlobalRef(JavaCPP_classes[i]);");
        this.out.println("        JavaCPP_classes[i] = NULL;");
        this.out.println("    }");
        this.out.println("    JavaCPP_vm = NULL;");
        this.out.println("}");
        this.out.println();
        this.doMethods(Pointer.class);
        this.doMethods(BytePointer.class);
        this.doMethods(ShortPointer.class);
        this.doMethods(IntPointer.class);
        this.doMethods(LongPointer.class);
        this.doMethods(FloatPointer.class);
        this.doMethods(DoublePointer.class);
        this.doMethods(CharPointer.class);
        this.doMethods(PointerPointer.class);
        this.doMethods(BoolPointer.class);
        this.doMethods(CLongPointer.class);
        this.doMethods(SizeTPointer.class);
        boolean didSomethingUseful = false;
        for (Class<?> cls : classes) {
            try {
                didSomethingUseful |= this.doMethods(cls);
            }
            catch (NoClassDefFoundError e2) {
                logger.log(Level.WARNING, "Could not generate code for class " + cls.getCanonicalName() + ": " + e2);
            }
        }
        this.out.println("}");
        this.out.println();
        return didSomethingUseful;
    }

    private boolean doMethods(Class<?> cls) {
        Properties classProperties = cls.getAnnotation(Properties.class);
        boolean platformMatches = false;
        if (classProperties != null) {
            for (Platform p : classProperties.value()) {
                if (!this.checkPlatform(p)) continue;
                platformMatches = true;
            }
        } else if (this.checkPlatform(cls.getAnnotation(Platform.class))) {
            platformMatches = true;
        }
        if (!platformMatches) {
            return false;
        }
        LinkedList<String> memberList = this.members.get(cls);
        if (!(cls.isAnnotationPresent(Opaque.class) && cls != Pointer.class || FunctionPointer.class.isAssignableFrom(cls) || cls.isAnnotationPresent(NoOffset.class))) {
            if (memberList == null) {
                memberList = new LinkedList();
                this.members.put(cls, memberList);
            }
            if (!memberList.contains("sizeof")) {
                memberList.add("sizeof");
            }
        }
        boolean didSomething = false;
        Class<?>[] classes = cls.getDeclaredClasses();
        for (int i2 = 0; i2 < classes.length; ++i2) {
            if (!Pointer.class.isAssignableFrom(classes[i2]) && !Pointer.Deallocator.class.isAssignableFrom(classes[i2])) continue;
            didSomething |= this.doMethods(classes[i2]);
        }
        String[] typeName = Generator.getCPPTypeName(cls);
        Method[] methods = cls.getDeclaredMethods();
        boolean[] callbackAllocators = new boolean[methods.length];
        Method functionMethod = Generator.getFunctionMethod(cls, callbackAllocators);
        if (functionMethod != null) {
            this.functionDefinitions.register("struct JavaCPP_" + Generator.mangle(cls.getName()) + " { " + typeName[0] + "pointer" + typeName[1] + "; };");
        }
        for (int i3 = 0; i3 < methods.length; ++i3) {
            MethodInformation methodInfo;
            if (!this.checkPlatform(methods[i3].getAnnotation(Platform.class)) || (methodInfo = Generator.getMethodInformation(methods[i3])) == null) continue;
            if (callbackAllocators[i3] && functionMethod == null) {
                logger.log(Level.WARNING, "No native call() method has been not declared in \"" + cls.getCanonicalName() + "\". No code will be generated for callback allocator.");
                continue;
            }
            String baseFunctionName = Generator.mangle(cls.getName()) + "_" + Generator.mangle(methodInfo.name);
            if (!(!methodInfo.memberGetter && !methodInfo.memberSetter || methodInfo.noOffset || memberList == null || Modifier.isStatic(methodInfo.modifiers) || memberList.contains(methodInfo.memberName[0]))) {
                memberList.add(methodInfo.memberName[0]);
            }
            didSomething = true;
            if (callbackAllocators[i3]) {
                this.doCallback(cls, functionMethod, baseFunctionName);
            }
            this.out.print("JNIEXPORT " + Generator.getJNITypeName(methodInfo.returnType) + " JNICALL Java_" + baseFunctionName);
            if (methodInfo.overloaded) {
                this.out.print("__" + Generator.mangle(Generator.getSignature(methodInfo.parameterTypes)));
            }
            if (Modifier.isStatic(methodInfo.modifiers)) {
                this.out.print("(JNIEnv* e, jclass c");
            } else {
                this.out.print("(JNIEnv* e, jobject o");
            }
            for (int j2 = 0; j2 < methodInfo.parameterTypes.length; ++j2) {
                this.out.print(", " + Generator.getJNITypeName(methodInfo.parameterTypes[j2]) + " p" + j2);
            }
            this.out.println(") {");
            if (callbackAllocators[i3]) {
                this.doCallbackAllocator(cls, functionMethod, baseFunctionName);
                continue;
            }
            if (!(Modifier.isStatic(methodInfo.modifiers) || methodInfo.allocator || methodInfo.arrayAllocator || methodInfo.deallocator)) {
                String[] thisType = (String[])typeName.clone();
                if (methodInfo.bufferGetter && "void*".equals(thisType[0])) {
                    thisType[0] = "char*";
                } else if (FunctionPointer.class.isAssignableFrom(cls)) {
                    thisType[0] = "JavaCPP_" + Generator.mangle(cls.getName()) + "*";
                    thisType[1] = "";
                }
                this.out.println("    " + thisType[0] + " pointer" + thisType[1] + " = (" + thisType[0] + thisType[1] + ")jlong_to_ptr(e->GetLongField(o, JavaCPP_addressFieldID));");
                this.out.println("    if (pointer == NULL) {");
                this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(NullPointerException.class) + "), \"This pointer address is NULL.\");");
                this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                this.out.println("    }");
                if (FunctionPointer.class.isAssignableFrom(cls)) {
                    this.out.println("    if (!pointer->pointer) {");
                    this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(NullPointerException.class) + "), \"This function pointer address is NULL.\");");
                    this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                    this.out.println("    }");
                }
                if (!cls.isAnnotationPresent(Opaque.class) || methodInfo.bufferGetter) {
                    this.out.println("    jint position = e->GetIntField(o, JavaCPP_positionFieldID);");
                    this.out.println("    pointer += position;");
                    if (methodInfo.bufferGetter) {
                        this.out.println("    jint capacity = e->GetIntField(o, JavaCPP_capacityFieldID);");
                    }
                }
            }
            this.doParametersBefore(methodInfo);
            String returnVariable = this.doReturnBefore(methodInfo);
            this.doCall(methodInfo, returnVariable);
            this.doReturnAfter(methodInfo);
            this.doParametersAfter(methodInfo);
            if (methodInfo.returnType != Void.TYPE) {
                this.out.println("    return r;");
            }
            this.out.println("}");
        }
        this.out.println();
        return didSomething;
    }

    private void doParametersBefore(MethodInformation methodInfo) {
        String adapterLine = "";
        Adapter prevAdapter = null;
        int prevAdapterArgc = 0;
        for (int j2 = 0; j2 < methodInfo.parameterTypes.length; ++j2) {
            if (methodInfo.parameterTypes[j2].isPrimitive()) continue;
            Annotation passBy = Generator.getParameterBy(methodInfo, j2);
            String cast = Generator.getParameterCast(methodInfo, j2);
            String[] typeName = Generator.getCPPTypeName(methodInfo.parameterTypes[j2]);
            Adapter adapter = Generator.getParameterAdapter(methodInfo, j2);
            if (FunctionPointer.class.isAssignableFrom(methodInfo.parameterTypes[j2])) {
                typeName[0] = "JavaCPP_" + Generator.mangle(methodInfo.parameterTypes[j2].getName()) + "*";
                typeName[1] = "";
            }
            if (typeName[0].length() == 0 || methodInfo.parameterRaw[j2]) {
                Class<?> c2;
                methodInfo.parameterRaw[j2] = true;
                typeName[0] = methodInfo.parameterTypes[j2] == Class.class ? "jclass" : (methodInfo.parameterTypes[j2] == String.class ? "jstring" : (methodInfo.parameterTypes[j2].isArray() ? ((c2 = methodInfo.parameterTypes[j2].getComponentType()).isPrimitive() ? "j" + c2.getName() + "Array" : "jobjectArray") : "jobject"));
                this.out.println("    " + typeName[0] + " pointer" + j2 + " = p" + j2 + ";");
                continue;
            }
            this.out.print("    " + typeName[0] + " pointer" + j2 + typeName[1] + " = ");
            if (Pointer.class.isAssignableFrom(methodInfo.parameterTypes[j2])) {
                this.out.println("p" + j2 + " == NULL ? NULL : (" + typeName[0] + typeName[1] + ")jlong_to_ptr(e->GetLongField(p" + j2 + ", JavaCPP_addressFieldID));");
                if (j2 == 0 && FunctionPointer.class.isAssignableFrom(methodInfo.cls) && methodInfo.cls.isAnnotationPresent(Namespace.class) || passBy instanceof ByVal || passBy instanceof ByRef) {
                    this.out.println("    if (pointer" + j2 + " == NULL) {");
                    this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(NullPointerException.class) + "), \"Pointer address of parameter " + j2 + " is NULL.\");");
                    this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                    this.out.println("    }");
                }
                if (adapter != null || prevAdapter != null) {
                    this.out.println("    jint capacity" + j2 + " = p" + j2 + " == NULL ? 0 : e->GetIntField(p" + j2 + ", JavaCPP_capacityFieldID);");
                }
                if (!(methodInfo.parameterTypes[j2].isAnnotationPresent(Opaque.class) || passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef)) {
                    this.out.println("    jint position" + j2 + " = p" + j2 + " == NULL ? 0 : e->GetIntField(p" + j2 + ", JavaCPP_positionFieldID);");
                    this.out.println("    pointer" + j2 + " += position" + j2 + ";");
                    if (adapter != null || prevAdapter != null) {
                        this.out.println("    capacity" + j2 + " -= position" + j2 + ";");
                    }
                }
            } else if (methodInfo.parameterTypes[j2] == String.class) {
                this.out.println("p" + j2 + " == NULL ? NULL : e->GetStringUTFChars(p" + j2 + ", NULL);");
                if (adapter != null || prevAdapter != null) {
                    this.out.println("    jint capacity" + j2 + " = 0;");
                }
            } else if (methodInfo.parameterTypes[j2].isArray() && methodInfo.parameterTypes[j2].getComponentType().isPrimitive()) {
                this.out.print("p" + j2 + " == NULL ? NULL : ");
                String s = methodInfo.parameterTypes[j2].getComponentType().getName();
                if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
                    this.out.println("(j" + s + "*)e->GetPrimitiveArrayCritical(p" + j2 + ", NULL);");
                } else {
                    s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
                    this.out.println("e->Get" + s + "ArrayElements(p" + j2 + ", NULL);");
                }
                if (adapter != null || prevAdapter != null) {
                    this.out.println("    jint capacity" + j2 + " = p" + j2 + " == NULL ? 0 : e->GetArrayLength(p" + j2 + ");");
                }
            } else if (Buffer.class.isAssignableFrom(methodInfo.parameterTypes[j2])) {
                this.out.println("p" + j2 + " == NULL ? NULL : (" + typeName[0] + typeName[1] + ")e->GetDirectBufferAddress(p" + j2 + ");");
                if (adapter != null || prevAdapter != null) {
                    this.out.println("    jint capacity" + j2 + " = p" + j2 + " == NULL ? 0 : e->GetDirectBufferCapacity(p" + j2 + ");");
                }
            } else {
                this.out.println("p" + j2 + ";");
                logger.log(Level.WARNING, "Method \"" + methodInfo.method + "\" has unsupported parameter type \"" + methodInfo.parameterTypes[j2].getCanonicalName() + "\". Compilation will most likely fail.");
            }
            if (adapter != null) {
                adapterLine = "    " + adapter.value() + " adapter" + j2 + "(";
                prevAdapter = adapter;
                prevAdapterArgc = adapter.argc();
            }
            if (prevAdapter != null) {
                if (!FunctionPointer.class.isAssignableFrom(methodInfo.cls)) {
                    adapterLine = adapterLine + cast;
                }
                adapterLine = adapterLine + "pointer" + j2 + ", capacity" + j2;
                if (--prevAdapterArgc > 0) {
                    adapterLine = adapterLine + ", ";
                }
            }
            if (prevAdapter == null || prevAdapterArgc > 0) continue;
            this.out.println(adapterLine + ");");
            prevAdapter = null;
            prevAdapterArgc = 0;
        }
    }

    private String doReturnBefore(MethodInformation methodInfo) {
        String returnVariable = "";
        if (methodInfo.returnType == Void.TYPE) {
            if (methodInfo.allocator || methodInfo.arrayAllocator) {
                this.out.println("    if (!e->IsSameObject(e->GetObjectClass(o), JavaCPP_getClass(e, " + this.jclasses.register(methodInfo.cls) + "))) {");
                this.out.println("        return;");
                this.out.println("    }");
                String[] typeName = Generator.getCPPTypeName(methodInfo.cls);
                returnVariable = typeName[0] + " rpointer" + typeName[1] + " = ";
            }
        } else {
            String[] typeName = Generator.getCastedCPPTypeName(methodInfo.annotations, methodInfo.returnType);
            if (methodInfo.valueSetter || methodInfo.memberSetter || methodInfo.noReturnGetter) {
                this.out.println("    jobject r = o;");
            } else if (methodInfo.returnType.isPrimitive()) {
                this.out.println("    " + Generator.getJNITypeName(methodInfo.returnType) + " r = 0;");
                returnVariable = typeName[0] + " rvalue" + typeName[1] + " = ";
            } else {
                Annotation returnBy = Generator.getBy(methodInfo.annotations);
                Adapter adapter = Generator.getAdapter(methodInfo.annotations);
                returnVariable = "rpointer = ";
                if (typeName[0].length() == 0 || methodInfo.returnRaw) {
                    Class<?> c2;
                    methodInfo.returnRaw = true;
                    typeName[0] = methodInfo.returnType == Class.class ? "jclass" : (methodInfo.returnType == String.class ? "jstring" : (methodInfo.returnType.isArray() ? ((c2 = methodInfo.returnType.getComponentType()).isPrimitive() ? "j" + c2.getName() + "Array" : "jobjectArray") : "jobject"));
                    this.out.println("    " + typeName[0] + " r = NULL;");
                    this.out.println("    " + typeName[0] + " rpointer;");
                } else if (Pointer.class.isAssignableFrom(methodInfo.returnType)) {
                    if (FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                        typeName[0] = "JavaCPP_" + Generator.mangle(methodInfo.returnType.getName()) + "*";
                        typeName[1] = "";
                        returnVariable = "rpointer->pointer = ";
                    }
                    String valueTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                    if (returnBy instanceof ByVal) {
                        returnVariable = returnVariable + "new " + valueTypeName + typeName[1] + "(";
                    } else if (returnBy instanceof ByRef) {
                        returnVariable = returnVariable + "&";
                    } else if (returnBy instanceof ByPtrPtr) {
                        returnVariable = returnVariable + "JavaCPP_dereference(e, ";
                    }
                    this.out.println("    jobject r = NULL;");
                    this.out.println("    " + typeName[0] + " rpointer" + typeName[1] + ";");
                    if (FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                        this.out.println("    rpointer = new " + valueTypeName + ";");
                    }
                } else if (methodInfo.returnType == String.class) {
                    this.out.println("    jstring r = NULL;");
                    this.out.println("    const char* rpointer;");
                } else if (methodInfo.bufferGetter) {
                    this.out.println("    jobject r = NULL;");
                    this.out.println("    char* rpointer;");
                } else {
                    logger.log(Level.WARNING, "Method \"" + methodInfo.method + "\" has unsupported return type \"" + methodInfo.returnType.getCanonicalName() + "\". Compilation will most likely fail.");
                }
                if (adapter != null) {
                    returnVariable = adapter.value() + " radapter(";
                }
            }
        }
        if (methodInfo.mayThrowException) {
            this.out.println("    try {");
        }
        return returnVariable;
    }

    private void doCall(MethodInformation methodInfo, String returnVariable) {
        int j2;
        boolean index;
        String indent = methodInfo.mayThrowException ? "        " : "    ";
        String prefix = "(";
        String suffix = ")";
        int skipParameters = 0;
        boolean bl = index = methodInfo.method.isAnnotationPresent(Index.class) || methodInfo.pairedMethod != null && methodInfo.pairedMethod.isAnnotationPresent(Index.class);
        if (methodInfo.deallocator) {
            this.out.println(indent + "void* allocatedAddress = jlong_to_ptr(p0);");
            this.out.println(indent + "void (*deallocatorAddress)(void*) = (void(*)(void*))jlong_to_ptr(p1);");
            this.out.println(indent + "if (deallocatorAddress != NULL && allocatedAddress != NULL) {");
            this.out.println(indent + "    (*deallocatorAddress)(allocatedAddress);");
            this.out.println(indent + "}");
            return;
        }
        if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
            boolean wantsPointer = false;
            int k2 = methodInfo.parameterTypes.length - 1;
            if ((methodInfo.valueSetter || methodInfo.memberSetter) && !(Generator.getParameterBy(methodInfo, k2) instanceof ByRef) && methodInfo.parameterTypes[k2] == String.class) {
                this.out.print(indent + "strcpy(");
                wantsPointer = true;
                prefix = ", ";
            } else if (k2 >= 1 && methodInfo.parameterTypes[0].isArray() && methodInfo.parameterTypes[0].getComponentType().isPrimitive() && (methodInfo.parameterTypes[1] == Integer.TYPE || methodInfo.parameterTypes[1] == Long.TYPE)) {
                this.out.print(indent + "memcpy(");
                wantsPointer = true;
                prefix = ", ";
                if (methodInfo.memberGetter || methodInfo.valueGetter) {
                    this.out.print("pointer0 + p1, ");
                } else {
                    prefix = prefix + "pointer0 + p1, ";
                }
                skipParameters = 2;
                suffix = " * sizeof(*pointer0)" + suffix;
            } else {
                this.out.print(indent + returnVariable);
                prefix = methodInfo.valueGetter || methodInfo.memberGetter ? "" : " = ";
                suffix = "";
            }
            if (Modifier.isStatic(methodInfo.modifiers)) {
                String[] namespace = Generator.getCPPTypeName(methodInfo.cls);
                if (namespace[0] != null && namespace[0].length() > 0) {
                    this.out.print(namespace[0].substring(0, namespace[0].length() - 1) + "::");
                }
                if (methodInfo.method.isAnnotationPresent(Namespace.class)) {
                    this.out.print(methodInfo.method.getAnnotation(Namespace.class).value() + "::");
                }
                this.out.print(methodInfo.memberName[0]);
            } else if (methodInfo.memberGetter || methodInfo.memberSetter) {
                if (index) {
                    this.out.print("(*pointer)");
                    prefix = "." + methodInfo.memberName[0] + prefix;
                } else {
                    this.out.print("pointer->" + methodInfo.memberName[0]);
                }
            } else {
                this.out.print(index ? "(*pointer)" : (methodInfo.dim > 0 || wantsPointer ? "pointer" : "*pointer"));
            }
        } else if (methodInfo.bufferGetter) {
            this.out.print(indent + returnVariable + "pointer");
            prefix = "";
            suffix = "";
        } else {
            this.out.print(indent + returnVariable);
            if (FunctionPointer.class.isAssignableFrom(methodInfo.cls)) {
                if (methodInfo.cls.isAnnotationPresent(Namespace.class)) {
                    this.out.print("(pointer0->*(pointer->pointer))");
                    skipParameters = 1;
                } else {
                    this.out.print("(*pointer->pointer)");
                }
            } else if (methodInfo.allocator) {
                String[] typeName = Generator.getCPPTypeName(methodInfo.cls);
                String valueTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                this.out.print("new " + valueTypeName);
                if (methodInfo.arrayAllocator) {
                    prefix = "[";
                    suffix = "]";
                }
            } else if (Modifier.isStatic(methodInfo.modifiers)) {
                String[] namespace = Generator.getCPPTypeName(methodInfo.cls);
                if (namespace[0] != null && namespace[0].length() > 0) {
                    this.out.print(namespace[0].substring(0, namespace[0].length() - 1));
                    this.out.print("::");
                }
                if (methodInfo.method.isAnnotationPresent(Namespace.class)) {
                    Namespace ns = methodInfo.method.getAnnotation(Namespace.class);
                    this.out.print(ns.value());
                    this.out.print("::");
                }
                this.out.print(methodInfo.memberName[0]);
            } else if (index) {
                this.out.print("(*pointer)");
                prefix = "." + methodInfo.memberName[0] + prefix;
            } else {
                this.out.print("pointer->" + methodInfo.memberName[0]);
            }
        }
        for (j2 = skipParameters; j2 < methodInfo.dim; ++j2) {
            String cast = Generator.getParameterCast(methodInfo, j2);
            this.out.print("[" + cast + (methodInfo.parameterTypes[j2].isPrimitive() ? "p" : "pointer") + j2 + "]");
        }
        if (methodInfo.memberName.length > 1) {
            this.out.print(methodInfo.memberName[1]);
        }
        this.out.print(prefix);
        if (methodInfo.withEnv) {
            this.out.print(Modifier.isStatic(methodInfo.modifiers) ? "e, c" : "e, o");
            if (methodInfo.parameterTypes.length - skipParameters - methodInfo.dim > 0) {
                this.out.print(", ");
            }
        }
        for (j2 = skipParameters + methodInfo.dim; j2 < methodInfo.parameterTypes.length; ++j2) {
            Annotation passBy = Generator.getParameterBy(methodInfo, j2);
            String cast = Generator.getParameterCast(methodInfo, j2);
            Adapter adapter = Generator.getParameterAdapter(methodInfo, j2);
            if (("(void*)".equals(cast) || "(void *)".equals(cast)) && methodInfo.parameterTypes[j2] == Long.TYPE) {
                this.out.print("jlong_to_ptr(p" + j2 + ")");
            } else if (methodInfo.parameterTypes[j2].isPrimitive()) {
                this.out.print(cast + "p" + j2);
            } else if (adapter != null) {
                cast = adapter.cast().trim();
                if (!(cast.isEmpty() || cast.startsWith("(") || cast.endsWith(")"))) {
                    cast = "(" + cast + ")";
                }
                this.out.print(cast + "adapter" + j2);
                j2 += adapter.argc() - 1;
            } else if (FunctionPointer.class.isAssignableFrom(methodInfo.parameterTypes[j2])) {
                this.out.print(cast + "(pointer" + j2 + " == NULL ? NULL : pointer" + j2 + "->pointer)");
            } else if (passBy instanceof ByVal || passBy instanceof ByRef && methodInfo.parameterTypes[j2] != String.class) {
                this.out.print("*" + cast + "pointer" + j2);
            } else if (passBy instanceof ByPtrPtr) {
                this.out.print(cast + "&pointer" + j2);
            } else {
                this.out.print(cast + "pointer" + j2);
            }
            if (j2 >= methodInfo.parameterTypes.length - 1) continue;
            this.out.print(", ");
        }
        this.out.print(suffix);
        if (methodInfo.memberName.length > 2) {
            this.out.print(methodInfo.memberName[2]);
        }
        if (Generator.getBy(methodInfo.annotations) instanceof ByRef && methodInfo.returnType == String.class) {
            this.out.print(".c_str()");
        }
    }

    private void doReturnAfter(MethodInformation methodInfo) {
        String indent;
        Annotation returnBy = Generator.getBy(methodInfo.annotations);
        Adapter adapter = Generator.getAdapter(methodInfo.annotations);
        if (Pointer.class.isAssignableFrom(methodInfo.returnType)) {
            if (adapter != null) {
                this.out.print(")");
            }
            if (returnBy instanceof ByVal || returnBy instanceof ByPtrPtr) {
                this.out.print(")");
            }
        }
        if (!methodInfo.deallocator) {
            this.out.println(";");
        }
        String string = indent = methodInfo.mayThrowException ? "        " : "    ";
        if (methodInfo.returnType == Void.TYPE) {
            if (methodInfo.allocator || methodInfo.arrayAllocator) {
                this.out.println(indent + "jint rcapacity = " + (methodInfo.arrayAllocator ? "p0;" : "1;"));
                boolean noDeallocator = methodInfo.cls.isAnnotationPresent(NoDeallocator.class);
                for (Annotation a2 : methodInfo.annotations) {
                    if (!(a2 instanceof NoDeallocator)) continue;
                    noDeallocator = true;
                    break;
                }
                if (noDeallocator) {
                    this.out.println(indent + "e->SetLongField(o, JavaCPP_addressFieldID, ptr_to_jlong(rpointer));");
                    this.out.println(indent + "e->SetIntField(o, JavaCPP_capacityFieldID, rcapacity);");
                } else {
                    this.out.println(indent + "jvalue args[3];");
                    this.out.println(indent + "args[0].j = ptr_to_jlong(rpointer);");
                    this.out.println(indent + "args[1].i = rcapacity;");
                    this.out.print(indent + "args[2].j = ptr_to_jlong(&JavaCPP_" + Generator.mangle(methodInfo.cls.getName()));
                    if (methodInfo.arrayAllocator) {
                        this.out.println("_deallocateArray);");
                        this.arrayDeallocators.register(methodInfo.cls);
                    } else {
                        this.out.println("_deallocate);");
                        this.deallocators.register(methodInfo.cls);
                    }
                    this.out.println(indent + "e->CallNonvirtualVoidMethodA(o, JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
                }
            }
        } else if (!(methodInfo.valueSetter || methodInfo.memberSetter || methodInfo.noReturnGetter)) {
            if (methodInfo.returnType.isPrimitive()) {
                this.out.println(indent + "r = (" + Generator.getJNITypeName(methodInfo.returnType) + ")rvalue;");
            } else if (methodInfo.returnRaw) {
                this.out.println(indent + "r = rpointer;");
            } else {
                boolean needInit = false;
                if (adapter != null) {
                    this.out.println(indent + "rpointer = radapter;");
                    this.out.println(indent + "jint rcapacity = (jint)radapter.capacity;");
                    this.out.println(indent + "jlong deallocator = ptr_to_jlong(&(" + adapter.value() + "::deallocate));");
                    needInit = true;
                } else if (returnBy instanceof ByVal || FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                    this.out.println(indent + "jint rcapacity = 1;");
                    this.out.println(indent + "jlong deallocator = ptr_to_jlong(&JavaCPP_" + Generator.mangle(methodInfo.returnType.getName()) + "_deallocate);");
                    this.deallocators.register(methodInfo.returnType);
                    needInit = true;
                }
                if (Pointer.class.isAssignableFrom(methodInfo.returnType)) {
                    if (!Modifier.isStatic(methodInfo.modifiers) && methodInfo.cls == methodInfo.returnType && !(returnBy instanceof ByVal)) {
                        this.out.println(indent + "if (rpointer == pointer) {");
                        this.out.println(indent + "    r = o;");
                        this.out.println(indent + "} else if (rpointer != NULL) {");
                    } else {
                        this.out.println(indent + "if (rpointer != NULL) {");
                    }
                    this.out.println(indent + "    r = e->AllocObject(JavaCPP_getClass(e, " + this.jclasses.register(methodInfo.returnType) + "));");
                    if (needInit) {
                        this.out.println(indent + "    if (deallocator != 0) {");
                        this.out.println(indent + "        jvalue args[3];");
                        this.out.println(indent + "        args[0].j = ptr_to_jlong(rpointer);");
                        this.out.println(indent + "        args[1].i = rcapacity;");
                        this.out.println(indent + "        args[2].j = deallocator;");
                        this.out.println(indent + "        e->CallNonvirtualVoidMethodA(r, JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
                        this.out.println(indent + "    } else {");
                        this.out.println(indent + "        e->SetLongField(r, JavaCPP_addressFieldID, ptr_to_jlong(rpointer));");
                        this.out.println(indent + "        e->SetIntField(r, JavaCPP_capacityFieldID, rcapacity);");
                        this.out.println(indent + "    }");
                    } else {
                        this.out.println(indent + "    e->SetLongField(r, JavaCPP_addressFieldID, ptr_to_jlong(rpointer));");
                    }
                    this.out.println(indent + "}");
                } else if (methodInfo.returnType == String.class) {
                    this.out.println(indent + "if (rpointer != NULL) {");
                    this.out.println(indent + "    r = e->NewStringUTF(rpointer);");
                    this.out.println(indent + "}");
                } else if (methodInfo.bufferGetter) {
                    this.out.println(indent + "if (rpointer != NULL) {");
                    this.out.println(indent + "    r = e->NewDirectByteBuffer(rpointer, capacity);");
                    this.out.println(indent + "}");
                }
            }
        }
    }

    private void doParametersAfter(MethodInformation methodInfo) {
        String indent = methodInfo.mayThrowException ? "        " : "    ";
        for (int j2 = 0; j2 < methodInfo.parameterTypes.length; ++j2) {
            if (methodInfo.parameterRaw[j2]) continue;
            Annotation passBy = Generator.getParameterBy(methodInfo, j2);
            String cast = Generator.getParameterCast(methodInfo, j2);
            String[] typeName = Generator.getCPPTypeName(methodInfo.parameterTypes[j2]);
            Adapter adapter = Generator.getParameterAdapter(methodInfo, j2);
            if (adapter != null && adapter.out()) {
                for (int k2 = 0; k2 < adapter.argc(); ++k2) {
                    this.out.println(indent + typeName[0] + " rpointer" + (j2 + k2) + typeName[1] + " = adapter" + j2 + ";");
                    this.out.println(indent + "if (rpointer" + (j2 + k2) + " != pointer" + (j2 + k2) + ") {");
                    this.out.println(indent + "    jvalue args[3];");
                    this.out.println(indent + "    args[0].j = ptr_to_jlong(rpointer" + (j2 + k2) + ");");
                    this.out.println(indent + "    args[1].i = (jint)adapter" + j2 + ".capacity" + (k2 > 0 ? k2 + ";" : ";"));
                    this.out.println(indent + "    args[2].j = ptr_to_jlong(&(" + adapter.value() + "::deallocate));");
                    this.out.println(indent + "    e->CallNonvirtualVoidMethodA(p" + j2 + ", JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
                    this.out.println(indent + "}");
                }
            } else if (Pointer.class.isAssignableFrom(methodInfo.parameterTypes[j2]) && (passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef) && !methodInfo.valueSetter && !methodInfo.memberSetter) {
                this.out.println(indent + "if (p" + j2 + " != NULL) e->SetLongField(p" + j2 + ", JavaCPP_addressFieldID, ptr_to_jlong(pointer" + j2 + "));");
            }
            if (methodInfo.parameterTypes[j2] == String.class) {
                this.out.println(indent + "if (p" + j2 + " != NULL) e->ReleaseStringUTFChars(p" + j2 + ", pointer" + j2 + ");");
                continue;
            }
            if (!methodInfo.parameterTypes[j2].isArray() || !methodInfo.parameterTypes[j2].getComponentType().isPrimitive()) continue;
            this.out.print(indent + "if (p" + j2 + " != NULL) ");
            String s = methodInfo.parameterTypes[j2].getComponentType().getName();
            if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
                this.out.println("e->ReleasePrimitiveArrayCritical(p" + j2 + ", pointer" + j2 + ", 0);");
                continue;
            }
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
            this.out.println("e->Release" + s + "ArrayElements(p" + j2 + ", pointer" + j2 + ", 0);");
        }
        if (methodInfo.mayThrowException) {
            this.out.println("    } catch (...) {");
            this.out.println("        JavaCPP_handleException(e);");
            this.out.println("    }");
        }
    }

    private void doCallback(Class<?> cls, Method callbackMethod, String callbackName) {
        Convention convention = cls.getAnnotation(Convention.class);
        String callingConvention = convention == null ? "" : convention.value() + " ";
        Class<?> callbackReturnType = callbackMethod.getReturnType();
        Class<?>[] callbackParameterTypes = callbackMethod.getParameterTypes();
        Annotation[] callbackAnnotations = callbackMethod.getAnnotations();
        Annotation[][] callbackParameterAnnotations = callbackMethod.getParameterAnnotations();
        this.functionPointers.register("JavaCPP_" + callbackName + "_instance");
        this.out.println("static jmethodID JavaCPP_" + callbackName + "_callMethodID = NULL;");
        String[] paramTypeName = Generator.getAnnotatedCPPTypeName(callbackAnnotations, callbackReturnType);
        this.out.print("static " + paramTypeName[0] + paramTypeName[1] + " " + callingConvention + "JavaCPP_" + callbackName + "_callback(");
        for (int j2 = 0; j2 < callbackParameterTypes.length; ++j2) {
            paramTypeName = Generator.getAnnotatedCPPTypeName(callbackParameterAnnotations[j2], callbackParameterTypes[j2]);
            this.out.print(paramTypeName[0] + " p" + j2 + paramTypeName[1]);
            if (j2 >= callbackParameterTypes.length - 1) continue;
            this.out.print(", ");
        }
        this.out.println(") {");
        String returnVariable = "";
        if (callbackReturnType != Void.TYPE) {
            this.out.println("    " + Generator.getJNITypeName(callbackReturnType) + " r = 0;");
            returnVariable = "r";
        }
        String callbackReturnCast = Generator.getCast(callbackAnnotations, callbackReturnType);
        Annotation returnBy = Generator.getBy(callbackAnnotations);
        String[] returnTypeName = Generator.getCPPTypeName(callbackReturnType);
        Adapter returnAdapter = Generator.getAdapter(callbackAnnotations);
        this.out.println("    JNIEnv* e;");
        this.out.println("    int needDetach = 0;");
        this.out.println("    if (JavaCPP_vm->GetEnv((void**)&e, JNI_VERSION_1_6) != JNI_OK) {");
        this.out.println("        struct {");
        this.out.println("            JNIEnv **e;");
        this.out.println("            operator JNIEnv**() { return e; }");
        this.out.println("            operator void**() { return (void**)e; }");
        this.out.println("        } e2 = { &e };");
        this.out.println("        if (JavaCPP_vm->AttachCurrentThread(e2, NULL) != 0) {");
        this.out.println("            JavaCPP_log(\"Could not attach the JavaVM to the current thread in callback for " + cls.getName() + ".\");");
        this.out.println("            goto end;");
        this.out.println("        }");
        this.out.println("        needDetach = 1;");
        this.out.println("    }");
        this.out.println("{");
        if (callbackParameterTypes.length > 0) {
            this.out.println("    jvalue args[" + callbackParameterTypes.length + "];");
            for (int j3 = 0; j3 < callbackParameterTypes.length; ++j3) {
                if (callbackParameterTypes[j3].isPrimitive()) {
                    this.out.println("    args[" + j3 + "]." + Generator.getSignature(callbackParameterTypes[j3]).toLowerCase() + " = p" + j3 + ";");
                    continue;
                }
                Annotation passBy = Generator.getBy(callbackParameterAnnotations[j3]);
                Adapter adapter = Generator.getAdapter(callbackParameterAnnotations[j3]);
                String[] typeName = adapter != null ? Generator.getCPPTypeName(callbackParameterTypes[j3]) : Generator.getCastedCPPTypeName(callbackParameterAnnotations[j3], callbackParameterTypes[j3]);
                boolean needInit = false;
                if (adapter != null) {
                    this.out.println("    " + adapter.value() + " adapter" + j3 + "(p" + j3 + ");");
                    this.out.println("    jint capacity" + j3 + " = (jint)adapter" + j3 + ".capacity;");
                    this.out.println("    jlong deallocator" + j3 + " = ptr_to_jlong(&(" + adapter.value() + "::deallocate));");
                    needInit = true;
                } else if (passBy instanceof ByVal && callbackParameterTypes[j3] != Pointer.class || FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j3])) {
                    this.out.println("    jint capacity" + j3 + " = 1;");
                    this.out.println("    jlong deallocator" + j3 + " = ptr_to_jlong(&JavaCPP_" + Generator.mangle(callbackParameterTypes[j3].getName()) + "_deallocate);");
                    this.deallocators.register(callbackParameterTypes[j3]);
                    needInit = true;
                }
                if (Pointer.class.isAssignableFrom(callbackParameterTypes[j3])) {
                    if (FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j3])) {
                        typeName[0] = "JavaCPP_" + Generator.mangle(callbackParameterTypes[j3].getName()) + "*";
                        typeName[1] = "";
                    }
                    String valueTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                    this.out.println("    jobject o" + j3 + " = NULL;");
                    this.out.println("    " + typeName[0] + " pointer" + j3 + typeName[1] + ";");
                    if (FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j3])) {
                        this.out.println("    pointer" + j3 + " = new " + valueTypeName + ";");
                        this.out.println("    pointer" + j3 + "->pointer = p" + j3 + ";");
                    } else if (adapter != null) {
                        this.out.println("    pointer" + j3 + " = adapter" + j3 + ";");
                    } else if (passBy instanceof ByVal && callbackParameterTypes[j3] != Pointer.class) {
                        this.out.println("    pointer" + j3 + " = new " + valueTypeName + typeName[1] + "(*(" + typeName[0] + typeName[1] + ")&p" + j3 + ");");
                    } else if (passBy instanceof ByVal || passBy instanceof ByRef) {
                        this.out.println("    pointer" + j3 + " = (" + typeName[0] + typeName[1] + ")&p" + j3 + ";");
                    } else if (passBy instanceof ByPtrPtr) {
                        this.out.println("    if (p" + j3 + " == NULL) {");
                        this.out.println("        throw std::runtime_error(\"Pointer address of parameter " + j3 + " is NULL.\")");
                        this.out.println("    }");
                        this.out.println("    pointer" + j3 + " = *p" + j3 + ";");
                    } else {
                        this.out.println("    pointer" + j3 + " = p" + j3 + ";");
                    }
                    String s = "    o" + j3 + " = e->AllocObject(JavaCPP_getClass(e, " + this.jclasses.register(callbackParameterTypes[j3]) + "));";
                    this.jclassesInit.register(callbackParameterTypes[j3]);
                    if (adapter != null && adapter.out() || passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef) {
                        this.out.println(s);
                    } else {
                        this.out.println("    if (pointer" + j3 + " != NULL) { ");
                        this.out.println("    " + s);
                        this.out.println("    }");
                    }
                    this.out.println("    if (o" + j3 + " != NULL) { ");
                    if (needInit) {
                        this.out.println("        if (deallocator" + j3 + " != 0) {");
                        this.out.println("            jvalue args[3];");
                        this.out.println("            args[0].j = ptr_to_jlong(pointer" + j3 + ");");
                        this.out.println("            args[1].i = capacity" + j3 + ";");
                        this.out.println("            args[2].j = deallocator" + j3 + ";");
                        this.out.println("            e->CallNonvirtualVoidMethodA(o" + j3 + ", JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
                        this.out.println("        } else {");
                        this.out.println("            e->SetLongField(o" + j3 + ", JavaCPP_addressFieldID, ptr_to_jlong(pointer" + j3 + "));");
                        this.out.println("            e->SetIntField(o" + j3 + ", JavaCPP_capacityFieldID, capacity" + j3 + ");");
                        this.out.println("        }");
                    } else {
                        this.out.println("        e->SetLongField(o" + j3 + ", JavaCPP_addressFieldID, ptr_to_jlong(pointer" + j3 + "));");
                    }
                    this.out.println("    }");
                    this.out.println("    args[" + j3 + "].l = o" + j3 + ";");
                    continue;
                }
                if (callbackParameterTypes[j3] == String.class) {
                    this.out.println("    jstring o" + j3 + " = p" + j3 + " == NULL ? NULL : e->NewStringUTF(" + (adapter != null ? "adapter" : "p") + j3 + ");");
                    this.out.println("    args[" + j3 + "].l = o" + j3 + ";");
                    continue;
                }
                logger.log(Level.WARNING, "Callback \"" + callbackMethod + "\" has unsupported parameter type \"" + callbackParameterTypes[j3].getCanonicalName() + "\". Compilation will most likely fail.");
            }
        }
        if (returnVariable.length() > 0) {
            returnVariable = returnVariable + " = ";
        }
        String s = "Object";
        if (callbackReturnType.isPrimitive()) {
            s = callbackReturnType.getName();
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        this.out.println("    " + returnVariable + "e->Call" + s + "MethodA(JavaCPP_" + callbackName + "_instance, JavaCPP_" + callbackName + "_callMethodID, " + (callbackParameterTypes.length == 0 ? "NULL);" : "args);"));
        for (int j4 = 0; j4 < callbackParameterTypes.length; ++j4) {
            if (Pointer.class.isAssignableFrom(callbackParameterTypes[j4])) {
                String[] typeName = Generator.getCastedCPPTypeName(callbackParameterAnnotations[j4], callbackParameterTypes[j4]);
                Annotation passBy = Generator.getBy(callbackParameterAnnotations[j4]);
                Adapter adapter = Generator.getAdapter(callbackParameterAnnotations[j4]);
                if (adapter != null && adapter.out() || passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef) {
                    this.out.println("    " + typeName[0] + " rpointer" + j4 + typeName[1] + " = (" + typeName[0] + typeName[1] + ")jlong_to_ptr(e->GetLongField(o" + j4 + ", JavaCPP_addressFieldID);");
                    if (adapter != null && adapter.out()) {
                        this.out.println("    jint rcapacity" + j4 + " = e->GetIntField(o" + j4 + ", JavaCPP_capacityFieldID));");
                    }
                    if (!callbackParameterTypes[j4].isAnnotationPresent(Opaque.class)) {
                        this.out.println("    jint rposition" + j4 + " = e->GetIntField(o" + j4 + ", JavaCPP_positionFieldID));");
                        this.out.println("    rpointer" + j4 + " += rposition" + j4 + ";");
                        if (adapter != null && adapter.out()) {
                            this.out.println("    rcapacity" + j4 + " -= rposition" + j4 + ";");
                        }
                    }
                    if (adapter != null && adapter.out()) {
                        this.out.println("    adapter" + j4 + ".assign(rpointer" + j4 + ", rcapacity" + j4 + ");");
                    } else if (passBy instanceof ByPtrPtr) {
                        this.out.println("    *p" + j4 + " = rpointer" + j4 + ";");
                    } else if (passBy instanceof ByPtrRef) {
                        this.out.println("    p" + j4 + " = rpointer" + j4 + ";");
                    }
                }
            }
            if (callbackParameterTypes[j4].isPrimitive()) continue;
            this.out.println("    e->DeleteLocalRef(o" + j4 + ");");
        }
        this.out.println("}");
        this.out.println("end:");
        if (callbackReturnType != Void.TYPE) {
            if (Pointer.class.isAssignableFrom(callbackReturnType)) {
                this.out.println("    " + returnTypeName[0] + " rpointer" + returnTypeName[1] + " = r == NULL ? NULL : (" + returnTypeName[0] + returnTypeName[1] + ")jlong_to_ptr(e->GetLongField(r, JavaCPP_addressFieldID));");
                if (returnAdapter != null) {
                    this.out.println("    jint rcapacity = r == NULL ? 0 : e->GetIntField(r, JavaCPP_capacityFieldID);");
                }
                if (!callbackReturnType.isAnnotationPresent(Opaque.class)) {
                    this.out.println("    jint rposition = r == NULL ? 0 : e->GetIntField(r, JavaCPP_positionFieldID);");
                    this.out.println("    rpointer += rposition;");
                    if (returnAdapter != null) {
                        this.out.println("    rcapacity -= rposition;");
                    }
                }
            } else if (Buffer.class.isAssignableFrom(callbackReturnType)) {
                this.out.println("    " + returnTypeName[0] + " rpointer" + returnTypeName[1] + " = r == NULL ? NULL : e->GetDirectBufferAddress(r);");
                if (returnAdapter != null) {
                    this.out.println("    jint rcapacity = r == NULL ? 0 : e->GetDirectBufferCapacity(r);");
                }
            } else if (!callbackReturnType.isPrimitive()) {
                logger.log(Level.WARNING, "Callback \"" + callbackMethod + "\" has unsupported return type \"" + callbackReturnType.getCanonicalName() + "\". Compilation will most likely fail.");
            }
        }
        this.out.println("    if (needDetach) {");
        this.out.println("        if (JavaCPP_vm->DetachCurrentThread() != 0) {");
        this.out.println("            JavaCPP_log(\"Could not deattach the JavaVM from the current thread in callback for " + cls.getName() + ".\");");
        this.out.println("        }");
        this.out.println("    }");
        if (callbackReturnType != Void.TYPE) {
            if (callbackReturnType.isPrimitive()) {
                this.out.println("    return " + callbackReturnCast + "r;");
            } else if (returnAdapter != null) {
                this.out.println("    return " + returnAdapter.value() + "(" + callbackReturnCast + "rpointer, rcapacity);");
            } else if (FunctionPointer.class.isAssignableFrom(callbackReturnType)) {
                this.out.println("    return " + callbackReturnCast + "(rpointer == NULL ? NULL : rpointer->pointer);");
            } else if (returnBy instanceof ByVal || returnBy instanceof ByRef) {
                this.out.println("    if (rpointer == NULL) {");
                this.out.println("        throw std::runtime_error(\"Return pointer address is NULL.\");");
                this.out.println("    }");
                this.out.println("    return *" + callbackReturnCast + "rpointer;");
            } else if (returnBy instanceof ByPtrPtr) {
                this.out.println("    return " + callbackReturnCast + "&rpointer;");
            } else {
                this.out.println("    return " + callbackReturnCast + "rpointer;");
            }
        }
        this.out.println("}");
    }

    private void doCallbackAllocator(Class cls, Method callbackMethod, String callbackName) {
        String valueTypeName = "JavaCPP_" + Generator.mangle(cls.getName());
        this.out.println("    e->DeleteGlobalRef(JavaCPP_" + callbackName + "_instance);");
        this.out.println("    JavaCPP_" + callbackName + "_instance = e->NewGlobalRef(o);");
        this.out.println("    if (JavaCPP_" + callbackName + "_instance == NULL) {");
        this.out.println("        JavaCPP_log(\"Error creating global reference of " + cls.getName() + " instance for callback.\");");
        this.out.println("        return;");
        this.out.println("    }");
        this.out.println("    JavaCPP_" + callbackName + "_callMethodID = e->GetMethodID(e->GetObjectClass(o), \"" + callbackMethod.getName() + "\", \"(" + Generator.getSignature(callbackMethod.getParameterTypes()) + ")" + Generator.getSignature(callbackMethod.getReturnType()) + "\");");
        this.out.println("    if (JavaCPP_" + callbackName + "_callMethodID == NULL) {");
        this.out.println("        JavaCPP_log(\"Error getting method ID of function caller \\\"" + callbackMethod + "\\\" for callback.\");");
        this.out.println("        return;");
        this.out.println("    }");
        this.out.println("    " + valueTypeName + "* rpointer = new " + valueTypeName + ";");
        this.out.println("    rpointer->pointer = &JavaCPP_" + callbackName + "_callback;");
        this.out.println("    jvalue args[3];");
        this.out.println("    args[0].j = ptr_to_jlong(rpointer);");
        this.out.println("    args[1].i = 1;");
        this.out.println("    args[2].j = ptr_to_jlong(&" + valueTypeName + "_deallocate);");
        this.deallocators.register(cls);
        this.out.println("    e->CallNonvirtualVoidMethodA(o, JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
        this.out.println("}");
    }

    public boolean checkPlatform(Platform platform) {
        if (platform == null) {
            return true;
        }
        String platformName = this.properties.getProperty("platform.name");
        String[][] names = new String[][]{platform.value(), platform.not()};
        boolean[] matches = new boolean[]{false, false};
        block0: for (int i2 = 0; i2 < names.length; ++i2) {
            for (String s : names[i2]) {
                if (!platformName.startsWith(s)) continue;
                matches[i2] = true;
                continue block0;
            }
        }
        return !(names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1]);
    }

    private static Method getFunctionMethod(Class<?> cls, boolean[] callbackAllocators) {
        if (!FunctionPointer.class.isAssignableFrom(cls)) {
            return null;
        }
        Method[] methods = cls.getDeclaredMethods();
        Method functionMethod = null;
        for (int i2 = 0; i2 < methods.length; ++i2) {
            String methodName = methods[i2].getName();
            int modifiers = methods[i2].getModifiers();
            Class<?>[] parameterTypes = methods[i2].getParameterTypes();
            Class<?> returnType = methods[i2].getReturnType();
            if (!Modifier.isNative(modifiers) || Modifier.isStatic(modifiers)) continue;
            if (callbackAllocators != null && methodName.startsWith("allocate") && returnType == Void.TYPE && parameterTypes.length == 0) {
                callbackAllocators[i2] = true;
                continue;
            }
            if (!methodName.startsWith("call")) continue;
            functionMethod = methods[i2];
        }
        return functionMethod;
    }

    public static MethodInformation getMethodInformation(Method method) {
        String[] stringArray;
        if (!Modifier.isNative(method.getModifiers())) {
            return null;
        }
        MethodInformation info = new MethodInformation();
        info.cls = method.getDeclaringClass();
        info.method = method;
        info.annotations = method.getAnnotations();
        info.modifiers = method.getModifiers();
        info.returnType = method.getReturnType();
        info.name = method.getName();
        Name name = method.getAnnotation(Name.class);
        if (name != null) {
            stringArray = name.value();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = info.name;
        }
        info.memberName = stringArray;
        Index index = method.getAnnotation(Index.class);
        info.dim = index != null ? index.value() : 0;
        info.parameterTypes = method.getParameterTypes();
        info.parameterAnnotations = method.getParameterAnnotations();
        info.returnRaw = method.isAnnotationPresent(Raw.class);
        info.withEnv = info.returnRaw ? method.getAnnotation(Raw.class).withEnv() : false;
        info.parameterRaw = new boolean[info.parameterAnnotations.length];
        for (int i2 = 0; i2 < info.parameterAnnotations.length; ++i2) {
            for (int j2 = 0; j2 < info.parameterAnnotations[i2].length; ++j2) {
                if (!(info.parameterAnnotations[i2][j2] instanceof Raw)) continue;
                info.parameterRaw[i2] = true;
                info.withEnv |= ((Raw)info.parameterAnnotations[i2][j2]).withEnv();
            }
        }
        boolean canBeGetter = info.returnType != Void.TYPE || info.parameterTypes.length > 0 && info.parameterTypes[0].isArray() && info.parameterTypes[0].getComponentType().isPrimitive();
        boolean canBeSetter = (info.returnType == Void.TYPE || info.returnType == info.cls) && info.parameterTypes.length > 0;
        boolean canBeAllocator = !Modifier.isStatic(info.modifiers) && info.returnType == Void.TYPE;
        boolean canBeArrayAllocator = canBeAllocator && info.parameterTypes.length == 1 && (info.parameterTypes[0] == Integer.TYPE || info.parameterTypes[0] == Long.TYPE);
        boolean valueGetter = false;
        boolean valueSetter = false;
        boolean memberGetter = false;
        boolean memberSetter = false;
        boolean noReturnGetter = false;
        Method pairedMethod = null;
        Method[] methods = info.cls.getDeclaredMethods();
        for (int i3 = 0; i3 < methods.length; ++i3) {
            boolean parameterAsReturn2;
            Method method2 = methods[i3];
            int modifiers2 = method2.getModifiers();
            Class<?> returnType2 = method2.getReturnType();
            String methodName2 = method2.getName();
            Class<?>[] parameterTypes2 = method2.getParameterTypes();
            if (method.equals(method2) || !Modifier.isNative(modifiers2)) continue;
            boolean canBeValueGetter = false;
            boolean canBeValueSetter = false;
            if (canBeGetter && "get".equals(info.name) && "put".equals(methodName2)) {
                canBeValueGetter = true;
            } else if (canBeSetter && "put".equals(info.name) && "get".equals(methodName2)) {
                canBeValueSetter = true;
            } else {
                if (!methodName2.equals(info.name)) continue;
                info.overloaded = true;
            }
            boolean sameIndexParameters = true;
            for (int j3 = 0; j3 < info.parameterTypes.length && j3 < parameterTypes2.length; ++j3) {
                if (info.parameterTypes[j3] == parameterTypes2[j3]) continue;
                sameIndexParameters = false;
            }
            if (!sameIndexParameters) continue;
            boolean parameterAsReturn = canBeValueGetter && info.parameterTypes.length > 0 && info.parameterTypes[0].isArray() && info.parameterTypes[0].getComponentType().isPrimitive();
            boolean bl = parameterAsReturn2 = canBeValueSetter && parameterTypes2.length > 0 && parameterTypes2[0].isArray() && parameterTypes2[0].getComponentType().isPrimitive();
            if (canBeGetter && parameterTypes2.length - (parameterAsReturn ? 0 : 1) == info.parameterTypes.length && (parameterAsReturn ? info.parameterTypes[info.parameterTypes.length - 1] : info.returnType) == parameterTypes2[parameterTypes2.length - 1] && (returnType2 == Void.TYPE || returnType2 == info.cls)) {
                pairedMethod = method2;
                valueGetter = canBeValueGetter;
                memberGetter = !canBeValueGetter;
                noReturnGetter = parameterAsReturn;
                continue;
            }
            if (!canBeSetter || info.parameterTypes.length - (parameterAsReturn2 ? 0 : 1) != parameterTypes2.length || (parameterAsReturn2 ? parameterTypes2[parameterTypes2.length - 1] : returnType2) != info.parameterTypes[info.parameterTypes.length - 1]) continue;
            pairedMethod = method2;
            valueSetter = canBeValueSetter;
            memberSetter = !canBeValueSetter;
        }
        Annotation behavior = Generator.getBehavior(info.annotations);
        if (canBeGetter && behavior instanceof ValueGetter) {
            info.valueGetter = true;
            info.noReturnGetter = noReturnGetter;
        } else if (canBeSetter && behavior instanceof ValueSetter) {
            info.valueSetter = true;
        } else if (canBeGetter && behavior instanceof MemberGetter) {
            info.memberGetter = true;
            info.noReturnGetter = noReturnGetter;
        } else if (canBeSetter && behavior instanceof MemberSetter) {
            info.memberSetter = true;
        } else if (canBeAllocator && behavior instanceof Allocator) {
            info.allocator = true;
        } else if (canBeArrayAllocator && behavior instanceof ArrayAllocator) {
            info.arrayAllocator = true;
            info.allocator = true;
        } else if (behavior == null) {
            if (info.returnType == Void.TYPE && "deallocate".equals(info.name) && !Modifier.isStatic(info.modifiers) && info.parameterTypes.length == 2 && info.parameterTypes[0] == Long.TYPE && info.parameterTypes[1] == Long.TYPE) {
                info.deallocator = true;
            } else if (canBeAllocator && "allocate".equals(info.name)) {
                info.allocator = true;
            } else if (canBeArrayAllocator && "allocateArray".equals(info.name)) {
                info.arrayAllocator = true;
                info.allocator = true;
            } else if (info.returnType.isAssignableFrom(ByteBuffer.class) && "asDirectBuffer".equals(info.name) && !Modifier.isStatic(info.modifiers) && info.parameterTypes.length == 0) {
                info.bufferGetter = true;
            } else if (valueGetter) {
                info.valueGetter = true;
                info.noReturnGetter = noReturnGetter;
                info.pairedMethod = pairedMethod;
            } else if (valueSetter) {
                info.valueSetter = true;
                info.pairedMethod = pairedMethod;
            } else if (memberGetter) {
                info.memberGetter = true;
                info.noReturnGetter = noReturnGetter;
                info.pairedMethod = pairedMethod;
            } else if (memberSetter) {
                info.memberSetter = true;
                info.pairedMethod = pairedMethod;
            }
        } else {
            logger.log(Level.WARNING, "Method \"" + method + "\" cannot behave like a \"" + behavior + "\". No code will be generated.");
            return null;
        }
        if (name == null && info.pairedMethod != null && (name = info.pairedMethod.getAnnotation(Name.class)) != null) {
            info.memberName = name.value();
        }
        boolean bl = info.noOffset = method.isAnnotationPresent(NoOffset.class) || method.isAnnotationPresent(Index.class);
        if (!info.noOffset && info.pairedMethod != null) {
            boolean bl2 = info.noOffset = info.pairedMethod.isAnnotationPresent(NoOffset.class) || info.pairedMethod.isAnnotationPresent(Index.class);
        }
        if (info.parameterTypes.length == 0 || !info.parameterTypes[0].isArray()) {
            if (info.valueGetter || info.memberGetter) {
                info.dim = info.parameterTypes.length;
            } else if (info.memberSetter || info.valueSetter) {
                info.dim = info.parameterTypes.length - 1;
            }
        }
        if (!((info.deallocator || info.valueGetter || info.valueSetter || info.memberGetter || info.memberSetter || info.bufferGetter) && !(Generator.getBy(info.annotations) instanceof ByVal))) {
            info.mayThrowException = true;
        }
        return info;
    }

    public static Adapter getParameterAdapter(MethodInformation methodInfo, int j2) {
        Adapter adapter = Generator.getAdapter(methodInfo.parameterAnnotations[j2]);
        if (adapter == null && methodInfo.pairedMethod != null && (methodInfo.valueSetter || methodInfo.memberSetter)) {
            adapter = Generator.getAdapter(methodInfo.pairedMethod.getAnnotations());
        }
        return adapter;
    }

    public static Adapter getAdapter(Annotation ... annotations) {
        for (Annotation a2 : annotations) {
            if (!(a2 instanceof Adapter)) continue;
            return (Adapter)a2;
        }
        return null;
    }

    public static String getParameterCast(MethodInformation methodInfo, int j2) {
        String cast = Generator.getCast(methodInfo.parameterAnnotations[j2], methodInfo.parameterTypes[j2]);
        if ((cast == null || cast.length() == 0) && j2 == methodInfo.parameterTypes.length - 1 && (methodInfo.valueSetter || methodInfo.memberSetter) && methodInfo.pairedMethod != null) {
            cast = Generator.getCast(methodInfo.pairedMethod.getAnnotations(), methodInfo.pairedMethod.getReturnType());
        }
        return cast;
    }

    public static String getCast(Annotation[] annotations, Class<?> type) {
        String[] typeName = null;
        Annotation by = Generator.getBy(annotations);
        for (Annotation a2 : annotations) {
            if (a2 instanceof Cast || a2 instanceof Const && (by instanceof ByVal || by instanceof ByRef)) {
                typeName = Generator.getCastedCPPTypeName(annotations, type);
                continue;
            }
            if (!(a2 instanceof Const)) continue;
            typeName = Generator.getAnnotatedCPPTypeName(annotations, type);
        }
        return typeName != null ? "(" + (String)typeName[0] + typeName[1] + ")" : "";
    }

    public static Annotation getParameterBy(MethodInformation methodInfo, int j2) {
        Annotation passBy = Generator.getBy(methodInfo.parameterAnnotations[j2]);
        if (passBy == null && methodInfo.pairedMethod != null && (methodInfo.valueSetter || methodInfo.memberSetter)) {
            passBy = Generator.getBy(methodInfo.pairedMethod.getAnnotations());
        }
        return passBy;
    }

    public static Annotation getBy(Annotation ... annotations) {
        Annotation byAnnotation = null;
        for (Annotation a2 : annotations) {
            if (!(a2 instanceof ByPtr) && !(a2 instanceof ByPtrPtr) && !(a2 instanceof ByPtrRef) && !(a2 instanceof ByRef) && !(a2 instanceof ByVal)) continue;
            if (byAnnotation != null) {
                logger.log(Level.WARNING, "\"By\" annotation \"" + byAnnotation + "\" already found. Ignoring superfluous annotation \"" + a2 + "\".");
                continue;
            }
            byAnnotation = a2;
        }
        return byAnnotation;
    }

    public static Annotation getBehavior(Annotation ... annotations) {
        Annotation behaviorAnnotation = null;
        for (Annotation a2 : annotations) {
            if (!(a2 instanceof Function) && !(a2 instanceof Allocator) && !(a2 instanceof ArrayAllocator) && !(a2 instanceof ValueSetter) && !(a2 instanceof ValueGetter) && !(a2 instanceof MemberGetter) && !(a2 instanceof MemberSetter)) continue;
            if (behaviorAnnotation != null) {
                logger.log(Level.WARNING, "Behavior annotation \"" + behaviorAnnotation + "\" already found. Ignoring superfluous annotation \"" + a2 + "\".");
                continue;
            }
            behaviorAnnotation = a2;
        }
        return behaviorAnnotation;
    }

    public static String[] getAnnotatedCPPTypeName(Annotation[] annotations, Class<?> type) {
        String[] typeName = Generator.getCastedCPPTypeName(annotations, type);
        String prefix = typeName[0];
        String suffix = typeName[1];
        Annotation by = Generator.getBy(annotations);
        if (by instanceof ByVal) {
            prefix = prefix.substring(0, prefix.length() - 1);
        } else if (by instanceof ByRef) {
            prefix = prefix.substring(0, prefix.length() - 1) + "&";
        } else if (by instanceof ByPtrPtr) {
            prefix = prefix + "*";
        } else if (by instanceof ByPtrRef) {
            prefix = prefix + "&";
        }
        typeName[0] = prefix;
        typeName[1] = suffix;
        return typeName;
    }

    public static String[] getCastedCPPTypeName(Annotation[] annotations, Class<?> type) {
        String[] typeName = null;
        boolean warning = false;
        for (Annotation a2 : annotations) {
            if (a2 instanceof Cast) {
                warning = typeName != null;
                String prefix = ((Cast)a2).value();
                String suffix = "";
                int parenthesis = prefix.indexOf(41);
                if (parenthesis > 0) {
                    suffix = prefix.substring(parenthesis).trim();
                    prefix = prefix.substring(0, parenthesis).trim();
                }
                typeName = new String[]{prefix, suffix};
                continue;
            }
            if (!(a2 instanceof Const)) continue;
            warning = typeName != null;
            typeName = Generator.getCPPTypeName(type);
            typeName[0] = "const " + typeName[0];
        }
        if (warning) {
            logger.log(Level.WARNING, "\"Cast\" and \"Const\" annotations are mutually exclusive.");
        }
        if (typeName == null) {
            typeName = Generator.getCPPTypeName(type);
        }
        return typeName;
    }

    public static String[] getCPPTypeName(Class<?> type) {
        String prefix = "";
        String suffix = "";
        if (type == Buffer.class || type == Pointer.class) {
            prefix = "void*";
        } else if (type == byte[].class || type == ByteBuffer.class || type == BytePointer.class) {
            prefix = "signed char*";
        } else if (type == short[].class || type == ShortBuffer.class || type == ShortPointer.class) {
            prefix = "short*";
        } else if (type == int[].class || type == IntBuffer.class || type == IntPointer.class) {
            prefix = "int*";
        } else if (type == long[].class || type == LongBuffer.class || type == LongPointer.class) {
            prefix = "jlong*";
        } else if (type == float[].class || type == FloatBuffer.class || type == FloatPointer.class) {
            prefix = "float*";
        } else if (type == double[].class || type == DoubleBuffer.class || type == DoublePointer.class) {
            prefix = "double*";
        } else if (type == char[].class || type == CharBuffer.class || type == CharPointer.class) {
            prefix = "unsigned short*";
        } else if (type == boolean[].class) {
            prefix = "unsigned char*";
        } else if (type == PointerPointer.class) {
            prefix = "void**";
        } else if (type == String.class) {
            prefix = "const char*";
        } else if (type == Byte.TYPE) {
            prefix = "signed char";
        } else if (type == Long.TYPE) {
            prefix = "jlong";
        } else if (type == Character.TYPE) {
            prefix = "unsigned short";
        } else if (type == Boolean.TYPE) {
            prefix = "unsigned char";
        } else if (type.isPrimitive()) {
            prefix = type.getName();
        } else if (FunctionPointer.class.isAssignableFrom(type)) {
            Method functionMethod = Generator.getFunctionMethod(type, null);
            if (functionMethod != null) {
                int j2;
                Convention convention = type.getAnnotation(Convention.class);
                String callingConvention = convention == null ? "" : convention.value() + " ";
                Namespace namespace = type.getAnnotation(Namespace.class);
                String spaceName = namespace == null ? "" : namespace.value() + "::";
                Class<?> returnType = functionMethod.getReturnType();
                Class<?>[] parameterTypes = functionMethod.getParameterTypes();
                Annotation[] annotations = functionMethod.getAnnotations();
                Annotation[][] parameterAnnotations = functionMethod.getParameterAnnotations();
                String[] returnTypeName = Generator.getAnnotatedCPPTypeName(annotations, returnType);
                prefix = returnTypeName[0] + returnTypeName[1] + " (" + callingConvention + spaceName + "*";
                suffix = ")(";
                if (namespace != null && !Pointer.class.isAssignableFrom(parameterTypes[0])) {
                    logger.log(Level.WARNING, "First parameter of call() method for member function pointer " + type.getCanonicalName() + " is not a Pointer. Compilation will most likely fail.");
                }
                int n2 = j2 = namespace == null ? 0 : 1;
                while (j2 < parameterTypes.length) {
                    String[] paramTypeName = Generator.getAnnotatedCPPTypeName(parameterAnnotations[j2], parameterTypes[j2]);
                    suffix = suffix + paramTypeName[0] + " p" + j2 + paramTypeName[1];
                    if (j2 < parameterTypes.length - 1) {
                        suffix = suffix + ", ";
                    }
                    ++j2;
                }
                suffix = suffix + ")";
                if (type.isAnnotationPresent(Const.class)) {
                    suffix = suffix + " const";
                }
            }
        } else {
            String spacedType = "";
            while (type != null) {
                String spaceName;
                Namespace namespace = type.getAnnotation(Namespace.class);
                String string = spaceName = namespace == null ? "" : namespace.value();
                if (Pointer.class.isAssignableFrom(type)) {
                    String s;
                    Name name = type.getAnnotation(Name.class);
                    if (name == null) {
                        s = type.getName();
                        s = s.substring(s.lastIndexOf("$") + 1);
                    } else {
                        s = name.value()[0];
                    }
                    spaceName = spaceName.length() == 0 ? s : spaceName + "::" + s;
                }
                if (spacedType.length() == 0) {
                    spacedType = spaceName;
                } else if (spaceName.length() > 0) {
                    spacedType = spaceName + "::" + spacedType;
                }
                type = type.getDeclaringClass();
            }
            prefix = spacedType.length() > 0 ? spacedType + "*" : "";
        }
        return new String[]{prefix, suffix};
    }

    public static String getJNITypeName(Class type) {
        if (type == Byte.TYPE) {
            return "jbyte";
        }
        if (type == Short.TYPE) {
            return "jshort";
        }
        if (type == Integer.TYPE) {
            return "jint";
        }
        if (type == Long.TYPE) {
            return "jlong";
        }
        if (type == Float.TYPE) {
            return "jfloat";
        }
        if (type == Double.TYPE) {
            return "jdouble";
        }
        if (type == Character.TYPE) {
            return "jchar";
        }
        if (type == Boolean.TYPE) {
            return "jboolean";
        }
        if (type == byte[].class) {
            return "jbyteArray";
        }
        if (type == short[].class) {
            return "jshortArray";
        }
        if (type == int[].class) {
            return "jintArray";
        }
        if (type == long[].class) {
            return "jlongArray";
        }
        if (type == float[].class) {
            return "jfloatArray";
        }
        if (type == double[].class) {
            return "jdoubleArray";
        }
        if (type == char[].class) {
            return "jcharArray";
        }
        if (type == boolean[].class) {
            return "jbooleanArray";
        }
        if (type.isArray()) {
            return "jobjectArray";
        }
        if (type == String.class) {
            return "jstring";
        }
        if (type == Class.class) {
            return "jclass";
        }
        if (type == Void.TYPE) {
            return "void";
        }
        return "jobject";
    }

    public static String getSignature(Class ... types) {
        StringBuilder signature = new StringBuilder(2 * types.length);
        for (int i2 = 0; i2 < types.length; ++i2) {
            signature.append(Generator.getSignature(types[i2]));
        }
        return signature.toString();
    }

    public static String getSignature(Class type) {
        if (type == Byte.TYPE) {
            return "B";
        }
        if (type == Short.TYPE) {
            return "S";
        }
        if (type == Integer.TYPE) {
            return "I";
        }
        if (type == Long.TYPE) {
            return "J";
        }
        if (type == Float.TYPE) {
            return "F";
        }
        if (type == Double.TYPE) {
            return "D";
        }
        if (type == Boolean.TYPE) {
            return "Z";
        }
        if (type == Character.TYPE) {
            return "C";
        }
        if (type == Void.TYPE) {
            return "V";
        }
        if (type.isArray()) {
            return type.getName().replace(".", "/");
        }
        return "L" + type.getName().replace(".", "/") + ";";
    }

    public static String mangle(String name) {
        StringBuilder mangledName = new StringBuilder(name.length());
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
                mangledName.append(c2);
                continue;
            }
            if (c2 == '_') {
                mangledName.append("_1");
                continue;
            }
            if (c2 == ';') {
                mangledName.append("_2");
                continue;
            }
            if (c2 == '[') {
                mangledName.append("_3");
                continue;
            }
            if (c2 == '.' || c2 == '/') {
                mangledName.append("_");
                continue;
            }
            String code = Integer.toHexString(c2);
            mangledName.append("_0");
            switch (code.length()) {
                case 1: {
                    mangledName.append("0");
                }
                case 2: {
                    mangledName.append("0");
                }
                case 3: {
                    mangledName.append("0");
                }
            }
            mangledName.append(code);
        }
        return mangledName.toString();
    }

    public static class MethodInformation {
        public Class<?> cls;
        public Method method;
        public Annotation[] annotations;
        public int modifiers;
        public Class<?> returnType;
        public String name;
        public String[] memberName;
        public int dim;
        public boolean[] parameterRaw;
        public Class<?>[] parameterTypes;
        public Annotation[][] parameterAnnotations;
        public boolean returnRaw;
        public boolean withEnv;
        public boolean overloaded;
        public boolean noOffset;
        public boolean deallocator;
        public boolean allocator;
        public boolean arrayAllocator;
        public boolean bufferGetter;
        public boolean valueGetter;
        public boolean valueSetter;
        public boolean memberGetter;
        public boolean memberSetter;
        public boolean noReturnGetter;
        public Method pairedMethod;
        public boolean mayThrowException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedListRegister<E>
    extends LinkedList<E> {
        public int register(E e2) {
            int i2 = this.indexOf(e2);
            if (i2 < 0) {
                this.add(e2);
                i2 = this.size() - 1;
            }
            return i2;
        }
    }
}

