/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.BaseChildSettings;
import com.googlecode.javacv.JavaCV;
import com.googlecode.javacv.Marker;
import com.googlecode.javacv.cpp.ARToolKitPlus;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.util.Arrays;
import java.util.logging.Logger;

public class MarkerDetector {
    private Settings settings;
    private ARToolKitPlus.MultiTracker tracker = null;
    private int width = 0;
    private int height = 0;
    private int depth = 0;
    private int channels = 0;
    private opencv_core.IplImage tempImage;
    private opencv_core.IplImage tempImage2;
    private opencv_core.IplImage sumImage;
    private opencv_core.IplImage sqSumImage;
    private opencv_core.IplImage thresholdedImage;
    private opencv_core.CvMat points = opencv_core.CvMat.create(1, 4, 5, 2);
    private opencv_core.CvPoint2D32f corners = new opencv_core.CvPoint2D32f(4);
    private opencv_core.CvMemStorage memory = opencv_core.CvMemStorage.create();
    private opencv_core.CvSize subPixelSize = null;
    private opencv_core.CvSize subPixelZeroZone = null;
    private opencv_core.CvTermCriteria subPixelTermCriteria = null;
    private opencv_core.CvPoint pts = new opencv_core.CvPoint(4);
    private opencv_core.CvPoint pt1 = new opencv_core.CvPoint();
    private opencv_core.CvPoint pt2 = new opencv_core.CvPoint();
    private opencv_core.CvFont font = new opencv_core.CvFont(1, 1.0, 1);
    private opencv_core.CvSize textSize = new opencv_core.CvSize();

    public MarkerDetector(Settings settings) {
        this.setSettings(settings);
    }

    public MarkerDetector() {
        this(new Settings());
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.subPixelSize = opencv_core.cvSize(settings.subPixelWindow / 2, settings.subPixelWindow / 2);
        this.subPixelZeroZone = opencv_core.cvSize(-1, -1);
        this.subPixelTermCriteria = opencv_core.cvTermCriteria(2, 100, 0.001);
    }

    public opencv_core.IplImage getThresholdedImage() {
        return this.thresholdedImage;
    }

    private void init(opencv_core.IplImage image) {
        if (this.tracker != null && image.width() == this.width && image.height() == this.height && image.depth() == this.depth && image.nChannels() == this.channels) {
            return;
        }
        this.width = image.width();
        this.height = image.height();
        this.depth = image.depth();
        this.channels = image.nChannels();
        if (this.depth != 8 || this.channels > 1) {
            this.tempImage = opencv_core.IplImage.create(this.width, this.height, 8, 1);
        }
        if (this.depth != 8 && this.channels > 1) {
            this.tempImage2 = opencv_core.IplImage.create(this.width, this.height, 8, 3);
        }
        this.sumImage = opencv_core.IplImage.create(this.width + 1, this.height + 1, 64, 1);
        this.sqSumImage = opencv_core.IplImage.create(this.width + 1, this.height + 1, 64, 1);
        this.thresholdedImage = opencv_core.IplImage.create(this.width, this.height, 8, 1);
        this.tracker = new ARToolKitPlus.MultiTracker(this.thresholdedImage.widthStep(), this.thresholdedImage.height());
        this.tracker.setLoggerFunction(new ARToolKitPlus.ArtLogFunction(){

            public void call(String nStr) {
                Logger.getLogger(MarkerDetector.class.getName()).warning(nStr);
            }
        });
        int pixfmt = 7;
        this.tracker.setPixelFormat(pixfmt);
        this.tracker.setBorderWidth(0.125);
        this.tracker.setUndistortionMode(0);
        this.tracker.setMarkerMode(2);
        this.tracker.setImageProcessingMode(1);
    }

    public Marker[] detect(opencv_core.IplImage image, boolean whiteMarkers) {
        this.init(image);
        if (this.depth != 8 && this.channels > 1) {
            opencv_core.cvConvertScale(image, this.tempImage2, 255.0 / image.highValue(), 0.0);
            opencv_imgproc.cvCvtColor(this.tempImage2, this.tempImage, this.channels > 3 ? 11 : 6);
            image = this.tempImage;
        } else if (this.depth != 8) {
            opencv_core.cvConvertScale(image, this.tempImage, 255.0 / image.highValue(), 0.0);
            image = this.tempImage;
        } else if (this.channels > 1) {
            opencv_imgproc.cvCvtColor(image, this.tempImage, this.channels > 3 ? 11 : 6);
            image = this.tempImage;
        }
        JavaCV.adaptiveThreshold(image, this.sumImage, this.sqSumImage, this.thresholdedImage, whiteMarkers, this.settings.thresholdWindowMax, this.settings.thresholdWindowMin, this.settings.thresholdVarMultiplier, whiteMarkers ? this.settings.thresholdKWhiteMarkers : this.settings.thresholdKBlackMarkers);
        int[] n2 = new int[1];
        ARToolKitPlus.ARMarkerInfo markers = new ARToolKitPlus.ARMarkerInfo(null);
        this.tracker.arDetectMarkerLite(this.thresholdedImage.getByteBuffer(), 128, markers, n2);
        Marker[] markers2 = new Marker[n2[0]];
        int n22 = 0;
        for (int i2 = 0; i2 < n2[0] && !markers.isNull(); ++i2) {
            markers.position(i2);
            int id = markers.id();
            if (id < 0) continue;
            int dir = markers.dir();
            double confidence = markers.cf();
            double[] vertex = new double[8];
            markers.vertex().get(vertex);
            int w = this.settings.subPixelWindow / 2 + 1;
            if (vertex[0] - (double)w < 0.0 || vertex[0] + (double)w >= (double)this.width || vertex[1] - (double)w < 0.0 || vertex[1] + (double)w >= (double)this.height || vertex[2] - (double)w < 0.0 || vertex[2] + (double)w >= (double)this.width || vertex[3] - (double)w < 0.0 || vertex[3] + (double)w >= (double)this.height || vertex[4] - (double)w < 0.0 || vertex[4] + (double)w >= (double)this.width || vertex[5] - (double)w < 0.0 || vertex[5] + (double)w >= (double)this.height || vertex[6] - (double)w < 0.0 || vertex[6] + (double)w >= (double)this.width || vertex[7] - (double)w < 0.0 || vertex[7] + (double)w >= (double)this.height) continue;
            opencv_core.CvBox2D box = opencv_imgproc.cvMinAreaRect2(this.points.put(vertex), this.memory);
            float bw = box.size().width();
            float bh = box.size().height();
            opencv_core.cvClearMemStorage(this.memory);
            if (bw <= 0.0f || bh <= 0.0f || (double)(bw / bh) < 0.1 || bw / bh > 10.0f) continue;
            for (int j2 = 0; j2 < 4; ++j2) {
                this.corners.position(j2).put(vertex[2 * j2], vertex[2 * j2 + 1]);
            }
            opencv_imgproc.cvFindCornerSubPix(image, this.corners.position(0), 4, this.subPixelSize, this.subPixelZeroZone, this.subPixelTermCriteria);
            vertex[0] = this.corners.position((4 - dir) % 4).x();
            vertex[1] = this.corners.position((4 - dir) % 4).y();
            vertex[2] = this.corners.position((5 - dir) % 4).x();
            vertex[3] = this.corners.position((5 - dir) % 4).y();
            vertex[4] = this.corners.position((6 - dir) % 4).x();
            vertex[5] = this.corners.position((6 - dir) % 4).y();
            vertex[6] = this.corners.position((7 - dir) % 4).x();
            vertex[7] = this.corners.position((7 - dir) % 4).y();
            markers2[n22++] = new Marker(id, vertex, confidence);
        }
        return Arrays.copyOf(markers2, n22);
    }

    public void draw(opencv_core.IplImage image, Marker[] markers) {
        for (Marker m2 : markers) {
            int cx = 0;
            int cy = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                int x = (int)Math.round(m2.corners[i2 * 2] * 65536.0);
                int y = (int)Math.round(m2.corners[i2 * 2 + 1] * 65536.0);
                this.pts.position(i2).x(x);
                this.pts.position(i2).y(y);
                cx += x;
                cy += y;
            }
            cx /= 4;
            cy /= 4;
            opencv_core.cvPolyLine((opencv_core.CvArr)image, this.pts, new int[]{4}, 1, 1, opencv_core.CV_RGB(0.0, 0.0, image.highValue()), 1, 16, 16);
            String text = Integer.toString(m2.id);
            int[] baseline = new int[1];
            opencv_core.cvGetTextSize(text, this.font, this.textSize, baseline);
            this.pt1.x(cx - (this.textSize.width() * 3 / 2 << 16) / 2);
            this.pt1.y(cy + (this.textSize.height() * 3 / 2 << 16) / 2);
            this.pt2.x(cx + (this.textSize.width() * 3 / 2 << 16) / 2);
            this.pt2.y(cy - (this.textSize.height() * 3 / 2 << 16) / 2);
            opencv_core.cvRectangle(image, this.pt1, this.pt2, opencv_core.CV_RGB(0.0, image.highValue(), 0.0), -1, 16, 16);
            this.pt1.x((int)Math.round((double)cx / 65536.0 - (double)(this.textSize.width() / 2)));
            this.pt1.y((int)Math.round((double)cy / 65536.0 + (double)(this.textSize.height() / 2) + 1.0));
            opencv_core.cvPutText(image, text, this.pt1, this.font, opencv_core.CvScalar.BLACK);
        }
    }

    public static class Settings
    extends BaseChildSettings {
        int thresholdWindowMin = 5;
        int thresholdWindowMax = 63;
        double thresholdVarMultiplier = 1.0;
        double thresholdKBlackMarkers = 0.6;
        double thresholdKWhiteMarkers = 1.0;
        int subPixelWindow = 11;

        public int getThresholdWindowMin() {
            return this.thresholdWindowMin;
        }

        public void setThresholdWindowMin(int thresholdWindowMin) {
            this.thresholdWindowMin = thresholdWindowMin;
        }

        public int getThresholdWindowMax() {
            return this.thresholdWindowMax;
        }

        public void setThresholdWindowMax(int thresholdWindowMax) {
            this.thresholdWindowMax = thresholdWindowMax;
        }

        public double getThresholdVarMultiplier() {
            return this.thresholdVarMultiplier;
        }

        public void setThresholdVarMultiplier(double thresholdVarMultiplier) {
            this.thresholdVarMultiplier = thresholdVarMultiplier;
        }

        public double getThresholdKBlackMarkers() {
            return this.thresholdKBlackMarkers;
        }

        public void setThresholdKBlackMarkers(double thresholdKBlackMarkers) {
            this.thresholdKBlackMarkers = thresholdKBlackMarkers;
        }

        public double getThresholdKWhiteMarkers() {
            return this.thresholdKWhiteMarkers;
        }

        public void setThresholdKWhiteMarkers(double thresholdKWhiteMarkers) {
            this.thresholdKWhiteMarkers = thresholdKWhiteMarkers;
        }

        public int getSubPixelWindow() {
            return this.subPixelWindow;
        }

        public void setSubPixelWindow(int subPixelWindow) {
            this.subPixelWindow = subPixelWindow;
        }
    }
}

