/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.FrameRecorder;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_highgui;
import java.io.File;

public class OpenCVFrameRecorder
extends FrameRecorder {
    private static FrameRecorder.Exception loadingException = null;
    private static final boolean windows = Loader.getPlatformName().startsWith("windows");
    private String filename;
    private opencv_highgui.CvVideoWriter writer = null;

    public static void tryLoad() throws FrameRecorder.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(opencv_highgui.class);
        }
        catch (Throwable t) {
            loadingException = new FrameRecorder.Exception("Failed to load " + OpenCVFrameRecorder.class, t);
            throw loadingException;
        }
    }

    public OpenCVFrameRecorder(File file, int imageWidth, int imageHeight) {
        this(file.getAbsolutePath(), imageWidth, imageHeight);
    }

    public OpenCVFrameRecorder(String filename, int imageWidth, int imageHeight) {
        this.filename = filename;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.pixelFormat = 1;
        this.codecID = windows ? -1 : opencv_highgui.CV_FOURCC_DEFAULT;
        this.bitrate = 0;
        this.frameRate = 30.0;
    }

    public void release() throws FrameRecorder.Exception {
        this.stop();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public void start() throws FrameRecorder.Exception {
        this.writer = opencv_highgui.cvCreateVideoWriter(this.filename, this.codecID, this.frameRate, opencv_core.cvSize(this.imageWidth, this.imageHeight), this.pixelFormat);
        if (this.writer == null) {
            throw new FrameRecorder.Exception("cvCreateVideoWriter(): Could not create a writer");
        }
    }

    public void stop() throws FrameRecorder.Exception {
        if (this.writer != null) {
            opencv_highgui.cvReleaseVideoWriter(this.writer);
            this.writer = null;
        }
    }

    public void record(opencv_core.IplImage frame) throws FrameRecorder.Exception {
        if (this.writer != null) {
            if (opencv_highgui.cvWriteFrame(this.writer, frame) == 0) {
                throw new FrameRecorder.Exception("cvWriteFrame(): Could not record frame");
            }
        } else {
            throw new FrameRecorder.Exception("Cannot record: There is no writer (Has start() been called?)");
        }
    }
}

