/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv.cpp;

import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.annotation.ByRef;
import com.googlecode.javacpp.annotation.MemberSetter;
import com.googlecode.javacpp.annotation.Name;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.Properties;
import com.googlecode.javacv.Parallel;
import com.googlecode.javacv.cpp.opencv_core;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.Arrays;

@Properties(value={@Platform(define={"MAX_SIZE 16"}, include={"cvkernels.h"}, options={"fastfpu"}, includepath={"/opt/local/include/"}), @Platform(value={"windows"}, includepath={"C:/opencv/build/include/"}), @Platform(value={"android"}, includepath={"../include/"})})
public class cvkernels {
    private static ThreadLocal<ParallelData[]> parallelData;

    public static native void multiWarpColorTransform32F(KernelData var0, int var1, opencv_core.CvRect var2, opencv_core.CvScalar var3);

    public static native void multiWarpColorTransform8U(KernelData var0, int var1, opencv_core.CvRect var2, opencv_core.CvScalar var3);

    public static void multiWarpColorTransform(KernelData data, opencv_core.CvRect roi, final opencv_core.CvScalar fillColor) {
        int h2;
        int w;
        int y;
        int x;
        final int size = data.capacity();
        final ParallelData[] pd = parallelData.get();
        for (int i2 = 0; i2 < pd.length; ++i2) {
            KernelData d2;
            int j2;
            if (pd[i2].data == null || pd[i2].data.capacity() < size) {
                pd[i2].data = new KernelData(size);
                for (j2 = 0; j2 < size; ++j2) {
                    d2 = pd[i2].data.position(j2);
                    data.position(j2);
                    if (data.dstDstDot() == null) continue;
                    d2.dstDstDot(ByteBuffer.allocateDirect(data.dstDstDot().capacity() * 8).order(ByteOrder.nativeOrder()).asDoubleBuffer());
                }
            }
            for (j2 = 0; j2 < size; ++j2) {
                d2 = pd[i2].data.position(j2);
                d2.copy(data.position(j2));
                d2.dstDstDot(d2.dstDstDot());
            }
        }
        opencv_core.IplImage img = data.position(0).srcImg();
        final int depth = img.depth();
        if (roi != null) {
            x = roi.x();
            y = roi.y();
            w = roi.width();
            h2 = roi.height();
        } else {
            x = 0;
            y = 0;
            w = img.width();
            h2 = img.height();
        }
        Parallel.loop(y, y + h2, pd.length, new Parallel.Looper(){

            public void loop(int from, int to, int looperID) {
                opencv_core.CvRect r = pd[looperID].roi.x(x).y(from).width(w).height(to - from);
                if (depth == 32) {
                    cvkernels.multiWarpColorTransform32F(pd[looperID].data.position(0), size, r, fillColor);
                } else if (depth == 8) {
                    cvkernels.multiWarpColorTransform8U(pd[looperID].data.position(0), size, r, fillColor);
                } else assert (false);
            }
        });
        for (int i3 = 0; i3 < size; ++i3) {
            int dstCount = 0;
            int dstCountZero = 0;
            int dstCountOutlier = 0;
            double srcDstDot = 0.0;
            double[] dstDstDot = null;
            if (data.dstDstDot() != null) {
                dstDstDot = new double[data.dstDstDot().capacity()];
            }
            for (int j3 = 0; j3 < pd.length; ++j3) {
                KernelData d3 = pd[j3].data.position(i3);
                dstCount += d3.dstCount();
                dstCountZero += d3.dstCountZero();
                dstCountOutlier += d3.dstCountOutlier();
                srcDstDot += d3.srcDstDot();
                if (dstDstDot == null || d3.dstDstDot() == null) continue;
                for (int k2 = 0; k2 < dstDstDot.length; ++k2) {
                    int n2 = k2;
                    dstDstDot[n2] = dstDstDot[n2] + d3.dstDstDot().get(k2);
                }
            }
            data.position(i3);
            data.dstCount(dstCount);
            data.dstCountZero(dstCountZero);
            data.dstCountOutlier(dstCountOutlier);
            data.srcDstDot(srcDstDot);
            if (dstDstDot == null || data.dstDstDot() == null) continue;
            data.dstDstDot().position(0);
            data.dstDstDot().put(dstDstDot);
        }
    }

    static {
        Loader.load();
        parallelData = new ThreadLocal<ParallelData[]>(){

            @Override
            protected ParallelData[] initialValue() {
                ParallelData[] pd = new ParallelData[Parallel.getNumThreads()];
                for (int i2 = 0; i2 < pd.length; ++i2) {
                    pd[i2] = new ParallelData();
                }
                return pd;
            }
        };
    }

    private static class ParallelData {
        KernelData data = null;
        opencv_core.CvRect roi = new opencv_core.CvRect();

        private ParallelData() {
        }
    }

    public static class KernelData
    extends Pointer {
        private DoubleBuffer[] dstDstDotBuffers = new DoubleBuffer[1];

        public KernelData() {
            this.allocate();
        }

        public KernelData(int size) {
            this.allocateArray(size);
        }

        public KernelData(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(int var1);

        public KernelData position(int position) {
            return (KernelData)super.position(position);
        }

        public native opencv_core.IplImage srcImg();

        public native KernelData srcImg(opencv_core.IplImage var1);

        public native opencv_core.IplImage srcImg2();

        public native KernelData srcImg2(opencv_core.IplImage var1);

        public native opencv_core.IplImage subImg();

        public native KernelData subImg(opencv_core.IplImage var1);

        public native opencv_core.IplImage srcDotImg();

        public native KernelData srcDotImg(opencv_core.IplImage var1);

        public native opencv_core.IplImage mask();

        public native KernelData mask(opencv_core.IplImage var1);

        public native double zeroThreshold();

        public native KernelData zeroThreshold(double var1);

        public native double outlierThreshold();

        public native KernelData outlierThreshold(double var1);

        public native opencv_core.CvMat H1();

        public native KernelData H1(opencv_core.CvMat var1);

        public native opencv_core.CvMat H2();

        public native KernelData H2(opencv_core.CvMat var1);

        public native opencv_core.CvMat X();

        public native KernelData X(opencv_core.CvMat var1);

        public native opencv_core.IplImage transImg();

        public native KernelData transImg(opencv_core.IplImage var1);

        public native opencv_core.IplImage dstImg();

        public native KernelData dstImg(opencv_core.IplImage var1);

        public native int dstCount();

        public native KernelData dstCount(int var1);

        public native int dstCountZero();

        public native KernelData dstCountZero(int var1);

        public native int dstCountOutlier();

        public native KernelData dstCountOutlier(int var1);

        public native double srcDstDot();

        public native KernelData srcDstDot(double var1);

        @MemberSetter
        @Name(value={"dstDstDot"})
        private native KernelData setDstDstDot(DoubleBuffer var1);

        public DoubleBuffer dstDstDot() {
            return this.dstDstDotBuffers[this.position];
        }

        public KernelData dstDstDot(DoubleBuffer dstDstDot) {
            if (this.dstDstDotBuffers.length < this.capacity) {
                this.dstDstDotBuffers = Arrays.copyOf(this.dstDstDotBuffers, this.capacity);
            }
            this.dstDstDotBuffers[this.position] = dstDstDot;
            return this.setDstDstDot(dstDstDot);
        }

        @Name(value={"operator="})
        @ByRef
        private native KernelData copy(@ByRef KernelData var1);

        static {
            Loader.load();
        }
    }
}

