/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video.h263;

import com.ibm.media.codec.video.h263.FrameBuffer;
import com.ibm.media.codec.video.h263.H263RtpPayloadParser;
import com.ibm.media.codec.video.h263.ReadStream;
import java.awt.Point;

public class H263Decoder
extends ReadStream {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997-1999.";
    private static final boolean DEBUG = false;
    private static final int I_PICTURE = 0;
    private static final int P_PICTURE = 1;
    private static final int INTRA_STUFFING = -1;
    private static final int INTER_STUFFING = -1;
    private static final int ESCAPE_CODE = 7167;
    private static final int PSC = 32;
    private static final int GBSC_1 = 33;
    private static final int GBSC_17 = 49;
    private static final int GBSC_30 = 62;
    private static final int EOS = 63;
    private static final int INIT_FORMAT = 9;
    private static final int USER_DEFINED_FORMAT = 7;
    private static final int SUB_QCIF_FORMAT = 1;
    private static final int QCIF_PAL_FORMAT = 2;
    private static final int CIF_PAL_FORMAT = 3;
    private static final int W0 = 277;
    private static final int W1 = 362;
    private static final int W2 = 473;
    private static final int W3 = 669;
    public static final int H263_RC_PICTURE_NOT_DONE = 0;
    public static final int H263_RC_PICTURE_DONE = 1;
    public static final int H263_RC_PICTURE_FORMAT_NOT_SUPPORTED = 2;
    public static final int H263_RC_PICTURE_FORMAT_NOT_INITED = 3;
    public int TemporalReference;
    public int LastTemporalReference;
    private int rtpTemporalReference;
    private int HeaderPlus;
    private int TypeInformation;
    private int CodingType;
    private int UnrestrictedMV;
    private int DeblockingFilter;
    private int SourceFormat;
    private int CPM;
    private int Quantizer;
    private int GroupNumber;
    private int GOB_FrameID;
    private int[][] BlockData;
    private int[][] BlockPtr = new int[6][];
    private int[] BlockOffset = new int[6];
    private int[] FrameWidthBlock;
    private int LastValue;
    private int FrameWidth;
    private int FrameWidthDiv2;
    private int FrameWidthx8;
    private int FrameHeight;
    private int HorMV;
    private int VerMV;
    private int Half_HorMV;
    private int Half_VerMV;
    private int xFrameWidth;
    private int xFrameWidthDiv2;
    public FrameBuffer CurrentFrame;
    protected boolean frameDone;
    private boolean foundPSC = false;
    private boolean standardH263Only;
    private long prevTimeStamp = 0L;
    private FrameBuffer PreviousFrame;
    private FrameBuffer xPrevFrame;
    private int MB_address;
    private int FirstMBinGOB;
    private int MBperGOB;
    private int MBpositionInGOB;
    private int GOBperFrame;
    private boolean HeaderInGOB;
    private int CurrentLumiOffset;
    private int CurrentCromOffset;
    private int xCurrentLumiOffset;
    private int xCurrentCromOffset;
    private static final int[] LumiOffset;
    private static final int[] CromOffset;
    private static final int[] xLumiOffset;
    private static final int[] xCromOffset;
    private static final int[] CodedMap;
    private int[] MBtypeCurrGOB;
    private int[] MBtypePrevGOB;
    private Point[] MotVectCurrGOB;
    private Point[] MotVectPrevGOB;
    private int prevCBP;
    private static final int[] dQuant;
    private static final int[][] recLevel_tab;
    private static final int[] clipQ_tab;
    private static final int[] pre8x8_tab;
    private static final int[] STRENGTH;
    private static final int[] zigzag_tab;
    private static final int[] IntraMCBPC_VLC_tab0;
    private static final int[] IntraMCBPC_VLC_tab1;
    private static final int[] InterMCBPC_VLC_tab0;
    private static final int[] InterMCBPC_VLC_tab1;
    private static final int[] CBPY_VLC_tab0;
    private static final int[] CBPY_VLC_tab1;
    private static final int[] MVD1_VLC_tab0;
    private static final int[] MVD1_VLC_tab1;
    private static final int[] MVD2_VLC_tab0;
    private static final int[] MVD2_VLC_tab1;
    private static final int[] TCOEFF1_tab0;
    private static final int[] TCOEFF1_tab1;
    private static final int[] TCOEFF2_tab0;
    private static final int[] TCOEFF2_tab1;
    private static final int[] TCOEFF3_tab0;
    private static final int[] TCOEFF3_tab1;
    private static final int[] clipTable;
    private static final int[] DfiltClip;

    final void init() {
        this.SourceFormat = 9;
    }

    public H263Decoder(boolean standardOnly) {
        this.standardH263Only = standardOnly;
        this.SourceFormat = 9;
        this.foundPSC = false;
        this.TemporalReference = 0;
        this.LastTemporalReference = 0;
        this.BlockData = new int[6][64];
        this.FrameWidthBlock = new int[6];
        this.MotVectCurrGOB = new Point[88];
        this.MotVectPrevGOB = new Point[88];
        int i2 = 0;
        while (i2 < 88) {
            this.MotVectCurrGOB[i2] = new Point(0, 0);
            this.MotVectPrevGOB[i2] = new Point(0, 0);
            ++i2;
        }
        this.MBtypeCurrGOB = new int[22];
        this.MBtypePrevGOB = new int[22];
    }

    private final int ChangeFormat(int NewFormat, int UnrestrictedMV) {
        switch (NewFormat) {
            case 1: {
                this.FrameWidth = 128;
                this.FrameHeight = 96;
                break;
            }
            case 2: {
                this.FrameWidth = 176;
                this.FrameHeight = 144;
                break;
            }
            case 3: {
                this.FrameWidth = 352;
                this.FrameHeight = 288;
                break;
            }
            case 7: {
                break;
            }
            default: {
                return 2;
            }
        }
        this.GOBperFrame = this.FrameHeight >> 4;
        this.MBperGOB = this.FrameWidth >> 4;
        int i2 = 0;
        while (i2 < this.GOBperFrame) {
            H263Decoder.LumiOffset[i2] = (this.FrameWidth << 4) * i2;
            H263Decoder.CromOffset[i2] = (this.FrameWidth << 2) * i2;
            H263Decoder.xLumiOffset[i2] = 16 + (32 + this.FrameWidth << 4) * (i2 + 1);
            H263Decoder.xCromOffset[i2] = 8 + (16 + (this.FrameWidth >> 1) << 3) * (i2 + 1);
            ++i2;
        }
        this.FrameWidthDiv2 = this.FrameWidth >> 1;
        this.FrameWidthx8 = this.FrameWidth << 3;
        this.CurrentFrame = new FrameBuffer(this.FrameWidth, this.FrameHeight);
        this.PreviousFrame = new FrameBuffer(this.FrameWidth, this.FrameHeight);
        this.FrameWidthBlock[0] = this.FrameWidth;
        this.FrameWidthBlock[1] = this.FrameWidth;
        this.FrameWidthBlock[2] = this.FrameWidth;
        this.FrameWidthBlock[3] = this.FrameWidth;
        this.FrameWidthBlock[4] = this.FrameWidthDiv2;
        this.FrameWidthBlock[5] = this.FrameWidthDiv2;
        if (UnrestrictedMV == 1) {
            this.xFrameWidth = this.FrameWidth + 32;
            this.xFrameWidthDiv2 = this.xFrameWidth >> 1;
            this.xPrevFrame = new FrameBuffer(this.FrameWidth + 32, this.FrameHeight + 32);
        } else {
            this.xFrameWidth = this.FrameWidth;
            this.xFrameWidthDiv2 = this.xFrameWidth >> 1;
            this.xPrevFrame = null;
        }
        this.SourceFormat = NewFormat;
        return 0;
    }

    public final int DecodeRtpPacket(byte[] inputBuffer, int inputOffset, int inputLength, byte[] packetHeader, int packetOffset, long timeStamp) {
        int mode = H263RtpPayloadParser.getMode(packetHeader, packetOffset);
        int startBit = H263RtpPayloadParser.getStartBit(packetHeader, packetOffset);
        int endBit = H263RtpPayloadParser.getEndBit(packetHeader, packetOffset);
        int src = H263RtpPayloadParser.getSRC(packetHeader, packetOffset);
        int rc = 0;
        this.rdptr = inputOffset;
        if (mode == 0) {
            boolean prevdone = false;
            if (!this.frameDone && this.foundPSC && timeStamp != this.prevTimeStamp && timeStamp != 0L) {
                this.rtpTemporalReference = H263RtpPayloadParser.getTemporalReference(packetHeader, packetOffset);
                if (this.rtpTemporalReference != 0) {
                    this.TemporalReference = this.rtpTemporalReference;
                }
                this.frameDone = true;
                this.foundPSC = false;
                prevdone = true;
            }
            this.prevTimeStamp = timeStamp;
            while (this.rdptr < inputLength + inputOffset) {
                try {
                    rc = this.DecodeGobs(inputBuffer, this.rdptr);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    System.out.println("[H263Decodeer::decodeRtpPacket] returning H263_RC_PICTURE_FORMAT_NOT_SUPPORTED");
                    return 2;
                }
            }
            if (prevdone) {
                prevdone = false;
                return 1;
            }
            return rc;
        }
        if (mode == 1) {
            return 2;
        }
        return 2;
    }

    public final int DecodePicture(byte[] ds_rdbfr, int ds_rdbfr_offset, boolean EntireFrame) {
        int rc = 0;
        if (EntireFrame) {
            this.frameDone = false;
            this.rdptr = ds_rdbfr_offset;
            while (rc == 0) {
                rc = this.DecodeGobs(ds_rdbfr, this.rdptr);
            }
        } else {
            rc = this.DecodeGobs(ds_rdbfr, ds_rdbfr_offset);
        }
        return rc;
    }

    public final int DecodeGobs(byte[] ds_rdbfr, int ds_rdbfr_offset) {
        int rc = 0;
        this.setInBuf(ds_rdbfr, ds_rdbfr_offset);
        this.GetNextStartCode();
        int startCode = this.getBits(22);
        if (startCode != 32 && startCode != 63 && !this.foundPSC) {
            return 3;
        }
        if (startCode == 32) {
            this.foundPSC = true;
        } else if (startCode == 63) {
            return 0;
        }
        if (startCode == 63) {
            this.GetNextStartCode();
            startCode = this.getBits(22);
        }
        if (startCode != 32 && !this.foundPSC) {
            return 0;
        }
        if (startCode == 32) {
            int PEI;
            this.foundPSC = true;
            int tmpTemporalReference = this.getBits(8);
            this.TypeInformation = this.getBits(8);
            int srcFormat = this.HeaderPlus = this.TypeInformation & 7;
            if (this.HeaderPlus == 7) {
                rc = this.ParseHeaderPlus();
                if (rc == 2) {
                    return rc;
                }
            } else {
                this.TypeInformation = this.getBits(5);
                if ((this.TypeInformation & 7) != 0) {
                    return 2;
                }
                this.CodingType = this.TypeInformation >> 4 & 1;
                this.UnrestrictedMV = (this.TypeInformation & 8) >> 3;
            }
            this.LastTemporalReference = this.TemporalReference;
            this.TemporalReference = tmpTemporalReference;
            this.Quantizer = this.getBits(5);
            if (this.HeaderPlus != 7) {
                this.CPM = this.getBits(1);
                if (this.CPM != 0) {
                    this.getBits(2);
                }
            }
            if ((PEI = this.getBits(1)) == 1) {
                return 2;
            }
            if (srcFormat != this.SourceFormat && (rc = this.ChangeFormat(srcFormat, this.UnrestrictedMV)) == 2) {
                return rc;
            }
            FrameBuffer tmpFrame = this.CurrentFrame;
            this.CurrentFrame = this.PreviousFrame;
            this.PreviousFrame = tmpFrame;
            this.BlockPtr[0] = this.CurrentFrame.Y;
            this.BlockPtr[1] = this.CurrentFrame.Y;
            this.BlockPtr[2] = this.CurrentFrame.Y;
            this.BlockPtr[3] = this.CurrentFrame.Y;
            this.BlockPtr[4] = this.CurrentFrame.Cb;
            this.BlockPtr[5] = this.CurrentFrame.Cr;
            if (this.CodingType == 0) {
                this.GroupNumber = 0;
                this.GetIntraPictMB();
            } else {
                if (this.UnrestrictedMV == 1) {
                    this.xFrameWidth = this.FrameWidth + 32;
                    this.xFrameWidthDiv2 = this.xFrameWidth >> 1;
                    this.CopyExtendedFrame(this.PreviousFrame.Y, this.xPrevFrame.Y, this.FrameWidth, this.FrameHeight, this.xFrameWidth, 16);
                    this.CopyExtendedFrame(this.PreviousFrame.Cb, this.xPrevFrame.Cb, this.FrameWidthDiv2, this.FrameHeight >> 1, this.xFrameWidthDiv2, 8);
                    this.CopyExtendedFrame(this.PreviousFrame.Cr, this.xPrevFrame.Cr, this.FrameWidthDiv2, this.FrameHeight >> 1, this.xFrameWidthDiv2, 8);
                }
                this.GroupNumber = 0;
                this.GetInterPictMB();
            }
        } else if (startCode >= 33 && startCode <= 62) {
            int tmp = startCode & 0x1F;
            if (tmp != this.GroupNumber) {
                this.GroupNumber = tmp;
            }
            if (this.CPM != 0) {
                this.skipBits(2);
            }
            this.GOB_FrameID = this.getBits(2);
            this.Quantizer = this.getBits(5);
            if (this.CodingType == 0) {
                this.GetIntraPictMB();
            } else {
                this.GetInterPictMB();
            }
        } else {
            return 2;
        }
        if (this.GroupNumber == this.GOBperFrame) {
            this.frameDone = true;
            this.foundPSC = false;
            if (this.DeblockingFilter == 1) {
                this.EdgeFilter();
            }
            return 1;
        }
        this.frameDone = false;
        return 0;
    }

    private final int ParseHeaderPlus() {
        int tmpBits;
        int srcFormat = 0;
        int UFEP = this.getBits(3);
        if (UFEP == 1) {
            srcFormat = this.getBits(3);
            tmpBits = this.getBits(1);
            if (tmpBits == 1) {
                return 2;
            }
            this.UnrestrictedMV = this.getBits(1);
            tmpBits = this.getBits(4);
            if (tmpBits > 1) {
                return 2;
            }
            this.DeblockingFilter = tmpBits & 1;
            tmpBits = this.getBits(9);
            if (tmpBits != 8) {
                return 2;
            }
        }
        this.CodingType = this.getBits(3);
        if (this.CodingType > 1) {
            return 2;
        }
        tmpBits = this.getBits(6);
        if (tmpBits != 1) {
            return 2;
        }
        this.CPM = this.getBits(1);
        if (this.CPM != 0) {
            this.getBits(2);
        }
        if (srcFormat == 6) {
            tmpBits = this.getBits(4);
            if (tmpBits != 2) {
                return 2;
            }
            int PDI = this.getBits(9);
            tmpBits = PDI + 1 << 2;
            if (tmpBits != this.FrameWidth) {
                this.SourceFormat = 9;
                this.FrameWidth = tmpBits;
            }
            tmpBits = this.getBits(1);
            PDI = this.getBits(9);
            tmpBits = PDI << 2;
            if (tmpBits != this.FrameHeight) {
                this.SourceFormat = 9;
                this.FrameHeight = tmpBits;
            }
        }
        return 1;
    }

    private final void EdgeFilter() {
        this.HorizEdgeFilter(this.CurrentFrame.Y, 0);
        this.VertEdgeFilter(this.CurrentFrame.Y, 0);
        this.HorizEdgeFilter(this.CurrentFrame.Cb, 1);
        this.VertEdgeFilter(this.CurrentFrame.Cb, 1);
        this.HorizEdgeFilter(this.CurrentFrame.Cr, 1);
        this.VertEdgeFilter(this.CurrentFrame.Cr, 1);
    }

    private final void HorizEdgeFilter(int[] rec, int divisor) {
        int width = this.FrameWidth >> divisor;
        int height = this.FrameHeight >> divisor;
        int j2 = 8;
        while (j2 < height) {
            int mbr = j2 >> 4 - divisor;
            int mbr_above = j2 + (divisor - 1 << 3) >> 4;
            int index = j2 * width;
            int i2 = 0;
            while (i2 < width) {
                int mbc = i2 >> 4 - divisor;
                if (CodedMap[(mbr + 1) * (mbc + 1)] > 0 || CodedMap[(mbr_above + 1) * (mbc + 1)] > 0) {
                    int delta = rec[index - (width << 1)] - (rec[index - width] << 2) + (rec[index] << 2) - rec[index + width] >> 3;
                    int d1 = (delta < 0 ? -1 : 1) * Math.max(0, Math.abs(delta) - Math.max(0, Math.abs(delta) - STRENGTH[this.Quantizer - 1] << 1));
                    int d2 = Math.min(Math.abs(d1 >> 1), Math.max(-Math.abs(d1 >> 1), rec[index - (width << 1)] - rec[index + width] >> 2));
                    rec[index + width] = rec[index + width] + d2;
                    rec[index] = DfiltClip[rec[index] - d1 + 128];
                    rec[index - width] = DfiltClip[rec[index - width] + d1 + 128];
                    rec[index - (width << 1)] = rec[index - (width << 1)] - d2;
                }
                ++i2;
                ++index;
            }
            j2 += 8;
        }
    }

    private final void VertEdgeFilter(int[] rec, int divisor) {
        int width = this.FrameWidth >> divisor;
        int height = this.FrameHeight >> divisor;
        int i2 = 8;
        while (i2 < width) {
            int mbc = i2 >> 4 - divisor;
            int mbc_left = i2 + (divisor - 1 << 3) >> 4;
            int index = i2;
            int j2 = 0;
            while (j2 < height) {
                int mbr = j2 >> 4 - divisor;
                if (CodedMap[(mbr + 1) * (mbc + 1)] > 0 || CodedMap[(mbr + 1) * (mbc_left + 1)] > 0) {
                    int delta = rec[index - 2] - (rec[index - 1] << 2) + (rec[index] << 2) - rec[index + 1] >> 3;
                    int d1 = (delta < 0 ? -1 : 1) * Math.max(0, Math.abs(delta) - Math.max(0, Math.abs(delta) - STRENGTH[this.Quantizer - 1] << 1));
                    int d2 = Math.min(Math.abs(d1 >> 1), Math.max(-Math.abs(d1 >> 1), rec[index - 2] - rec[index + 1] >> 2));
                    rec[index + 1] = rec[index + 1] + d2;
                    rec[index] = DfiltClip[rec[index] - d1 + 128];
                    rec[index - 1] = DfiltClip[rec[index - 1] + d1 + 128];
                    rec[index - 2] = rec[index - 2] - d2;
                }
                ++j2;
                index += width;
            }
            i2 += 8;
        }
    }

    private final void GetIntraPictMB() {
        int[] clipQ = clipQ_tab;
        do {
            this.FirstMBinGOB = this.GroupNumber * this.MBperGOB;
            this.CurrentLumiOffset = LumiOffset[this.GroupNumber];
            this.CurrentCromOffset = CromOffset[this.GroupNumber];
            this.MB_address = this.FirstMBinGOB;
            int MBinNextGOB = this.FirstMBinGOB + this.MBperGOB;
            while (this.MB_address < MBinNextGOB) {
                int MCBPC;
                while ((MCBPC = this.GetIntraMCBPC_VLC()) == -1) {
                }
                int MBtype = MCBPC >> 4;
                int CBPY = this.GetCBPY_VLC() >> 4;
                if (MBtype == 4) {
                    this.Quantizer = clipQ[this.Quantizer + dQuant[this.nextBits(2)]];
                    this.skipBits(2);
                }
                H263Decoder.CodedMap[this.MB_address] = 2;
                this.BlockOffset[0] = this.CurrentLumiOffset;
                this.BlockOffset[1] = this.BlockOffset[0] + 8;
                this.BlockOffset[2] = this.BlockOffset[0] + this.FrameWidthx8;
                this.BlockOffset[3] = this.BlockOffset[2] + 8;
                this.BlockOffset[4] = this.CurrentCromOffset;
                this.BlockOffset[5] = this.CurrentCromOffset;
                int CBP = CBPY << 2 | MCBPC & 3;
                int cnt = 0;
                while (cnt < 6) {
                    int tempDC = this.getBits(8);
                    if (tempDC == 255) {
                        tempDC = 128;
                    }
                    this.BlockData[cnt][0] = tempDC << 12;
                    if ((CBP & 0x20) != 0) {
                        this.GetCoefficients(1, cnt);
                    }
                    this.idct8x8(this.BlockData[cnt], this.BlockPtr[cnt], this.BlockOffset[cnt], this.FrameWidthBlock[cnt], 1);
                    CBP <<= 1;
                    ++cnt;
                }
                this.CurrentLumiOffset += 16;
                this.CurrentCromOffset += 8;
                ++this.MB_address;
            }
            ++this.GroupNumber;
        } while (this.StartCodeFound() == 0 && this.GroupNumber < this.GOBperFrame);
    }

    private final void GetInterPictMB() {
        int MCBPC = 0;
        int[] clipQ = clipQ_tab;
        this.HeaderInGOB = true;
        do {
            this.FirstMBinGOB = this.GroupNumber * this.MBperGOB;
            this.CurrentLumiOffset = LumiOffset[this.GroupNumber];
            this.CurrentCromOffset = CromOffset[this.GroupNumber];
            this.xCurrentLumiOffset = xLumiOffset[this.GroupNumber];
            this.xCurrentCromOffset = xCromOffset[this.GroupNumber];
            this.MB_address = this.FirstMBinGOB;
            int MBinNextGOB = this.FirstMBinGOB + this.MBperGOB;
            while (this.MB_address < MBinNextGOB) {
                int COD;
                this.MBpositionInGOB = this.MB_address - this.FirstMBinGOB;
                do {
                    if ((COD = this.getBits(1)) == 0) continue;
                    if (this.UnrestrictedMV != 0) {
                        this.Copy16x16Pel(this.xPrevFrame.Y, this.xCurrentLumiOffset, this.CurrentFrame.Y, this.CurrentLumiOffset);
                        this.Copy8x8Pel(this.xPrevFrame.Cr, this.xCurrentCromOffset, this.CurrentFrame.Cr, this.CurrentCromOffset);
                        this.Copy8x8Pel(this.xPrevFrame.Cb, this.xCurrentCromOffset, this.CurrentFrame.Cb, this.CurrentCromOffset);
                    } else {
                        this.Copy16x16Pel(this.PreviousFrame.Y, this.CurrentLumiOffset, this.CurrentFrame.Y, this.CurrentLumiOffset);
                        this.Copy8x8Pel(this.PreviousFrame.Cr, this.CurrentCromOffset, this.CurrentFrame.Cr, this.CurrentCromOffset);
                        this.Copy8x8Pel(this.PreviousFrame.Cb, this.CurrentCromOffset, this.CurrentFrame.Cb, this.CurrentCromOffset);
                    }
                    this.MotVectCurrGOB[this.MBpositionInGOB].x = 0;
                    this.MotVectCurrGOB[this.MBpositionInGOB].y = 0;
                    this.CurrentLumiOffset += 16;
                    this.CurrentCromOffset += 8;
                    this.xCurrentLumiOffset += 16;
                    this.xCurrentCromOffset += 8;
                    break;
                } while ((MCBPC = this.GetInterMCBPC_VLC()) == -1);
                if (COD == 0) {
                    int cnt;
                    int CBP;
                    int CBPY;
                    int MBtype = MCBPC >> 4;
                    this.BlockOffset[0] = this.CurrentLumiOffset;
                    this.BlockOffset[1] = this.BlockOffset[0] + 8;
                    this.BlockOffset[2] = this.BlockOffset[0] + this.FrameWidthx8;
                    this.BlockOffset[3] = this.BlockOffset[2] + 8;
                    this.BlockOffset[4] = this.CurrentCromOffset;
                    this.BlockOffset[5] = this.CurrentCromOffset;
                    if (MBtype >= 3) {
                        H263Decoder.CodedMap[this.MB_address] = 2;
                        CBPY = this.GetCBPY_VLC() >> 4;
                        if (MBtype == 4) {
                            this.Quantizer = clipQ[this.Quantizer + dQuant[this.nextBits(2)]];
                            this.skipBits(2);
                        }
                        CBP = CBPY << 2 | MCBPC & 3;
                        cnt = 0;
                        while (cnt < 6) {
                            int tempDC = this.getBits(8);
                            if (tempDC == 255) {
                                tempDC = 128;
                            }
                            this.BlockData[cnt][0] = tempDC << 12;
                            if ((CBP & 0x20) != 0) {
                                this.GetCoefficients(1, cnt);
                            }
                            this.idct8x8(this.BlockData[cnt], this.BlockPtr[cnt], this.BlockOffset[cnt], this.FrameWidthBlock[cnt], 1);
                            CBP <<= 1;
                            ++cnt;
                        }
                        this.MotVectCurrGOB[this.MBpositionInGOB].x = 0;
                        this.MotVectCurrGOB[this.MBpositionInGOB].y = 0;
                    } else {
                        H263Decoder.CodedMap[this.MB_address] = 1;
                        CBPY = this.GetCBPY_VLC();
                        if (MBtype == 1) {
                            this.Quantizer = clipQ[this.Quantizer + dQuant[this.nextBits(2)]];
                            this.skipBits(2);
                        }
                        this.FindMV();
                        this.BasePredPel();
                        CBP = CBPY << 2 | MCBPC & 3;
                        cnt = 0;
                        while (cnt < 6) {
                            if ((CBP & 0x20) != 0) {
                                this.GetCoefficients(0, cnt);
                                this.idct8x8(this.BlockData[cnt], this.BlockPtr[cnt], this.BlockOffset[cnt], this.FrameWidthBlock[cnt], 0);
                            }
                            CBP <<= 1;
                            ++cnt;
                        }
                    }
                    this.CurrentLumiOffset += 16;
                    this.CurrentCromOffset += 8;
                    this.xCurrentLumiOffset += 16;
                    this.xCurrentCromOffset += 8;
                } else {
                    H263Decoder.CodedMap[this.MB_address] = 0;
                }
                ++this.MB_address;
            }
            Point[] MotVectTemp = this.MotVectCurrGOB;
            this.MotVectCurrGOB = this.MotVectPrevGOB;
            this.MotVectPrevGOB = MotVectTemp;
            ++this.GroupNumber;
            this.HeaderInGOB = false;
        } while (this.StartCodeFound() == 0 && this.GroupNumber < this.GOBperFrame);
    }

    private final void GetCoefficients(int startIndex, int cnt) {
        int last;
        int bits = 0;
        int vlcValue = 0;
        int vlcBits = 0;
        int[] zigzag = zigzag_tab;
        int[] pre8x8 = pre8x8_tab;
        int[][] recLevel = recLevel_tab;
        int[] tempData = this.BlockData[cnt];
        int[] TCOEFF10 = TCOEFF1_tab0;
        int[] TCOEFF11 = TCOEFF1_tab1;
        int[] TCOEFF20 = TCOEFF2_tab0;
        int[] TCOEFF21 = TCOEFF2_tab1;
        int[] TCOEFF30 = TCOEFF3_tab0;
        int[] TCOEFF31 = TCOEFF3_tab1;
        int i2 = startIndex;
        while (i2 < 64) {
            tempData[i2] = 0;
            ++i2;
        }
        i2 = startIndex - 1;
        do {
            int run;
            int level;
            int offset;
            if ((bits = this.nextBits(13)) >= 1024) {
                offset = (bits >> 6) - 16;
                vlcValue = TCOEFF10[offset];
                vlcBits = TCOEFF11[offset];
            } else if (bits >= 256) {
                offset = (bits >> 3) - 32;
                vlcValue = TCOEFF20[offset];
                vlcBits = TCOEFF21[offset];
            } else {
                offset = (bits >> 1) - 8;
                vlcValue = TCOEFF30[offset];
                vlcBits = TCOEFF31[offset];
            }
            this.skipBits(vlcBits + 1);
            int value = vlcValue;
            if (value != 7167) {
                level = (bits >> 12 - vlcBits & 1) != 0 ? -(value & 0xF) : value & 0xF;
                run = value >> 4 & 0x3F;
                last = value & 0x1000;
            } else {
                value = this.getBits(15);
                level = value << 24 >> 24;
                run = value >> 8 & 0x3F;
                last = value & 0x4000;
            }
            i2 += run + 1;
            int index = zigzag[i2 &= 0x3F];
            if (level == 0) continue;
            boolean sign = level < 0;
            level = Math.abs(level);
            tempData[index] = (this.Quantizer & 1) != 0 ? pre8x8[index] * (sign ? -recLevel[this.Quantizer][level] : recLevel[this.Quantizer][level]) : pre8x8[index] * (sign ? 1 - recLevel[this.Quantizer][level] : recLevel[this.Quantizer][level] - 1);
        } while (last == 0);
        this.LastValue = i2;
    }

    private final int GetIntraMCBPC_VLC() {
        int bits = this.nextBits(9);
        if (bits == 1) {
            this.skipBits(9);
            return -1;
        }
        int index = bits >> 3;
        int vlcValue = IntraMCBPC_VLC_tab0[index];
        int vlcBits = IntraMCBPC_VLC_tab1[index];
        this.skipBits(vlcBits);
        return vlcValue;
    }

    private final int GetCBPY_VLC() {
        int index = this.nextBits(6);
        int vlcValue = CBPY_VLC_tab0[index];
        int vlcBits = CBPY_VLC_tab1[index];
        this.skipBits(vlcBits);
        return vlcValue;
    }

    private final int GetInterMCBPC_VLC() {
        int index = this.nextBits(9);
        int vlcValue = InterMCBPC_VLC_tab0[index];
        int vlcBits = InterMCBPC_VLC_tab1[index];
        this.skipBits(vlcBits);
        return vlcValue;
    }

    private final int GetMVD_VLC() {
        int vlcBits;
        int vlcValue;
        int bits = this.nextBits(13);
        if (bits >= 192) {
            int index = bits >> 5;
            vlcValue = MVD1_VLC_tab0[index];
            vlcBits = MVD1_VLC_tab1[index];
        } else {
            int index = bits;
            vlcValue = MVD2_VLC_tab0[index];
            vlcBits = MVD2_VLC_tab1[index];
        }
        this.skipBits(vlcBits);
        return vlcValue;
    }

    public final void CopyExtendedFrame(int[] src, int[] dest, int Width, int Height, int xWidth, int edge) {
        int imageSize = Width * Height;
        int xImageSize = xWidth * (Height + (edge << 1));
        int xStripe = xWidth * edge;
        int srcIndex = 0;
        int destIndex = xStripe + edge;
        while (srcIndex < imageSize) {
            System.arraycopy(src, srcIndex, dest, destIndex, Width);
            srcIndex += Width;
            destIndex += xWidth;
        }
        destIndex = xStripe;
        srcIndex = 0;
        while (destIndex < xImageSize - xStripe) {
            int Index2 = 0;
            while (Index2 < edge) {
                dest[destIndex + Index2] = src[srcIndex];
                dest[destIndex + Width + edge + Index2] = src[srcIndex + Width - 1];
                ++Index2;
            }
            destIndex += xWidth;
            srcIndex += Width;
        }
        destIndex = 0;
        while (destIndex < xStripe) {
            System.arraycopy(dest, xStripe, dest, destIndex, edge);
            System.arraycopy(dest, xStripe + Width + edge, dest, destIndex + Width + edge, edge);
            destIndex += xWidth;
        }
        destIndex = xImageSize - xStripe;
        while (destIndex < xImageSize) {
            System.arraycopy(dest, xImageSize - xStripe - xWidth, dest, destIndex, edge);
            System.arraycopy(dest, xImageSize - xStripe - edge, dest, destIndex + Width + edge, edge);
            destIndex += xWidth;
        }
        destIndex = edge;
        while (destIndex < xStripe + edge) {
            System.arraycopy(dest, xStripe + edge, dest, destIndex, Width);
            System.arraycopy(dest, xImageSize - xStripe - xWidth + edge, dest, destIndex + xImageSize - xStripe, Width);
            destIndex += xWidth;
        }
    }

    private final void BasePredPel() {
        int[] src1;
        int srcIndex;
        int[] src;
        int x_vec = this.MotVectCurrGOB[this.MBpositionInGOB].x;
        int y_vec = this.MotVectCurrGOB[this.MBpositionInGOB].y;
        if (x_vec < -32 && this.MBpositionInGOB == 0) {
            x_vec = -32;
        } else if (x_vec > 32 && this.MBpositionInGOB == this.GOBperFrame - 1) {
            x_vec = 32;
        }
        this.HorMV = x_vec >> 1;
        this.Half_HorMV = x_vec & 1;
        if (y_vec < -32 && this.GroupNumber == 0) {
            y_vec = -32;
        } else if (y_vec > 32 && this.GroupNumber == this.GOBperFrame - 1) {
            y_vec = 32;
        }
        this.VerMV = y_vec >> 1;
        this.Half_VerMV = y_vec & 1;
        int[] dest = this.CurrentFrame.Y;
        int destIndex = this.CurrentLumiOffset;
        if (this.UnrestrictedMV != 0) {
            src = this.xPrevFrame.Y;
            srcIndex = this.xCurrentLumiOffset + this.VerMV * this.xFrameWidth + this.HorMV;
        } else {
            src = this.PreviousFrame.Y;
            srcIndex = this.CurrentLumiOffset + this.VerMV * this.FrameWidth + this.HorMV;
        }
        if (this.Half_HorMV != 0 && this.Half_VerMV != 0) {
            this.InterpF16x16Pel(src, srcIndex, dest, destIndex);
        } else if (this.Half_HorMV != 0 || this.Half_VerMV != 0) {
            this.Interp16x16Pel(src, srcIndex, dest, destIndex, this.Half_HorMV, this.Half_VerMV);
        } else {
            this.Copy16x16Pel(src, srcIndex, dest, destIndex);
        }
        this.Half_HorMV |= this.HorMV & 1;
        this.HorMV >>= 1;
        this.Half_VerMV |= this.VerMV & 1;
        this.VerMV >>= 1;
        dest = this.CurrentFrame.Cr;
        destIndex = this.CurrentCromOffset;
        int[] dest1 = this.CurrentFrame.Cb;
        if (this.UnrestrictedMV != 0) {
            src = this.xPrevFrame.Cr;
            srcIndex = this.xCurrentCromOffset + this.VerMV * this.xFrameWidthDiv2 + this.HorMV;
            src1 = this.xPrevFrame.Cb;
        } else {
            src = this.PreviousFrame.Cr;
            srcIndex = this.CurrentCromOffset + this.VerMV * this.FrameWidthDiv2 + this.HorMV;
            src1 = this.PreviousFrame.Cb;
        }
        if (this.Half_HorMV != 0 && this.Half_VerMV != 0) {
            this.InterpF8x8Pel(src, srcIndex, dest, destIndex);
            this.InterpF8x8Pel(src1, srcIndex, dest1, destIndex);
        } else if (this.Half_HorMV != 0 || this.Half_VerMV != 0) {
            this.Interp8x8Pel(src, srcIndex, dest, destIndex, this.Half_HorMV, this.Half_VerMV);
            this.Interp8x8Pel(src1, srcIndex, dest1, destIndex, this.Half_HorMV, this.Half_VerMV);
        } else {
            this.Copy8x8Pel(src, srcIndex, dest, destIndex);
            this.Copy8x8Pel(src1, srcIndex, dest1, destIndex);
        }
    }

    private final void FindMV() {
        int MV3y;
        int MV3x;
        int MV1y;
        int MV1x;
        int MBpositionInGOB = this.MB_address - this.FirstMBinGOB;
        int HorMVD = this.GetMVD_VLC();
        int VerMVD = this.GetMVD_VLC();
        if (MBpositionInGOB == 0) {
            MV1x = 0;
            MV1y = 0;
        } else {
            MV1x = this.MotVectCurrGOB[MBpositionInGOB - 1].x;
            MV1y = this.MotVectCurrGOB[MBpositionInGOB - 1].y;
        }
        if (this.HeaderInGOB) {
            this.MotVectCurrGOB[MBpositionInGOB].x = this.CALC_MVC(HorMVD, MV1x);
            this.MotVectCurrGOB[MBpositionInGOB].y = this.CALC_MVC(VerMVD, MV1y);
            return;
        }
        int MV2x = this.MotVectPrevGOB[MBpositionInGOB].x;
        int MV2y = this.MotVectPrevGOB[MBpositionInGOB].y;
        if (MBpositionInGOB + 1 == this.MBperGOB) {
            MV3x = 0;
            MV3y = 0;
        } else {
            MV3x = this.MotVectPrevGOB[MBpositionInGOB + 1].x;
            MV3y = this.MotVectPrevGOB[MBpositionInGOB + 1].y;
        }
        int MVx = this.median(MV1x, MV2x, MV3x);
        int MVy = this.median(MV1y, MV2y, MV3y);
        this.MotVectCurrGOB[MBpositionInGOB].x = this.CALC_MVC(HorMVD, MVx);
        this.MotVectCurrGOB[MBpositionInGOB].y = this.CALC_MVC(VerMVD, MVy);
    }

    private final int median(int mv1, int mv2, int mv3) {
        return mv1 >= mv2 ? (mv2 >= mv3 ? mv2 : (mv1 >= mv3 ? mv3 : mv1)) : (mv1 >= mv3 ? mv1 : (mv2 >= mv3 ? mv3 : mv2));
    }

    private final int CALC_MVC(int MVd, int Pc) {
        return this.UnrestrictedMV == 0 ? (MVd + Pc + 96 & 0x3F) - 32 : (Pc >= 33 ? MVd + Pc & 0x3F : (Pc <= -32 ? -(-(MVd + Pc) & 0x3F) : MVd + Pc));
    }

    private final void Copy16x16Pel(int[] src, int srcIndex, int[] dest, int destIndex) {
        int frameW = this.FrameWidth;
        int xframeW = this.xFrameWidth;
        int i2 = 0;
        while (i2 < 16) {
            System.arraycopy(src, srcIndex, dest, destIndex, 16);
            destIndex += frameW;
            srcIndex += xframeW;
            ++i2;
        }
    }

    private final void Interp16x16Pel(int[] src, int srcIndex, int[] dest, int destIndex, int Hor, int Ver) {
        int offset1 = srcIndex;
        int offset2 = srcIndex + Ver * this.xFrameWidth + Hor;
        int frameW = this.FrameWidth;
        int xframeW = this.xFrameWidth;
        int i2 = 0;
        while (i2 < 16) {
            int j2 = 0;
            while (j2 < 16) {
                dest[destIndex + j2] = src[offset1 + j2] + src[offset2 + j2] + 1 >> 1;
                ++j2;
            }
            destIndex += frameW;
            offset1 += xframeW;
            offset2 += xframeW;
            ++i2;
        }
    }

    private final void InterpF16x16Pel(int[] src, int srcIndex, int[] dest, int destIndex) {
        int offset1 = srcIndex;
        int offset2 = srcIndex + this.xFrameWidth;
        int width1 = this.FrameWidth - 15;
        int width2 = this.xFrameWidth - 16;
        int i2 = 0;
        while (i2 < 16) {
            int x10 = src[offset1++];
            int x11 = src[offset1++];
            int x12 = src[offset1++];
            int x13 = src[offset1++];
            int x14 = src[offset1++];
            int x15 = src[offset1++];
            int x16 = src[offset1++];
            int x17 = src[offset1++];
            int x18 = src[offset1++];
            int x19 = src[offset1++];
            int x110 = src[offset1++];
            int x111 = src[offset1++];
            int x112 = src[offset1++];
            int x113 = src[offset1++];
            int x114 = src[offset1++];
            int x115 = src[offset1++];
            int x116 = src[offset1];
            int x20 = src[offset2++];
            int x21 = src[offset2++];
            int x22 = src[offset2++];
            int x23 = src[offset2++];
            int x24 = src[offset2++];
            int x25 = src[offset2++];
            int x26 = src[offset2++];
            int x27 = src[offset2++];
            int x28 = src[offset2++];
            int x29 = src[offset2++];
            int x210 = src[offset2++];
            int x211 = src[offset2++];
            int x212 = src[offset2++];
            int x213 = src[offset2++];
            int x214 = src[offset2++];
            int x215 = src[offset2++];
            int x216 = src[offset2];
            dest[destIndex++] = x10 + x11 + x20 + x21 + 2 >> 2;
            dest[destIndex++] = x11 + x12 + x21 + x22 + 2 >> 2;
            dest[destIndex++] = x12 + x13 + x22 + x23 + 2 >> 2;
            dest[destIndex++] = x13 + x14 + x23 + x24 + 2 >> 2;
            dest[destIndex++] = x14 + x15 + x24 + x25 + 2 >> 2;
            dest[destIndex++] = x15 + x16 + x25 + x26 + 2 >> 2;
            dest[destIndex++] = x16 + x17 + x26 + x27 + 2 >> 2;
            dest[destIndex++] = x17 + x18 + x27 + x28 + 2 >> 2;
            dest[destIndex++] = x18 + x19 + x28 + x29 + 2 >> 2;
            dest[destIndex++] = x19 + x110 + x29 + x210 + 2 >> 2;
            dest[destIndex++] = x110 + x111 + x210 + x211 + 2 >> 2;
            dest[destIndex++] = x111 + x112 + x211 + x212 + 2 >> 2;
            dest[destIndex++] = x112 + x113 + x212 + x213 + 2 >> 2;
            dest[destIndex++] = x113 + x114 + x213 + x214 + 2 >> 2;
            dest[destIndex++] = x114 + x115 + x214 + x215 + 2 >> 2;
            dest[destIndex] = x115 + x116 + x215 + x216 + 2 >> 2;
            destIndex += width1;
            offset1 += width2;
            offset2 += width2;
            ++i2;
        }
    }

    private final void Copy8x8Pel(int[] src, int srcIndex, int[] dest, int destIndex) {
        int width1 = this.FrameWidthDiv2;
        int width2 = this.xFrameWidthDiv2;
        int i2 = 0;
        while (i2 < 8) {
            System.arraycopy(src, srcIndex, dest, destIndex, 8);
            destIndex += width1;
            srcIndex += width2;
            ++i2;
        }
    }

    private final void Interp8x8Pel(int[] src, int srcIndex, int[] dest, int destIndex, int Hor, int Ver) {
        int offset1 = srcIndex;
        int offset2 = srcIndex + Ver * this.xFrameWidthDiv2 + Hor;
        int width1 = this.FrameWidthDiv2 - 8;
        int width2 = this.xFrameWidthDiv2 - 8;
        int i2 = 0;
        while (i2 < 8) {
            int j2 = 0;
            while (j2 < 8) {
                dest[destIndex++] = src[offset1++] + src[offset2++] + 1 >> 1;
                ++j2;
            }
            destIndex += width1;
            offset1 += width2;
            offset2 += width2;
            ++i2;
        }
    }

    private final void InterpF8x8Pel(int[] src, int srcIndex, int[] dest, int destIndex) {
        int offset1 = srcIndex;
        int offset2 = srcIndex + this.xFrameWidthDiv2;
        int width1 = this.FrameWidthDiv2 - 7;
        int width2 = this.xFrameWidthDiv2 - 8;
        int i2 = 0;
        while (i2 < 8) {
            int x10 = src[offset1++];
            int x11 = src[offset1++];
            int x12 = src[offset1++];
            int x13 = src[offset1++];
            int x14 = src[offset1++];
            int x15 = src[offset1++];
            int x16 = src[offset1++];
            int x17 = src[offset1++];
            int x18 = src[offset1];
            int x20 = src[offset2++];
            int x21 = src[offset2++];
            int x22 = src[offset2++];
            int x23 = src[offset2++];
            int x24 = src[offset2++];
            int x25 = src[offset2++];
            int x26 = src[offset2++];
            int x27 = src[offset2++];
            int x28 = src[offset2];
            dest[destIndex++] = x10 + x11 + x20 + x21 + 2 >> 2;
            dest[destIndex++] = x11 + x12 + x21 + x22 + 2 >> 2;
            dest[destIndex++] = x12 + x13 + x22 + x23 + 2 >> 2;
            dest[destIndex++] = x13 + x14 + x23 + x24 + 2 >> 2;
            dest[destIndex++] = x14 + x15 + x24 + x25 + 2 >> 2;
            dest[destIndex++] = x15 + x16 + x25 + x26 + 2 >> 2;
            dest[destIndex++] = x16 + x17 + x26 + x27 + 2 >> 2;
            dest[destIndex] = x17 + x18 + x27 + x28 + 2 >> 2;
            destIndex += width1;
            offset1 += width2;
            offset2 += width2;
            ++i2;
        }
    }

    private final void GetNextStartCode() {
        while (this.nextBits(17) != 1) {
            this.skipBits(1);
        }
    }

    private final int StartCodeFound() {
        int code = this.nextBits(16);
        if (code == 0) {
            int count = 0;
            while ((code = this.nextBits(17)) != 1 && count < 7) {
                this.skipBits(1);
                ++count;
            }
            if (code == 1) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private final void idct8x8(int[] blk, int[] pixel, int pixOffset, int width, int flag) {
        int x4;
        int x5;
        int x6;
        int y1;
        int x7;
        int y4;
        int y3;
        int y2;
        int y5;
        int x2;
        int x1;
        int x3;
        int x0;
        int x10;
        int x11;
        int x9;
        int x8;
        int i8 = 7;
        int i16 = 15;
        int i24 = 23;
        int i32 = 31;
        int i40 = 39;
        int i48 = 47;
        int i56 = 55;
        int i2 = -1;
        while (i2 < 7) {
            int blk_i56;
            int blk_i48;
            int blk_i40;
            int blk_i32;
            int blk_i24;
            int blk_i16;
            int blk_i8;
            int blk_i = blk[++i2];
            if (((blk_i8 = blk[++i8]) | (blk_i16 = blk[++i16]) | (blk_i24 = blk[++i24]) | (blk_i32 = blk[++i32]) | (blk_i40 = blk[++i40]) | (blk_i48 = blk[++i48]) | (blk_i56 = blk[++i56])) == 0) {
                blk[i48] = blk[i56] = blk_i;
                blk[i40] = blk[i56];
                blk[i32] = blk[i56];
                blk[i24] = blk[i56];
                blk[i16] = blk[i56];
                blk[i8] = blk[i56];
                continue;
            }
            x8 = blk_i + blk_i32;
            x9 = blk_i - blk_i32;
            x11 = blk_i16 + blk_i48;
            x10 = (362 * (blk_i16 - blk_i48) >> 8) - x11;
            x0 = x8 + x11;
            x3 = x8 - x11;
            x1 = x9 + x10;
            x2 = x9 - x10;
            y5 = blk_i40 + blk_i24;
            y2 = blk_i40 - blk_i24;
            y3 = blk_i8 + blk_i56;
            y4 = blk_i8 - blk_i56;
            x7 = y3 + y5;
            x9 = 362 * (y3 - y5) >> 8;
            y1 = 473 * (y2 + y4) >> 8;
            x8 = (277 * y4 >> 8) - y1;
            x10 = (-669 * y2 >> 8) + y1;
            x6 = x10 - x7;
            x5 = x9 - x6;
            x4 = x8 + x5;
            blk[i2] = x0 + x7;
            blk[i8] = x1 + x6;
            blk[i16] = x2 + x5;
            blk[i24] = x3 - x4;
            blk[i32] = x3 + x4;
            blk[i40] = x2 - x5;
            blk[i48] = x1 - x6;
            blk[i56] = x0 - x7;
        }
        int offset = 0;
        int[] clip = clipTable;
        int i3 = 0;
        while (i3 < 8) {
            int o7;
            int blk_o7;
            int o0 = offset++;
            int blk_o0 = blk[o0];
            int o1 = offset++;
            int blk_o1 = blk[o1];
            int o2 = offset++;
            int blk_o2 = blk[o2];
            int o3 = offset++;
            int blk_o3 = blk[o3];
            int o4 = offset++;
            int blk_o4 = blk[o4];
            int o5 = offset++;
            int blk_o5 = blk[o5];
            int o6 = offset++;
            int blk_o6 = blk[o6];
            if ((blk_o1 | blk_o2 | blk_o3 | blk_o4 | blk_o5 | blk_o6 | (blk_o7 = blk[o7 = offset++])) == 0) {
                int temp;
                blk[o6] = blk[o7] = (temp = blk_o0 + 2048 >> 12);
                blk[o5] = blk[o7];
                blk[o4] = blk[o7];
                blk[o3] = blk[o7];
                blk[o2] = blk[o7];
                blk[o1] = blk[o7];
                blk[o0] = blk[o7];
                if (flag != 0) {
                    temp = clip[0x3FF & temp];
                    int n2 = pixOffset++;
                    int n3 = pixOffset++;
                    int n4 = pixOffset++;
                    int n5 = pixOffset++;
                    int n6 = pixOffset++;
                    int n7 = pixOffset++;
                    int n8 = pixOffset++;
                    int n9 = pixOffset++;
                    int n10 = temp;
                    pixel[n9] = n10;
                    pixel[n8] = n10;
                    pixel[n7] = n10;
                    pixel[n6] = n10;
                    pixel[n5] = n10;
                    pixel[n4] = n10;
                    pixel[n3] = n10;
                    pixel[n2] = n10;
                } else {
                    pixel[pixOffset] = clip[0x3FF & pixel[pixOffset++] + temp];
                    pixel[pixOffset] = clip[0x3FF & pixel[pixOffset++] + temp];
                    pixel[pixOffset] = clip[0x3FF & pixel[pixOffset++] + temp];
                    pixel[pixOffset] = clip[0x3FF & pixel[pixOffset++] + temp];
                    pixel[pixOffset] = clip[0x3FF & pixel[pixOffset++] + temp];
                    pixel[pixOffset] = clip[0x3FF & pixel[pixOffset++] + temp];
                    pixel[pixOffset] = clip[0x3FF & pixel[pixOffset++] + temp];
                    pixel[pixOffset] = clip[0x3FF & pixel[pixOffset++] + temp];
                }
                pixOffset += width - 8;
            } else {
                x8 = blk_o0 + blk_o4;
                x9 = blk_o0 - blk_o4;
                x11 = blk_o2 + blk_o6;
                x10 = (362 * (blk_o2 - blk_o6) >> 8) - x11;
                x0 = x8 + x11 + 2048;
                x3 = x8 - x11 + 2048;
                x1 = x9 + x10 + 2048;
                x2 = x9 - x10 + 2048;
                y5 = blk_o5 + blk_o3;
                y2 = blk_o5 - blk_o3;
                y3 = blk_o1 + blk_o7;
                y4 = blk_o1 - blk_o7;
                x7 = y3 + y5;
                x9 = 362 * (y3 - y5) >> 8;
                y1 = 473 * (y2 + y4) >> 8;
                x8 = (277 * y4 >> 8) - y1;
                x10 = (-669 * y2 >> 8) + y1;
                x6 = x10 - x7;
                x5 = x9 - x6;
                x4 = x8 + x5;
                if (flag != 0) {
                    int n11 = pixOffset++;
                    blk[o0] = x0 + x7 >> 12;
                    pixel[n11] = clip[0x3FF & blk[o0]];
                    int n12 = pixOffset++;
                    blk[o1] = x1 + x6 >> 12;
                    pixel[n12] = clip[0x3FF & blk[o1]];
                    int n13 = pixOffset++;
                    blk[o2] = x2 + x5 >> 12;
                    pixel[n13] = clip[0x3FF & blk[o2]];
                    int n14 = pixOffset++;
                    blk[o3] = x3 - x4 >> 12;
                    pixel[n14] = clip[0x3FF & blk[o3]];
                    int n15 = pixOffset++;
                    blk[o4] = x3 + x4 >> 12;
                    pixel[n15] = clip[0x3FF & blk[o4]];
                    int n16 = pixOffset++;
                    blk[o5] = x2 - x5 >> 12;
                    pixel[n16] = clip[0x3FF & blk[o5]];
                    int n17 = pixOffset++;
                    blk[o6] = x1 - x6 >> 12;
                    pixel[n17] = clip[0x3FF & blk[o6]];
                    int n18 = pixOffset++;
                    blk[o7] = x0 - x7 >> 12;
                    pixel[n18] = clip[0x3FF & blk[o7]];
                } else {
                    int n19 = pixOffset;
                    int n20 = pixOffset++;
                    blk[o0] = x0 + x7 >> 12;
                    pixel[n19] = clip[0x3FF & pixel[n20] + blk[o0]];
                    int n21 = pixOffset;
                    int n22 = pixOffset++;
                    blk[o1] = x1 + x6 >> 12;
                    pixel[n21] = clip[0x3FF & pixel[n22] + blk[o1]];
                    int n23 = pixOffset;
                    int n24 = pixOffset++;
                    blk[o2] = x2 + x5 >> 12;
                    pixel[n23] = clip[0x3FF & pixel[n24] + blk[o2]];
                    int n25 = pixOffset;
                    int n26 = pixOffset++;
                    blk[o3] = x3 - x4 >> 12;
                    pixel[n25] = clip[0x3FF & pixel[n26] + blk[o3]];
                    int n27 = pixOffset;
                    int n28 = pixOffset++;
                    blk[o4] = x3 + x4 >> 12;
                    pixel[n27] = clip[0x3FF & pixel[n28] + blk[o4]];
                    int n29 = pixOffset;
                    int n30 = pixOffset++;
                    blk[o5] = x2 - x5 >> 12;
                    pixel[n29] = clip[0x3FF & pixel[n30] + blk[o5]];
                    int n31 = pixOffset;
                    int n32 = pixOffset++;
                    blk[o6] = x1 - x6 >> 12;
                    pixel[n31] = clip[0x3FF & pixel[n32] + blk[o6]];
                    int n33 = pixOffset;
                    int n34 = pixOffset++;
                    blk[o7] = x0 - x7 >> 12;
                    pixel[n33] = clip[0x3FF & pixel[n34] + blk[o7]];
                }
                pixOffset += width - 8;
            }
            ++i3;
        }
    }

    public void finalize() {
        this.CurrentFrame = null;
        this.PreviousFrame = null;
        this.xPrevFrame = null;
        this.MotVectCurrGOB = null;
        this.MotVectPrevGOB = null;
        this.MBtypeCurrGOB = null;
        this.MBtypePrevGOB = null;
    }

    static {
        int temp;
        LumiOffset = new int[36];
        CromOffset = new int[36];
        xLumiOffset = new int[36];
        xCromOffset = new int[36];
        CodedMap = new int[2048];
        dQuant = new int[]{1, 0, 3, 4};
        recLevel_tab = new int[32][128];
        clipQ_tab = new int[36];
        pre8x8_tab = new int[]{512, 710, 669, 602, 512, 402, 277, 141, 710, 985, 928, 835, 710, 558, 384, 196, 669, 928, 874, 787, 669, 526, 362, 185, 602, 835, 787, 708, 602, 473, 326, 166, 512, 710, 669, 602, 512, 402, 277, 141, 402, 558, 526, 473, 402, 316, 218, 111, 277, 384, 362, 326, 277, 218, 150, 76, 141, 196, 185, 166, 141, 111, 76, 39};
        STRENGTH = new int[31];
        zigzag_tab = new int[64];
        IntraMCBPC_VLC_tab0 = new int[64];
        IntraMCBPC_VLC_tab1 = new int[64];
        InterMCBPC_VLC_tab0 = new int[512];
        InterMCBPC_VLC_tab1 = new int[512];
        CBPY_VLC_tab0 = new int[64];
        CBPY_VLC_tab1 = new int[64];
        MVD1_VLC_tab0 = new int[256];
        MVD1_VLC_tab1 = new int[256];
        MVD2_VLC_tab0 = new int[256];
        MVD2_VLC_tab1 = new int[256];
        TCOEFF1_tab0 = new int[112];
        TCOEFF1_tab1 = new int[112];
        TCOEFF2_tab0 = new int[96];
        TCOEFF2_tab1 = new int[96];
        TCOEFF3_tab0 = new int[120];
        TCOEFF3_tab1 = new int[120];
        clipTable = new int[1024];
        DfiltClip = new int[512];
        int row = 0;
        int col = 0;
        int direction = 1;
        int i2 = 0;
        while (i2 < 32) {
            int temp2;
            H263Decoder.zigzag_tab[i2] = temp2 = row * 8 + col;
            H263Decoder.zigzag_tab[63 - i2] = 63 - temp2;
            row -= direction;
            if ((col += direction) < 0) {
                direction = 1;
                col = 0;
            }
            if (row < 0) {
                direction = -1;
                row = 0;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 1024) {
            H263Decoder.clipTable[i3] = i3 < 256 ? i3 : (i3 < 512 ? 255 : 0);
            ++i3;
        }
        int i4 = 0;
        while (i4 < recLevel_tab.length) {
            int j2 = 0;
            while (j2 < recLevel_tab[i4].length) {
                if (j2 == 0) {
                    H263Decoder.recLevel_tab[i4][j2] = 0;
                } else {
                    temp = i4 * (2 * j2 + 1);
                    H263Decoder.recLevel_tab[i4][j2] = temp < -2048 ? -2048 : (temp > 2047 ? 2047 : temp);
                }
                ++j2;
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < clipQ_tab.length) {
            temp = i5 - 2;
            H263Decoder.clipQ_tab[i5] = temp < 1 ? 1 : (temp > 31 ? 31 : temp);
            ++i5;
        }
        int i6 = 1;
        while (i6 < IntraMCBPC_VLC_tab0.length) {
            int n2 = i6 <= 3 ? 64 + i6 : (i6 <= 7 ? 64 : (H263Decoder.IntraMCBPC_VLC_tab0[i6] = i6 <= 31 ? i6 / 8 + 48 : 48));
            H263Decoder.IntraMCBPC_VLC_tab1[i6] = i6 <= 3 ? 6 : (i6 <= 7 ? 4 : (i6 <= 31 ? 3 : 1));
            ++i6;
        }
        int i7 = 1;
        while (i7 < InterMCBPC_VLC_tab0.length) {
            int n3 = i7 <= 1 ? -1 : (i7 <= 4 ? 69 - i7 : (i7 <= 5 ? 19 : (i7 <= 9 ? 53 - i7 / 2 : (i7 <= 11 ? 35 : (i7 <= 15 ? 51 : (i7 <= 19 ? 34 : (i7 <= 23 ? 33 : (i7 <= 27 ? 18 : (i7 <= 31 ? 17 : (i7 <= 39 ? 64 : (i7 <= 47 ? 3 : (i7 <= 63 ? 48 : (i7 <= 95 ? 2 : (i7 <= 127 ? 1 : (i7 <= 191 ? 32 : (H263Decoder.InterMCBPC_VLC_tab0[i7] = i7 < 256 ? 16 : 0))))))))))))))));
            H263Decoder.InterMCBPC_VLC_tab1[i7] = i7 <= 5 ? 9 : (i7 <= 11 ? 8 : (i7 <= 31 ? 7 : (i7 <= 47 ? 6 : (i7 <= 63 ? 5 : (i7 <= 127 ? 4 : (i7 <= 255 ? 3 : 1))))));
            ++i7;
        }
        int i8 = 2;
        while (i8 < CBPY_VLC_tab0.length) {
            int n4 = i8 <= 2 ? 105 : (i8 <= 3 ? 150 : (i8 <= 5 ? 135 : (i8 <= 7 ? 75 : (i8 <= 9 ? 45 : (i8 <= 11 ? 30 : (i8 <= 15 ? 15 : (i8 <= 19 ? 195 : (i8 <= 23 ? 165 : (i8 <= 27 ? 225 : (i8 <= 31 ? 90 : (i8 <= 35 ? 210 : (i8 <= 39 ? 60 : (i8 <= 43 ? 180 : (H263Decoder.CBPY_VLC_tab0[i8] = i8 <= 47 ? 120 : 240))))))))))))));
            H263Decoder.CBPY_VLC_tab1[i8] = i8 <= 3 ? 6 : (i8 <= 11 ? 5 : (i8 <= 47 ? 4 : 2));
            ++i8;
        }
        int i9 = 6;
        while (i9 < MVD1_VLC_tab0.length) {
            int n5 = i9 <= 11 ? (10 - i9 / 2) * (1 - (i9 & 1) * 2) : (i9 <= 15 ? 4 * (1 - (i9 & 2)) : (i9 <= 31 ? 3 * (1 - (1 & i9 >> 3) * 2) : (i9 <= 63 ? 2 * (1 - (1 & i9 >> 4) * 2) : (H263Decoder.MVD1_VLC_tab0[i9] = i9 < 128 ? 1 - (1 & i9 >> 5) * 2 : 0))));
            H263Decoder.MVD1_VLC_tab1[i9] = i9 <= 11 ? 8 : (i9 <= 15 ? 7 : (i9 <= 31 ? 5 : (i9 <= 63 ? 4 : (i9 <= 127 ? 3 : 1))));
            ++i9;
        }
        int i10 = 0;
        while (i10 < MVD2_VLC_tab0.length) {
            int n6 = i10 < 5 ? 0 : (i10 == 5 ? -32 : (i10 <= 7 ? 31 * (1 - (i10 & 1) * 2) : (i10 <= 31 ? (32 - (i10 >> 2)) * (1 - (1 & i10 >> 1) * 2) : (H263Decoder.MVD2_VLC_tab0[i10] = i10 <= 143 ? (28 - (i10 >> 3)) * (1 - (1 & i10 >> 2) * 2) : (19 - (i10 >> 4)) * (1 - (1 & i10 >> 3) * 2)))));
            H263Decoder.MVD2_VLC_tab1[i10] = i10 <= 4 ? 5 : (i10 <= 7 ? 13 : (i10 <= 31 ? 12 : (i10 <= 143 ? 11 : (i10 <= 191 ? 10 : 5))));
            ++i10;
        }
        int i11 = 0;
        while (i11 < TCOEFF1_tab0.length) {
            int n7 = i11 <= 3 ? 4225 - i11 * 16 : (i11 <= 6 ? 257 - i11 * 16 : (i11 <= 7 ? 4 : (i11 <= 15 ? 4225 - i11 / 2 * 16 : (i11 <= 23 ? 273 - i11 / 2 * 16 : (i11 <= 25 ? 18 : (i11 <= 27 ? 3 : (i11 <= 39 ? 193 - i11 / 4 * 16 : (i11 <= 47 ? 4097 : (i11 <= 79 ? 1 : (i11 <= 95 ? 17 : (H263Decoder.TCOEFF1_tab0[i11] = i11 <= 103 ? 33 : 2)))))))))));
            H263Decoder.TCOEFF1_tab1[i11] = i11 <= 7 ? 7 : (i11 <= 27 ? 6 : (i11 <= 39 ? 5 : (i11 <= 47 ? 4 : (i11 <= 79 ? 2 : (i11 <= 95 ? 3 : 4)))));
            ++i11;
        }
        int i12 = 0;
        while (i12 < TCOEFF2_tab0.length) {
            int n8 = i12 <= 1 ? 9 - i12 : (i12 <= 17 ? 4497 - i12 / 2 * 16 : (i12 <= 19 ? 4098 : (i12 <= 35 ? 513 - i12 / 2 * 16 : (i12 <= 39 ? 354 - i12 / 2 * 16 : (i12 <= 43 ? 27 - i12 / 2 : (i12 <= 75 ? 4529 - i12 / 4 * 16 : (i12 <= 83 ? 529 - i12 / 4 * 16 : (H263Decoder.TCOEFF2_tab0[i12] = i12 <= 91 ? 349 - i12 / 4 * 15 : 5))))))));
            H263Decoder.TCOEFF2_tab1[i12] = i12 <= 1 ? 10 : (i12 <= 43 ? 9 : 8);
            ++i12;
        }
        int i13 = 0;
        while (i13 < TCOEFF3_tab0.length) {
            int n9 = i13 <= 3 ? 4114 - i13 / 2 * 15 : (i13 <= 7 ? 13 - i13 / 2 : (i13 <= 23 ? 4577 - i13 / 4 * 16 : (i13 <= 43 ? 242 - i13 / 4 * 16 : (i13 <= 51 ? 227 - i13 / 4 * 16 : (i13 <= 55 ? 20 : (i13 <= 59 ? i13 / 2 * 9 - 240 : (i13 <= 63 ? i13 / 2 * 16 - 111 : (i13 <= 71 ? i13 / 2 * 16 + 4049 : (i13 <= 72 ? 22 : (i13 <= 73 ? 36 : (i13 <= 74 ? 67 : (i13 <= 75 ? 83 : (i13 <= 76 ? 99 : (i13 <= 77 ? 162 : (i13 <= 78 ? 401 : (i13 <= 79 ? 417 : (H263Decoder.TCOEFF3_tab0[i13] = i13 <= 87 ? i13 * 16 + 3345 : 7167)))))))))))))))));
            H263Decoder.TCOEFF3_tab1[i13] = i13 <= 7 ? 11 : (i13 <= 55 ? 10 : (i13 <= 71 ? 11 : (i13 <= 87 ? 12 : 6)));
            ++i13;
        }
        int i14 = 0;
        while (i14 < 31) {
            H263Decoder.STRENGTH[i14] = i14 < 6 ? (i14 >> 1) + 1 : (i14 < 9 ? 4 : (i14 < 13 ? i14 + 1 >> 1 : (i14 + 2) / 3 + 2));
            ++i14;
        }
        int i15 = 0;
        while (i15 < 512) {
            H263Decoder.DfiltClip[i15] = i15 < 128 ? 0 : (i15 < 384 ? i15 - 128 : 255);
            ++i15;
        }
    }
}

