/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticArrowButton;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticSpinnerUI;
import com.jgoodies.looks.plastic.PlasticXPUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class PlasticXPSpinnerUI
extends PlasticSpinnerUI {
    public static ComponentUI createUI(JComponent b2) {
        return new PlasticXPSpinnerUI();
    }

    protected Component createArrowButton(int direction) {
        return new SpinnerXPArrowButton(direction);
    }

    private static final class SpinnerXPArrowButton
    extends PlasticArrowButton {
        SpinnerXPArrowButton(int direction) {
            super(direction, UIManager.getInt("ScrollBar.width") - 1, false);
        }

        protected int calculateArrowHeight(int height, int width) {
            int arrowHeight = Math.min((height - 4) / 3, (width - 4) / 3);
            return Math.max(arrowHeight, 3);
        }

        protected boolean isPaintingNorthBottom() {
            return true;
        }

        protected int calculateArrowOffset() {
            return 1;
        }

        protected void paintNorth(Graphics g2, boolean leftToRight, boolean isEnabled, Color arrowColor, boolean isPressed, int width, int height, int w, int h2, int arrowHeight, int arrowOffset, boolean paintBottom) {
            if (!this.isFreeStanding) {
                ++height;
                g2.translate(0, -1);
                if (!leftToRight) {
                    ++width;
                    g2.translate(-1, 0);
                } else {
                    width += 2;
                }
            }
            g2.setColor(arrowColor);
            int startY = 1 + (h2 + 1 - arrowHeight) / 2;
            int startX = w / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g2.fillRect(startX - line - arrowOffset, startY + line, 2 * (line + 1), 1);
            }
            this.paintNorthBorder(g2, isEnabled, width, height, paintBottom);
            if (!this.isFreeStanding) {
                --height;
                g2.translate(0, 1);
                if (!leftToRight) {
                    --width;
                    g2.translate(1, 0);
                } else {
                    width -= 2;
                }
            }
        }

        private void paintNorthBorder(Graphics g2, boolean isEnabled, int w, int h2, boolean paintBottom) {
            if (isEnabled) {
                boolean isPressed;
                boolean bl = isPressed = this.model.isPressed() && this.model.isArmed();
                if (isPressed) {
                    PlasticXPUtils.drawPressedButtonBorder(g2, 0, 1, w - 2, h2);
                } else {
                    PlasticXPUtils.drawPlainButtonBorder(g2, 0, 1, w - 2, h2);
                }
            } else {
                PlasticXPUtils.drawDisabledButtonBorder(g2, 0, 1, w - 2, h2 + 1);
            }
            g2.setColor(isEnabled ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            g2.fillRect(0, 1, 1, 1);
            if (paintBottom) {
                g2.fillRect(0, h2 - 1, w - 1, 1);
            }
        }

        protected void paintSouth(Graphics g2, boolean leftToRight, boolean isEnabled, Color arrowColor, boolean isPressed, int width, int height, int w, int h2, int arrowHeight, int arrowOffset) {
            if (!this.isFreeStanding) {
                ++height;
                if (!leftToRight) {
                    ++width;
                    g2.translate(-1, 0);
                } else {
                    width += 2;
                }
            }
            g2.setColor(arrowColor);
            int startY = (h2 + 0 - arrowHeight) / 2 + arrowHeight - 2;
            int startX = w / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g2.fillRect(startX - line - arrowOffset, startY - line, 2 * (line + 1), 1);
            }
            this.paintSouthBorder(g2, isEnabled, width, height);
            if (!this.isFreeStanding) {
                --height;
                if (!leftToRight) {
                    --width;
                    g2.translate(1, 0);
                } else {
                    width -= 2;
                }
            }
        }

        private void paintSouthBorder(Graphics g2, boolean isEnabled, int w, int h2) {
            if (isEnabled) {
                boolean isPressed;
                boolean bl = isPressed = this.model.isPressed() && this.model.isArmed();
                if (isPressed) {
                    PlasticXPUtils.drawPressedButtonBorder(g2, 0, -2, w - 2, h2 + 1);
                } else {
                    PlasticXPUtils.drawPlainButtonBorder(g2, 0, -2, w - 2, h2 + 1);
                }
            } else {
                PlasticXPUtils.drawDisabledButtonBorder(g2, 0, -2, w - 2, h2 + 1);
            }
            g2.setColor(isEnabled ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            g2.fillRect(0, h2 - 2, 1, 1);
        }
    }
}

