/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PObjectOutputStream;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PCamera
extends PNode {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_LAYERS = "layers";
    public static final int PROPERTY_CODE_LAYERS = 2048;
    public static final String PROPERTY_VIEW_TRANSFORM = "viewTransform";
    public static final int PROPERTY_CODE_VIEW_TRANSFORM = 4096;
    public static final int VIEW_CONSTRAINT_NONE = 0;
    public static final int VIEW_CONSTRAINT_ALL = 1;
    public static final int VIEW_CONSTRAINT_CENTER = 2;
    private transient PComponent component;
    private transient List layers;
    private final PAffineTransform viewTransform = new PAffineTransform();
    private int viewConstraint = 0;
    private static final PBounds TEMP_REPAINT_RECT = new PBounds();

    public PCamera() {
        this.layers = new ArrayList();
    }

    public PComponent getComponent() {
        return this.component;
    }

    public void setComponent(PComponent component) {
        this.component = component;
        this.invalidatePaint();
    }

    public void repaintFrom(PBounds localBounds, PNode sourceNode) {
        if (this.getParent() != null) {
            if (sourceNode != this) {
                this.localToParent(localBounds);
            }
            if (this.component != null) {
                this.component.repaint(localBounds);
            }
            this.getParent().repaintFrom(localBounds, this);
        }
    }

    public void repaintFromLayer(PBounds viewBounds, PLayer repaintedLayer) {
        TEMP_REPAINT_RECT.setRect(viewBounds);
        this.viewToLocal(TEMP_REPAINT_RECT);
        if (this.getBoundsReference().intersects(TEMP_REPAINT_RECT)) {
            Rectangle2D.intersect(TEMP_REPAINT_RECT, this.getBoundsReference(), TEMP_REPAINT_RECT);
            this.repaintFrom(TEMP_REPAINT_RECT, repaintedLayer);
        }
    }

    public void repaintFromLayer(PBounds viewBounds, PNode repaintedLayer) {
        throw new IllegalArgumentException("repaintedLayer not an instance of PLayer");
    }

    public List getLayersReference() {
        return this.layers;
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public PLayer getLayer(int index) {
        return (PLayer)this.layers.get(index);
    }

    public int indexOfLayer(PLayer layer) {
        return this.layers.indexOf(layer);
    }

    public void addLayer(PLayer layer) {
        this.addLayer(this.layers.size(), layer);
    }

    public void addLayer(int index, PLayer layer) {
        this.layers.add(index, layer);
        layer.addCamera(this);
        this.invalidatePaint();
        this.firePropertyChange(2048, PROPERTY_LAYERS, null, this.layers);
    }

    public PLayer removeLayer(PLayer layer) {
        layer.removeCamera(this);
        if (this.layers.remove(layer)) {
            this.invalidatePaint();
            this.firePropertyChange(2048, PROPERTY_LAYERS, null, this.layers);
        }
        return layer;
    }

    public PLayer removeLayer(int index) {
        PLayer layer = (PLayer)this.layers.remove(index);
        layer.removeCamera(this);
        this.invalidatePaint();
        this.firePropertyChange(2048, PROPERTY_LAYERS, null, this.layers);
        return layer;
    }

    public PBounds getUnionOfLayerFullBounds() {
        PBounds result = new PBounds();
        int size = this.layers.size();
        for (int i2 = 0; i2 < size; ++i2) {
            PLayer each = (PLayer)this.layers.get(i2);
            result.add(each.getFullBoundsReference());
        }
        return result;
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
        paintContext.pushClip(this.getBoundsReference());
        paintContext.pushTransform(this.viewTransform);
        this.paintCameraView(paintContext);
        this.paintDebugInfo(paintContext);
        paintContext.popTransform(this.viewTransform);
        paintContext.popClip(this.getBoundsReference());
    }

    protected void paintCameraView(PPaintContext paintContext) {
        int size = this.layers.size();
        for (int i2 = 0; i2 < size; ++i2) {
            PLayer each = (PLayer)this.layers.get(i2);
            each.fullPaint(paintContext);
        }
    }

    protected void paintDebugInfo(PPaintContext paintContext) {
        if (PDebug.debugBounds || PDebug.debugFullBounds) {
            Graphics2D g2 = paintContext.getGraphics();
            paintContext.setRenderQuality(0);
            g2.setStroke(new BasicStroke(0.0f));
            ArrayList nodes = new ArrayList();
            PBounds nodeBounds = new PBounds();
            Color boundsColor = Color.red;
            Color fullBoundsColor = new Color(1.0f, 0.0f, 0.0f, 0.2f);
            int size = this.layers.size();
            for (int i2 = 0; i2 < size; ++i2) {
                ((PLayer)this.layers.get(i2)).getAllNodes(null, nodes);
            }
            Iterator i3 = this.getAllNodes(null, nodes).iterator();
            while (i3.hasNext()) {
                PNode each = (PNode)i3.next();
                if (PDebug.debugBounds) {
                    g2.setPaint(boundsColor);
                    nodeBounds.setRect(each.getBoundsReference());
                    if (!nodeBounds.isEmpty()) {
                        each.localToGlobal(nodeBounds);
                        this.globalToLocal(nodeBounds);
                        if (each == this || each.isDescendentOf(this)) {
                            this.localToView(nodeBounds);
                        }
                        g2.draw(nodeBounds);
                    }
                }
                if (!PDebug.debugFullBounds) continue;
                g2.setPaint(fullBoundsColor);
                nodeBounds.setRect(each.getFullBoundsReference());
                if (nodeBounds.isEmpty()) continue;
                if (each.getParent() != null) {
                    each.getParent().localToGlobal(nodeBounds);
                }
                this.globalToLocal(nodeBounds);
                if (each == this || each.isDescendentOf(this)) {
                    this.localToView(nodeBounds);
                }
                g2.fill(nodeBounds);
            }
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        paintContext.pushCamera(this);
        super.fullPaint(paintContext);
        paintContext.popCamera();
    }

    public PPickPath pick(double x, double y, double halo) {
        PBounds b2 = new PBounds(new Point2D.Double(x, y), -halo, -halo);
        PPickPath result = new PPickPath(this, b2);
        this.fullPick(result);
        if (result.getNodeStackReference().size() == 0) {
            result.pushNode(this);
            result.pushTransform(this.getTransformReference(false));
        }
        return result;
    }

    protected boolean pickAfterChildren(PPickPath pickPath) {
        if (this.intersects(pickPath.getPickBounds())) {
            pickPath.pushTransform(this.viewTransform);
            if (this.pickCameraView(pickPath)) {
                return true;
            }
            pickPath.popTransform(this.viewTransform);
            return true;
        }
        return false;
    }

    protected boolean pickCameraView(PPickPath pickPath) {
        int size = this.layers.size();
        for (int i2 = size - 1; i2 >= 0; --i2) {
            PLayer each = (PLayer)this.layers.get(i2);
            if (!each.fullPick(pickPath)) continue;
            return true;
        }
        return false;
    }

    public PBounds getViewBounds() {
        return (PBounds)this.localToView(this.getBounds());
    }

    public void setViewBounds(Rectangle2D centerBounds) {
        this.animateViewToCenterBounds(centerBounds, true, 0L);
    }

    public double getViewScale() {
        return this.viewTransform.getScale();
    }

    public void scaleView(double scale) {
        this.scaleViewAboutPoint(scale, 0.0, 0.0);
    }

    public void scaleViewAboutPoint(double scale, double x, double y) {
        this.viewTransform.scaleAboutPoint(scale, x, y);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(4096, PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public void setViewScale(double scale) {
        this.scaleView(scale / this.getViewScale());
    }

    public void translateView(double dx, double dy) {
        this.viewTransform.translate(dx, dy);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(4096, PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public void setViewOffset(double x, double y) {
        this.viewTransform.setOffset(x, y);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(4096, PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public PAffineTransform getViewTransform() {
        return (PAffineTransform)this.viewTransform.clone();
    }

    public PAffineTransform getViewTransformReference() {
        return this.viewTransform;
    }

    public void setViewTransform(AffineTransform viewTransform) {
        this.viewTransform.setTransform(viewTransform);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(4096, PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public PTransformActivity animateViewToCenterBounds(Rectangle2D centerBounds, boolean shouldScaleToFit, long duration) {
        double s;
        PBounds viewBounds = this.getViewBounds();
        PDimension delta = viewBounds.deltaRequiredToCenter(centerBounds);
        PAffineTransform newTransform = this.getViewTransform();
        newTransform.translate(delta.width, delta.height);
        if (shouldScaleToFit && (s = Math.min(viewBounds.getWidth() / centerBounds.getWidth(), viewBounds.getHeight() / centerBounds.getHeight())) != Double.POSITIVE_INFINITY && s != 0.0) {
            newTransform.scaleAboutPoint(s, centerBounds.getCenterX(), centerBounds.getCenterY());
        }
        return this.animateViewToTransform(newTransform, duration);
    }

    public PTransformActivity animateViewToPanToBounds(Rectangle2D panToBounds, long duration) {
        PBounds viewBounds = this.getViewBounds();
        PDimension delta = viewBounds.deltaRequiredToContain(panToBounds);
        if (delta.width != 0.0 || delta.height != 0.0) {
            if (duration == 0L) {
                this.translateView(-delta.width, -delta.height);
            } else {
                PAffineTransform at = this.getViewTransform();
                at.translate(-delta.width, -delta.height);
                return this.animateViewToTransform(at, duration);
            }
        }
        return null;
    }

    public PTransformActivity animateViewToIncludeBounds(Rectangle2D includeBounds, long duration) {
        return this.animateViewToPanToBounds(includeBounds, duration);
    }

    public PTransformActivity animateViewToTransform(AffineTransform destination, long duration) {
        if (duration == 0L) {
            this.setViewTransform(destination);
            return null;
        }
        PTransformActivity.Target t = new PTransformActivity.Target(){

            public void setTransform(AffineTransform aTransform) {
                PCamera.this.setViewTransform(aTransform);
            }

            public void getSourceMatrix(double[] aSource) {
                PCamera.this.viewTransform.getMatrix(aSource);
            }
        };
        PTransformActivity transformActivity = new PTransformActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE, t, destination);
        PRoot r = this.getRoot();
        if (r != null) {
            r.getActivityScheduler().addActivity(transformActivity);
        }
        return transformActivity;
    }

    public int getViewConstraint() {
        return this.viewConstraint;
    }

    public void setViewConstraint(int viewConstraint) {
        if (viewConstraint != 0 && viewConstraint != 2 && viewConstraint != 1) {
            throw new IllegalArgumentException("view constraint must be one of VIEW_CONSTRAINT_NONE, VIEW_CONSTRAINT_CENTER, or VIEW_CONSTRAINT_ALL");
        }
        this.viewConstraint = viewConstraint;
        this.applyViewConstraints();
    }

    protected void applyViewConstraints() {
        if (0 == this.viewConstraint) {
            return;
        }
        PBounds viewBounds = this.getViewBounds();
        PBounds layerBounds = (PBounds)this.globalToLocal(this.getUnionOfLayerFullBounds());
        if (2 == this.viewConstraint) {
            layerBounds.setRect(layerBounds.getCenterX(), layerBounds.getCenterY(), 0.0, 0.0);
        }
        PDimension constraintDelta = viewBounds.deltaRequiredToContain(layerBounds);
        this.viewTransform.translate(-constraintDelta.width, -constraintDelta.height);
    }

    public Point2D viewToLocal(Point2D viewPoint) {
        return this.viewTransform.transform(viewPoint, viewPoint);
    }

    public Dimension2D viewToLocal(Dimension2D viewDimension) {
        return this.viewTransform.transform(viewDimension, viewDimension);
    }

    public Rectangle2D viewToLocal(Rectangle2D viewRectangle) {
        return this.viewTransform.transform(viewRectangle, viewRectangle);
    }

    public Point2D localToView(Point2D localPoint) {
        return this.viewTransform.inverseTransform(localPoint, localPoint);
    }

    public Dimension2D localToView(Dimension2D localDimension) {
        return this.viewTransform.inverseTransform(localDimension, localDimension);
    }

    public Rectangle2D localToView(Rectangle2D localRectangle) {
        return this.viewTransform.inverseTransform(localRectangle, localRectangle);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!(out instanceof PObjectOutputStream)) {
            throw new RuntimeException("cannot serialize PCamera to a non PObjectOutputStream");
        }
        out.defaultWriteObject();
        int count = this.getLayerCount();
        for (int i2 = 0; i2 < count; ++i2) {
            ((PObjectOutputStream)out).writeConditionalObject(this.layers.get(i2));
        }
        out.writeObject(Boolean.FALSE);
        ((PObjectOutputStream)out).writeConditionalObject(this.component);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.layers = new ArrayList();
        while (true) {
            Object each;
            if ((each = in.readObject()) == null) {
                continue;
            }
            if (each.equals(Boolean.FALSE)) break;
            this.layers.add(each);
        }
        this.component = (PComponent)in.readObject();
    }
}

