/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.geom.Point2D;

public abstract class PDragSequenceEventHandler
extends PBasicInputEventHandler {
    private double minDragStartDistance = 0.0;
    private transient boolean isDragging = false;
    private transient Point2D mousePressedCanvasPoint;
    private transient PActivity dragActivity;
    private transient PInputEvent dragEvent;
    private transient int sequenceInitiatedButton = 0;

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setIsDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    public double getMinDragStartDistance() {
        return this.minDragStartDistance;
    }

    public void setMinDragStartDistance(double minDistance) {
        this.minDragStartDistance = minDistance;
    }

    public Point2D getMousePressedCanvasPoint() {
        if (this.mousePressedCanvasPoint == null) {
            this.mousePressedCanvasPoint = new Point2D.Double();
        }
        return this.mousePressedCanvasPoint;
    }

    protected void startDrag(PInputEvent event) {
        this.dragEvent = event;
        this.startDragActivity(event);
        this.setIsDragging(true);
        event.getComponent().setInteracting(true);
    }

    protected void drag(PInputEvent event) {
        this.dragEvent = event;
    }

    protected void endDrag(PInputEvent event) {
        this.stopDragActivity(event);
        this.dragEvent = null;
        event.getComponent().setInteracting(false);
        this.setIsDragging(false);
    }

    protected boolean shouldStartDragInteraction(PInputEvent event) {
        return this.getMousePressedCanvasPoint().distance(event.getCanvasPosition()) >= this.getMinDragStartDistance();
    }

    protected PActivity getDragActivity() {
        return this.dragActivity;
    }

    protected void startDragActivity(PInputEvent event) {
        this.dragActivity = new PActivity(-1L, PUtil.DEFAULT_ACTIVITY_STEP_RATE);
        this.dragActivity.setDelegate(new PActivity.PActivityDelegate(){

            public void activityStarted(PActivity activity) {
                PDragSequenceEventHandler.this.dragActivityFirstStep(PDragSequenceEventHandler.this.dragEvent);
            }

            public void activityStepped(PActivity activity) {
                PDragSequenceEventHandler.this.dragActivityStep(PDragSequenceEventHandler.this.dragEvent);
            }

            public void activityFinished(PActivity activity) {
                PDragSequenceEventHandler.this.dragActivityFinalStep(PDragSequenceEventHandler.this.dragEvent);
            }
        });
        event.getCamera().getRoot().addActivity(this.dragActivity);
    }

    protected void stopDragActivity(PInputEvent event) {
        this.dragActivity.terminate();
        this.dragActivity = null;
    }

    protected void dragActivityFirstStep(PInputEvent event) {
    }

    protected void dragActivityStep(PInputEvent event) {
    }

    protected void dragActivityFinalStep(PInputEvent aEvent) {
    }

    public void mousePressed(PInputEvent event) {
        super.mousePressed(event);
        if (this.sequenceInitiatedButton == 0) {
            this.sequenceInitiatedButton = event.getButton();
            this.getMousePressedCanvasPoint().setLocation(event.getCanvasPosition());
            if (!this.isDragging() && this.shouldStartDragInteraction(event)) {
                this.startDrag(event);
            }
        }
    }

    public void mouseDragged(PInputEvent event) {
        super.mouseDragged(event);
        if (this.sequenceInitiatedButton != 0) {
            if (!this.isDragging()) {
                if (this.shouldStartDragInteraction(event)) {
                    this.startDrag(event);
                }
                return;
            }
            this.drag(event);
        }
    }

    public void mouseReleased(PInputEvent event) {
        super.mouseReleased(event);
        if (this.sequenceInitiatedButton == event.getButton()) {
            if (this.isDragging()) {
                this.endDrag(event);
            }
            this.sequenceInitiatedButton = 0;
        }
    }
}

