/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;

public class PText
extends PNode {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_TEXT = "text";
    public static final int PROPERTY_CODE_TEXT = 524288;
    public static final String PROPERTY_FONT = "font";
    public static final int PROPERTY_CODE_FONT = 0x100000;
    public static final String PROPERTY_TEXT_PAINT = "text  paint";
    public static final int PROPERTY_CODE_TEXT_PAINT = 0x200000;
    public static Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    public static double DEFAULT_GREEK_THRESHOLD = 5.5;
    public static final float DEFAULT_HORIZONTAL_ALIGNMENT = 0.0f;
    public static final String DEFAULT_TEXT = "";
    public static final Paint DEFAULT_TEXT_PAINT = Color.BLACK;
    private static final TextLayout[] EMPTY_TEXT_LAYOUT_ARRAY = new TextLayout[0];
    private String text = "";
    private Paint textPaint = DEFAULT_TEXT_PAINT;
    private Font font = DEFAULT_FONT;
    protected double greekThreshold = DEFAULT_GREEK_THRESHOLD;
    private float horizontalAlignment = 0.0f;
    private boolean constrainHeightToTextHeight = true;
    private boolean constrainWidthToTextWidth = true;
    private transient TextLayout[] lines;

    public PText() {
        this.setText(DEFAULT_TEXT);
    }

    public PText(String text) {
        this();
        this.setText(text);
    }

    public float getJustification() {
        return this.getHorizontalAlignment();
    }

    public void setJustification(float justification) {
        this.setHorizontalAlignment(justification);
    }

    public float getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(float horizontalAlignment) {
        if (!PText.validHorizontalAlignment(horizontalAlignment)) {
            throw new IllegalArgumentException("horizontalAlignment must be one of Component.LEFT_ALIGNMENT, Component.CENTER_ALIGNMENT, or Component.RIGHT_ALIGNMENT");
        }
        this.horizontalAlignment = horizontalAlignment;
    }

    private static boolean validHorizontalAlignment(float horizontalAlignment) {
        return 0.0f == horizontalAlignment || 0.5f == horizontalAlignment || 1.0f == horizontalAlignment;
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint textPaint) {
        if (textPaint == this.textPaint) {
            return;
        }
        Paint oldTextPaint = this.textPaint;
        this.textPaint = textPaint;
        this.invalidatePaint();
        this.firePropertyChange(0x200000, PROPERTY_TEXT_PAINT, oldTextPaint, this.textPaint);
    }

    public boolean isConstrainWidthToTextWidth() {
        return this.constrainWidthToTextWidth;
    }

    public void setConstrainWidthToTextWidth(boolean constrainWidthToTextWidth) {
        this.constrainWidthToTextWidth = constrainWidthToTextWidth;
        this.recomputeLayout();
    }

    public boolean isConstrainHeightToTextHeight() {
        return this.constrainHeightToTextHeight;
    }

    public void setConstrainHeightToTextHeight(boolean constrainHeightToTextHeight) {
        this.constrainHeightToTextHeight = constrainHeightToTextHeight;
        this.recomputeLayout();
    }

    public double getGreekThreshold() {
        return this.greekThreshold;
    }

    public void setGreekThreshold(double greekThreshold) {
        this.greekThreshold = greekThreshold;
        this.invalidatePaint();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        if (newText == null && this.text == null || newText != null && newText.equals(this.text)) {
            return;
        }
        String oldText = this.text;
        this.text = newText == null ? DEFAULT_TEXT : newText;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(524288, PROPERTY_TEXT, oldText, this.text);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == this.font) {
            return;
        }
        Font oldFont = this.font;
        this.font = font == null ? DEFAULT_FONT : font;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(0x100000, PROPERTY_FONT, oldFont, this.font);
    }

    public void recomputeLayout() {
        ArrayList<TextLayout> linesList = new ArrayList<TextLayout>();
        double textWidth = 0.0;
        double textHeight = 0.0;
        if (this.text != null && this.text.length() > 0) {
            AttributedString atString = new AttributedString(this.text);
            atString.addAttribute(TextAttribute.FONT, this.getFont());
            AttributedCharacterIterator itr = atString.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(itr, PPaintContext.RENDER_QUALITY_HIGH_FRC);
            float availableWidth = this.constrainWidthToTextWidth ? Float.MAX_VALUE : (float)this.getWidth();
            int nextLineBreakOffset = this.text.indexOf(10);
            nextLineBreakOffset = nextLineBreakOffset == -1 ? Integer.MAX_VALUE : ++nextLineBreakOffset;
            while (measurer.getPosition() < itr.getEndIndex()) {
                TextLayout aTextLayout = this.computeNextLayout(measurer, availableWidth, nextLineBreakOffset);
                if (nextLineBreakOffset == measurer.getPosition()) {
                    nextLineBreakOffset = this.text.indexOf(10, measurer.getPosition());
                    nextLineBreakOffset = nextLineBreakOffset == -1 ? Integer.MAX_VALUE : ++nextLineBreakOffset;
                }
                linesList.add(aTextLayout);
                textHeight += (double)aTextLayout.getAscent();
                textHeight += (double)(aTextLayout.getDescent() + aTextLayout.getLeading());
                textWidth = Math.max(textWidth, (double)aTextLayout.getAdvance());
            }
        }
        this.lines = linesList.toArray(EMPTY_TEXT_LAYOUT_ARRAY);
        if (this.constrainWidthToTextWidth || this.constrainHeightToTextHeight) {
            double newWidth = this.getWidth();
            double newHeight = this.getHeight();
            if (this.constrainWidthToTextWidth) {
                newWidth = textWidth;
            }
            if (this.constrainHeightToTextHeight) {
                newHeight = textHeight;
            }
            super.setBounds(this.getX(), this.getY(), newWidth, newHeight);
        }
    }

    protected TextLayout computeNextLayout(LineBreakMeasurer lineBreakMeasurer, float availableWidth, int nextLineBreakOffset) {
        return lineBreakMeasurer.nextLayout(availableWidth, nextLineBreakOffset, false);
    }

    protected void paintGreek(PPaintContext paintContext) {
    }

    protected void paintText(PPaintContext paintContext) {
        float x = (float)this.getX();
        float y = (float)this.getY();
        float bottomY = (float)this.getHeight() + y;
        Graphics2D g2 = paintContext.getGraphics();
        if (this.lines == null) {
            this.recomputeLayout();
            this.repaint();
            return;
        }
        g2.setPaint(this.textPaint);
        for (int i2 = 0; i2 < this.lines.length; ++i2) {
            TextLayout tl = this.lines[i2];
            if (bottomY < (y += tl.getAscent())) {
                return;
            }
            float offset = (float)(this.getWidth() - (double)tl.getAdvance()) * this.horizontalAlignment;
            tl.draw(g2, x + offset, y);
            y += tl.getDescent() + tl.getLeading();
        }
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
        if (this.textPaint == null) {
            return;
        }
        float screenFontSize = (float)this.getFont().getSize() * (float)paintContext.getScale();
        if ((double)screenFontSize <= this.greekThreshold) {
            this.paintGreek(paintContext);
        }
        this.paintText(paintContext);
    }

    protected void internalUpdateBounds(double x, double y, double width, double height) {
        this.recomputeLayout();
    }
}

