/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolox.util.PSemanticStroke;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class PFixedWidthStroke
extends PSemanticStroke
implements Serializable {
    private static final float DEFAULT_MITER_LIMIT = 10.0f;
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, null, 0.0f);
    private static final long serialVersionUID = 1L;
    private final transient float[] dash;
    private final transient float[] tmpDash;

    public PFixedWidthStroke() {
        this(DEFAULT_STROKE);
    }

    private PFixedWidthStroke(BasicStroke stroke) {
        super(stroke);
        this.dash = stroke.getDashArray();
        this.tmpDash = (float[])(this.dash == null ? null : new float[this.dash.length]);
    }

    public PFixedWidthStroke(float width) {
        this(width, 2, 0, 10.0f, null, 0.0f);
    }

    public PFixedWidthStroke(float width, int cap, int join) {
        this(width, cap, join, 10.0f, null, 0.0f);
    }

    public PFixedWidthStroke(float width, int cap, int join, float miterlimit) {
        this(width, cap, join, miterlimit, null, 0.0f);
    }

    public PFixedWidthStroke(float width, int cap, int join, float miterlimit, float[] dash, float dashPhase) {
        this(new BasicStroke(width, cap, join, miterlimit, dash, dashPhase));
    }

    public Object clone() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public float[] getDashArray() {
        return ((BasicStroke)this.stroke).getDashArray();
    }

    public float getDashPhase() {
        return ((BasicStroke)this.stroke).getDashPhase();
    }

    public int getEndCap() {
        return ((BasicStroke)this.stroke).getEndCap();
    }

    public int getLineJoin() {
        return ((BasicStroke)this.stroke).getLineJoin();
    }

    public float getLineWidth() {
        return ((BasicStroke)this.stroke).getLineWidth();
    }

    public float getMiterLimit() {
        return ((BasicStroke)this.stroke).getMiterLimit();
    }

    protected Stroke newStroke(float activeScale) {
        float ml;
        if (this.tmpDash != null) {
            for (int i2 = this.dash.length - 1; i2 >= 0; --i2) {
                this.tmpDash[i2] = this.dash[i2] / activeScale;
            }
        }
        float sanitizedMiterLimit = (ml = this.getMiterLimit() / activeScale) < 1.0f ? 1.0f : ml;
        return new BasicStroke(this.getLineWidth() / activeScale, this.getEndCap(), this.getLineJoin(), sanitizedMiterLimit, this.tmpDash, this.getDashPhase() / activeScale);
    }

    protected Object readResolve() throws ObjectStreamException {
        return new PFixedWidthStroke((BasicStroke)this.stroke);
    }
}

