/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.io.Files;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.media.MediaLocator;
import javax.swing.Timer;
import org.sikuli.api.JpegImagesToMovie;
import org.sikuli.api.ScreenRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenRegionRecorder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    volatile boolean stopped = false;
    public int captureInterval = 200;
    public File store;
    private final File output;
    private final ScreenRegion screenRegion;
    private Thread capturingThread = null;
    volatile boolean recording = false;
    private static ExecutorService makeMovieExecutor = Executors.newFixedThreadPool(1);
    private static List<Thread> capturingThreads = Collections.synchronizedList(new ArrayList());

    public ScreenRegionRecorder(ScreenRegion screenRegion, File output) {
        this.output = output;
        this.screenRegion = screenRegion;
    }

    void recordFrame() throws IOException {
        BufferedImage image = this.screenRegion.capture();
        ImageIO.write((RenderedImage)image, "jpeg", new File(this.store, System.currentTimeMillis() + ".jpeg"));
    }

    public static void awaitTermination() {
        for (Thread t : capturingThreads) {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        makeMovieExecutor.shutdown();
        try {
            makeMovieExecutor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    public synchronized void start(int duration) {
        if (this.capturingThread != null && this.capturingThread.isAlive()) {
            return;
        }
        this.store = Files.createTempDir();
        this.logger.trace("created a temporary directory to store captured frames at " + this.store);
        this.capturingThread = new CapturingThread();
        capturingThreads.add(this.capturingThread);
        this.capturingThread.start();
        Timer stopLaterThread = new Timer(duration, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScreenRegionRecorder.this.stop();
            }
        });
        stopLaterThread.start();
    }

    private synchronized void submitMakeMovieJob() {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                ScreenRegionRecorder.this.logger.trace("making the movie ...");
                JpegImagesToMovie imageToMovie = new JpegImagesToMovie();
                Vector<String> imgLst = new Vector<String>();
                File[] fileLst = ScreenRegionRecorder.this.store.listFiles();
                for (int i2 = 0; i2 < fileLst.length; ++i2) {
                    imgLst.add(fileLst[i2].getAbsolutePath());
                }
                ScreenRegionRecorder.this.logger.trace("writing " + imgLst.size() + " frames to file " + ScreenRegionRecorder.this.output);
                MediaLocator oml = JpegImagesToMovie.createMediaLocator(ScreenRegionRecorder.this.output.toString());
                if (oml == null) {
                    ScreenRegionRecorder.this.logger.debug("Cannot build media locator from: " + ScreenRegionRecorder.this.output);
                }
                if (!imageToMovie.doIt(((ScreenRegionRecorder)ScreenRegionRecorder.this).screenRegion.getBounds().width, ((ScreenRegionRecorder)ScreenRegionRecorder.this).screenRegion.getBounds().height, 1000 / ScreenRegionRecorder.this.captureInterval, imgLst, oml)) {
                    ScreenRegionRecorder.this.logger.debug("Failed to execute JpegImagesToMovie");
                }
                ScreenRegionRecorder.this.logger.trace("movie is written to " + ScreenRegionRecorder.this.output);
            }
        };
        makeMovieExecutor.execute(job);
    }

    class CapturingThread
    extends Thread {
        public CapturingThread() {
            this.setName("screen-capture-thread");
        }

        @Override
        public void run() {
            ScreenRegionRecorder.this.logger.trace("started recording in screen region " + ScreenRegionRecorder.this.screenRegion);
            ScreenRegionRecorder.this.recording = true;
            try {
                while (!ScreenRegionRecorder.this.stopped) {
                    ScreenRegionRecorder.this.recordFrame();
                    ScreenRegionRecorder.this.logger.trace("captured a frame");
                    Thread.sleep(ScreenRegionRecorder.this.captureInterval);
                }
            }
            catch (IOException e2) {
                ScreenRegionRecorder.this.logger.debug("recording failed due to IO error: " + e2);
            }
            catch (InterruptedException e3) {
                ScreenRegionRecorder.this.logger.debug("recording failed due to interruption: " + e3);
            }
            ScreenRegionRecorder.this.logger.trace("stopped recording");
            ScreenRegionRecorder.this.recording = false;
            ScreenRegionRecorder.this.stopped = false;
            ScreenRegionRecorder.this.submitMakeMovieJob();
        }
    }
}

