/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.jgoodies.looks.Fonts;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.sikuli.api.DefaultTarget;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.api.TextImageGenerator;
import org.sikuli.core.cv.TextMap;
import org.sikuli.core.draw.ImageRenderer;
import org.sikuli.core.draw.PiccoloImageRenderer;
import org.sikuli.core.logging.ImageExplainer;
import org.sikuli.ocr.FontModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextTarget
extends DefaultTarget
implements Target {
    private static final int MAX_FONT_SIZE = 14;
    private static final int MIN_FONT_SIZE = 9;
    private static ImageExplainer explainer;
    private static Logger logger;
    private final String text;
    static List<WeightedFontModel> fontModels;

    public TextTarget(String text) {
        this.text = text;
    }

    private static List<TextMatch> findCandidateMatches(ScreenRegion screenRegion, String word, double minScore, boolean firstMatchOnly) {
        ScreenRegion snapshot = screenRegion.snapshot();
        TextMap map = TextMap.createFrom(snapshot.capture());
        explainer.step(map.getImage(), (Object)"text map");
        ArrayList<TextMatch> ret = Lists.newArrayList();
        for (WeightedFontModel fontModel : fontModels) {
            logger.trace("test font model => " + fontModel);
            BufferedImage img = TextImageGenerator.create(word, fontModel.getFont(), fontModel.getSize(), fontModel.getTracking());
            ImageTarget t = new ImageTarget(img);
            t.setMinScore(minScore);
            List<ScreenRegion> matchedRegions = snapshot.findAll(t);
            if (matchedRegions.isEmpty()) continue;
            logger.trace("top score = " + matchedRegions.get(0).getScore());
            for (ScreenRegion matchedRegion : matchedRegions) {
                Rectangle r = matchedRegion.getBounds();
                Rectangle s = snapshot.getBounds();
                int localx = r.x - s.x;
                int localy = r.y - s.y;
                if (!(map.computeTextScore(localx, localy, r.width, r.height) > 0.0)) continue;
                TextMatch m2 = new TextMatch(matchedRegion, fontModel);
                ret.add(m2);
                fontModel.maxScore = Math.max(fontModel.maxScore, matchedRegion.getScore());
            }
            double quickAcceptThreshold = Math.max(0.65, fontModel.maxScore * 0.85);
            if (!firstMatchOnly || !(matchedRegions.get(0).getScore() >= quickAcceptThreshold)) continue;
            return ret;
        }
        return ret;
    }

    static List<TextMatch> removeOverlappedMatches(List<TextMatch> candidateMatches) {
        ArrayList<TextMatch> filteredCandidateMatches = Lists.newArrayList();
        for (TextMatch m1 : candidateMatches) {
            Rectangle s1 = m1.screenRegion.getBounds();
            final Rectangle r1 = new Rectangle(s1.x, s1.y, s1.width, s1.height);
            boolean isOverlapping = Iterables.any(filteredCandidateMatches, new Predicate<TextMatch>(){

                @Override
                public boolean apply(TextMatch m2) {
                    Rectangle s2 = m2.screenRegion.getBounds();
                    Rectangle r2 = new Rectangle(s2.x, s2.y, s2.width, s2.height);
                    return r1.intersects(r2);
                }
            });
            if (isOverlapping) continue;
            filteredCandidateMatches.add(m1);
        }
        return filteredCandidateMatches;
    }

    static ImageRenderer visualize(BufferedImage image, final List<TextMatch> matches) {
        PiccoloImageRenderer a2 = new PiccoloImageRenderer(image){

            @Override
            protected void addContent(PLayer layer) {
                for (int i2 = 0; i2 < matches.size(); ++i2) {
                    if (i2 > 1) continue;
                    Rectangle r = ((TextMatch)matches.get((int)i2)).screenRegion.getBounds();
                    PPath p = PPath.createRectangle(r.x, r.y, r.width, r.height);
                    if (i2 == 0) {
                        p.setStrokePaint(Color.red);
                    } else {
                        p.setStrokePaint(Color.blue);
                    }
                    p.setPaint(null);
                    PText t = new PText("" + i2);
                    t.setOffset(r.getX(), r.getY());
                    layer.addChild(p);
                    layer.addChild(t);
                }
            }
        };
        return a2;
    }

    List<TextMatch> findMatches(ScreenRegion screenRegion, String text) {
        logger.debug("find matches for [" + text + "]");
        ScreenRegion snapshot = screenRegion.snapshot();
        List<TextMatch> candidateMatches = TextTarget.findCandidateMatches(snapshot, text, this.getMinScore(), true);
        TextTarget.sortCandidateMatchesByScore(candidateMatches);
        candidateMatches = TextTarget.removeOverlappedMatches(candidateMatches);
        TextTarget.updateFontModelWeights(candidateMatches);
        TextTarget.sortFontModelsByWeight();
        explainer.step(TextTarget.visualize(snapshot.capture(), candidateMatches), (Object)("matches for <" + text + ">"));
        return candidateMatches;
    }

    private static void sortFontModelsByWeight() {
        Collections.sort(fontModels, new Comparator<WeightedFontModel>(){

            @Override
            public int compare(WeightedFontModel m0, WeightedFontModel m1) {
                return m1.weight - m0.weight;
            }
        });
    }

    private static void updateFontModelWeights(List<TextMatch> candidateMatches) {
        int w = candidateMatches.size();
        for (TextMatch m2 : candidateMatches) {
            m2.fontModel.weight += w;
            --w;
        }
    }

    private static void sortCandidateMatchesByScore(List<TextMatch> candidateMatches) {
        Collections.sort(candidateMatches, new Comparator<TextMatch>(){

            @Override
            public int compare(TextMatch m0, TextMatch m1) {
                return Double.compare(m1.screenRegion.getScore(), m0.screenRegion.getScore());
            }
        });
    }

    private static List<ScreenRegion> covertToScreenRegions(ScreenRegion parent, List<TextMatch> matches) {
        ArrayList<ScreenRegion> ret = Lists.newArrayList();
        for (TextMatch m2 : matches) {
            ScreenRegion rm = m2.screenRegion;
            rm.setScreen(parent.getScreen());
            ret.add(rm);
        }
        return ret;
    }

    @Override
    protected List<ScreenRegion> getUnordredMatches(ScreenRegion screenRegion) {
        List<TextMatch> matches = this.findMatches(screenRegion, this.text);
        return TextTarget.covertToScreenRegions(screenRegion, matches);
    }

    public String toString() {
        return "[StringTarget: " + this.text + "]";
    }

    static {
        Font[] fonts;
        explainer = ImageExplainer.getExplainer(TextTarget.class);
        logger = LoggerFactory.getLogger(TextTarget.class);
        fontModels = Lists.newArrayList();
        for (Font font : fonts = new Font[]{Fonts.SEGOE_UI_12PT, Fonts.WINDOWS_XP_120DPI_DEFAULT_GUI, new Font("sansserif", 0, 0), new Font("serif", 0, 0)}) {
            for (double size = 9.0; size <= 14.0; size += 1.0) {
                for (double tracking = 0.0; tracking > -0.03; tracking -= 0.01) {
                    WeightedFontModel fontModel = new WeightedFontModel();
                    fontModel.setFont(font);
                    fontModel.setTracking(tracking);
                    fontModel.setSize(size);
                    fontModels.add(fontModel);
                }
            }
        }
    }

    static class TextMatch {
        ScreenRegion screenRegion;
        WeightedFontModel fontModel;

        public TextMatch(ScreenRegion screenRegion, WeightedFontModel fontModel) {
            this.screenRegion = screenRegion;
            this.fontModel = fontModel;
        }
    }

    static class WeightedFontModel
    extends FontModel {
        int weight = 0;
        double maxScore = 0.0;

        WeightedFontModel() {
        }

        @Override
        public String toString() {
            return "weight:" + this.weight + ", maxScore: " + this.maxScore + "," + super.toString();
        }
    }
}

