/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.robot.desktop;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.HeadlessException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import org.sikuli.api.robot.Env;
import org.sikuli.api.robot.Key;
import org.sikuli.api.robot.OS;
import org.sikuli.api.robot.desktop.OutQuarticEase;
import org.sikuli.api.robot.desktop.TimeBasedAnimator;

class AWTRobot
extends Robot {
    static final int MAX_DELAY = 60000;
    public static double DelayBeforeDrop = 0.3;
    public static double DelayAfterDrag = 0.3;
    GraphicsDevice gdev;
    public static float MoveMouseDelay = 0.5f;

    public AWTRobot(GraphicsDevice gdev) throws AWTException {
        super(gdev);
        this.gdev = gdev;
    }

    public AWTRobot() throws AWTException {
    }

    public Point getOrigin() {
        return this.gdev.getDefaultConfiguration().getBounds().getLocation();
    }

    public static Point getMouseLocation() throws HeadlessException {
        Point loc = MouseInfo.getPointerInfo().getLocation();
        return loc;
    }

    public void smoothMove(Point dest) {
        this.smoothMove(AWTRobot.getMouseLocation(), dest, (long)(MoveMouseDelay * 1000.0f));
    }

    public void smoothMove(Point src, Point dest, long ms) {
        if (ms == 0L) {
            this.mouseMove(dest.x, dest.y);
            return;
        }
        TimeBasedAnimator aniX = new TimeBasedAnimator(new OutQuarticEase(src.x, dest.x, ms));
        TimeBasedAnimator aniY = new TimeBasedAnimator(new OutQuarticEase(src.y, dest.y, ms));
        while (aniX.running()) {
            float x = aniX.step();
            float y = aniY.step();
            this.mouseMove((int)x, (int)y);
            this.delay(50);
        }
    }

    public void dragDrop(Point start, Point end, int steps, long ms, int buttons) {
        this.mouseMove(start.x, start.y);
        this.mousePress(buttons);
        this.delay((int)(DelayAfterDrag * 1000.0));
        this.waitForIdle();
        this.smoothMove(start, end, ms);
        this.delay((int)(DelayBeforeDrop * 1000.0));
        this.mouseRelease(buttons);
        this.waitForIdle();
    }

    @Override
    public void delay(int ms) {
        if (ms < 0) {
            ms = 0;
        }
        while (ms > 60000) {
            super.delay(60000);
            ms -= 60000;
        }
        super.delay(ms);
    }

    public BufferedImage captureScreen(Rectangle rect) {
        return this.createScreenCapture(rect);
    }

    public void pressModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.keyPress(16);
        }
        if ((modifiers & 2) != 0) {
            this.keyPress(17);
        }
        if ((modifiers & 8) != 0) {
            this.keyPress(18);
        }
        if ((modifiers & 4) != 0) {
            if (Env.getOS() == OS.WINDOWS) {
                this.keyPress(524);
            } else {
                this.keyPress(157);
            }
        }
    }

    public void releaseModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.keyRelease(16);
        }
        if ((modifiers & 2) != 0) {
            this.keyRelease(17);
        }
        if ((modifiers & 8) != 0) {
            this.keyRelease(18);
        }
        if ((modifiers & 4) != 0) {
            if (Env.getOS() == OS.WINDOWS) {
                this.keyRelease(524);
            } else {
                this.keyRelease(157);
            }
        }
    }

    protected void doType(KeyMode mode, int ... keyCodes) {
        if (mode == KeyMode.PRESS_ONLY) {
            for (int i2 = 0; i2 < keyCodes.length; ++i2) {
                this.keyPress(keyCodes[i2]);
            }
        } else if (mode == KeyMode.RELEASE_ONLY) {
            for (int i3 = 0; i3 < keyCodes.length; ++i3) {
                this.keyRelease(keyCodes[i3]);
            }
        } else {
            int i4;
            for (i4 = 0; i4 < keyCodes.length; ++i4) {
                this.keyPress(keyCodes[i4]);
            }
            for (i4 = 0; i4 < keyCodes.length; ++i4) {
                this.keyRelease(keyCodes[i4]);
            }
        }
    }

    public void typeChar(char character, KeyMode mode) {
        this.doType(mode, Key.toJavaKeyCode(character));
    }

    public Object getDevice() {
        return null;
    }

    public static enum KeyMode {
        PRESS_ONLY,
        RELEASE_ONLY,
        PRESS_RELEASE;

    }
}

