/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PShadow;
import java.awt.BasicStroke;
import java.awt.Color;
import org.sikuli.api.visual.BoxElement;
import org.sikuli.api.visual.CircleElement;
import org.sikuli.api.visual.Element;
import org.sikuli.api.visual.ImageElement;
import org.sikuli.api.visual.LabelElement;

class PNodeFactory {
    private static final Color SHADOW_PAINT = new Color(10, 10, 10, 200);

    PNodeFactory() {
    }

    public static PNode createFrom(Element element) {
        Class<?> clazz = element.getClass();
        if (clazz == LabelElement.class) {
            return PNodeFactory.createFrom((LabelElement)element);
        }
        if (clazz == BoxElement.class) {
            return PNodeFactory.createFrom((BoxElement)element);
        }
        if (clazz == CircleElement.class) {
            return PNodeFactory.createFrom((CircleElement)element);
        }
        if (clazz == ImageElement.class) {
            return PNodeFactory.createFrom((ImageElement)element);
        }
        return new PNode();
    }

    public static PNode createFrom(LabelElement element) {
        PText txt = new PText(element.text);
        txt.setTextPaint(Color.black);
        txt.setPaint(Color.yellow);
        txt.setTextPaint(element.color);
        txt.setFont(txt.getFont().deriveFont(element.fontSize));
        PNode labelNode = new PNode();
        labelNode.setPaint(Color.yellow);
        labelNode.addChild(txt);
        labelNode.setHeight(txt.getHeight() + 2.0);
        labelNode.setWidth(txt.getWidth() + 4.0);
        txt.setOffset(2.0, 1.0);
        labelNode.setOffset(element.x, element.y);
        return PNodeFactory.addShadow(labelNode);
    }

    public static PNode createFrom(CircleElement element) {
        PPath p = PPath.createEllipse(1.0f, 1.0f, element.width, element.height);
        p.setStrokePaint(element.lineColor);
        p.setPaint(null);
        p.setStroke(new BasicStroke(element.lineWidth));
        PNode foregroundNode = new PNode();
        foregroundNode.addChild(p);
        foregroundNode.setHeight(p.getHeight() + 4.0);
        foregroundNode.setWidth(p.getWidth() + 4.0);
        p.setOffset(2.0, 2.0);
        foregroundNode.setOffset(element.x, element.y);
        return PNodeFactory.addShadow(foregroundNode);
    }

    public static PNode createFrom(BoxElement element) {
        PPath p = PPath.createRectangle(1.0f, 1.0f, element.width, element.height);
        p.setStrokePaint(element.lineColor);
        p.setPaint(null);
        p.setStroke(new BasicStroke(element.lineWidth));
        PNode foregroundNode = new PNode();
        foregroundNode.addChild(p);
        foregroundNode.setHeight(p.getHeight() + 4.0);
        foregroundNode.setWidth(p.getWidth() + 4.0);
        p.setOffset(2.0, 2.0);
        foregroundNode.setOffset(element.x, element.y);
        return PNodeFactory.addShadow(foregroundNode);
    }

    public static PNode createFrom(ImageElement element) {
        PImage p = new PImage(element.image);
        PNode foregroundNode = new PNode();
        foregroundNode.addChild(p);
        foregroundNode.setHeight(p.getHeight() + 4.0);
        foregroundNode.setWidth(p.getWidth() + 4.0);
        p.setOffset(2.0, 2.0);
        foregroundNode.setOffset(element.x, element.y);
        return PNodeFactory.addShadow(foregroundNode);
    }

    public static void setStyle() {
    }

    private static PNode addShadow(PNode contentNode) {
        PNode contentNodeWithShadow = new PNode();
        double xoffset = contentNode.getXOffset();
        double yoffset = contentNode.getYOffset();
        int blurRadius = 4;
        int tx = 5;
        int ty = 5;
        PShadow shadowNode = new PShadow(contentNode.toImage(), SHADOW_PAINT, blurRadius);
        contentNode.setOffset(tx, ty);
        shadowNode.setOffset((double)(tx - 2 * blurRadius) + 1.0, (double)(ty - 2 * blurRadius) + 1.0);
        contentNodeWithShadow.addChild(shadowNode);
        contentNodeWithShadow.addChild(contentNode);
        contentNodeWithShadow.setOffset(xoffset - (double)tx - (double)blurRadius, yoffset - (double)ty - (double)blurRadius);
        contentNodeWithShadow.setBounds(0.0, 0.0, contentNode.getWidth() + (double)(2 * blurRadius) + (double)tx, contentNode.getHeight() + (double)(2 * blurRadius) + (double)ty);
        return contentNodeWithShadow;
    }
}

