/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.sikuli.api.Relative;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.robot.desktop.DesktopScreen;
import org.sikuli.api.visual.BoxOverlay;
import org.sikuli.api.visual.CircleOverlay;
import org.sikuli.api.visual.ImageOverlay;
import org.sikuli.api.visual.LabelOverlay;

public class ScreenPainter {
    public void box(ScreenRegion screenRegion, int duration) {
        Rectangle b2 = ((DesktopScreen)screenRegion.getScreen()).getBounds();
        Rectangle r = screenRegion.getBounds();
        new BoxOverlay(b2.x + r.x, b2.y + r.y, r.width, r.height).show(duration);
    }

    public void circle(ScreenRegion screenRegion, int duration) {
        Rectangle b2 = ((DesktopScreen)screenRegion.getScreen()).getBounds();
        Rectangle r = screenRegion.getBounds();
        new CircleOverlay(b2.x + r.x, b2.y + r.y, r.width, r.height).show(duration);
    }

    public void circle(ScreenLocation l2, int duration) {
        Rectangle b2 = ((DesktopScreen)l2.getScreen()).getBounds();
        new CircleOverlay(b2.x + l2.getX() - 10, b2.y + l2.getY() - 10, 20, 20).show(duration);
    }

    public void label(ScreenRegion screenRegion, String txt, int duration) {
        ScreenLocation labelLocation = Relative.to(screenRegion).topLeft().above(5).left(5).getScreenLocation();
        this.label(labelLocation, txt, duration);
    }

    public void label(ScreenLocation l2, String txt, int duration) {
        Rectangle b2 = ((DesktopScreen)l2.getScreen()).getBounds();
        new LabelOverlay(txt, b2.x + l2.getX(), b2.y + l2.getY()).show(duration);
    }

    public void image(ScreenLocation l2, BufferedImage image, int time) {
        Rectangle b2 = ((DesktopScreen)l2.getScreen()).getBounds();
        new ImageOverlay(image, b2.x + l2.getX(), b2.y + l2.getY()).show(time);
    }
}

