/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import com.google.common.collect.Lists;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.robot.desktop.DesktopScreen;
import org.sikuli.api.visual.Canvas;
import org.sikuli.api.visual.Element;
import org.sikuli.api.visual.PNodeFactory;
import org.sikuli.api.visual.ScreenDisplayable;
import org.sikuli.api.visual.ScreenOverlayWindow;
import org.sikuli.core.cv.VisionUtils;

public class ScreenRegionCanvas
extends Canvas {
    private ScreenRegion screenRegion;

    public ScreenRegionCanvas(ScreenRegion screenRegion) {
        this.setScreenRegion(screenRegion);
    }

    @Override
    public void display(int seconds) {
        ArrayList<ScreenDisplayable> displayableList = Lists.newArrayList();
        for (Element element : this.getElements()) {
            displayableList.add(this.createScreenDisplayable(element));
        }
        for (ScreenDisplayable d2 : displayableList) {
            d2.displayOnScreen();
        }
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
        for (ScreenDisplayable d2 : displayableList) {
            d2.hideFromScreen();
        }
    }

    protected ScreenDisplayable createScreenDisplayable(Element element) {
        Rectangle screenBounds = ((DesktopScreen)this.getScreenRegion().getScreen()).getBounds();
        ScreenOverlayWindow overlayWindow = new ScreenOverlayWindow();
        PNode node = PNodeFactory.createFrom(element);
        int x = (int)node.getXOffset();
        int y = (int)node.getYOffset();
        PBounds bounds = node.getBounds();
        node.setOffset(0.0, 0.0);
        overlayWindow.getCanvas().getLayer().addChild(node);
        overlayWindow.setLocation(screenBounds.x + x, screenBounds.y + y);
        overlayWindow.setSize((int)bounds.width, (int)bounds.height);
        return overlayWindow;
    }

    @Override
    public BufferedImage createImage() {
        PCanvas canvas = new PCanvas();
        BufferedImage backgroundImage = this.getScreenRegion().capture();
        PImage background = new PImage(backgroundImage);
        canvas.getLayer().addChild(background);
        canvas.setBounds(0, 0, backgroundImage.getWidth(), backgroundImage.getHeight());
        PLayer layer = canvas.getLayer();
        Rectangle r = this.getScreenRegion().getBounds();
        System.out.println(this.getScreenRegion());
        PLayer foregroundLayer = new PLayer();
        layer.addChild(foregroundLayer);
        foregroundLayer.setGlobalTranslation(new Point(-r.x, -r.y));
        layer.addChild(foregroundLayer);
        for (Element element : this.getElements()) {
            PNode node = PNodeFactory.createFrom(element);
            foregroundLayer.addChild(node);
        }
        return VisionUtils.createComponentImage(canvas);
    }

    public ScreenRegion getScreenRegion() {
        return this.screenRegion;
    }

    public void setScreenRegion(ScreenRegion screenRegion) {
        this.screenRegion = screenRegion;
    }
}

