/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.util.ArrayList;
import java.util.Collections;
import org.sikuli.core.cv.BaseTemplateFinder;
import org.sikuli.core.cv.FindResult;
import org.sikuli.core.cv.MatchFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DownsampleTemplateFinder
extends BaseTemplateFinder {
    static Logger logger = LoggerFactory.getLogger(DownsampleTemplateFinder.class);

    DownsampleTemplateFinder() {
    }

    private opencv_core.CvSize getSmallerSize(opencv_core.IplImage image, double ratio) {
        return opencv_core.cvSize((int)(1.0 * (double)image.width() / ratio), (int)(1.0 * (double)image.height() / ratio));
    }

    opencv_core.IplImage createSmallerImage(opencv_core.IplImage image, double ratio) {
        if (ratio == 1.0) {
            return image;
        }
        opencv_core.CvSize smallerSize = this.getSmallerSize(image, ratio);
        opencv_core.IplImage smallerImage = opencv_core.IplImage.create(smallerSize, 8, 1);
        opencv_imgproc.cvResize(image, smallerImage, 1);
        return smallerImage;
    }

    private ArrayList<FindResult> findCandidatesAtCoarseLevel(opencv_core.IplImage input, opencv_core.IplImage target, double factor, int n2) {
        opencv_core.IplImage coarseInput = this.createSmallerImage(input, factor);
        opencv_core.IplImage coarseTarget = this.createSmallerImage(target, factor);
        opencv_core.IplImage coarseMatchResultMatrix = DownsampleTemplateFinder.computeTemplateMatchResultMatrix(coarseInput, coarseTarget);
        MatchFetcher coarseMatcher = new MatchFetcher(coarseMatchResultMatrix, coarseTarget);
        ArrayList<FindResult> candidateResults = new ArrayList<FindResult>();
        for (int i2 = 0; i2 < n2; ++i2) {
            FindResult m2 = coarseMatcher.fetchNextMatch();
            int x = (int)(1.0 * (double)m2.x * factor);
            int y = (int)(1.0 * (double)m2.y * factor);
            int d2 = (int)(factor + 1.0);
            int x0 = Math.max(x - d2, 0);
            int y0 = Math.max(y - d2, 0);
            int x1 = Math.min(x + d2 + target.width(), input.width());
            int y1 = Math.min(y + d2 + target.height(), input.height());
            opencv_core.CvRect roi = opencv_core.cvRect(x0, y0, x1 - x0, y1 - y0);
            opencv_core.cvSetImageROI(input, roi);
            opencv_core.IplImage fineMatchResultMatrix = DownsampleTemplateFinder.computeTemplateMatchResultMatrix(input, target);
            opencv_core.cvResetImageROI(input);
            MatchFetcher fineMatcher = new MatchFetcher(fineMatchResultMatrix, target);
            FindResult candiateMatch = fineMatcher.fetchNextMatch();
            candiateMatch.x += roi.x();
            candiateMatch.y += roi.y();
            candidateResults.add(candiateMatch);
            fineMatchResultMatrix.release();
        }
        Collections.sort(candidateResults, Collections.reverseOrder());
        coarseMatchResultMatrix.release();
        coarseInput.release();
        coarseTarget.release();
        Collections.sort(candidateResults, Collections.reverseOrder());
        return candidateResults;
    }

    FindResult[] findTopKMatches(opencv_core.IplImage input, opencv_core.IplImage target, double factor, int k2) {
        ArrayList<FindResult> candidateResults = this.findCandidatesAtCoarseLevel(input, target, factor, 10 + k2);
        FindResult[] topKCandidates = new FindResult[k2];
        for (int i2 = 0; i2 < k2; ++i2) {
            topKCandidates[i2] = candidateResults.get(i2);
        }
        return topKCandidates;
    }

    FindResult findTopMatch(opencv_core.IplImage input, opencv_core.IplImage target, double factor) {
        ArrayList<FindResult> candidateResults = this.findCandidatesAtCoarseLevel(input, target, factor, 10);
        return candidateResults.get(0);
    }
}

