/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import org.sikuli.core.cv.FindResult;

public class TemplateMatchHelper {
    opencv_core.IplImage resultMatrix;
    opencv_core.IplImage target;
    private int method;

    public TemplateMatchHelper(int method) {
        this.method = method;
    }

    public void match(opencv_core.IplImage input, opencv_core.IplImage target) {
        int tWidth = target.roi() != null ? target.roi().width() : target.width();
        int tHeight = target.roi() != null ? target.roi().height() : target.height();
        int iWidth = input.roi() != null ? input.roi().width() : input.width();
        int iHeight = input.roi() != null ? input.roi().height() : input.height();
        int rwidth = iWidth - tWidth + 1;
        int rheight = iHeight - tHeight + 1;
        this.target = target;
        this.resultMatrix = opencv_core.IplImage.create(opencv_core.cvSize(rwidth, rheight), 32, 1);
        opencv_imgproc.cvMatchTemplate(input, target, this.resultMatrix, this.method);
    }

    public FindResult fetchResult() {
        opencv_core.CvPoint detectionLoc;
        double detectionScore;
        double[] min = new double[1];
        double[] max = new double[1];
        opencv_core.CvPoint minPoint = new opencv_core.CvPoint(2);
        opencv_core.CvPoint maxPoint = new opencv_core.CvPoint(2);
        opencv_core.cvMinMaxLoc((opencv_core.CvArr)this.resultMatrix, min, max, minPoint, maxPoint, null);
        if (this.method == 0 || this.method == 1) {
            detectionScore = min[0];
            detectionLoc = minPoint;
        } else {
            detectionScore = max[0];
            detectionLoc = maxPoint;
        }
        FindResult r = new FindResult();
        r.x = detectionLoc.x();
        r.y = detectionLoc.y();
        r.width = this.target.width();
        r.height = this.target.height();
        r.score = detectionScore;
        int xmargin = this.target.width() / 3;
        int ymargin = this.target.height() / 3;
        int x = detectionLoc.x();
        int y = detectionLoc.y();
        int x0 = Math.max(x - xmargin, 0);
        int y0 = Math.max(y - ymargin, 0);
        int x1 = Math.min(x + xmargin, this.resultMatrix.width());
        int y1 = Math.min(y + ymargin, this.resultMatrix.height());
        opencv_core.cvRectangle(this.resultMatrix, opencv_core.cvPoint(x0, y0), opencv_core.cvPoint(x1 - 1, y1 - 1), opencv_core.cvRealScalar(0.0), -1, 8, 0);
        return r;
    }
}

