/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.sikuli.core.cv.FindResult;
import org.sikuli.core.cv.MarginFinderOld;
import org.sikuli.core.cv.TemplateMatchHelper;
import org.sikuli.core.cv.TextMap;
import org.sikuli.core.draw.BlobPainter;
import org.sikuli.core.logging.ImageExplainer;

public class VisionUtils {
    static ImageExplainer explainer = ImageExplainer.getExplainer(VisionUtils.class);

    public static <T> T[] mapOverCols(opencv_core.IplImage input, Class<T> c2, Function<opencv_core.CvArr, T> op) {
        opencv_core.CvRect roi = opencv_core.cvGetImageROI(input);
        Object[] vals = (Object[])Array.newInstance(c2, roi.width());
        for (int i2 = roi.x(); i2 < roi.x() + roi.width(); ++i2) {
            opencv_core.CvRect colROI = opencv_core.cvRect(i2, roi.y(), 1, roi.height());
            opencv_core.cvSetImageROI(input, colROI);
            T val = op.apply(input);
            vals[i2 - roi.x()] = val;
            opencv_core.cvResetImageROI(input);
        }
        opencv_core.cvSetImageROI(input, roi);
        return vals;
    }

    public static <T> T[] mapOverRows(opencv_core.IplImage input, Class<T> c2, Function<opencv_core.CvArr, T> op) {
        opencv_core.CvRect roi = opencv_core.cvGetImageROI(input);
        Object[] vals = (Object[])Array.newInstance(c2, roi.height());
        for (int i2 = roi.y(); i2 < roi.y() + roi.height(); ++i2) {
            opencv_core.CvRect rowROI = opencv_core.cvRect(roi.x(), i2, roi.width(), 1);
            opencv_core.cvSetImageROI(input, rowROI);
            T val = op.apply(input);
            vals[i2 - roi.y()] = val;
            opencv_core.cvResetImageROI(input);
        }
        opencv_core.cvSetImageROI(input, roi);
        return vals;
    }

    public static BufferedImage getSubimageInsideMargin(BufferedImage image) {
        Rectangle r = MarginFinderOld.getRegionInsideMargin(image);
        return image.getSubimage(r.x, r.y, r.width, r.height);
    }

    public static Rectangle getRegionInsideMargin(BufferedImage image) {
        return MarginFinderOld.getRegionInsideMargin(image);
    }

    public static BufferedImage createComponentImage(Component component) {
        Dimension size = component.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = image.createGraphics();
        component.paint(g2);
        g2.dispose();
        return image;
    }

    public static BufferedImage captureScreen(Rectangle rect) {
        try {
            return new Robot().createScreenCapture(rect);
        }
        catch (AWTException aWTException) {
            return null;
        }
    }

    public static List<opencv_core.CvRect> detectBlobs(opencv_core.IplImage input) {
        opencv_core.CvSeq contour;
        opencv_core.IplImage clone = input.clone();
        opencv_core.CvMemStorage storage = opencv_core.CvMemStorage.create();
        opencv_imgproc.cvFindContours(clone, storage, contour, Loader.sizeof(opencv_core.CvContour.class), 0, 2);
        ArrayList<opencv_core.CvRect> rects = Lists.newArrayList();
        for (contour = new opencv_core.CvSeq(null); contour != null && !contour.isNull(); contour = contour.h_next()) {
            if (contour.elem_size() <= 0) continue;
            opencv_core.CvRect boundingRect = opencv_imgproc.cvBoundingRect(contour, 0);
            rects.add(boundingRect);
        }
        return rects;
    }

    public static BufferedImage createImageFrom(Component component) {
        Dimension size = component.getPreferredSize();
        if (size.width == 0 || size.height == 0) {
            size = component.getSize();
        }
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = image.createGraphics();
        component.paint(g2);
        g2.dispose();
        return image;
    }

    public static void negate(opencv_core.IplImage src, opencv_core.IplImage dest) {
        opencv_core.cvSubRS(src, opencv_core.cvScalarAll(255.0), dest, null);
    }

    public static opencv_core.IplImage createGrayImageFrom(opencv_core.IplImage input) {
        if (input.nChannels() == 3) {
            opencv_core.IplImage gray = opencv_core.IplImage.create(opencv_core.cvGetSize(input), 8, 1);
            opencv_imgproc.cvCvtColor(input, gray, 6);
            return gray;
        }
        if (input.nChannels() == 4) {
            opencv_core.IplImage gray = opencv_core.IplImage.create(opencv_core.cvGetSize(input), 8, 1);
            opencv_core.cvSetImageCOI(input, 3);
            opencv_core.cvCopy(input, gray);
            opencv_core.cvSetImageCOI(input, 0);
            return gray;
        }
        if (input.nChannels() == 2) {
            opencv_core.IplImage gray = opencv_core.IplImage.create(opencv_core.cvGetSize(input), 8, 1);
            opencv_core.IplImage alpha = opencv_core.IplImage.create(opencv_core.cvGetSize(input), 8, 1);
            opencv_core.IplImage white = opencv_core.IplImage.create(opencv_core.cvGetSize(input), 8, 1);
            opencv_core.cvSet(white, opencv_core.CvScalar.WHITE);
            opencv_core.cvSetImageCOI(input, 1);
            opencv_core.cvCopy(input, gray);
            opencv_core.cvSetImageCOI(input, 2);
            opencv_core.cvCopy(input, alpha);
            opencv_core.cvCopy(gray, white, alpha);
            return white;
        }
        return input;
    }

    public static opencv_core.IplImage computeForegroundMaskOf(opencv_core.IplImage inputImage) {
        opencv_core.IplImage grayImage = VisionUtils.createGrayImageFrom(inputImage);
        opencv_core.IplImage foregroundMask = opencv_core.IplImage.create(opencv_core.cvGetSize(grayImage), 8, 1);
        opencv_imgproc.cvCanny(grayImage, foregroundMask, 33.0, 66.5, 3);
        opencv_imgproc.IplConvKernel kernel = opencv_imgproc.IplConvKernel.create(3, 3, 1, 1, 0, null);
        opencv_imgproc.cvDilate(foregroundMask, foregroundMask, kernel, 2);
        kernel.release();
        return foregroundMask;
    }

    public static opencv_core.IplImage computeEdges(opencv_core.IplImage inputImage) {
        opencv_core.IplImage grayImage = VisionUtils.createGrayImageFrom(inputImage);
        opencv_core.IplImage foregroundMask = opencv_core.IplImage.create(opencv_core.cvGetSize(grayImage), 8, 1);
        opencv_imgproc.cvCanny(grayImage, foregroundMask, 33.0, 66.5, 3);
        return foregroundMask;
    }

    public static opencv_core.IplImage getForeground(opencv_core.IplImage inputImage) {
        opencv_core.IplImage grayImage = VisionUtils.createGrayImageFrom(inputImage);
        opencv_core.IplImage foregroundMask = opencv_core.IplImage.create(opencv_core.cvGetSize(grayImage), 8, 1);
        opencv_core.IplImage foreground = opencv_core.IplImage.create(opencv_core.cvGetSize(inputImage), 8, 3);
        opencv_imgproc.cvCanny(grayImage, foregroundMask, 33.0, 66.5, 3);
        opencv_imgproc.IplConvKernel kernel = opencv_imgproc.IplConvKernel.create(3, 3, 1, 1, 0, null);
        opencv_imgproc.cvDilate(foregroundMask, foregroundMask, kernel, 1);
        kernel.release();
        opencv_core.cvSet(foreground, opencv_core.cvScalarAll(255.0));
        opencv_core.cvCopy(inputImage, foreground, foregroundMask);
        return foreground;
    }

    public static double computeBestTemplateMatchScore(opencv_core.IplImage input, opencv_core.IplImage template) {
        TemplateMatchHelper th = new TemplateMatchHelper(5);
        th.match(input, template);
        FindResult fetchResult = th.fetchResult();
        double score = fetchResult.score;
        return score;
    }

    public static opencv_core.IplImage computeWeighingMask(int w, int h2) {
        opencv_core.IplImage mask = opencv_core.IplImage.create(opencv_core.cvSize(w, h2), 8, 1);
        opencv_core.cvSet(mask, opencv_core.cvScalarAll(255.0), null);
        opencv_core.cvSet2D(mask, w / 2, h2 / 2, opencv_core.cvScalarAll(0.0));
        opencv_core.IplImage dist = opencv_core.IplImage.create(opencv_core.cvSize(w, h2), 32, 1);
        opencv_imgproc.cvDistTransform(mask, dist, 1, 3, null, null, 0);
        opencv_core.IplImage out = opencv_core.IplImage.createCompatible(mask);
        opencv_core.cvConvertScaleAbs(dist, out, -1.0, 0.0);
        opencv_core.cvSubRS(out, opencv_core.cvScalarAll(255.0), out, null);
        try {
            ImageIO.write((RenderedImage)out.getBufferedImage(), "png", new File("dist.png"));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return mask;
    }

    public static BufferedImage paintBlobsOnImage(BufferedImage image, List<opencv_core.CvRect> blobs) {
        return new BlobPainter(image, blobs).render();
    }

    public static void extractCharacterBlocks(BufferedImage image) {
        TextMap e2 = new TextMap();
        e2.init(image);
    }

    public static opencv_core.IplImage cloneWithoutAlphaChannel(opencv_core.IplImage bgra) {
        opencv_core.IplImage bgr = opencv_core.IplImage.create(bgra.width(), bgra.height(), 8, 3);
        opencv_core.IplImage alpha = opencv_core.IplImage.create(bgra.width(), bgra.height(), 8, 1);
        opencv_core.CvArr[] in = new opencv_core.IplImage[]{bgra};
        opencv_core.CvArr[] out = new opencv_core.IplImage[]{bgr, alpha};
        int[] from_to = new int[]{0, 3, 1, 0, 2, 1, 3, 2};
        opencv_core.cvMixChannels(in, 1, out, 2, from_to, 4);
        return bgr;
    }

    public static void main(String[] args) throws IOException {
        ImageExplainer.getExplainer(TextMap.class).setLevel(ImageExplainer.Level.ALL);
        BufferedImage image = ImageIO.read(new File("screen.png"));
        TextMap m2 = TextMap.createFrom(image);
        m2.computeTextScore(10, 10, 200, 200);
    }
}

