/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search.algorithm;

import com.google.common.primitives.Doubles;
import com.googlecode.javacv.cpp.opencv_core;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.sikuli.core.cv.ImagePreprocessor;
import org.sikuli.core.cv.VisionUtils;
import org.sikuli.core.search.RegionMatch;
import org.sikuli.core.search.SearchAlgorithm;
import org.sikuli.core.search.TemplateMatchingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchByTextureAndColorAtOriginalResolution
implements SearchAlgorithm<RegionMatch> {
    private static Logger logger = LoggerFactory.getLogger(SearchByTextureAndColorAtOriginalResolution.class);
    private opencv_core.IplImage query;
    private opencv_core.IplImage input;
    private opencv_core.CvScalar avergerColorOfTheQueryImage;
    private opencv_core.IplImage resultMatrix = null;
    private ColorRegionMatch fetchedMatch = null;
    private LinkedList<ColorRegionMatch> prefetchedCandidates = new LinkedList();
    private int MAX_NUMBER_TO_PREFETCH = 10;

    public SearchByTextureAndColorAtOriginalResolution(opencv_core.IplImage input, opencv_core.IplImage query) {
        this.input = input;
        this.query = query;
    }

    @Override
    public void execute() {
        opencv_core.CvScalar avg;
        this.resultMatrix = TemplateMatchingUtilities.computeTemplateMatchResultMatrix(ImagePreprocessor.createGrayscale(this.input), ImagePreprocessor.createGrayscale(this.query));
        logger.trace("channels:" + this.query.nChannels());
        logger.trace("alpha channel:" + this.query.alphaChannel());
        logger.trace("bt:" + this.query.getBufferedImageType());
        if (this.query.nChannels() == 4) {
            this.query = VisionUtils.cloneWithoutAlphaChannel(this.query);
        }
        if (this.input.nChannels() == 4) {
            this.input = VisionUtils.cloneWithoutAlphaChannel(this.input);
        }
        this.avergerColorOfTheQueryImage = avg = opencv_core.cvAvg(this.query, null);
    }

    private static double calculateL1Distance(opencv_core.CvScalar a2, opencv_core.CvScalar b2) {
        logger.trace(SearchByTextureAndColorAtOriginalResolution.toString(a2) + "<->" + SearchByTextureAndColorAtOriginalResolution.toString(b2));
        double d2 = 0.0;
        for (int i2 = 0; i2 < 3; ++i2) {
            d2 += Math.abs(a2.getVal(i2) - b2.getVal(i2));
        }
        return d2;
    }

    private static String toString(opencv_core.CvScalar a2) {
        String s = "[";
        for (int i2 = 0; i2 < 4; ++i2) {
            s = s + String.format("%3.0f ", a2.getVal(i2));
        }
        s = s + "]";
        return s;
    }

    private double calculateColorDifferenceBetweenMatchedRegionAndTarget(Rectangle m2) {
        opencv_core.cvSetImageROI(this.input, opencv_core.cvRect(m2.x, m2.y, m2.width, m2.height));
        opencv_core.CvScalar averageColorOfTheMatchedRegion = opencv_core.cvAvg(this.input, null);
        double diff = SearchByTextureAndColorAtOriginalResolution.calculateL1Distance(this.avergerColorOfTheQueryImage, averageColorOfTheMatchedRegion);
        opencv_core.cvResetImageROI(this.input);
        return diff;
    }

    private double calculateColorMatchScore(Rectangle r) {
        double rawScore = this.calculateColorDifferenceBetweenMatchedRegionAndTarget(r);
        return (255.0 - Math.min(rawScore, 255.0)) / 255.0;
    }

    private ColorRegionMatch fetchNextColorRegionMath() {
        TemplateMatchingUtilities.TemplateMatchResult result = TemplateMatchingUtilities.fetchNextBestMatch(this.resultMatrix, this.query);
        ColorRegionMatch newMatch = new ColorRegionMatch(result.getBounds());
        newMatch.colorScore = this.calculateColorMatchScore(result.getBounds());
        newMatch.textureScore = result.score;
        return newMatch;
    }

    private void prefetch() {
        boolean hasPrefetchedEnough;
        if (this.fetchedMatch != null) {
            this.prefetchedCandidates.add(this.fetchedMatch);
            this.fetchedMatch = null;
        }
        do {
            boolean isDropInTextureSimilaritySingificant;
            ColorRegionMatch previousMatch = this.prefetchedCandidates.isEmpty() ? null : this.prefetchedCandidates.getLast();
            ColorRegionMatch newMatch = this.fetchNextColorRegionMath();
            logger.trace("prefecth (" + this.prefetchedCandidates.size() + ")" + newMatch);
            double dropInTextureSimilarity = previousMatch == null ? 0.0 : 1.0 - newMatch.textureScore / previousMatch.textureScore;
            boolean bl = isDropInTextureSimilaritySingificant = dropInTextureSimilarity > 0.15;
            if (isDropInTextureSimilaritySingificant) {
                previousMatch = newMatch;
                break;
            }
            this.prefetchedCandidates.add(newMatch);
        } while (!(hasPrefetchedEnough = this.prefetchedCandidates.size() >= this.MAX_NUMBER_TO_PREFETCH));
        Collections.sort(this.prefetchedCandidates, new Comparator<ColorRegionMatch>(){

            @Override
            public int compare(ColorRegionMatch a2, ColorRegionMatch b2) {
                return Doubles.compare(b2.getScore(), a2.getScore());
            }
        });
    }

    @Override
    public RegionMatch fetchNext() {
        if (this.prefetchedCandidates.isEmpty()) {
            this.prefetch();
        }
        ColorRegionMatch colorRegionMatch = this.prefetchedCandidates.poll();
        return colorRegionMatch;
    }

    static class ColorRegionMatch
    extends RegionMatch {
        double colorScore;
        double textureScore;

        public ColorRegionMatch(Rectangle r) {
            super(r.getBounds());
        }

        @Override
        public double getScore() {
            double s1 = this.textureScore;
            double s2 = this.colorScore;
            double s = s2 > 0.85 ? s1 : 0.0;
            return s;
        }

        public String toString() {
            return " x = " + this.x + ", y = " + this.y + ", textureScore = " + String.format("%1.3f", this.textureScore) + ", colorScore = " + String.format("%1.3f", this.colorScore);
        }
    }
}

