/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ocr;

import com.google.common.collect.Lists;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.core.cv.TextMap;
import org.sikuli.core.draw.ImageRenderer;
import org.sikuli.core.draw.PiccoloImageRenderer;
import org.sikuli.core.logging.ImageExplainer;
import org.sikuli.core.search.ImageQuery;
import org.sikuli.core.search.ImageSearcher;
import org.sikuli.core.search.RegionMatch;
import org.sikuli.ocr.RecognizedDigit;
import org.sikuli.ocr.TextImageRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitRecognizer {
    private static final ImageExplainer explainer = ImageExplainer.getExplainer(DigitRecognizer.class);
    private static final Logger logger = LoggerFactory.getLogger(DigitRecognizer.class);
    static final int HORIZONTAL_SPLIT_THRESHOLD = 12;
    static final double DIGIT_MATCH_MIN_SCORE = 0.65;
    static final int dy = 20;
    static final int dx = 12;
    static final int margin = 5;
    static ImageSearcher digitImageSearcher = new ImageSearcher(DigitRecognizer.generateDigitTemplateImage());

    private DigitRecognizer() {
    }

    private static Integer convertLocationToDigit(int x, int y) {
        int i2 = Math.round((x - 5) / 12);
        int px = (x - 5) % 12;
        int py = (y - 5) % 20;
        if (px < 3 && py > 3) {
            return null;
        }
        return i2;
    }

    private static BufferedImage generateDigitTemplateImage() {
        final ArrayList<Font> fonts = Lists.newArrayList();
        fonts.add(new Font("sansserif", 0, 0));
        fonts.add(new Font("serif", 0, 0));
        fonts.add(new Font("monaco", 0, 0));
        PiccoloImageRenderer a2 = new PiccoloImageRenderer(130, 140 * fonts.size() + 20){

            @Override
            protected void addContent(PLayer layer) {
                int x = 5;
                int y = 5;
                for (Font font : fonts) {
                    for (int size = 9; size <= 15; ++size) {
                        for (int i2 = 0; i2 <= 9; ++i2) {
                            BufferedImage digitImage = TextImageRenderer.render("" + i2, font, size, 0.0);
                            PImage pi = new PImage(digitImage);
                            pi.setOffset(x, y);
                            layer.addChild(pi);
                            x += 12;
                        }
                        y += 20;
                        x = 5;
                    }
                }
            }
        };
        explainer.step(a2, (Object)"generated digit template images");
        return a2.render();
    }

    public static List<RecognizedDigit> recognize(BufferedImage inputImage) {
        ArrayList<RecognizedDigit> recognizedDigits = Lists.newArrayList();
        TextMap tm = TextMap.createFrom(inputImage);
        for (Rectangle r : tm.getCharacterBounds()) {
            DigitRecognizer.recognizeDigit(inputImage, r, digitImageSearcher, recognizedDigits);
        }
        explainer.step(DigitRecognizer.visualize(inputImage, recognizedDigits), (Object)"recognized digits");
        return recognizedDigits;
    }

    private static ImageRenderer visualize(BufferedImage inputImage, final List<RecognizedDigit> recognizedDigits) {
        return new PiccoloImageRenderer(inputImage){

            @Override
            protected void addContent(PLayer layer) {
                for (RecognizedDigit r : recognizedDigits) {
                    PText t = new PText("" + r.digit);
                    t.setOffset(r.x, r.y + r.height);
                    t.setScale(0.7f);
                    t.setTextPaint(Color.red);
                    layer.addChild(t);
                }
            }
        };
    }

    private static void recognizeDigit(BufferedImage inputImage, Rectangle r, ImageSearcher digitImageSearcher, List<RecognizedDigit> recognizedDigits) {
        if (r.width == 0 || r.height <= 3) {
            return;
        }
        BufferedImage charImage = inputImage.getSubimage(r.x, r.y, r.width, r.height);
        ImageQuery q = new ImageQuery(charImage);
        List matches = digitImageSearcher.search(q, null, 1);
        RegionMatch m2 = (RegionMatch)matches.get(0);
        double score = m2.getScore();
        Integer i2 = DigitRecognizer.convertLocationToDigit(m2.x, m2.y);
        logger.trace("[" + i2 + "] (" + m2.x + "," + m2.y + ") score: " + score);
        if (score > 0.65 && i2 != null) {
            RecognizedDigit md = new RecognizedDigit();
            md.x = r.x;
            md.y = r.y;
            md.width = r.width;
            md.height = r.height;
            md.digit = Integer.toString(i2).charAt(0);
            recognizedDigits.add(md);
        } else if (r.width > 12) {
            Rectangle r1 = new Rectangle(r.x, r.y, r.width / 2, r.height);
            Rectangle r2 = new Rectangle(r.x + r.width / 2, r.y, r.width / 2, r.height);
            DigitRecognizer.recognizeDigit(inputImage, r1, digitImageSearcher, recognizedDigits);
            DigitRecognizer.recognizeDigit(inputImage, r2, digitImageSearcher, recognizedDigits);
        }
    }
}

