# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseMysqlConfigArgs', 'DatabaseMysqlConfig']

@pulumi.input_type
class DatabaseMysqlConfigArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 backup_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 binlog_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 group_concat_max_len: Optional[pulumi.Input[_builtins.int]] = None,
                 information_schema_stats_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_ft_min_token_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_ft_server_stopword_table: Optional[pulumi.Input[_builtins.str]] = None,
                 innodb_lock_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_log_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_online_alter_log_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_print_all_deadlocks: Optional[pulumi.Input[_builtins.bool]] = None,
                 innodb_rollback_on_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 interactive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_tmp_mem_storage_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 long_query_time: Optional[pulumi.Input[_builtins.float]] = None,
                 max_allowed_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 max_heap_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 net_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 net_write_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 sort_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 tmp_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a DatabaseMysqlConfig resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target MySQL cluster.
        :param pulumi.Input[_builtins.int] backup_hour: The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] backup_minute: The minute of the backup hour when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] binlog_retention_period: The minimum amount of time, in seconds, to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        :param pulumi.Input[_builtins.int] connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with bad handshake.
        :param pulumi.Input[_builtins.str] default_time_zone: Default server time zone, in the form of an offset from UTC (from -12:00 to +12:00), a time zone name (EST), or `SYSTEM` to use the MySQL server default.
        :param pulumi.Input[_builtins.int] group_concat_max_len: The maximum permitted result length, in bytes, for the `GROUP_CONCAT()` function.
        :param pulumi.Input[_builtins.int] information_schema_stats_expiry: The time, in seconds, before cached statistics expire.
        :param pulumi.Input[_builtins.int] innodb_ft_min_token_size: The minimum length of words that an InnoDB FULLTEXT index stores.
        :param pulumi.Input[_builtins.str] innodb_ft_server_stopword_table: The InnoDB FULLTEXT index stopword list for all InnoDB tables.
        :param pulumi.Input[_builtins.int] innodb_lock_wait_timeout: The time, in seconds, that an InnoDB transaction waits for a row lock. before giving up.
        :param pulumi.Input[_builtins.int] innodb_log_buffer_size: The size of the buffer, in bytes, that InnoDB uses to write to the log files. on disk.
        :param pulumi.Input[_builtins.int] innodb_online_alter_log_max_size: The upper limit, in bytes, of the size of the temporary log files used during online DDL operations for InnoDB tables.
        :param pulumi.Input[_builtins.bool] innodb_print_all_deadlocks: When enabled, records information about all deadlocks in InnoDB user transactions in the error log. Disabled by default.
        :param pulumi.Input[_builtins.bool] innodb_rollback_on_timeout: When enabled, transaction timeouts cause InnoDB to abort and roll back the entire transaction.
        :param pulumi.Input[_builtins.int] interactive_timeout: The time, in seconds, the server waits for activity on an interactive. connection before closing it.
        :param pulumi.Input[_builtins.str] internal_tmp_mem_storage_engine: The storage engine for in-memory internal temporary tables. Supported values are: `TempTable`, `MEMORY`.
        :param pulumi.Input[_builtins.float] long_query_time: The time, in seconds, for a query to take to execute before being captured by `slow_query_logs`. Default is `10` seconds.
        :param pulumi.Input[_builtins.int] max_allowed_packet: The size of the largest message, in bytes, that can be received by the server. Default is `67108864` (64M).
        :param pulumi.Input[_builtins.int] max_heap_table_size: The maximum size, in bytes, of internal in-memory tables. Also set `tmp_table_size`. Default is `16777216` (16M)
        :param pulumi.Input[_builtins.int] net_read_timeout: The time, in seconds, to wait for more data from an existing connection. aborting the read.
        :param pulumi.Input[_builtins.int] net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param pulumi.Input[_builtins.bool] slow_query_log: When enabled, captures slow queries. When disabled, also truncates the mysql.slow_log table. Default is false.
        :param pulumi.Input[_builtins.int] sort_buffer_size: The sort buffer size, in bytes, for `ORDER BY` optimization. Default is `262144`. (256K).
        :param pulumi.Input[_builtins.str] sql_mode: Global SQL mode. If empty, uses MySQL server defaults. Must only include uppercase alphabetic characters, underscores, and commas.
        :param pulumi.Input[_builtins.bool] sql_require_primary_key: Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
        :param pulumi.Input[_builtins.int] tmp_table_size: The maximum size, in bytes, of internal in-memory tables. Also set `max_heap_table_size`. Default is `16777216` (16M).
        :param pulumi.Input[_builtins.int] wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if binlog_retention_period is not None:
            pulumi.set(__self__, "binlog_retention_period", binlog_retention_period)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if default_time_zone is not None:
            pulumi.set(__self__, "default_time_zone", default_time_zone)
        if group_concat_max_len is not None:
            pulumi.set(__self__, "group_concat_max_len", group_concat_max_len)
        if information_schema_stats_expiry is not None:
            pulumi.set(__self__, "information_schema_stats_expiry", information_schema_stats_expiry)
        if innodb_ft_min_token_size is not None:
            pulumi.set(__self__, "innodb_ft_min_token_size", innodb_ft_min_token_size)
        if innodb_ft_server_stopword_table is not None:
            pulumi.set(__self__, "innodb_ft_server_stopword_table", innodb_ft_server_stopword_table)
        if innodb_lock_wait_timeout is not None:
            pulumi.set(__self__, "innodb_lock_wait_timeout", innodb_lock_wait_timeout)
        if innodb_log_buffer_size is not None:
            pulumi.set(__self__, "innodb_log_buffer_size", innodb_log_buffer_size)
        if innodb_online_alter_log_max_size is not None:
            pulumi.set(__self__, "innodb_online_alter_log_max_size", innodb_online_alter_log_max_size)
        if innodb_print_all_deadlocks is not None:
            pulumi.set(__self__, "innodb_print_all_deadlocks", innodb_print_all_deadlocks)
        if innodb_rollback_on_timeout is not None:
            pulumi.set(__self__, "innodb_rollback_on_timeout", innodb_rollback_on_timeout)
        if interactive_timeout is not None:
            pulumi.set(__self__, "interactive_timeout", interactive_timeout)
        if internal_tmp_mem_storage_engine is not None:
            pulumi.set(__self__, "internal_tmp_mem_storage_engine", internal_tmp_mem_storage_engine)
        if long_query_time is not None:
            pulumi.set(__self__, "long_query_time", long_query_time)
        if max_allowed_packet is not None:
            pulumi.set(__self__, "max_allowed_packet", max_allowed_packet)
        if max_heap_table_size is not None:
            pulumi.set(__self__, "max_heap_table_size", max_heap_table_size)
        if net_read_timeout is not None:
            pulumi.set(__self__, "net_read_timeout", net_read_timeout)
        if net_write_timeout is not None:
            pulumi.set(__self__, "net_write_timeout", net_write_timeout)
        if slow_query_log is not None:
            pulumi.set(__self__, "slow_query_log", slow_query_log)
        if sort_buffer_size is not None:
            pulumi.set(__self__, "sort_buffer_size", sort_buffer_size)
        if sql_mode is not None:
            pulumi.set(__self__, "sql_mode", sql_mode)
        if sql_require_primary_key is not None:
            pulumi.set(__self__, "sql_require_primary_key", sql_require_primary_key)
        if tmp_table_size is not None:
            pulumi.set(__self__, "tmp_table_size", tmp_table_size)
        if wait_timeout is not None:
            pulumi.set(__self__, "wait_timeout", wait_timeout)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the target MySQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_hour", value)

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minute of the backup hour when backup for the service starts. New backup only starts if previous backup has already completed.
        """
        return pulumi.get(self, "backup_minute")

    @backup_minute.setter
    def backup_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_minute", value)

    @_builtins.property
    @pulumi.getter(name="binlogRetentionPeriod")
    def binlog_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum amount of time, in seconds, to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        """
        return pulumi.get(self, "binlog_retention_period")

    @binlog_retention_period.setter
    def binlog_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "binlog_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with bad handshake.
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connect_timeout", value)

    @_builtins.property
    @pulumi.getter(name="defaultTimeZone")
    def default_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default server time zone, in the form of an offset from UTC (from -12:00 to +12:00), a time zone name (EST), or `SYSTEM` to use the MySQL server default.
        """
        return pulumi.get(self, "default_time_zone")

    @default_time_zone.setter
    def default_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="groupConcatMaxLen")
    def group_concat_max_len(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum permitted result length, in bytes, for the `GROUP_CONCAT()` function.
        """
        return pulumi.get(self, "group_concat_max_len")

    @group_concat_max_len.setter
    def group_concat_max_len(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_concat_max_len", value)

    @_builtins.property
    @pulumi.getter(name="informationSchemaStatsExpiry")
    def information_schema_stats_expiry(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, before cached statistics expire.
        """
        return pulumi.get(self, "information_schema_stats_expiry")

    @information_schema_stats_expiry.setter
    def information_schema_stats_expiry(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "information_schema_stats_expiry", value)

    @_builtins.property
    @pulumi.getter(name="innodbFtMinTokenSize")
    def innodb_ft_min_token_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum length of words that an InnoDB FULLTEXT index stores.
        """
        return pulumi.get(self, "innodb_ft_min_token_size")

    @innodb_ft_min_token_size.setter
    def innodb_ft_min_token_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "innodb_ft_min_token_size", value)

    @_builtins.property
    @pulumi.getter(name="innodbFtServerStopwordTable")
    def innodb_ft_server_stopword_table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The InnoDB FULLTEXT index stopword list for all InnoDB tables.
        """
        return pulumi.get(self, "innodb_ft_server_stopword_table")

    @innodb_ft_server_stopword_table.setter
    def innodb_ft_server_stopword_table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "innodb_ft_server_stopword_table", value)

    @_builtins.property
    @pulumi.getter(name="innodbLockWaitTimeout")
    def innodb_lock_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, that an InnoDB transaction waits for a row lock. before giving up.
        """
        return pulumi.get(self, "innodb_lock_wait_timeout")

    @innodb_lock_wait_timeout.setter
    def innodb_lock_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "innodb_lock_wait_timeout", value)

    @_builtins.property
    @pulumi.getter(name="innodbLogBufferSize")
    def innodb_log_buffer_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the buffer, in bytes, that InnoDB uses to write to the log files. on disk.
        """
        return pulumi.get(self, "innodb_log_buffer_size")

    @innodb_log_buffer_size.setter
    def innodb_log_buffer_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "innodb_log_buffer_size", value)

    @_builtins.property
    @pulumi.getter(name="innodbOnlineAlterLogMaxSize")
    def innodb_online_alter_log_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upper limit, in bytes, of the size of the temporary log files used during online DDL operations for InnoDB tables.
        """
        return pulumi.get(self, "innodb_online_alter_log_max_size")

    @innodb_online_alter_log_max_size.setter
    def innodb_online_alter_log_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "innodb_online_alter_log_max_size", value)

    @_builtins.property
    @pulumi.getter(name="innodbPrintAllDeadlocks")
    def innodb_print_all_deadlocks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, records information about all deadlocks in InnoDB user transactions in the error log. Disabled by default.
        """
        return pulumi.get(self, "innodb_print_all_deadlocks")

    @innodb_print_all_deadlocks.setter
    def innodb_print_all_deadlocks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "innodb_print_all_deadlocks", value)

    @_builtins.property
    @pulumi.getter(name="innodbRollbackOnTimeout")
    def innodb_rollback_on_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, transaction timeouts cause InnoDB to abort and roll back the entire transaction.
        """
        return pulumi.get(self, "innodb_rollback_on_timeout")

    @innodb_rollback_on_timeout.setter
    def innodb_rollback_on_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "innodb_rollback_on_timeout", value)

    @_builtins.property
    @pulumi.getter(name="interactiveTimeout")
    def interactive_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, the server waits for activity on an interactive. connection before closing it.
        """
        return pulumi.get(self, "interactive_timeout")

    @interactive_timeout.setter
    def interactive_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interactive_timeout", value)

    @_builtins.property
    @pulumi.getter(name="internalTmpMemStorageEngine")
    def internal_tmp_mem_storage_engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage engine for in-memory internal temporary tables. Supported values are: `TempTable`, `MEMORY`.
        """
        return pulumi.get(self, "internal_tmp_mem_storage_engine")

    @internal_tmp_mem_storage_engine.setter
    def internal_tmp_mem_storage_engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_tmp_mem_storage_engine", value)

    @_builtins.property
    @pulumi.getter(name="longQueryTime")
    def long_query_time(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The time, in seconds, for a query to take to execute before being captured by `slow_query_logs`. Default is `10` seconds.
        """
        return pulumi.get(self, "long_query_time")

    @long_query_time.setter
    def long_query_time(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "long_query_time", value)

    @_builtins.property
    @pulumi.getter(name="maxAllowedPacket")
    def max_allowed_packet(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the largest message, in bytes, that can be received by the server. Default is `67108864` (64M).
        """
        return pulumi.get(self, "max_allowed_packet")

    @max_allowed_packet.setter
    def max_allowed_packet(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_allowed_packet", value)

    @_builtins.property
    @pulumi.getter(name="maxHeapTableSize")
    def max_heap_table_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum size, in bytes, of internal in-memory tables. Also set `tmp_table_size`. Default is `16777216` (16M)
        """
        return pulumi.get(self, "max_heap_table_size")

    @max_heap_table_size.setter
    def max_heap_table_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_heap_table_size", value)

    @_builtins.property
    @pulumi.getter(name="netReadTimeout")
    def net_read_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, to wait for more data from an existing connection. aborting the read.
        """
        return pulumi.get(self, "net_read_timeout")

    @net_read_timeout.setter
    def net_read_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "net_read_timeout", value)

    @_builtins.property
    @pulumi.getter(name="netWriteTimeout")
    def net_write_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.
        """
        return pulumi.get(self, "net_write_timeout")

    @net_write_timeout.setter
    def net_write_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "net_write_timeout", value)

    @_builtins.property
    @pulumi.getter(name="slowQueryLog")
    def slow_query_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, captures slow queries. When disabled, also truncates the mysql.slow_log table. Default is false.
        """
        return pulumi.get(self, "slow_query_log")

    @slow_query_log.setter
    def slow_query_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "slow_query_log", value)

    @_builtins.property
    @pulumi.getter(name="sortBufferSize")
    def sort_buffer_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sort buffer size, in bytes, for `ORDER BY` optimization. Default is `262144`. (256K).
        """
        return pulumi.get(self, "sort_buffer_size")

    @sort_buffer_size.setter
    def sort_buffer_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sort_buffer_size", value)

    @_builtins.property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Global SQL mode. If empty, uses MySQL server defaults. Must only include uppercase alphabetic characters, underscores, and commas.
        """
        return pulumi.get(self, "sql_mode")

    @sql_mode.setter
    def sql_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_mode", value)

    @_builtins.property
    @pulumi.getter(name="sqlRequirePrimaryKey")
    def sql_require_primary_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
        """
        return pulumi.get(self, "sql_require_primary_key")

    @sql_require_primary_key.setter
    def sql_require_primary_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sql_require_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="tmpTableSize")
    def tmp_table_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum size, in bytes, of internal in-memory tables. Also set `max_heap_table_size`. Default is `16777216` (16M).
        """
        return pulumi.get(self, "tmp_table_size")

    @tmp_table_size.setter
    def tmp_table_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tmp_table_size", value)

    @_builtins.property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        return pulumi.get(self, "wait_timeout")

    @wait_timeout.setter
    def wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_timeout", value)


@pulumi.input_type
class _DatabaseMysqlConfigState:
    def __init__(__self__, *,
                 backup_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 binlog_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 group_concat_max_len: Optional[pulumi.Input[_builtins.int]] = None,
                 information_schema_stats_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_ft_min_token_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_ft_server_stopword_table: Optional[pulumi.Input[_builtins.str]] = None,
                 innodb_lock_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_log_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_online_alter_log_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_print_all_deadlocks: Optional[pulumi.Input[_builtins.bool]] = None,
                 innodb_rollback_on_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 interactive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_tmp_mem_storage_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 long_query_time: Optional[pulumi.Input[_builtins.float]] = None,
                 max_allowed_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 max_heap_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 net_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 net_write_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 sort_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 tmp_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering DatabaseMysqlConfig resources.
        :param pulumi.Input[_builtins.int] backup_hour: The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] backup_minute: The minute of the backup hour when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] binlog_retention_period: The minimum amount of time, in seconds, to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target MySQL cluster.
        :param pulumi.Input[_builtins.int] connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with bad handshake.
        :param pulumi.Input[_builtins.str] default_time_zone: Default server time zone, in the form of an offset from UTC (from -12:00 to +12:00), a time zone name (EST), or `SYSTEM` to use the MySQL server default.
        :param pulumi.Input[_builtins.int] group_concat_max_len: The maximum permitted result length, in bytes, for the `GROUP_CONCAT()` function.
        :param pulumi.Input[_builtins.int] information_schema_stats_expiry: The time, in seconds, before cached statistics expire.
        :param pulumi.Input[_builtins.int] innodb_ft_min_token_size: The minimum length of words that an InnoDB FULLTEXT index stores.
        :param pulumi.Input[_builtins.str] innodb_ft_server_stopword_table: The InnoDB FULLTEXT index stopword list for all InnoDB tables.
        :param pulumi.Input[_builtins.int] innodb_lock_wait_timeout: The time, in seconds, that an InnoDB transaction waits for a row lock. before giving up.
        :param pulumi.Input[_builtins.int] innodb_log_buffer_size: The size of the buffer, in bytes, that InnoDB uses to write to the log files. on disk.
        :param pulumi.Input[_builtins.int] innodb_online_alter_log_max_size: The upper limit, in bytes, of the size of the temporary log files used during online DDL operations for InnoDB tables.
        :param pulumi.Input[_builtins.bool] innodb_print_all_deadlocks: When enabled, records information about all deadlocks in InnoDB user transactions in the error log. Disabled by default.
        :param pulumi.Input[_builtins.bool] innodb_rollback_on_timeout: When enabled, transaction timeouts cause InnoDB to abort and roll back the entire transaction.
        :param pulumi.Input[_builtins.int] interactive_timeout: The time, in seconds, the server waits for activity on an interactive. connection before closing it.
        :param pulumi.Input[_builtins.str] internal_tmp_mem_storage_engine: The storage engine for in-memory internal temporary tables. Supported values are: `TempTable`, `MEMORY`.
        :param pulumi.Input[_builtins.float] long_query_time: The time, in seconds, for a query to take to execute before being captured by `slow_query_logs`. Default is `10` seconds.
        :param pulumi.Input[_builtins.int] max_allowed_packet: The size of the largest message, in bytes, that can be received by the server. Default is `67108864` (64M).
        :param pulumi.Input[_builtins.int] max_heap_table_size: The maximum size, in bytes, of internal in-memory tables. Also set `tmp_table_size`. Default is `16777216` (16M)
        :param pulumi.Input[_builtins.int] net_read_timeout: The time, in seconds, to wait for more data from an existing connection. aborting the read.
        :param pulumi.Input[_builtins.int] net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param pulumi.Input[_builtins.bool] slow_query_log: When enabled, captures slow queries. When disabled, also truncates the mysql.slow_log table. Default is false.
        :param pulumi.Input[_builtins.int] sort_buffer_size: The sort buffer size, in bytes, for `ORDER BY` optimization. Default is `262144`. (256K).
        :param pulumi.Input[_builtins.str] sql_mode: Global SQL mode. If empty, uses MySQL server defaults. Must only include uppercase alphabetic characters, underscores, and commas.
        :param pulumi.Input[_builtins.bool] sql_require_primary_key: Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
        :param pulumi.Input[_builtins.int] tmp_table_size: The maximum size, in bytes, of internal in-memory tables. Also set `max_heap_table_size`. Default is `16777216` (16M).
        :param pulumi.Input[_builtins.int] wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if binlog_retention_period is not None:
            pulumi.set(__self__, "binlog_retention_period", binlog_retention_period)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if default_time_zone is not None:
            pulumi.set(__self__, "default_time_zone", default_time_zone)
        if group_concat_max_len is not None:
            pulumi.set(__self__, "group_concat_max_len", group_concat_max_len)
        if information_schema_stats_expiry is not None:
            pulumi.set(__self__, "information_schema_stats_expiry", information_schema_stats_expiry)
        if innodb_ft_min_token_size is not None:
            pulumi.set(__self__, "innodb_ft_min_token_size", innodb_ft_min_token_size)
        if innodb_ft_server_stopword_table is not None:
            pulumi.set(__self__, "innodb_ft_server_stopword_table", innodb_ft_server_stopword_table)
        if innodb_lock_wait_timeout is not None:
            pulumi.set(__self__, "innodb_lock_wait_timeout", innodb_lock_wait_timeout)
        if innodb_log_buffer_size is not None:
            pulumi.set(__self__, "innodb_log_buffer_size", innodb_log_buffer_size)
        if innodb_online_alter_log_max_size is not None:
            pulumi.set(__self__, "innodb_online_alter_log_max_size", innodb_online_alter_log_max_size)
        if innodb_print_all_deadlocks is not None:
            pulumi.set(__self__, "innodb_print_all_deadlocks", innodb_print_all_deadlocks)
        if innodb_rollback_on_timeout is not None:
            pulumi.set(__self__, "innodb_rollback_on_timeout", innodb_rollback_on_timeout)
        if interactive_timeout is not None:
            pulumi.set(__self__, "interactive_timeout", interactive_timeout)
        if internal_tmp_mem_storage_engine is not None:
            pulumi.set(__self__, "internal_tmp_mem_storage_engine", internal_tmp_mem_storage_engine)
        if long_query_time is not None:
            pulumi.set(__self__, "long_query_time", long_query_time)
        if max_allowed_packet is not None:
            pulumi.set(__self__, "max_allowed_packet", max_allowed_packet)
        if max_heap_table_size is not None:
            pulumi.set(__self__, "max_heap_table_size", max_heap_table_size)
        if net_read_timeout is not None:
            pulumi.set(__self__, "net_read_timeout", net_read_timeout)
        if net_write_timeout is not None:
            pulumi.set(__self__, "net_write_timeout", net_write_timeout)
        if slow_query_log is not None:
            pulumi.set(__self__, "slow_query_log", slow_query_log)
        if sort_buffer_size is not None:
            pulumi.set(__self__, "sort_buffer_size", sort_buffer_size)
        if sql_mode is not None:
            pulumi.set(__self__, "sql_mode", sql_mode)
        if sql_require_primary_key is not None:
            pulumi.set(__self__, "sql_require_primary_key", sql_require_primary_key)
        if tmp_table_size is not None:
            pulumi.set(__self__, "tmp_table_size", tmp_table_size)
        if wait_timeout is not None:
            pulumi.set(__self__, "wait_timeout", wait_timeout)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_hour", value)

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minute of the backup hour when backup for the service starts. New backup only starts if previous backup has already completed.
        """
        return pulumi.get(self, "backup_minute")

    @backup_minute.setter
    def backup_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_minute", value)

    @_builtins.property
    @pulumi.getter(name="binlogRetentionPeriod")
    def binlog_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum amount of time, in seconds, to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        """
        return pulumi.get(self, "binlog_retention_period")

    @binlog_retention_period.setter
    def binlog_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "binlog_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the target MySQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with bad handshake.
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connect_timeout", value)

    @_builtins.property
    @pulumi.getter(name="defaultTimeZone")
    def default_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default server time zone, in the form of an offset from UTC (from -12:00 to +12:00), a time zone name (EST), or `SYSTEM` to use the MySQL server default.
        """
        return pulumi.get(self, "default_time_zone")

    @default_time_zone.setter
    def default_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="groupConcatMaxLen")
    def group_concat_max_len(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum permitted result length, in bytes, for the `GROUP_CONCAT()` function.
        """
        return pulumi.get(self, "group_concat_max_len")

    @group_concat_max_len.setter
    def group_concat_max_len(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_concat_max_len", value)

    @_builtins.property
    @pulumi.getter(name="informationSchemaStatsExpiry")
    def information_schema_stats_expiry(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, before cached statistics expire.
        """
        return pulumi.get(self, "information_schema_stats_expiry")

    @information_schema_stats_expiry.setter
    def information_schema_stats_expiry(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "information_schema_stats_expiry", value)

    @_builtins.property
    @pulumi.getter(name="innodbFtMinTokenSize")
    def innodb_ft_min_token_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum length of words that an InnoDB FULLTEXT index stores.
        """
        return pulumi.get(self, "innodb_ft_min_token_size")

    @innodb_ft_min_token_size.setter
    def innodb_ft_min_token_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "innodb_ft_min_token_size", value)

    @_builtins.property
    @pulumi.getter(name="innodbFtServerStopwordTable")
    def innodb_ft_server_stopword_table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The InnoDB FULLTEXT index stopword list for all InnoDB tables.
        """
        return pulumi.get(self, "innodb_ft_server_stopword_table")

    @innodb_ft_server_stopword_table.setter
    def innodb_ft_server_stopword_table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "innodb_ft_server_stopword_table", value)

    @_builtins.property
    @pulumi.getter(name="innodbLockWaitTimeout")
    def innodb_lock_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, that an InnoDB transaction waits for a row lock. before giving up.
        """
        return pulumi.get(self, "innodb_lock_wait_timeout")

    @innodb_lock_wait_timeout.setter
    def innodb_lock_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "innodb_lock_wait_timeout", value)

    @_builtins.property
    @pulumi.getter(name="innodbLogBufferSize")
    def innodb_log_buffer_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the buffer, in bytes, that InnoDB uses to write to the log files. on disk.
        """
        return pulumi.get(self, "innodb_log_buffer_size")

    @innodb_log_buffer_size.setter
    def innodb_log_buffer_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "innodb_log_buffer_size", value)

    @_builtins.property
    @pulumi.getter(name="innodbOnlineAlterLogMaxSize")
    def innodb_online_alter_log_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upper limit, in bytes, of the size of the temporary log files used during online DDL operations for InnoDB tables.
        """
        return pulumi.get(self, "innodb_online_alter_log_max_size")

    @innodb_online_alter_log_max_size.setter
    def innodb_online_alter_log_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "innodb_online_alter_log_max_size", value)

    @_builtins.property
    @pulumi.getter(name="innodbPrintAllDeadlocks")
    def innodb_print_all_deadlocks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, records information about all deadlocks in InnoDB user transactions in the error log. Disabled by default.
        """
        return pulumi.get(self, "innodb_print_all_deadlocks")

    @innodb_print_all_deadlocks.setter
    def innodb_print_all_deadlocks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "innodb_print_all_deadlocks", value)

    @_builtins.property
    @pulumi.getter(name="innodbRollbackOnTimeout")
    def innodb_rollback_on_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, transaction timeouts cause InnoDB to abort and roll back the entire transaction.
        """
        return pulumi.get(self, "innodb_rollback_on_timeout")

    @innodb_rollback_on_timeout.setter
    def innodb_rollback_on_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "innodb_rollback_on_timeout", value)

    @_builtins.property
    @pulumi.getter(name="interactiveTimeout")
    def interactive_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, the server waits for activity on an interactive. connection before closing it.
        """
        return pulumi.get(self, "interactive_timeout")

    @interactive_timeout.setter
    def interactive_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interactive_timeout", value)

    @_builtins.property
    @pulumi.getter(name="internalTmpMemStorageEngine")
    def internal_tmp_mem_storage_engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage engine for in-memory internal temporary tables. Supported values are: `TempTable`, `MEMORY`.
        """
        return pulumi.get(self, "internal_tmp_mem_storage_engine")

    @internal_tmp_mem_storage_engine.setter
    def internal_tmp_mem_storage_engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_tmp_mem_storage_engine", value)

    @_builtins.property
    @pulumi.getter(name="longQueryTime")
    def long_query_time(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The time, in seconds, for a query to take to execute before being captured by `slow_query_logs`. Default is `10` seconds.
        """
        return pulumi.get(self, "long_query_time")

    @long_query_time.setter
    def long_query_time(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "long_query_time", value)

    @_builtins.property
    @pulumi.getter(name="maxAllowedPacket")
    def max_allowed_packet(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the largest message, in bytes, that can be received by the server. Default is `67108864` (64M).
        """
        return pulumi.get(self, "max_allowed_packet")

    @max_allowed_packet.setter
    def max_allowed_packet(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_allowed_packet", value)

    @_builtins.property
    @pulumi.getter(name="maxHeapTableSize")
    def max_heap_table_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum size, in bytes, of internal in-memory tables. Also set `tmp_table_size`. Default is `16777216` (16M)
        """
        return pulumi.get(self, "max_heap_table_size")

    @max_heap_table_size.setter
    def max_heap_table_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_heap_table_size", value)

    @_builtins.property
    @pulumi.getter(name="netReadTimeout")
    def net_read_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, to wait for more data from an existing connection. aborting the read.
        """
        return pulumi.get(self, "net_read_timeout")

    @net_read_timeout.setter
    def net_read_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "net_read_timeout", value)

    @_builtins.property
    @pulumi.getter(name="netWriteTimeout")
    def net_write_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.
        """
        return pulumi.get(self, "net_write_timeout")

    @net_write_timeout.setter
    def net_write_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "net_write_timeout", value)

    @_builtins.property
    @pulumi.getter(name="slowQueryLog")
    def slow_query_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, captures slow queries. When disabled, also truncates the mysql.slow_log table. Default is false.
        """
        return pulumi.get(self, "slow_query_log")

    @slow_query_log.setter
    def slow_query_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "slow_query_log", value)

    @_builtins.property
    @pulumi.getter(name="sortBufferSize")
    def sort_buffer_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sort buffer size, in bytes, for `ORDER BY` optimization. Default is `262144`. (256K).
        """
        return pulumi.get(self, "sort_buffer_size")

    @sort_buffer_size.setter
    def sort_buffer_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sort_buffer_size", value)

    @_builtins.property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Global SQL mode. If empty, uses MySQL server defaults. Must only include uppercase alphabetic characters, underscores, and commas.
        """
        return pulumi.get(self, "sql_mode")

    @sql_mode.setter
    def sql_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_mode", value)

    @_builtins.property
    @pulumi.getter(name="sqlRequirePrimaryKey")
    def sql_require_primary_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
        """
        return pulumi.get(self, "sql_require_primary_key")

    @sql_require_primary_key.setter
    def sql_require_primary_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sql_require_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="tmpTableSize")
    def tmp_table_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum size, in bytes, of internal in-memory tables. Also set `max_heap_table_size`. Default is `16777216` (16M).
        """
        return pulumi.get(self, "tmp_table_size")

    @tmp_table_size.setter
    def tmp_table_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tmp_table_size", value)

    @_builtins.property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        return pulumi.get(self, "wait_timeout")

    @wait_timeout.setter
    def wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_timeout", value)


@pulumi.type_token("digitalocean:index/databaseMysqlConfig:DatabaseMysqlConfig")
class DatabaseMysqlConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 binlog_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 group_concat_max_len: Optional[pulumi.Input[_builtins.int]] = None,
                 information_schema_stats_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_ft_min_token_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_ft_server_stopword_table: Optional[pulumi.Input[_builtins.str]] = None,
                 innodb_lock_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_log_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_online_alter_log_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_print_all_deadlocks: Optional[pulumi.Input[_builtins.bool]] = None,
                 innodb_rollback_on_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 interactive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_tmp_mem_storage_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 long_query_time: Optional[pulumi.Input[_builtins.float]] = None,
                 max_allowed_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 max_heap_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 net_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 net_write_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 sort_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 tmp_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a virtual resource that can be used to change advanced configuration
        options for a DigitalOcean managed MySQL database cluster.

        > **Note** MySQL configurations are only removed from state when destroyed. The remote configuration is not unset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        example_database_cluster = digitalocean.DatabaseCluster("example",
            name="example-mysql-cluster",
            engine="mysql",
            version="8",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1)
        example = digitalocean.DatabaseMysqlConfig("example",
            cluster_id=example_database_cluster.id,
            connect_timeout=10,
            default_time_zone="UTC")
        ```

        ## Import

        A MySQL database cluster's configuration can be imported using the `id` the parent cluster, e.g.

        ```sh
        $ pulumi import digitalocean:index/databaseMysqlConfig:DatabaseMysqlConfig example 4b62829a-9c42-465b-aaa3-84051048e712
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] backup_hour: The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] backup_minute: The minute of the backup hour when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] binlog_retention_period: The minimum amount of time, in seconds, to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target MySQL cluster.
        :param pulumi.Input[_builtins.int] connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with bad handshake.
        :param pulumi.Input[_builtins.str] default_time_zone: Default server time zone, in the form of an offset from UTC (from -12:00 to +12:00), a time zone name (EST), or `SYSTEM` to use the MySQL server default.
        :param pulumi.Input[_builtins.int] group_concat_max_len: The maximum permitted result length, in bytes, for the `GROUP_CONCAT()` function.
        :param pulumi.Input[_builtins.int] information_schema_stats_expiry: The time, in seconds, before cached statistics expire.
        :param pulumi.Input[_builtins.int] innodb_ft_min_token_size: The minimum length of words that an InnoDB FULLTEXT index stores.
        :param pulumi.Input[_builtins.str] innodb_ft_server_stopword_table: The InnoDB FULLTEXT index stopword list for all InnoDB tables.
        :param pulumi.Input[_builtins.int] innodb_lock_wait_timeout: The time, in seconds, that an InnoDB transaction waits for a row lock. before giving up.
        :param pulumi.Input[_builtins.int] innodb_log_buffer_size: The size of the buffer, in bytes, that InnoDB uses to write to the log files. on disk.
        :param pulumi.Input[_builtins.int] innodb_online_alter_log_max_size: The upper limit, in bytes, of the size of the temporary log files used during online DDL operations for InnoDB tables.
        :param pulumi.Input[_builtins.bool] innodb_print_all_deadlocks: When enabled, records information about all deadlocks in InnoDB user transactions in the error log. Disabled by default.
        :param pulumi.Input[_builtins.bool] innodb_rollback_on_timeout: When enabled, transaction timeouts cause InnoDB to abort and roll back the entire transaction.
        :param pulumi.Input[_builtins.int] interactive_timeout: The time, in seconds, the server waits for activity on an interactive. connection before closing it.
        :param pulumi.Input[_builtins.str] internal_tmp_mem_storage_engine: The storage engine for in-memory internal temporary tables. Supported values are: `TempTable`, `MEMORY`.
        :param pulumi.Input[_builtins.float] long_query_time: The time, in seconds, for a query to take to execute before being captured by `slow_query_logs`. Default is `10` seconds.
        :param pulumi.Input[_builtins.int] max_allowed_packet: The size of the largest message, in bytes, that can be received by the server. Default is `67108864` (64M).
        :param pulumi.Input[_builtins.int] max_heap_table_size: The maximum size, in bytes, of internal in-memory tables. Also set `tmp_table_size`. Default is `16777216` (16M)
        :param pulumi.Input[_builtins.int] net_read_timeout: The time, in seconds, to wait for more data from an existing connection. aborting the read.
        :param pulumi.Input[_builtins.int] net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param pulumi.Input[_builtins.bool] slow_query_log: When enabled, captures slow queries. When disabled, also truncates the mysql.slow_log table. Default is false.
        :param pulumi.Input[_builtins.int] sort_buffer_size: The sort buffer size, in bytes, for `ORDER BY` optimization. Default is `262144`. (256K).
        :param pulumi.Input[_builtins.str] sql_mode: Global SQL mode. If empty, uses MySQL server defaults. Must only include uppercase alphabetic characters, underscores, and commas.
        :param pulumi.Input[_builtins.bool] sql_require_primary_key: Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
        :param pulumi.Input[_builtins.int] tmp_table_size: The maximum size, in bytes, of internal in-memory tables. Also set `max_heap_table_size`. Default is `16777216` (16M).
        :param pulumi.Input[_builtins.int] wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseMysqlConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a virtual resource that can be used to change advanced configuration
        options for a DigitalOcean managed MySQL database cluster.

        > **Note** MySQL configurations are only removed from state when destroyed. The remote configuration is not unset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        example_database_cluster = digitalocean.DatabaseCluster("example",
            name="example-mysql-cluster",
            engine="mysql",
            version="8",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1)
        example = digitalocean.DatabaseMysqlConfig("example",
            cluster_id=example_database_cluster.id,
            connect_timeout=10,
            default_time_zone="UTC")
        ```

        ## Import

        A MySQL database cluster's configuration can be imported using the `id` the parent cluster, e.g.

        ```sh
        $ pulumi import digitalocean:index/databaseMysqlConfig:DatabaseMysqlConfig example 4b62829a-9c42-465b-aaa3-84051048e712
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseMysqlConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseMysqlConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 binlog_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 group_concat_max_len: Optional[pulumi.Input[_builtins.int]] = None,
                 information_schema_stats_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_ft_min_token_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_ft_server_stopword_table: Optional[pulumi.Input[_builtins.str]] = None,
                 innodb_lock_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_log_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_online_alter_log_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 innodb_print_all_deadlocks: Optional[pulumi.Input[_builtins.bool]] = None,
                 innodb_rollback_on_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 interactive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_tmp_mem_storage_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 long_query_time: Optional[pulumi.Input[_builtins.float]] = None,
                 max_allowed_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 max_heap_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 net_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 net_write_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 sort_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
                 sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 tmp_table_size: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseMysqlConfigArgs.__new__(DatabaseMysqlConfigArgs)

            __props__.__dict__["backup_hour"] = backup_hour
            __props__.__dict__["backup_minute"] = backup_minute
            __props__.__dict__["binlog_retention_period"] = binlog_retention_period
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["connect_timeout"] = connect_timeout
            __props__.__dict__["default_time_zone"] = default_time_zone
            __props__.__dict__["group_concat_max_len"] = group_concat_max_len
            __props__.__dict__["information_schema_stats_expiry"] = information_schema_stats_expiry
            __props__.__dict__["innodb_ft_min_token_size"] = innodb_ft_min_token_size
            __props__.__dict__["innodb_ft_server_stopword_table"] = innodb_ft_server_stopword_table
            __props__.__dict__["innodb_lock_wait_timeout"] = innodb_lock_wait_timeout
            __props__.__dict__["innodb_log_buffer_size"] = innodb_log_buffer_size
            __props__.__dict__["innodb_online_alter_log_max_size"] = innodb_online_alter_log_max_size
            __props__.__dict__["innodb_print_all_deadlocks"] = innodb_print_all_deadlocks
            __props__.__dict__["innodb_rollback_on_timeout"] = innodb_rollback_on_timeout
            __props__.__dict__["interactive_timeout"] = interactive_timeout
            __props__.__dict__["internal_tmp_mem_storage_engine"] = internal_tmp_mem_storage_engine
            __props__.__dict__["long_query_time"] = long_query_time
            __props__.__dict__["max_allowed_packet"] = max_allowed_packet
            __props__.__dict__["max_heap_table_size"] = max_heap_table_size
            __props__.__dict__["net_read_timeout"] = net_read_timeout
            __props__.__dict__["net_write_timeout"] = net_write_timeout
            __props__.__dict__["slow_query_log"] = slow_query_log
            __props__.__dict__["sort_buffer_size"] = sort_buffer_size
            __props__.__dict__["sql_mode"] = sql_mode
            __props__.__dict__["sql_require_primary_key"] = sql_require_primary_key
            __props__.__dict__["tmp_table_size"] = tmp_table_size
            __props__.__dict__["wait_timeout"] = wait_timeout
        super(DatabaseMysqlConfig, __self__).__init__(
            'digitalocean:index/databaseMysqlConfig:DatabaseMysqlConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_hour: Optional[pulumi.Input[_builtins.int]] = None,
            backup_minute: Optional[pulumi.Input[_builtins.int]] = None,
            binlog_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            default_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            group_concat_max_len: Optional[pulumi.Input[_builtins.int]] = None,
            information_schema_stats_expiry: Optional[pulumi.Input[_builtins.int]] = None,
            innodb_ft_min_token_size: Optional[pulumi.Input[_builtins.int]] = None,
            innodb_ft_server_stopword_table: Optional[pulumi.Input[_builtins.str]] = None,
            innodb_lock_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            innodb_log_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
            innodb_online_alter_log_max_size: Optional[pulumi.Input[_builtins.int]] = None,
            innodb_print_all_deadlocks: Optional[pulumi.Input[_builtins.bool]] = None,
            innodb_rollback_on_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
            interactive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            internal_tmp_mem_storage_engine: Optional[pulumi.Input[_builtins.str]] = None,
            long_query_time: Optional[pulumi.Input[_builtins.float]] = None,
            max_allowed_packet: Optional[pulumi.Input[_builtins.int]] = None,
            max_heap_table_size: Optional[pulumi.Input[_builtins.int]] = None,
            net_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            net_write_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
            sort_buffer_size: Optional[pulumi.Input[_builtins.int]] = None,
            sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
            sql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
            tmp_table_size: Optional[pulumi.Input[_builtins.int]] = None,
            wait_timeout: Optional[pulumi.Input[_builtins.int]] = None) -> 'DatabaseMysqlConfig':
        """
        Get an existing DatabaseMysqlConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] backup_hour: The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] backup_minute: The minute of the backup hour when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] binlog_retention_period: The minimum amount of time, in seconds, to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target MySQL cluster.
        :param pulumi.Input[_builtins.int] connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with bad handshake.
        :param pulumi.Input[_builtins.str] default_time_zone: Default server time zone, in the form of an offset from UTC (from -12:00 to +12:00), a time zone name (EST), or `SYSTEM` to use the MySQL server default.
        :param pulumi.Input[_builtins.int] group_concat_max_len: The maximum permitted result length, in bytes, for the `GROUP_CONCAT()` function.
        :param pulumi.Input[_builtins.int] information_schema_stats_expiry: The time, in seconds, before cached statistics expire.
        :param pulumi.Input[_builtins.int] innodb_ft_min_token_size: The minimum length of words that an InnoDB FULLTEXT index stores.
        :param pulumi.Input[_builtins.str] innodb_ft_server_stopword_table: The InnoDB FULLTEXT index stopword list for all InnoDB tables.
        :param pulumi.Input[_builtins.int] innodb_lock_wait_timeout: The time, in seconds, that an InnoDB transaction waits for a row lock. before giving up.
        :param pulumi.Input[_builtins.int] innodb_log_buffer_size: The size of the buffer, in bytes, that InnoDB uses to write to the log files. on disk.
        :param pulumi.Input[_builtins.int] innodb_online_alter_log_max_size: The upper limit, in bytes, of the size of the temporary log files used during online DDL operations for InnoDB tables.
        :param pulumi.Input[_builtins.bool] innodb_print_all_deadlocks: When enabled, records information about all deadlocks in InnoDB user transactions in the error log. Disabled by default.
        :param pulumi.Input[_builtins.bool] innodb_rollback_on_timeout: When enabled, transaction timeouts cause InnoDB to abort and roll back the entire transaction.
        :param pulumi.Input[_builtins.int] interactive_timeout: The time, in seconds, the server waits for activity on an interactive. connection before closing it.
        :param pulumi.Input[_builtins.str] internal_tmp_mem_storage_engine: The storage engine for in-memory internal temporary tables. Supported values are: `TempTable`, `MEMORY`.
        :param pulumi.Input[_builtins.float] long_query_time: The time, in seconds, for a query to take to execute before being captured by `slow_query_logs`. Default is `10` seconds.
        :param pulumi.Input[_builtins.int] max_allowed_packet: The size of the largest message, in bytes, that can be received by the server. Default is `67108864` (64M).
        :param pulumi.Input[_builtins.int] max_heap_table_size: The maximum size, in bytes, of internal in-memory tables. Also set `tmp_table_size`. Default is `16777216` (16M)
        :param pulumi.Input[_builtins.int] net_read_timeout: The time, in seconds, to wait for more data from an existing connection. aborting the read.
        :param pulumi.Input[_builtins.int] net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param pulumi.Input[_builtins.bool] slow_query_log: When enabled, captures slow queries. When disabled, also truncates the mysql.slow_log table. Default is false.
        :param pulumi.Input[_builtins.int] sort_buffer_size: The sort buffer size, in bytes, for `ORDER BY` optimization. Default is `262144`. (256K).
        :param pulumi.Input[_builtins.str] sql_mode: Global SQL mode. If empty, uses MySQL server defaults. Must only include uppercase alphabetic characters, underscores, and commas.
        :param pulumi.Input[_builtins.bool] sql_require_primary_key: Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
        :param pulumi.Input[_builtins.int] tmp_table_size: The maximum size, in bytes, of internal in-memory tables. Also set `max_heap_table_size`. Default is `16777216` (16M).
        :param pulumi.Input[_builtins.int] wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseMysqlConfigState.__new__(_DatabaseMysqlConfigState)

        __props__.__dict__["backup_hour"] = backup_hour
        __props__.__dict__["backup_minute"] = backup_minute
        __props__.__dict__["binlog_retention_period"] = binlog_retention_period
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["connect_timeout"] = connect_timeout
        __props__.__dict__["default_time_zone"] = default_time_zone
        __props__.__dict__["group_concat_max_len"] = group_concat_max_len
        __props__.__dict__["information_schema_stats_expiry"] = information_schema_stats_expiry
        __props__.__dict__["innodb_ft_min_token_size"] = innodb_ft_min_token_size
        __props__.__dict__["innodb_ft_server_stopword_table"] = innodb_ft_server_stopword_table
        __props__.__dict__["innodb_lock_wait_timeout"] = innodb_lock_wait_timeout
        __props__.__dict__["innodb_log_buffer_size"] = innodb_log_buffer_size
        __props__.__dict__["innodb_online_alter_log_max_size"] = innodb_online_alter_log_max_size
        __props__.__dict__["innodb_print_all_deadlocks"] = innodb_print_all_deadlocks
        __props__.__dict__["innodb_rollback_on_timeout"] = innodb_rollback_on_timeout
        __props__.__dict__["interactive_timeout"] = interactive_timeout
        __props__.__dict__["internal_tmp_mem_storage_engine"] = internal_tmp_mem_storage_engine
        __props__.__dict__["long_query_time"] = long_query_time
        __props__.__dict__["max_allowed_packet"] = max_allowed_packet
        __props__.__dict__["max_heap_table_size"] = max_heap_table_size
        __props__.__dict__["net_read_timeout"] = net_read_timeout
        __props__.__dict__["net_write_timeout"] = net_write_timeout
        __props__.__dict__["slow_query_log"] = slow_query_log
        __props__.__dict__["sort_buffer_size"] = sort_buffer_size
        __props__.__dict__["sql_mode"] = sql_mode
        __props__.__dict__["sql_require_primary_key"] = sql_require_primary_key
        __props__.__dict__["tmp_table_size"] = tmp_table_size
        __props__.__dict__["wait_timeout"] = wait_timeout
        return DatabaseMysqlConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> pulumi.Output[_builtins.int]:
        """
        The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> pulumi.Output[_builtins.int]:
        """
        The minute of the backup hour when backup for the service starts. New backup only starts if previous backup has already completed.
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="binlogRetentionPeriod")
    def binlog_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum amount of time, in seconds, to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        """
        return pulumi.get(self, "binlog_retention_period")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the target MySQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with bad handshake.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="defaultTimeZone")
    def default_time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Default server time zone, in the form of an offset from UTC (from -12:00 to +12:00), a time zone name (EST), or `SYSTEM` to use the MySQL server default.
        """
        return pulumi.get(self, "default_time_zone")

    @_builtins.property
    @pulumi.getter(name="groupConcatMaxLen")
    def group_concat_max_len(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum permitted result length, in bytes, for the `GROUP_CONCAT()` function.
        """
        return pulumi.get(self, "group_concat_max_len")

    @_builtins.property
    @pulumi.getter(name="informationSchemaStatsExpiry")
    def information_schema_stats_expiry(self) -> pulumi.Output[_builtins.int]:
        """
        The time, in seconds, before cached statistics expire.
        """
        return pulumi.get(self, "information_schema_stats_expiry")

    @_builtins.property
    @pulumi.getter(name="innodbFtMinTokenSize")
    def innodb_ft_min_token_size(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum length of words that an InnoDB FULLTEXT index stores.
        """
        return pulumi.get(self, "innodb_ft_min_token_size")

    @_builtins.property
    @pulumi.getter(name="innodbFtServerStopwordTable")
    def innodb_ft_server_stopword_table(self) -> pulumi.Output[_builtins.str]:
        """
        The InnoDB FULLTEXT index stopword list for all InnoDB tables.
        """
        return pulumi.get(self, "innodb_ft_server_stopword_table")

    @_builtins.property
    @pulumi.getter(name="innodbLockWaitTimeout")
    def innodb_lock_wait_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The time, in seconds, that an InnoDB transaction waits for a row lock. before giving up.
        """
        return pulumi.get(self, "innodb_lock_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="innodbLogBufferSize")
    def innodb_log_buffer_size(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the buffer, in bytes, that InnoDB uses to write to the log files. on disk.
        """
        return pulumi.get(self, "innodb_log_buffer_size")

    @_builtins.property
    @pulumi.getter(name="innodbOnlineAlterLogMaxSize")
    def innodb_online_alter_log_max_size(self) -> pulumi.Output[_builtins.int]:
        """
        The upper limit, in bytes, of the size of the temporary log files used during online DDL operations for InnoDB tables.
        """
        return pulumi.get(self, "innodb_online_alter_log_max_size")

    @_builtins.property
    @pulumi.getter(name="innodbPrintAllDeadlocks")
    def innodb_print_all_deadlocks(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, records information about all deadlocks in InnoDB user transactions in the error log. Disabled by default.
        """
        return pulumi.get(self, "innodb_print_all_deadlocks")

    @_builtins.property
    @pulumi.getter(name="innodbRollbackOnTimeout")
    def innodb_rollback_on_timeout(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, transaction timeouts cause InnoDB to abort and roll back the entire transaction.
        """
        return pulumi.get(self, "innodb_rollback_on_timeout")

    @_builtins.property
    @pulumi.getter(name="interactiveTimeout")
    def interactive_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The time, in seconds, the server waits for activity on an interactive. connection before closing it.
        """
        return pulumi.get(self, "interactive_timeout")

    @_builtins.property
    @pulumi.getter(name="internalTmpMemStorageEngine")
    def internal_tmp_mem_storage_engine(self) -> pulumi.Output[_builtins.str]:
        """
        The storage engine for in-memory internal temporary tables. Supported values are: `TempTable`, `MEMORY`.
        """
        return pulumi.get(self, "internal_tmp_mem_storage_engine")

    @_builtins.property
    @pulumi.getter(name="longQueryTime")
    def long_query_time(self) -> pulumi.Output[_builtins.float]:
        """
        The time, in seconds, for a query to take to execute before being captured by `slow_query_logs`. Default is `10` seconds.
        """
        return pulumi.get(self, "long_query_time")

    @_builtins.property
    @pulumi.getter(name="maxAllowedPacket")
    def max_allowed_packet(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the largest message, in bytes, that can be received by the server. Default is `67108864` (64M).
        """
        return pulumi.get(self, "max_allowed_packet")

    @_builtins.property
    @pulumi.getter(name="maxHeapTableSize")
    def max_heap_table_size(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum size, in bytes, of internal in-memory tables. Also set `tmp_table_size`. Default is `16777216` (16M)
        """
        return pulumi.get(self, "max_heap_table_size")

    @_builtins.property
    @pulumi.getter(name="netReadTimeout")
    def net_read_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The time, in seconds, to wait for more data from an existing connection. aborting the read.
        """
        return pulumi.get(self, "net_read_timeout")

    @_builtins.property
    @pulumi.getter(name="netWriteTimeout")
    def net_write_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.
        """
        return pulumi.get(self, "net_write_timeout")

    @_builtins.property
    @pulumi.getter(name="slowQueryLog")
    def slow_query_log(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, captures slow queries. When disabled, also truncates the mysql.slow_log table. Default is false.
        """
        return pulumi.get(self, "slow_query_log")

    @_builtins.property
    @pulumi.getter(name="sortBufferSize")
    def sort_buffer_size(self) -> pulumi.Output[_builtins.int]:
        """
        The sort buffer size, in bytes, for `ORDER BY` optimization. Default is `262144`. (256K).
        """
        return pulumi.get(self, "sort_buffer_size")

    @_builtins.property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Global SQL mode. If empty, uses MySQL server defaults. Must only include uppercase alphabetic characters, underscores, and commas.
        """
        return pulumi.get(self, "sql_mode")

    @_builtins.property
    @pulumi.getter(name="sqlRequirePrimaryKey")
    def sql_require_primary_key(self) -> pulumi.Output[_builtins.bool]:
        """
        Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
        """
        return pulumi.get(self, "sql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="tmpTableSize")
    def tmp_table_size(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum size, in bytes, of internal in-memory tables. Also set `max_heap_table_size`. Default is `16777216` (16M).
        """
        return pulumi.get(self, "tmp_table_size")

    @_builtins.property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        return pulumi.get(self, "wait_timeout")

