# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseOnlineMigrationArgs', 'DatabaseOnlineMigration']

@pulumi.input_type
class DatabaseOnlineMigrationArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 source: pulumi.Input['DatabaseOnlineMigrationSourceArgs'],
                 disable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_dbs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DatabaseOnlineMigration resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target MySQL cluster.
        :param pulumi.Input['DatabaseOnlineMigrationSourceArgs'] source: Configuration for migration
        :param pulumi.Input[_builtins.bool] disable_ssl: When set to true, enables SSL encryption when connecting to the source database.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_dbs: A list of databases that should be ignored during migration.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "source", source)
        if disable_ssl is not None:
            pulumi.set(__self__, "disable_ssl", disable_ssl)
        if ignore_dbs is not None:
            pulumi.set(__self__, "ignore_dbs", ignore_dbs)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the target MySQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input['DatabaseOnlineMigrationSourceArgs']:
        """
        Configuration for migration
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['DatabaseOnlineMigrationSourceArgs']):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="disableSsl")
    def disable_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true, enables SSL encryption when connecting to the source database.
        """
        return pulumi.get(self, "disable_ssl")

    @disable_ssl.setter
    def disable_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_ssl", value)

    @_builtins.property
    @pulumi.getter(name="ignoreDbs")
    def ignore_dbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of databases that should be ignored during migration.
        """
        return pulumi.get(self, "ignore_dbs")

    @ignore_dbs.setter
    def ignore_dbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignore_dbs", value)


@pulumi.input_type
class _DatabaseOnlineMigrationState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_dbs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input['DatabaseOnlineMigrationSourceArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseOnlineMigration resources.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target MySQL cluster.
        :param pulumi.Input[_builtins.str] created_at: The date and time when the online migration was created
        :param pulumi.Input[_builtins.bool] disable_ssl: When set to true, enables SSL encryption when connecting to the source database.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_dbs: A list of databases that should be ignored during migration.
        :param pulumi.Input['DatabaseOnlineMigrationSourceArgs'] source: Configuration for migration
        :param pulumi.Input[_builtins.str] status: The status of the online migration
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if disable_ssl is not None:
            pulumi.set(__self__, "disable_ssl", disable_ssl)
        if ignore_dbs is not None:
            pulumi.set(__self__, "ignore_dbs", ignore_dbs)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the target MySQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the online migration was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="disableSsl")
    def disable_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true, enables SSL encryption when connecting to the source database.
        """
        return pulumi.get(self, "disable_ssl")

    @disable_ssl.setter
    def disable_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_ssl", value)

    @_builtins.property
    @pulumi.getter(name="ignoreDbs")
    def ignore_dbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of databases that should be ignored during migration.
        """
        return pulumi.get(self, "ignore_dbs")

    @ignore_dbs.setter
    def ignore_dbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignore_dbs", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['DatabaseOnlineMigrationSourceArgs']]:
        """
        Configuration for migration
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['DatabaseOnlineMigrationSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the online migration
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("digitalocean:index/databaseOnlineMigration:DatabaseOnlineMigration")
class DatabaseOnlineMigration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_dbs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input[Union['DatabaseOnlineMigrationSourceArgs', 'DatabaseOnlineMigrationSourceArgsDict']]] = None,
                 __props__=None):
        """
        Provides a virtual resource that can be used to start an online migration
        for a DigitalOcean managed database cluster. Migrating a cluster establishes a
        connection with an existing cluster and replicates its contents to the target
        cluster. If the existing database is continuously being written to, the migration
        process will continue for up to two weeks unless it is manually stopped.
        Online migration is only available for MySQL, PostgreSQL, Caching, and Valkey clusters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        source = digitalocean.DatabaseCluster("source",
            name="st01",
            engine="mysql",
            version="8",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1,
            tags=["production"])
        destination = digitalocean.DatabaseCluster("destination",
            name="dt01",
            engine="mysql",
            version="8",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1,
            tags=["production"])
        source_db = digitalocean.DatabaseDb("source_db",
            cluster_id=source.id,
            name="terraform-db-om-source")
        foobar = digitalocean.DatabaseOnlineMigration("foobar",
            cluster_id=destination.id,
            source={
                "host": source.host,
                "db_name": source_db.name,
                "port": source.port,
                "username": source.user,
                "password": source.password,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    destination,
                    source,
                    source_db,
                ]))
        ```

        ## Import

        A MySQL database cluster's online_migration can be imported using the `id` the parent cluster, e.g.

        ```sh
        $ pulumi import digitalocean:index/databaseOnlineMigration:DatabaseOnlineMigration example 4b62829a-9c42-465b-aaa3-84051048e712
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target MySQL cluster.
        :param pulumi.Input[_builtins.bool] disable_ssl: When set to true, enables SSL encryption when connecting to the source database.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_dbs: A list of databases that should be ignored during migration.
        :param pulumi.Input[Union['DatabaseOnlineMigrationSourceArgs', 'DatabaseOnlineMigrationSourceArgsDict']] source: Configuration for migration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseOnlineMigrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a virtual resource that can be used to start an online migration
        for a DigitalOcean managed database cluster. Migrating a cluster establishes a
        connection with an existing cluster and replicates its contents to the target
        cluster. If the existing database is continuously being written to, the migration
        process will continue for up to two weeks unless it is manually stopped.
        Online migration is only available for MySQL, PostgreSQL, Caching, and Valkey clusters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        source = digitalocean.DatabaseCluster("source",
            name="st01",
            engine="mysql",
            version="8",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1,
            tags=["production"])
        destination = digitalocean.DatabaseCluster("destination",
            name="dt01",
            engine="mysql",
            version="8",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1,
            tags=["production"])
        source_db = digitalocean.DatabaseDb("source_db",
            cluster_id=source.id,
            name="terraform-db-om-source")
        foobar = digitalocean.DatabaseOnlineMigration("foobar",
            cluster_id=destination.id,
            source={
                "host": source.host,
                "db_name": source_db.name,
                "port": source.port,
                "username": source.user,
                "password": source.password,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    destination,
                    source,
                    source_db,
                ]))
        ```

        ## Import

        A MySQL database cluster's online_migration can be imported using the `id` the parent cluster, e.g.

        ```sh
        $ pulumi import digitalocean:index/databaseOnlineMigration:DatabaseOnlineMigration example 4b62829a-9c42-465b-aaa3-84051048e712
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseOnlineMigrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseOnlineMigrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_dbs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input[Union['DatabaseOnlineMigrationSourceArgs', 'DatabaseOnlineMigrationSourceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseOnlineMigrationArgs.__new__(DatabaseOnlineMigrationArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["disable_ssl"] = disable_ssl
            __props__.__dict__["ignore_dbs"] = ignore_dbs
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
        super(DatabaseOnlineMigration, __self__).__init__(
            'digitalocean:index/databaseOnlineMigration:DatabaseOnlineMigration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            disable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
            ignore_dbs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source: Optional[pulumi.Input[Union['DatabaseOnlineMigrationSourceArgs', 'DatabaseOnlineMigrationSourceArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseOnlineMigration':
        """
        Get an existing DatabaseOnlineMigration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target MySQL cluster.
        :param pulumi.Input[_builtins.str] created_at: The date and time when the online migration was created
        :param pulumi.Input[_builtins.bool] disable_ssl: When set to true, enables SSL encryption when connecting to the source database.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_dbs: A list of databases that should be ignored during migration.
        :param pulumi.Input[Union['DatabaseOnlineMigrationSourceArgs', 'DatabaseOnlineMigrationSourceArgsDict']] source: Configuration for migration
        :param pulumi.Input[_builtins.str] status: The status of the online migration
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseOnlineMigrationState.__new__(_DatabaseOnlineMigrationState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["disable_ssl"] = disable_ssl
        __props__.__dict__["ignore_dbs"] = ignore_dbs
        __props__.__dict__["source"] = source
        __props__.__dict__["status"] = status
        return DatabaseOnlineMigration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the target MySQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the online migration was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="disableSsl")
    def disable_ssl(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When set to true, enables SSL encryption when connecting to the source database.
        """
        return pulumi.get(self, "disable_ssl")

    @_builtins.property
    @pulumi.getter(name="ignoreDbs")
    def ignore_dbs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of databases that should be ignored during migration.
        """
        return pulumi.get(self, "ignore_dbs")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.DatabaseOnlineMigrationSource']:
        """
        Configuration for migration
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the online migration
        """
        return pulumi.get(self, "status")

