# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDatabaseReplicaResult',
    'AwaitableGetDatabaseReplicaResult',
    'get_database_replica',
    'get_database_replica_output',
]

@pulumi.output_type
class GetDatabaseReplicaResult:
    """
    A collection of values returned by getDatabaseReplica.
    """
    def __init__(__self__, cluster_id=None, database=None, host=None, id=None, name=None, password=None, port=None, private_host=None, private_network_uuid=None, private_uri=None, region=None, storage_size_mib=None, tags=None, uri=None, user=None, uuid=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if database and not isinstance(database, str):
            raise TypeError("Expected argument 'database' to be a str")
        pulumi.set(__self__, "database", database)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if private_host and not isinstance(private_host, str):
            raise TypeError("Expected argument 'private_host' to be a str")
        pulumi.set(__self__, "private_host", private_host)
        if private_network_uuid and not isinstance(private_network_uuid, str):
            raise TypeError("Expected argument 'private_network_uuid' to be a str")
        pulumi.set(__self__, "private_network_uuid", private_network_uuid)
        if private_uri and not isinstance(private_uri, str):
            raise TypeError("Expected argument 'private_uri' to be a str")
        pulumi.set(__self__, "private_uri", private_uri)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if storage_size_mib and not isinstance(storage_size_mib, str):
            raise TypeError("Expected argument 'storage_size_mib' to be a str")
        pulumi.set(__self__, "storage_size_mib", storage_size_mib)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if uri and not isinstance(uri, str):
            raise TypeError("Expected argument 'uri' to be a str")
        pulumi.set(__self__, "uri", uri)
        if user and not isinstance(user, str):
            raise TypeError("Expected argument 'user' to be a str")
        pulumi.set(__self__, "user", user)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        Name of the replica's default database.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Database replica's hostname.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Password for the replica's default user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Network port that the database replica is listening on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="privateHost")
    def private_host(self) -> _builtins.str:
        """
        Same as `host`, but only accessible from resources within the account and in the same region.
        """
        return pulumi.get(self, "private_host")

    @_builtins.property
    @pulumi.getter(name="privateNetworkUuid")
    def private_network_uuid(self) -> _builtins.str:
        return pulumi.get(self, "private_network_uuid")

    @_builtins.property
    @pulumi.getter(name="privateUri")
    def private_uri(self) -> _builtins.str:
        """
        Same as `uri`, but only accessible from resources within the account and in the same region.
        """
        return pulumi.get(self, "private_uri")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="storageSizeMib")
    def storage_size_mib(self) -> _builtins.str:
        return pulumi.get(self, "storage_size_mib")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of tag names to be applied to the database replica.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The full URI for connecting to the database replica.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        Username for the replica's default user.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID of the database replica.
        """
        return pulumi.get(self, "uuid")


class AwaitableGetDatabaseReplicaResult(GetDatabaseReplicaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseReplicaResult(
            cluster_id=self.cluster_id,
            database=self.database,
            host=self.host,
            id=self.id,
            name=self.name,
            password=self.password,
            port=self.port,
            private_host=self.private_host,
            private_network_uuid=self.private_network_uuid,
            private_uri=self.private_uri,
            region=self.region,
            storage_size_mib=self.storage_size_mib,
            tags=self.tags,
            uri=self.uri,
            user=self.user,
            uuid=self.uuid)


def get_database_replica(cluster_id: Optional[_builtins.str] = None,
                         name: Optional[_builtins.str] = None,
                         tags: Optional[Sequence[_builtins.str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseReplicaResult:
    """
    Provides information on a DigitalOcean database replica.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    example = digitalocean.get_database_cluster(name="example-cluster")
    read_only = digitalocean.get_database_replica(cluster_id=example.id,
        name="terra-test-ro")
    pulumi.export("replicaOutput", read_only.uri)
    ```


    :param _builtins.str cluster_id: The ID of the original source database cluster.
    :param _builtins.str name: The name for the database replica.
    :param Sequence[_builtins.str] tags: A list of tag names to be applied to the database replica.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getDatabaseReplica:getDatabaseReplica', __args__, opts=opts, typ=GetDatabaseReplicaResult).value

    return AwaitableGetDatabaseReplicaResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        database=pulumi.get(__ret__, 'database'),
        host=pulumi.get(__ret__, 'host'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        password=pulumi.get(__ret__, 'password'),
        port=pulumi.get(__ret__, 'port'),
        private_host=pulumi.get(__ret__, 'private_host'),
        private_network_uuid=pulumi.get(__ret__, 'private_network_uuid'),
        private_uri=pulumi.get(__ret__, 'private_uri'),
        region=pulumi.get(__ret__, 'region'),
        storage_size_mib=pulumi.get(__ret__, 'storage_size_mib'),
        tags=pulumi.get(__ret__, 'tags'),
        uri=pulumi.get(__ret__, 'uri'),
        user=pulumi.get(__ret__, 'user'),
        uuid=pulumi.get(__ret__, 'uuid'))
def get_database_replica_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                name: Optional[pulumi.Input[_builtins.str]] = None,
                                tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseReplicaResult]:
    """
    Provides information on a DigitalOcean database replica.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    example = digitalocean.get_database_cluster(name="example-cluster")
    read_only = digitalocean.get_database_replica(cluster_id=example.id,
        name="terra-test-ro")
    pulumi.export("replicaOutput", read_only.uri)
    ```


    :param _builtins.str cluster_id: The ID of the original source database cluster.
    :param _builtins.str name: The name for the database replica.
    :param Sequence[_builtins.str] tags: A list of tag names to be applied to the database replica.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('digitalocean:index/getDatabaseReplica:getDatabaseReplica', __args__, opts=opts, typ=GetDatabaseReplicaResult)
    return __ret__.apply(lambda __response__: GetDatabaseReplicaResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        database=pulumi.get(__response__, 'database'),
        host=pulumi.get(__response__, 'host'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        password=pulumi.get(__response__, 'password'),
        port=pulumi.get(__response__, 'port'),
        private_host=pulumi.get(__response__, 'private_host'),
        private_network_uuid=pulumi.get(__response__, 'private_network_uuid'),
        private_uri=pulumi.get(__response__, 'private_uri'),
        region=pulumi.get(__response__, 'region'),
        storage_size_mib=pulumi.get(__response__, 'storage_size_mib'),
        tags=pulumi.get(__response__, 'tags'),
        uri=pulumi.get(__response__, 'uri'),
        user=pulumi.get(__response__, 'user'),
        uuid=pulumi.get(__response__, 'uuid')))
