# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRecordsResult',
    'AwaitableGetRecordsResult',
    'get_records',
    'get_records_output',
]

@pulumi.output_type
class GetRecordsResult:
    """
    A collection of values returned by getRecords.
    """
    def __init__(__self__, domain=None, filters=None, id=None, records=None, sorts=None):
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if sorts and not isinstance(sorts, list):
            raise TypeError("Expected argument 'sorts' to be a list")
        pulumi.set(__self__, "sorts", sorts)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Domain of the DNS record.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRecordsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetRecordsRecordResult']:
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def sorts(self) -> Optional[Sequence['outputs.GetRecordsSortResult']]:
        return pulumi.get(self, "sorts")


class AwaitableGetRecordsResult(GetRecordsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecordsResult(
            domain=self.domain,
            filters=self.filters,
            id=self.id,
            records=self.records,
            sorts=self.sorts)


def get_records(domain: Optional[_builtins.str] = None,
                filters: Optional[Sequence[Union['GetRecordsFilterArgs', 'GetRecordsFilterArgsDict']]] = None,
                sorts: Optional[Sequence[Union['GetRecordsSortArgs', 'GetRecordsSortArgsDict']]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecordsResult:
    """
    Retrieve information about all DNS records within a domain, with the ability to filter and sort the results.
    If no filters are specified, all records will be returned.

    ## Example Usage

    Get data for all MX records in a domain:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean
    import pulumi_std as std

    example = digitalocean.get_records(domain="example.com",
        filters=[{
            "key": "type",
            "values": ["MX"],
        }])
    pulumi.export("mailServers", std.join(separator=",",
        input=[__item.value for __item in example.records]).result)
    ```


    :param _builtins.str domain: The domain name to search for DNS records
    :param Sequence[Union['GetRecordsFilterArgs', 'GetRecordsFilterArgsDict']] filters: Filter the results.
           The `filter` block is documented below.
    :param Sequence[Union['GetRecordsSortArgs', 'GetRecordsSortArgsDict']] sorts: Sort the results.
           The `sort` block is documented below.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['filters'] = filters
    __args__['sorts'] = sorts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getRecords:getRecords', __args__, opts=opts, typ=GetRecordsResult).value

    return AwaitableGetRecordsResult(
        domain=pulumi.get(__ret__, 'domain'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        records=pulumi.get(__ret__, 'records'),
        sorts=pulumi.get(__ret__, 'sorts'))
def get_records_output(domain: Optional[pulumi.Input[_builtins.str]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRecordsFilterArgs', 'GetRecordsFilterArgsDict']]]]] = None,
                       sorts: Optional[pulumi.Input[Optional[Sequence[Union['GetRecordsSortArgs', 'GetRecordsSortArgsDict']]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRecordsResult]:
    """
    Retrieve information about all DNS records within a domain, with the ability to filter and sort the results.
    If no filters are specified, all records will be returned.

    ## Example Usage

    Get data for all MX records in a domain:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean
    import pulumi_std as std

    example = digitalocean.get_records(domain="example.com",
        filters=[{
            "key": "type",
            "values": ["MX"],
        }])
    pulumi.export("mailServers", std.join(separator=",",
        input=[__item.value for __item in example.records]).result)
    ```


    :param _builtins.str domain: The domain name to search for DNS records
    :param Sequence[Union['GetRecordsFilterArgs', 'GetRecordsFilterArgsDict']] filters: Filter the results.
           The `filter` block is documented below.
    :param Sequence[Union['GetRecordsSortArgs', 'GetRecordsSortArgsDict']] sorts: Sort the results.
           The `sort` block is documented below.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['filters'] = filters
    __args__['sorts'] = sorts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('digitalocean:index/getRecords:getRecords', __args__, opts=opts, typ=GetRecordsResult)
    return __ret__.apply(lambda __response__: GetRecordsResult(
        domain=pulumi.get(__response__, 'domain'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        records=pulumi.get(__response__, 'records'),
        sorts=pulumi.get(__response__, 'sorts')))
