# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['KubernetesClusterArgs', 'KubernetesCluster']

@pulumi.input_type
class KubernetesClusterArgs:
    def __init__(__self__, *,
                 node_pool: pulumi.Input['KubernetesClusterNodePoolArgs'],
                 region: pulumi.Input[Union[_builtins.str, 'Region']],
                 version: pulumi.Input[_builtins.str],
                 amd_gpu_device_metrics_exporter_plugin: Optional[pulumi.Input['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs']] = None,
                 amd_gpu_device_plugin: Optional[pulumi.Input['KubernetesClusterAmdGpuDevicePluginArgs']] = None,
                 auto_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_autoscaler_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterClusterAutoscalerConfigurationArgs']]]] = None,
                 cluster_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_firewall: Optional[pulumi.Input['KubernetesClusterControlPlaneFirewallArgs']] = None,
                 destroy_all_associated_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha: Optional[pulumi.Input[_builtins.bool]] = None,
                 kubeconfig_expire_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 maintenance_policy: Optional[pulumi.Input['KubernetesClusterMaintenancePolicyArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing_agent: Optional[pulumi.Input['KubernetesClusterRoutingAgentArgs']] = None,
                 service_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 surge_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KubernetesCluster resource.
        :param pulumi.Input['KubernetesClusterNodePoolArgs'] node_pool: A block representing the cluster's default node pool. Additional node pools may be added to the cluster using the `KubernetesNodePool` resource. The following arguments may be specified:
        :param pulumi.Input[Union[_builtins.str, 'Region']] region: The slug identifier for the region where the Kubernetes cluster will be created.
        :param pulumi.Input[_builtins.str] version: The slug identifier for the version of Kubernetes used for the cluster. Use [doctl](https://github.com/digitalocean/doctl) to find the available versions `doctl kubernetes options versions`. (**Note:** A cluster may only be upgraded to newer versions in-place. If the version is decreased, a new resource will be created.)
        :param pulumi.Input['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs'] amd_gpu_device_metrics_exporter_plugin: Block containing options for the AMD GPU device metrics exporter component.
        :param pulumi.Input['KubernetesClusterAmdGpuDevicePluginArgs'] amd_gpu_device_plugin: Block containing options for the AMD GPU device plugin component. If not specified, the component will be enabled by default for clusters with AMD GPU nodes.
        :param pulumi.Input[_builtins.bool] auto_upgrade: A boolean value indicating whether the cluster will be automatically upgraded to new patch releases during its maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesClusterClusterAutoscalerConfigurationArgs']]] cluster_autoscaler_configurations: Block containing options for cluster auto-scaling.
        :param pulumi.Input[_builtins.str] cluster_subnet: The range of IP addresses in the overlay network of the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        :param pulumi.Input['KubernetesClusterControlPlaneFirewallArgs'] control_plane_firewall: A block representing the cluster's control plane firewall
        :param pulumi.Input[_builtins.bool] destroy_all_associated_resources: **Use with caution.** When set to true, all associated DigitalOcean resources created via the Kubernetes API (load balancers, volumes, and volume snapshots) will be destroyed along with the cluster when it is destroyed.
        :param pulumi.Input[_builtins.bool] ha: Enable/disable the high availability control plane for a cluster. Once enabled for a cluster, high availability cannot be disabled. Default: false
        :param pulumi.Input[_builtins.int] kubeconfig_expire_seconds: The duration in seconds that the returned Kubernetes credentials will be valid. If not set or 0, the credentials will have a 7 day expiry.
        :param pulumi.Input['KubernetesClusterMaintenancePolicyArgs'] maintenance_policy: A block representing the cluster's maintenance window. Updates will be applied within this window. If not specified, a default maintenance window will be chosen. `auto_upgrade` must be set to `true` for this to have an effect.
        :param pulumi.Input[_builtins.str] name: A name for the Kubernetes cluster.
        :param pulumi.Input[_builtins.bool] registry_integration: Enables or disables the DigitalOcean container registry integration for the cluster. This requires that a container registry has first been created for the account. Default: false
        :param pulumi.Input['KubernetesClusterRoutingAgentArgs'] routing_agent: Block containing options for the routing-agent component. If not specified, the routing-agent component will not be installed in the cluster.
        :param pulumi.Input[_builtins.str] service_subnet: The range of assignable IP addresses for services running in the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        :param pulumi.Input[_builtins.bool] surge_upgrade: Enable/disable surge upgrades for a cluster. Default: true
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag names to be applied to the Kubernetes cluster.
        :param pulumi.Input[_builtins.str] vpc_uuid: The ID of the VPC where the Kubernetes cluster will be located.
        """
        pulumi.set(__self__, "node_pool", node_pool)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "version", version)
        if amd_gpu_device_metrics_exporter_plugin is not None:
            pulumi.set(__self__, "amd_gpu_device_metrics_exporter_plugin", amd_gpu_device_metrics_exporter_plugin)
        if amd_gpu_device_plugin is not None:
            pulumi.set(__self__, "amd_gpu_device_plugin", amd_gpu_device_plugin)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if cluster_autoscaler_configurations is not None:
            pulumi.set(__self__, "cluster_autoscaler_configurations", cluster_autoscaler_configurations)
        if cluster_subnet is not None:
            pulumi.set(__self__, "cluster_subnet", cluster_subnet)
        if control_plane_firewall is not None:
            pulumi.set(__self__, "control_plane_firewall", control_plane_firewall)
        if destroy_all_associated_resources is not None:
            pulumi.set(__self__, "destroy_all_associated_resources", destroy_all_associated_resources)
        if ha is not None:
            pulumi.set(__self__, "ha", ha)
        if kubeconfig_expire_seconds is not None:
            pulumi.set(__self__, "kubeconfig_expire_seconds", kubeconfig_expire_seconds)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registry_integration is not None:
            pulumi.set(__self__, "registry_integration", registry_integration)
        if routing_agent is not None:
            pulumi.set(__self__, "routing_agent", routing_agent)
        if service_subnet is not None:
            pulumi.set(__self__, "service_subnet", service_subnet)
        if surge_upgrade is not None:
            pulumi.set(__self__, "surge_upgrade", surge_upgrade)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @_builtins.property
    @pulumi.getter(name="nodePool")
    def node_pool(self) -> pulumi.Input['KubernetesClusterNodePoolArgs']:
        """
        A block representing the cluster's default node pool. Additional node pools may be added to the cluster using the `KubernetesNodePool` resource. The following arguments may be specified:
        """
        return pulumi.get(self, "node_pool")

    @node_pool.setter
    def node_pool(self, value: pulumi.Input['KubernetesClusterNodePoolArgs']):
        pulumi.set(self, "node_pool", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[Union[_builtins.str, 'Region']]:
        """
        The slug identifier for the region where the Kubernetes cluster will be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[Union[_builtins.str, 'Region']]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The slug identifier for the version of Kubernetes used for the cluster. Use [doctl](https://github.com/digitalocean/doctl) to find the available versions `doctl kubernetes options versions`. (**Note:** A cluster may only be upgraded to newer versions in-place. If the version is decreased, a new resource will be created.)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="amdGpuDeviceMetricsExporterPlugin")
    def amd_gpu_device_metrics_exporter_plugin(self) -> Optional[pulumi.Input['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs']]:
        """
        Block containing options for the AMD GPU device metrics exporter component.
        """
        return pulumi.get(self, "amd_gpu_device_metrics_exporter_plugin")

    @amd_gpu_device_metrics_exporter_plugin.setter
    def amd_gpu_device_metrics_exporter_plugin(self, value: Optional[pulumi.Input['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs']]):
        pulumi.set(self, "amd_gpu_device_metrics_exporter_plugin", value)

    @_builtins.property
    @pulumi.getter(name="amdGpuDevicePlugin")
    def amd_gpu_device_plugin(self) -> Optional[pulumi.Input['KubernetesClusterAmdGpuDevicePluginArgs']]:
        """
        Block containing options for the AMD GPU device plugin component. If not specified, the component will be enabled by default for clusters with AMD GPU nodes.
        """
        return pulumi.get(self, "amd_gpu_device_plugin")

    @amd_gpu_device_plugin.setter
    def amd_gpu_device_plugin(self, value: Optional[pulumi.Input['KubernetesClusterAmdGpuDevicePluginArgs']]):
        pulumi.set(self, "amd_gpu_device_plugin", value)

    @_builtins.property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value indicating whether the cluster will be automatically upgraded to new patch releases during its maintenance window.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="clusterAutoscalerConfigurations")
    def cluster_autoscaler_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterClusterAutoscalerConfigurationArgs']]]]:
        """
        Block containing options for cluster auto-scaling.
        """
        return pulumi.get(self, "cluster_autoscaler_configurations")

    @cluster_autoscaler_configurations.setter
    def cluster_autoscaler_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterClusterAutoscalerConfigurationArgs']]]]):
        pulumi.set(self, "cluster_autoscaler_configurations", value)

    @_builtins.property
    @pulumi.getter(name="clusterSubnet")
    def cluster_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of IP addresses in the overlay network of the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        """
        return pulumi.get(self, "cluster_subnet")

    @cluster_subnet.setter
    def cluster_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_subnet", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneFirewall")
    def control_plane_firewall(self) -> Optional[pulumi.Input['KubernetesClusterControlPlaneFirewallArgs']]:
        """
        A block representing the cluster's control plane firewall
        """
        return pulumi.get(self, "control_plane_firewall")

    @control_plane_firewall.setter
    def control_plane_firewall(self, value: Optional[pulumi.Input['KubernetesClusterControlPlaneFirewallArgs']]):
        pulumi.set(self, "control_plane_firewall", value)

    @_builtins.property
    @pulumi.getter(name="destroyAllAssociatedResources")
    def destroy_all_associated_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        **Use with caution.** When set to true, all associated DigitalOcean resources created via the Kubernetes API (load balancers, volumes, and volume snapshots) will be destroyed along with the cluster when it is destroyed.
        """
        return pulumi.get(self, "destroy_all_associated_resources")

    @destroy_all_associated_resources.setter
    def destroy_all_associated_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "destroy_all_associated_resources", value)

    @_builtins.property
    @pulumi.getter
    def ha(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable/disable the high availability control plane for a cluster. Once enabled for a cluster, high availability cannot be disabled. Default: false
        """
        return pulumi.get(self, "ha")

    @ha.setter
    def ha(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ha", value)

    @_builtins.property
    @pulumi.getter(name="kubeconfigExpireSeconds")
    def kubeconfig_expire_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration in seconds that the returned Kubernetes credentials will be valid. If not set or 0, the credentials will have a 7 day expiry.
        """
        return pulumi.get(self, "kubeconfig_expire_seconds")

    @kubeconfig_expire_seconds.setter
    def kubeconfig_expire_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "kubeconfig_expire_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['KubernetesClusterMaintenancePolicyArgs']]:
        """
        A block representing the cluster's maintenance window. Updates will be applied within this window. If not specified, a default maintenance window will be chosen. `auto_upgrade` must be set to `true` for this to have an effect.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['KubernetesClusterMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="registryIntegration")
    def registry_integration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables the DigitalOcean container registry integration for the cluster. This requires that a container registry has first been created for the account. Default: false
        """
        return pulumi.get(self, "registry_integration")

    @registry_integration.setter
    def registry_integration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "registry_integration", value)

    @_builtins.property
    @pulumi.getter(name="routingAgent")
    def routing_agent(self) -> Optional[pulumi.Input['KubernetesClusterRoutingAgentArgs']]:
        """
        Block containing options for the routing-agent component. If not specified, the routing-agent component will not be installed in the cluster.
        """
        return pulumi.get(self, "routing_agent")

    @routing_agent.setter
    def routing_agent(self, value: Optional[pulumi.Input['KubernetesClusterRoutingAgentArgs']]):
        pulumi.set(self, "routing_agent", value)

    @_builtins.property
    @pulumi.getter(name="serviceSubnet")
    def service_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of assignable IP addresses for services running in the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        """
        return pulumi.get(self, "service_subnet")

    @service_subnet.setter
    def service_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_subnet", value)

    @_builtins.property
    @pulumi.getter(name="surgeUpgrade")
    def surge_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable/disable surge upgrades for a cluster. Default: true
        """
        return pulumi.get(self, "surge_upgrade")

    @surge_upgrade.setter
    def surge_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "surge_upgrade", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tag names to be applied to the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC where the Kubernetes cluster will be located.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_uuid", value)


@pulumi.input_type
class _KubernetesClusterState:
    def __init__(__self__, *,
                 amd_gpu_device_metrics_exporter_plugin: Optional[pulumi.Input['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs']] = None,
                 amd_gpu_device_plugin: Optional[pulumi.Input['KubernetesClusterAmdGpuDevicePluginArgs']] = None,
                 auto_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_autoscaler_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterClusterAutoscalerConfigurationArgs']]]] = None,
                 cluster_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_firewall: Optional[pulumi.Input['KubernetesClusterControlPlaneFirewallArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 destroy_all_associated_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ha: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_configs: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeConfigArgs']]]] = None,
                 kubeconfig_expire_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 maintenance_policy: Optional[pulumi.Input['KubernetesClusterMaintenancePolicyArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool: Optional[pulumi.Input['KubernetesClusterNodePoolArgs']] = None,
                 region: Optional[pulumi.Input[Union[_builtins.str, 'Region']]] = None,
                 registry_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing_agent: Optional[pulumi.Input['KubernetesClusterRoutingAgentArgs']] = None,
                 service_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 surge_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KubernetesCluster resources.
        :param pulumi.Input['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs'] amd_gpu_device_metrics_exporter_plugin: Block containing options for the AMD GPU device metrics exporter component.
        :param pulumi.Input['KubernetesClusterAmdGpuDevicePluginArgs'] amd_gpu_device_plugin: Block containing options for the AMD GPU device plugin component. If not specified, the component will be enabled by default for clusters with AMD GPU nodes.
        :param pulumi.Input[_builtins.bool] auto_upgrade: A boolean value indicating whether the cluster will be automatically upgraded to new patch releases during its maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesClusterClusterAutoscalerConfigurationArgs']]] cluster_autoscaler_configurations: Block containing options for cluster auto-scaling.
        :param pulumi.Input[_builtins.str] cluster_subnet: The range of IP addresses in the overlay network of the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        :param pulumi.Input[_builtins.str] cluster_urn: The uniform resource name (URN) for the Kubernetes cluster.
        :param pulumi.Input['KubernetesClusterControlPlaneFirewallArgs'] control_plane_firewall: A block representing the cluster's control plane firewall
        :param pulumi.Input[_builtins.str] created_at: The date and time when the node was created.
        :param pulumi.Input[_builtins.bool] destroy_all_associated_resources: **Use with caution.** When set to true, all associated DigitalOcean resources created via the Kubernetes API (load balancers, volumes, and volume snapshots) will be destroyed along with the cluster when it is destroyed.
        :param pulumi.Input[_builtins.str] endpoint: The base URL of the API server on the Kubernetes master node.
        :param pulumi.Input[_builtins.bool] ha: Enable/disable the high availability control plane for a cluster. Once enabled for a cluster, high availability cannot be disabled. Default: false
        :param pulumi.Input[_builtins.str] ipv4_address: The public IPv4 address of the Kubernetes master node. This will not be set if high availability is configured on the cluster (v1.21+)
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeConfigArgs']]] kube_configs: A representation of the Kubernetes cluster's kubeconfig with the following attributes:
        :param pulumi.Input[_builtins.int] kubeconfig_expire_seconds: The duration in seconds that the returned Kubernetes credentials will be valid. If not set or 0, the credentials will have a 7 day expiry.
        :param pulumi.Input['KubernetesClusterMaintenancePolicyArgs'] maintenance_policy: A block representing the cluster's maintenance window. Updates will be applied within this window. If not specified, a default maintenance window will be chosen. `auto_upgrade` must be set to `true` for this to have an effect.
        :param pulumi.Input[_builtins.str] name: A name for the Kubernetes cluster.
        :param pulumi.Input['KubernetesClusterNodePoolArgs'] node_pool: A block representing the cluster's default node pool. Additional node pools may be added to the cluster using the `KubernetesNodePool` resource. The following arguments may be specified:
        :param pulumi.Input[Union[_builtins.str, 'Region']] region: The slug identifier for the region where the Kubernetes cluster will be created.
        :param pulumi.Input[_builtins.bool] registry_integration: Enables or disables the DigitalOcean container registry integration for the cluster. This requires that a container registry has first been created for the account. Default: false
        :param pulumi.Input['KubernetesClusterRoutingAgentArgs'] routing_agent: Block containing options for the routing-agent component. If not specified, the routing-agent component will not be installed in the cluster.
        :param pulumi.Input[_builtins.str] service_subnet: The range of assignable IP addresses for services running in the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        :param pulumi.Input[_builtins.str] status: A string indicating the current status of the individual node.
        :param pulumi.Input[_builtins.bool] surge_upgrade: Enable/disable surge upgrades for a cluster. Default: true
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag names to be applied to the Kubernetes cluster.
        :param pulumi.Input[_builtins.str] updated_at: The date and time when the node was last updated.
        :param pulumi.Input[_builtins.str] version: The slug identifier for the version of Kubernetes used for the cluster. Use [doctl](https://github.com/digitalocean/doctl) to find the available versions `doctl kubernetes options versions`. (**Note:** A cluster may only be upgraded to newer versions in-place. If the version is decreased, a new resource will be created.)
        :param pulumi.Input[_builtins.str] vpc_uuid: The ID of the VPC where the Kubernetes cluster will be located.
        """
        if amd_gpu_device_metrics_exporter_plugin is not None:
            pulumi.set(__self__, "amd_gpu_device_metrics_exporter_plugin", amd_gpu_device_metrics_exporter_plugin)
        if amd_gpu_device_plugin is not None:
            pulumi.set(__self__, "amd_gpu_device_plugin", amd_gpu_device_plugin)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if cluster_autoscaler_configurations is not None:
            pulumi.set(__self__, "cluster_autoscaler_configurations", cluster_autoscaler_configurations)
        if cluster_subnet is not None:
            pulumi.set(__self__, "cluster_subnet", cluster_subnet)
        if cluster_urn is not None:
            pulumi.set(__self__, "cluster_urn", cluster_urn)
        if control_plane_firewall is not None:
            pulumi.set(__self__, "control_plane_firewall", control_plane_firewall)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if destroy_all_associated_resources is not None:
            pulumi.set(__self__, "destroy_all_associated_resources", destroy_all_associated_resources)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if ha is not None:
            pulumi.set(__self__, "ha", ha)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if kube_configs is not None:
            pulumi.set(__self__, "kube_configs", kube_configs)
        if kubeconfig_expire_seconds is not None:
            pulumi.set(__self__, "kubeconfig_expire_seconds", kubeconfig_expire_seconds)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool is not None:
            pulumi.set(__self__, "node_pool", node_pool)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registry_integration is not None:
            pulumi.set(__self__, "registry_integration", registry_integration)
        if routing_agent is not None:
            pulumi.set(__self__, "routing_agent", routing_agent)
        if service_subnet is not None:
            pulumi.set(__self__, "service_subnet", service_subnet)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if surge_upgrade is not None:
            pulumi.set(__self__, "surge_upgrade", surge_upgrade)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @_builtins.property
    @pulumi.getter(name="amdGpuDeviceMetricsExporterPlugin")
    def amd_gpu_device_metrics_exporter_plugin(self) -> Optional[pulumi.Input['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs']]:
        """
        Block containing options for the AMD GPU device metrics exporter component.
        """
        return pulumi.get(self, "amd_gpu_device_metrics_exporter_plugin")

    @amd_gpu_device_metrics_exporter_plugin.setter
    def amd_gpu_device_metrics_exporter_plugin(self, value: Optional[pulumi.Input['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs']]):
        pulumi.set(self, "amd_gpu_device_metrics_exporter_plugin", value)

    @_builtins.property
    @pulumi.getter(name="amdGpuDevicePlugin")
    def amd_gpu_device_plugin(self) -> Optional[pulumi.Input['KubernetesClusterAmdGpuDevicePluginArgs']]:
        """
        Block containing options for the AMD GPU device plugin component. If not specified, the component will be enabled by default for clusters with AMD GPU nodes.
        """
        return pulumi.get(self, "amd_gpu_device_plugin")

    @amd_gpu_device_plugin.setter
    def amd_gpu_device_plugin(self, value: Optional[pulumi.Input['KubernetesClusterAmdGpuDevicePluginArgs']]):
        pulumi.set(self, "amd_gpu_device_plugin", value)

    @_builtins.property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value indicating whether the cluster will be automatically upgraded to new patch releases during its maintenance window.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="clusterAutoscalerConfigurations")
    def cluster_autoscaler_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterClusterAutoscalerConfigurationArgs']]]]:
        """
        Block containing options for cluster auto-scaling.
        """
        return pulumi.get(self, "cluster_autoscaler_configurations")

    @cluster_autoscaler_configurations.setter
    def cluster_autoscaler_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterClusterAutoscalerConfigurationArgs']]]]):
        pulumi.set(self, "cluster_autoscaler_configurations", value)

    @_builtins.property
    @pulumi.getter(name="clusterSubnet")
    def cluster_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of IP addresses in the overlay network of the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        """
        return pulumi.get(self, "cluster_subnet")

    @cluster_subnet.setter
    def cluster_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_subnet", value)

    @_builtins.property
    @pulumi.getter(name="clusterUrn")
    def cluster_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The uniform resource name (URN) for the Kubernetes cluster.
        """
        return pulumi.get(self, "cluster_urn")

    @cluster_urn.setter
    def cluster_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_urn", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneFirewall")
    def control_plane_firewall(self) -> Optional[pulumi.Input['KubernetesClusterControlPlaneFirewallArgs']]:
        """
        A block representing the cluster's control plane firewall
        """
        return pulumi.get(self, "control_plane_firewall")

    @control_plane_firewall.setter
    def control_plane_firewall(self, value: Optional[pulumi.Input['KubernetesClusterControlPlaneFirewallArgs']]):
        pulumi.set(self, "control_plane_firewall", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the node was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="destroyAllAssociatedResources")
    def destroy_all_associated_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        **Use with caution.** When set to true, all associated DigitalOcean resources created via the Kubernetes API (load balancers, volumes, and volume snapshots) will be destroyed along with the cluster when it is destroyed.
        """
        return pulumi.get(self, "destroy_all_associated_resources")

    @destroy_all_associated_resources.setter
    def destroy_all_associated_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "destroy_all_associated_resources", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base URL of the API server on the Kubernetes master node.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def ha(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable/disable the high availability control plane for a cluster. Once enabled for a cluster, high availability cannot be disabled. Default: false
        """
        return pulumi.get(self, "ha")

    @ha.setter
    def ha(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ha", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public IPv4 address of the Kubernetes master node. This will not be set if high availability is configured on the cluster (v1.21+)
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfigs")
    def kube_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeConfigArgs']]]]:
        """
        A representation of the Kubernetes cluster's kubeconfig with the following attributes:
        """
        return pulumi.get(self, "kube_configs")

    @kube_configs.setter
    def kube_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeConfigArgs']]]]):
        pulumi.set(self, "kube_configs", value)

    @_builtins.property
    @pulumi.getter(name="kubeconfigExpireSeconds")
    def kubeconfig_expire_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration in seconds that the returned Kubernetes credentials will be valid. If not set or 0, the credentials will have a 7 day expiry.
        """
        return pulumi.get(self, "kubeconfig_expire_seconds")

    @kubeconfig_expire_seconds.setter
    def kubeconfig_expire_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "kubeconfig_expire_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['KubernetesClusterMaintenancePolicyArgs']]:
        """
        A block representing the cluster's maintenance window. Updates will be applied within this window. If not specified, a default maintenance window will be chosen. `auto_upgrade` must be set to `true` for this to have an effect.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['KubernetesClusterMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodePool")
    def node_pool(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolArgs']]:
        """
        A block representing the cluster's default node pool. Additional node pools may be added to the cluster using the `KubernetesNodePool` resource. The following arguments may be specified:
        """
        return pulumi.get(self, "node_pool")

    @node_pool.setter
    def node_pool(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolArgs']]):
        pulumi.set(self, "node_pool", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[Union[_builtins.str, 'Region']]]:
        """
        The slug identifier for the region where the Kubernetes cluster will be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[Union[_builtins.str, 'Region']]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="registryIntegration")
    def registry_integration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables the DigitalOcean container registry integration for the cluster. This requires that a container registry has first been created for the account. Default: false
        """
        return pulumi.get(self, "registry_integration")

    @registry_integration.setter
    def registry_integration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "registry_integration", value)

    @_builtins.property
    @pulumi.getter(name="routingAgent")
    def routing_agent(self) -> Optional[pulumi.Input['KubernetesClusterRoutingAgentArgs']]:
        """
        Block containing options for the routing-agent component. If not specified, the routing-agent component will not be installed in the cluster.
        """
        return pulumi.get(self, "routing_agent")

    @routing_agent.setter
    def routing_agent(self, value: Optional[pulumi.Input['KubernetesClusterRoutingAgentArgs']]):
        pulumi.set(self, "routing_agent", value)

    @_builtins.property
    @pulumi.getter(name="serviceSubnet")
    def service_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of assignable IP addresses for services running in the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        """
        return pulumi.get(self, "service_subnet")

    @service_subnet.setter
    def service_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_subnet", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string indicating the current status of the individual node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="surgeUpgrade")
    def surge_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable/disable surge upgrades for a cluster. Default: true
        """
        return pulumi.get(self, "surge_upgrade")

    @surge_upgrade.setter
    def surge_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "surge_upgrade", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tag names to be applied to the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the node was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The slug identifier for the version of Kubernetes used for the cluster. Use [doctl](https://github.com/digitalocean/doctl) to find the available versions `doctl kubernetes options versions`. (**Note:** A cluster may only be upgraded to newer versions in-place. If the version is decreased, a new resource will be created.)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC where the Kubernetes cluster will be located.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_uuid", value)


@pulumi.type_token("digitalocean:index/kubernetesCluster:KubernetesCluster")
class KubernetesCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amd_gpu_device_metrics_exporter_plugin: Optional[pulumi.Input[Union['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs', 'KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgsDict']]] = None,
                 amd_gpu_device_plugin: Optional[pulumi.Input[Union['KubernetesClusterAmdGpuDevicePluginArgs', 'KubernetesClusterAmdGpuDevicePluginArgsDict']]] = None,
                 auto_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_autoscaler_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterClusterAutoscalerConfigurationArgs', 'KubernetesClusterClusterAutoscalerConfigurationArgsDict']]]]] = None,
                 cluster_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_firewall: Optional[pulumi.Input[Union['KubernetesClusterControlPlaneFirewallArgs', 'KubernetesClusterControlPlaneFirewallArgsDict']]] = None,
                 destroy_all_associated_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha: Optional[pulumi.Input[_builtins.bool]] = None,
                 kubeconfig_expire_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['KubernetesClusterMaintenancePolicyArgs', 'KubernetesClusterMaintenancePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool: Optional[pulumi.Input[Union['KubernetesClusterNodePoolArgs', 'KubernetesClusterNodePoolArgsDict']]] = None,
                 region: Optional[pulumi.Input[Union[_builtins.str, 'Region']]] = None,
                 registry_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing_agent: Optional[pulumi.Input[Union['KubernetesClusterRoutingAgentArgs', 'KubernetesClusterRoutingAgentArgsDict']]] = None,
                 service_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 surge_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Before importing a Kubernetes cluster, the cluster's default node pool must be tagged with

        the `terraform:default-node-pool` tag. The provider will automatically add this tag if

        the cluster only has a single node pool. Clusters with more than one node pool, however, will require

        that you manually add the `terraform:default-node-pool` tag to the node pool that you intend to be

        the default node pool.

        Then the Kubernetes cluster and its default node pool can be imported using the cluster's `id`, e.g.

        ```sh
        $ pulumi import digitalocean:index/kubernetesCluster:KubernetesCluster mycluster 1b8b2100-0e9f-4e8f-ad78-9eb578c2a0af
        ```

        Additional node pools must be imported separately as `digitalocean_kubernetes_cluster`

        resources, e.g.

        ```sh
        $ pulumi import digitalocean:index/kubernetesCluster:KubernetesCluster mynodepool 9d76f410-9284-4436-9633-4066852442c8
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs', 'KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgsDict']] amd_gpu_device_metrics_exporter_plugin: Block containing options for the AMD GPU device metrics exporter component.
        :param pulumi.Input[Union['KubernetesClusterAmdGpuDevicePluginArgs', 'KubernetesClusterAmdGpuDevicePluginArgsDict']] amd_gpu_device_plugin: Block containing options for the AMD GPU device plugin component. If not specified, the component will be enabled by default for clusters with AMD GPU nodes.
        :param pulumi.Input[_builtins.bool] auto_upgrade: A boolean value indicating whether the cluster will be automatically upgraded to new patch releases during its maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterClusterAutoscalerConfigurationArgs', 'KubernetesClusterClusterAutoscalerConfigurationArgsDict']]]] cluster_autoscaler_configurations: Block containing options for cluster auto-scaling.
        :param pulumi.Input[_builtins.str] cluster_subnet: The range of IP addresses in the overlay network of the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        :param pulumi.Input[Union['KubernetesClusterControlPlaneFirewallArgs', 'KubernetesClusterControlPlaneFirewallArgsDict']] control_plane_firewall: A block representing the cluster's control plane firewall
        :param pulumi.Input[_builtins.bool] destroy_all_associated_resources: **Use with caution.** When set to true, all associated DigitalOcean resources created via the Kubernetes API (load balancers, volumes, and volume snapshots) will be destroyed along with the cluster when it is destroyed.
        :param pulumi.Input[_builtins.bool] ha: Enable/disable the high availability control plane for a cluster. Once enabled for a cluster, high availability cannot be disabled. Default: false
        :param pulumi.Input[_builtins.int] kubeconfig_expire_seconds: The duration in seconds that the returned Kubernetes credentials will be valid. If not set or 0, the credentials will have a 7 day expiry.
        :param pulumi.Input[Union['KubernetesClusterMaintenancePolicyArgs', 'KubernetesClusterMaintenancePolicyArgsDict']] maintenance_policy: A block representing the cluster's maintenance window. Updates will be applied within this window. If not specified, a default maintenance window will be chosen. `auto_upgrade` must be set to `true` for this to have an effect.
        :param pulumi.Input[_builtins.str] name: A name for the Kubernetes cluster.
        :param pulumi.Input[Union['KubernetesClusterNodePoolArgs', 'KubernetesClusterNodePoolArgsDict']] node_pool: A block representing the cluster's default node pool. Additional node pools may be added to the cluster using the `KubernetesNodePool` resource. The following arguments may be specified:
        :param pulumi.Input[Union[_builtins.str, 'Region']] region: The slug identifier for the region where the Kubernetes cluster will be created.
        :param pulumi.Input[_builtins.bool] registry_integration: Enables or disables the DigitalOcean container registry integration for the cluster. This requires that a container registry has first been created for the account. Default: false
        :param pulumi.Input[Union['KubernetesClusterRoutingAgentArgs', 'KubernetesClusterRoutingAgentArgsDict']] routing_agent: Block containing options for the routing-agent component. If not specified, the routing-agent component will not be installed in the cluster.
        :param pulumi.Input[_builtins.str] service_subnet: The range of assignable IP addresses for services running in the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        :param pulumi.Input[_builtins.bool] surge_upgrade: Enable/disable surge upgrades for a cluster. Default: true
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag names to be applied to the Kubernetes cluster.
        :param pulumi.Input[_builtins.str] version: The slug identifier for the version of Kubernetes used for the cluster. Use [doctl](https://github.com/digitalocean/doctl) to find the available versions `doctl kubernetes options versions`. (**Note:** A cluster may only be upgraded to newer versions in-place. If the version is decreased, a new resource will be created.)
        :param pulumi.Input[_builtins.str] vpc_uuid: The ID of the VPC where the Kubernetes cluster will be located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Before importing a Kubernetes cluster, the cluster's default node pool must be tagged with

        the `terraform:default-node-pool` tag. The provider will automatically add this tag if

        the cluster only has a single node pool. Clusters with more than one node pool, however, will require

        that you manually add the `terraform:default-node-pool` tag to the node pool that you intend to be

        the default node pool.

        Then the Kubernetes cluster and its default node pool can be imported using the cluster's `id`, e.g.

        ```sh
        $ pulumi import digitalocean:index/kubernetesCluster:KubernetesCluster mycluster 1b8b2100-0e9f-4e8f-ad78-9eb578c2a0af
        ```

        Additional node pools must be imported separately as `digitalocean_kubernetes_cluster`

        resources, e.g.

        ```sh
        $ pulumi import digitalocean:index/kubernetesCluster:KubernetesCluster mynodepool 9d76f410-9284-4436-9633-4066852442c8
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amd_gpu_device_metrics_exporter_plugin: Optional[pulumi.Input[Union['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs', 'KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgsDict']]] = None,
                 amd_gpu_device_plugin: Optional[pulumi.Input[Union['KubernetesClusterAmdGpuDevicePluginArgs', 'KubernetesClusterAmdGpuDevicePluginArgsDict']]] = None,
                 auto_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_autoscaler_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterClusterAutoscalerConfigurationArgs', 'KubernetesClusterClusterAutoscalerConfigurationArgsDict']]]]] = None,
                 cluster_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_firewall: Optional[pulumi.Input[Union['KubernetesClusterControlPlaneFirewallArgs', 'KubernetesClusterControlPlaneFirewallArgsDict']]] = None,
                 destroy_all_associated_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha: Optional[pulumi.Input[_builtins.bool]] = None,
                 kubeconfig_expire_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['KubernetesClusterMaintenancePolicyArgs', 'KubernetesClusterMaintenancePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool: Optional[pulumi.Input[Union['KubernetesClusterNodePoolArgs', 'KubernetesClusterNodePoolArgsDict']]] = None,
                 region: Optional[pulumi.Input[Union[_builtins.str, 'Region']]] = None,
                 registry_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing_agent: Optional[pulumi.Input[Union['KubernetesClusterRoutingAgentArgs', 'KubernetesClusterRoutingAgentArgsDict']]] = None,
                 service_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 surge_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesClusterArgs.__new__(KubernetesClusterArgs)

            __props__.__dict__["amd_gpu_device_metrics_exporter_plugin"] = amd_gpu_device_metrics_exporter_plugin
            __props__.__dict__["amd_gpu_device_plugin"] = amd_gpu_device_plugin
            __props__.__dict__["auto_upgrade"] = auto_upgrade
            __props__.__dict__["cluster_autoscaler_configurations"] = cluster_autoscaler_configurations
            __props__.__dict__["cluster_subnet"] = cluster_subnet
            __props__.__dict__["control_plane_firewall"] = control_plane_firewall
            __props__.__dict__["destroy_all_associated_resources"] = destroy_all_associated_resources
            __props__.__dict__["ha"] = ha
            __props__.__dict__["kubeconfig_expire_seconds"] = kubeconfig_expire_seconds
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["name"] = name
            if node_pool is None and not opts.urn:
                raise TypeError("Missing required property 'node_pool'")
            __props__.__dict__["node_pool"] = node_pool
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["registry_integration"] = registry_integration
            __props__.__dict__["routing_agent"] = routing_agent
            __props__.__dict__["service_subnet"] = service_subnet
            __props__.__dict__["surge_upgrade"] = surge_upgrade
            __props__.__dict__["tags"] = tags
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["vpc_uuid"] = vpc_uuid
            __props__.__dict__["cluster_urn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["ipv4_address"] = None
            __props__.__dict__["kube_configs"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["kubeConfigs"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(KubernetesCluster, __self__).__init__(
            'digitalocean:index/kubernetesCluster:KubernetesCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amd_gpu_device_metrics_exporter_plugin: Optional[pulumi.Input[Union['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs', 'KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgsDict']]] = None,
            amd_gpu_device_plugin: Optional[pulumi.Input[Union['KubernetesClusterAmdGpuDevicePluginArgs', 'KubernetesClusterAmdGpuDevicePluginArgsDict']]] = None,
            auto_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
            cluster_autoscaler_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterClusterAutoscalerConfigurationArgs', 'KubernetesClusterClusterAutoscalerConfigurationArgsDict']]]]] = None,
            cluster_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_urn: Optional[pulumi.Input[_builtins.str]] = None,
            control_plane_firewall: Optional[pulumi.Input[Union['KubernetesClusterControlPlaneFirewallArgs', 'KubernetesClusterControlPlaneFirewallArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            destroy_all_associated_resources: Optional[pulumi.Input[_builtins.bool]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            ha: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
            kube_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterKubeConfigArgs', 'KubernetesClusterKubeConfigArgsDict']]]]] = None,
            kubeconfig_expire_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            maintenance_policy: Optional[pulumi.Input[Union['KubernetesClusterMaintenancePolicyArgs', 'KubernetesClusterMaintenancePolicyArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_pool: Optional[pulumi.Input[Union['KubernetesClusterNodePoolArgs', 'KubernetesClusterNodePoolArgsDict']]] = None,
            region: Optional[pulumi.Input[Union[_builtins.str, 'Region']]] = None,
            registry_integration: Optional[pulumi.Input[_builtins.bool]] = None,
            routing_agent: Optional[pulumi.Input[Union['KubernetesClusterRoutingAgentArgs', 'KubernetesClusterRoutingAgentArgsDict']]] = None,
            service_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            surge_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'KubernetesCluster':
        """
        Get an existing KubernetesCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgs', 'KubernetesClusterAmdGpuDeviceMetricsExporterPluginArgsDict']] amd_gpu_device_metrics_exporter_plugin: Block containing options for the AMD GPU device metrics exporter component.
        :param pulumi.Input[Union['KubernetesClusterAmdGpuDevicePluginArgs', 'KubernetesClusterAmdGpuDevicePluginArgsDict']] amd_gpu_device_plugin: Block containing options for the AMD GPU device plugin component. If not specified, the component will be enabled by default for clusters with AMD GPU nodes.
        :param pulumi.Input[_builtins.bool] auto_upgrade: A boolean value indicating whether the cluster will be automatically upgraded to new patch releases during its maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterClusterAutoscalerConfigurationArgs', 'KubernetesClusterClusterAutoscalerConfigurationArgsDict']]]] cluster_autoscaler_configurations: Block containing options for cluster auto-scaling.
        :param pulumi.Input[_builtins.str] cluster_subnet: The range of IP addresses in the overlay network of the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        :param pulumi.Input[_builtins.str] cluster_urn: The uniform resource name (URN) for the Kubernetes cluster.
        :param pulumi.Input[Union['KubernetesClusterControlPlaneFirewallArgs', 'KubernetesClusterControlPlaneFirewallArgsDict']] control_plane_firewall: A block representing the cluster's control plane firewall
        :param pulumi.Input[_builtins.str] created_at: The date and time when the node was created.
        :param pulumi.Input[_builtins.bool] destroy_all_associated_resources: **Use with caution.** When set to true, all associated DigitalOcean resources created via the Kubernetes API (load balancers, volumes, and volume snapshots) will be destroyed along with the cluster when it is destroyed.
        :param pulumi.Input[_builtins.str] endpoint: The base URL of the API server on the Kubernetes master node.
        :param pulumi.Input[_builtins.bool] ha: Enable/disable the high availability control plane for a cluster. Once enabled for a cluster, high availability cannot be disabled. Default: false
        :param pulumi.Input[_builtins.str] ipv4_address: The public IPv4 address of the Kubernetes master node. This will not be set if high availability is configured on the cluster (v1.21+)
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterKubeConfigArgs', 'KubernetesClusterKubeConfigArgsDict']]]] kube_configs: A representation of the Kubernetes cluster's kubeconfig with the following attributes:
        :param pulumi.Input[_builtins.int] kubeconfig_expire_seconds: The duration in seconds that the returned Kubernetes credentials will be valid. If not set or 0, the credentials will have a 7 day expiry.
        :param pulumi.Input[Union['KubernetesClusterMaintenancePolicyArgs', 'KubernetesClusterMaintenancePolicyArgsDict']] maintenance_policy: A block representing the cluster's maintenance window. Updates will be applied within this window. If not specified, a default maintenance window will be chosen. `auto_upgrade` must be set to `true` for this to have an effect.
        :param pulumi.Input[_builtins.str] name: A name for the Kubernetes cluster.
        :param pulumi.Input[Union['KubernetesClusterNodePoolArgs', 'KubernetesClusterNodePoolArgsDict']] node_pool: A block representing the cluster's default node pool. Additional node pools may be added to the cluster using the `KubernetesNodePool` resource. The following arguments may be specified:
        :param pulumi.Input[Union[_builtins.str, 'Region']] region: The slug identifier for the region where the Kubernetes cluster will be created.
        :param pulumi.Input[_builtins.bool] registry_integration: Enables or disables the DigitalOcean container registry integration for the cluster. This requires that a container registry has first been created for the account. Default: false
        :param pulumi.Input[Union['KubernetesClusterRoutingAgentArgs', 'KubernetesClusterRoutingAgentArgsDict']] routing_agent: Block containing options for the routing-agent component. If not specified, the routing-agent component will not be installed in the cluster.
        :param pulumi.Input[_builtins.str] service_subnet: The range of assignable IP addresses for services running in the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        :param pulumi.Input[_builtins.str] status: A string indicating the current status of the individual node.
        :param pulumi.Input[_builtins.bool] surge_upgrade: Enable/disable surge upgrades for a cluster. Default: true
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag names to be applied to the Kubernetes cluster.
        :param pulumi.Input[_builtins.str] updated_at: The date and time when the node was last updated.
        :param pulumi.Input[_builtins.str] version: The slug identifier for the version of Kubernetes used for the cluster. Use [doctl](https://github.com/digitalocean/doctl) to find the available versions `doctl kubernetes options versions`. (**Note:** A cluster may only be upgraded to newer versions in-place. If the version is decreased, a new resource will be created.)
        :param pulumi.Input[_builtins.str] vpc_uuid: The ID of the VPC where the Kubernetes cluster will be located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesClusterState.__new__(_KubernetesClusterState)

        __props__.__dict__["amd_gpu_device_metrics_exporter_plugin"] = amd_gpu_device_metrics_exporter_plugin
        __props__.__dict__["amd_gpu_device_plugin"] = amd_gpu_device_plugin
        __props__.__dict__["auto_upgrade"] = auto_upgrade
        __props__.__dict__["cluster_autoscaler_configurations"] = cluster_autoscaler_configurations
        __props__.__dict__["cluster_subnet"] = cluster_subnet
        __props__.__dict__["cluster_urn"] = cluster_urn
        __props__.__dict__["control_plane_firewall"] = control_plane_firewall
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["destroy_all_associated_resources"] = destroy_all_associated_resources
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["ha"] = ha
        __props__.__dict__["ipv4_address"] = ipv4_address
        __props__.__dict__["kube_configs"] = kube_configs
        __props__.__dict__["kubeconfig_expire_seconds"] = kubeconfig_expire_seconds
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["node_pool"] = node_pool
        __props__.__dict__["region"] = region
        __props__.__dict__["registry_integration"] = registry_integration
        __props__.__dict__["routing_agent"] = routing_agent
        __props__.__dict__["service_subnet"] = service_subnet
        __props__.__dict__["status"] = status
        __props__.__dict__["surge_upgrade"] = surge_upgrade
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_uuid"] = vpc_uuid
        return KubernetesCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="amdGpuDeviceMetricsExporterPlugin")
    def amd_gpu_device_metrics_exporter_plugin(self) -> pulumi.Output['outputs.KubernetesClusterAmdGpuDeviceMetricsExporterPlugin']:
        """
        Block containing options for the AMD GPU device metrics exporter component.
        """
        return pulumi.get(self, "amd_gpu_device_metrics_exporter_plugin")

    @_builtins.property
    @pulumi.getter(name="amdGpuDevicePlugin")
    def amd_gpu_device_plugin(self) -> pulumi.Output['outputs.KubernetesClusterAmdGpuDevicePlugin']:
        """
        Block containing options for the AMD GPU device plugin component. If not specified, the component will be enabled by default for clusters with AMD GPU nodes.
        """
        return pulumi.get(self, "amd_gpu_device_plugin")

    @_builtins.property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean value indicating whether the cluster will be automatically upgraded to new patch releases during its maintenance window.
        """
        return pulumi.get(self, "auto_upgrade")

    @_builtins.property
    @pulumi.getter(name="clusterAutoscalerConfigurations")
    def cluster_autoscaler_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.KubernetesClusterClusterAutoscalerConfiguration']]]:
        """
        Block containing options for cluster auto-scaling.
        """
        return pulumi.get(self, "cluster_autoscaler_configurations")

    @_builtins.property
    @pulumi.getter(name="clusterSubnet")
    def cluster_subnet(self) -> pulumi.Output[_builtins.str]:
        """
        The range of IP addresses in the overlay network of the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        """
        return pulumi.get(self, "cluster_subnet")

    @_builtins.property
    @pulumi.getter(name="clusterUrn")
    def cluster_urn(self) -> pulumi.Output[_builtins.str]:
        """
        The uniform resource name (URN) for the Kubernetes cluster.
        """
        return pulumi.get(self, "cluster_urn")

    @_builtins.property
    @pulumi.getter(name="controlPlaneFirewall")
    def control_plane_firewall(self) -> pulumi.Output['outputs.KubernetesClusterControlPlaneFirewall']:
        """
        A block representing the cluster's control plane firewall
        """
        return pulumi.get(self, "control_plane_firewall")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the node was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="destroyAllAssociatedResources")
    def destroy_all_associated_resources(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        **Use with caution.** When set to true, all associated DigitalOcean resources created via the Kubernetes API (load balancers, volumes, and volume snapshots) will be destroyed along with the cluster when it is destroyed.
        """
        return pulumi.get(self, "destroy_all_associated_resources")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The base URL of the API server on the Kubernetes master node.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def ha(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable/disable the high availability control plane for a cluster. Once enabled for a cluster, high availability cannot be disabled. Default: false
        """
        return pulumi.get(self, "ha")

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Output[_builtins.str]:
        """
        The public IPv4 address of the Kubernetes master node. This will not be set if high availability is configured on the cluster (v1.21+)
        """
        return pulumi.get(self, "ipv4_address")

    @_builtins.property
    @pulumi.getter(name="kubeConfigs")
    def kube_configs(self) -> pulumi.Output[Sequence['outputs.KubernetesClusterKubeConfig']]:
        """
        A representation of the Kubernetes cluster's kubeconfig with the following attributes:
        """
        return pulumi.get(self, "kube_configs")

    @_builtins.property
    @pulumi.getter(name="kubeconfigExpireSeconds")
    def kubeconfig_expire_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration in seconds that the returned Kubernetes credentials will be valid. If not set or 0, the credentials will have a 7 day expiry.
        """
        return pulumi.get(self, "kubeconfig_expire_seconds")

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output['outputs.KubernetesClusterMaintenancePolicy']:
        """
        A block representing the cluster's maintenance window. Updates will be applied within this window. If not specified, a default maintenance window will be chosen. `auto_upgrade` must be set to `true` for this to have an effect.
        """
        return pulumi.get(self, "maintenance_policy")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A name for the Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodePool")
    def node_pool(self) -> pulumi.Output['outputs.KubernetesClusterNodePool']:
        """
        A block representing the cluster's default node pool. Additional node pools may be added to the cluster using the `KubernetesNodePool` resource. The following arguments may be specified:
        """
        return pulumi.get(self, "node_pool")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The slug identifier for the region where the Kubernetes cluster will be created.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registryIntegration")
    def registry_integration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables or disables the DigitalOcean container registry integration for the cluster. This requires that a container registry has first been created for the account. Default: false
        """
        return pulumi.get(self, "registry_integration")

    @_builtins.property
    @pulumi.getter(name="routingAgent")
    def routing_agent(self) -> pulumi.Output['outputs.KubernetesClusterRoutingAgent']:
        """
        Block containing options for the routing-agent component. If not specified, the routing-agent component will not be installed in the cluster.
        """
        return pulumi.get(self, "routing_agent")

    @_builtins.property
    @pulumi.getter(name="serviceSubnet")
    def service_subnet(self) -> pulumi.Output[_builtins.str]:
        """
        The range of assignable IP addresses for services running in the Kubernetes cluster. For more information, see [here](https://docs.digitalocean.com/products/kubernetes/how-to/create-clusters/#create-with-vpc-native).
        """
        return pulumi.get(self, "service_subnet")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        A string indicating the current status of the individual node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="surgeUpgrade")
    def surge_upgrade(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable/disable surge upgrades for a cluster. Default: true
        """
        return pulumi.get(self, "surge_upgrade")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of tag names to be applied to the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the node was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The slug identifier for the version of Kubernetes used for the cluster. Use [doctl](https://github.com/digitalocean/doctl) to find the available versions `doctl kubernetes options versions`. (**Note:** A cluster may only be upgraded to newer versions in-place. If the version is decreased, a new resource will be created.)
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC where the Kubernetes cluster will be located.
        """
        return pulumi.get(self, "vpc_uuid")

