# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectResourcesArgs', 'ProjectResources']

@pulumi.input_type
class ProjectResourcesArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 resources: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a ProjectResources resource.
        :param pulumi.Input[_builtins.str] project: the ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: a list of uniform resource names (URNs) for the resources associated with the project
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "resources", resources)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        the ID of the project
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        a list of uniform resource names (URNs) for the resources associated with the project
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class _ProjectResourcesState:
    def __init__(__self__, *,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ProjectResources resources.
        :param pulumi.Input[_builtins.str] project: the ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: a list of uniform resource names (URNs) for the resources associated with the project
        """
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the ID of the project
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        a list of uniform resource names (URNs) for the resources associated with the project
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.type_token("digitalocean:index/projectResources:ProjectResources")
class ProjectResources(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Assign resources to a DigitalOcean Project. This is useful if you need to assign resources
        managed via this provider to a DigitalOcean Project managed outside of the provider.

        The following resource types can be associated with a project:

        * App Platform Apps
        * Database Clusters
        * Domains
        * Droplets
        * Floating IPs
        * Kubernetes Clusters
        * Load Balancers
        * Spaces Buckets
        * Volumes

        ## Example Usage

        The following example assigns a droplet to a Project managed outside of the provider:

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        playground = digitalocean.get_project(name="playground")
        foobar = digitalocean.Droplet("foobar",
            name="example",
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            image="ubuntu-22-04-x64",
            region=digitalocean.Region.NYC3)
        barfoo = digitalocean.ProjectResources("barfoo",
            project=playground.id,
            resources=[foobar.droplet_urn])
        ```

        ## Import

        Importing this resource is not supported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] project: the ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: a list of uniform resource names (URNs) for the resources associated with the project
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectResourcesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Assign resources to a DigitalOcean Project. This is useful if you need to assign resources
        managed via this provider to a DigitalOcean Project managed outside of the provider.

        The following resource types can be associated with a project:

        * App Platform Apps
        * Database Clusters
        * Domains
        * Droplets
        * Floating IPs
        * Kubernetes Clusters
        * Load Balancers
        * Spaces Buckets
        * Volumes

        ## Example Usage

        The following example assigns a droplet to a Project managed outside of the provider:

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        playground = digitalocean.get_project(name="playground")
        foobar = digitalocean.Droplet("foobar",
            name="example",
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            image="ubuntu-22-04-x64",
            region=digitalocean.Region.NYC3)
        barfoo = digitalocean.ProjectResources("barfoo",
            project=playground.id,
            resources=[foobar.droplet_urn])
        ```

        ## Import

        Importing this resource is not supported.

        :param str resource_name: The name of the resource.
        :param ProjectResourcesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectResourcesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectResourcesArgs.__new__(ProjectResourcesArgs)

            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if resources is None and not opts.urn:
                raise TypeError("Missing required property 'resources'")
            __props__.__dict__["resources"] = resources
        super(ProjectResources, __self__).__init__(
            'digitalocean:index/projectResources:ProjectResources',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ProjectResources':
        """
        Get an existing ProjectResources resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] project: the ID of the project
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: a list of uniform resource names (URNs) for the resources associated with the project
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectResourcesState.__new__(_ProjectResourcesState)

        __props__.__dict__["project"] = project
        __props__.__dict__["resources"] = resources
        return ProjectResources(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        the ID of the project
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        a list of uniform resource names (URNs) for the resources associated with the project
        """
        return pulumi.get(self, "resources")

