# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ReservedIpv6Args', 'ReservedIpv6']

@pulumi.input_type
class ReservedIpv6Args:
    def __init__(__self__, *,
                 region_slug: pulumi.Input[_builtins.str],
                 droplet_id: Optional[pulumi.Input[_builtins.int]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ReservedIpv6 resource.
        :param pulumi.Input[_builtins.str] region_slug: The region that the reserved IPv6 needs to be reserved to.
        """
        pulumi.set(__self__, "region_slug", region_slug)
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter(name="regionSlug")
    def region_slug(self) -> pulumi.Input[_builtins.str]:
        """
        The region that the reserved IPv6 needs to be reserved to.
        """
        return pulumi.get(self, "region_slug")

    @region_slug.setter
    def region_slug(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region_slug", value)

    @_builtins.property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "droplet_id")

    @droplet_id.setter
    def droplet_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "droplet_id", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class _ReservedIpv6State:
    def __init__(__self__, *,
                 droplet_id: Optional[pulumi.Input[_builtins.int]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region_slug: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ipv6_urn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReservedIpv6 resources.
        :param pulumi.Input[_builtins.str] region_slug: The region that the reserved IPv6 needs to be reserved to.
        :param pulumi.Input[_builtins.str] reserved_ipv6_urn: the uniform resource name for the reserved ipv6
        """
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if region_slug is not None:
            pulumi.set(__self__, "region_slug", region_slug)
        if reserved_ipv6_urn is not None:
            pulumi.set(__self__, "reserved_ipv6_urn", reserved_ipv6_urn)

    @_builtins.property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "droplet_id")

    @droplet_id.setter
    def droplet_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "droplet_id", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="regionSlug")
    def region_slug(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region that the reserved IPv6 needs to be reserved to.
        """
        return pulumi.get(self, "region_slug")

    @region_slug.setter
    def region_slug(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_slug", value)

    @_builtins.property
    @pulumi.getter(name="reservedIpv6Urn")
    def reserved_ipv6_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the uniform resource name for the reserved ipv6
        """
        return pulumi.get(self, "reserved_ipv6_urn")

    @reserved_ipv6_urn.setter
    def reserved_ipv6_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_ipv6_urn", value)


@pulumi.type_token("digitalocean:index/reservedIpv6:ReservedIpv6")
class ReservedIpv6(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 droplet_id: Optional[pulumi.Input[_builtins.int]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region_slug: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DigitalOcean reserved IPv6 to represent a publicly-accessible static IPv6 addresses that can be mapped to one of your Droplets.

        > **NOTE:** Reserved IPv6s can be assigned to a Droplet using
        `ReservedIpv6Assignment` resource only.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        foobar = digitalocean.ReservedIpv6("foobar", region_slug="nyc3")
        ```

        ## Import

        Reserved IPv6s can be imported using the `ip`, e.g.

        ```sh
        $ pulumi import digitalocean:index/reservedIpv6:ReservedIpv6 myip 
        ```

        2409:40d0:fa:27dd:9b24:7074:7b85:eee6

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region_slug: The region that the reserved IPv6 needs to be reserved to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReservedIpv6Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DigitalOcean reserved IPv6 to represent a publicly-accessible static IPv6 addresses that can be mapped to one of your Droplets.

        > **NOTE:** Reserved IPv6s can be assigned to a Droplet using
        `ReservedIpv6Assignment` resource only.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        foobar = digitalocean.ReservedIpv6("foobar", region_slug="nyc3")
        ```

        ## Import

        Reserved IPv6s can be imported using the `ip`, e.g.

        ```sh
        $ pulumi import digitalocean:index/reservedIpv6:ReservedIpv6 myip 
        ```

        2409:40d0:fa:27dd:9b24:7074:7b85:eee6

        :param str resource_name: The name of the resource.
        :param ReservedIpv6Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReservedIpv6Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 droplet_id: Optional[pulumi.Input[_builtins.int]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region_slug: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReservedIpv6Args.__new__(ReservedIpv6Args)

            __props__.__dict__["droplet_id"] = droplet_id
            __props__.__dict__["ip"] = ip
            if region_slug is None and not opts.urn:
                raise TypeError("Missing required property 'region_slug'")
            __props__.__dict__["region_slug"] = region_slug
            __props__.__dict__["reserved_ipv6_urn"] = None
        super(ReservedIpv6, __self__).__init__(
            'digitalocean:index/reservedIpv6:ReservedIpv6',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            droplet_id: Optional[pulumi.Input[_builtins.int]] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            region_slug: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_ipv6_urn: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReservedIpv6':
        """
        Get an existing ReservedIpv6 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region_slug: The region that the reserved IPv6 needs to be reserved to.
        :param pulumi.Input[_builtins.str] reserved_ipv6_urn: the uniform resource name for the reserved ipv6
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReservedIpv6State.__new__(_ReservedIpv6State)

        __props__.__dict__["droplet_id"] = droplet_id
        __props__.__dict__["ip"] = ip
        __props__.__dict__["region_slug"] = region_slug
        __props__.__dict__["reserved_ipv6_urn"] = reserved_ipv6_urn
        return ReservedIpv6(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "droplet_id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="regionSlug")
    def region_slug(self) -> pulumi.Output[_builtins.str]:
        """
        The region that the reserved IPv6 needs to be reserved to.
        """
        return pulumi.get(self, "region_slug")

    @_builtins.property
    @pulumi.getter(name="reservedIpv6Urn")
    def reserved_ipv6_urn(self) -> pulumi.Output[_builtins.str]:
        """
        the uniform resource name for the reserved ipv6
        """
        return pulumi.get(self, "reserved_ipv6_urn")

