from pydantic import BaseModel, Field


class GlobalConfig(BaseModel, validate_assignment=True):
    """Global configuration for the generated SDK.

    Args:
        validate_retrieve (bool): Whether to validate the data retrieved from the CDF. Defaults to True.
            Note setting this to False can lead to unexpected behavior if required fields are missing
            or have the wrong type.
        max_select_depth (int): The maximum depth of select queries. Defaults to 4.

    """

    validate_retrieve: bool = True
    max_select_depth: int = Field(3, ge=1)


global_config = GlobalConfig()
