#!/usr/bin/env python3
from nicegui import ui
from biblemategui import config, BIBLEMATEGUI_APP_DIR
from biblemategui.pages.home import *
import os

# Home Page

@ui.page('/')
def page_home(
    t: str | None = None, # Token for using custom data: allow users to pass a custom token, which won't be stored, via a parameter when using public devices. For personal devices, enable persistent settings using `custom_token`.
    k: bool | None = True, # keep valid specified parameters in history
    m: bool | None = True, # display menu
    l: int | None = None, # layout; either: 1 (bible area only) or 2 (bible & tool areas) or 3 (tool area only)
    bbt: str | None = None, # bible bible text
    bb: int | None = None, # bible book
    bc: int | None = None, # bible chapter
    bv: int | None = None, # bible verse
    tbt: str | None = None, # tool bible text
    tb: int | None = None, # tool book
    tc: int | None = None, # tool chapter
    tv: int | None = None, # tool verse
    tool: str | None = None, # supported options: bible, ...
):
    """
    Home page that accepts optional parameters.
    Example: /?bb=1&bc=1&bv=1
    """

    # manage custom resources
    if not config.custom_token or (t and t == config.custom_token) or (app.storage.user.setdefault('custom_token', "") == config.custom_token):
        app.storage.client["custom"] = True # short-term memory (single page visit)

    # Use app.storage.user to store session-specific state
    # This keeps the settings unique for each user
    app.storage.user.setdefault('left_drawer_open', False)
    app.storage.user.setdefault('sync', True) # TODO - add disable sync option later

    if l is not None and l in (1, 2, 3):
        app.storage.user['layout'] = l
    else:
        l = app.storage.user.setdefault('layout', 2)

    if bbt is not None:
        app.storage.user['bible_book_text'] = bbt
    else:
        bbt = app.storage.user.setdefault('bible_book_text', "NET")
    if bb is not None:
        app.storage.user['bible_book_number'] = bb
    else:
        bb = app.storage.user.setdefault('bible_book_number', 1)
    if bc is not None:
        app.storage.user['bible_chapter_number'] = bc
    else:
        bc = app.storage.user.setdefault('bible_chapter_number', 1)
    if bv is not None:
        app.storage.user['bible_verse_number'] = bv
    else:
        bv = app.storage.user.setdefault('bible_verse_number', 1)
    if tbt is not None:
        app.storage.user['tool_book_text'] = tbt
    else:
        tbt = app.storage.user.setdefault('tool_book_text', "KJV")
    if tb is not None:
        app.storage.user['tool_book_number'] = tb
    else:
        tb = app.storage.user.setdefault('tool_book_number', 1)
    if tc is not None:
        app.storage.user['tool_chapter_number'] = tc
    else:
        tc = app.storage.user.setdefault('tool_chapter_number', 1)
    if tv is not None:
        app.storage.user['tool_verse_number'] = tv
    else:
        tv = app.storage.user.setdefault('tool_verse_number', 1)
        
    gui = BibleMateGUI()
    
    # navigation menu
    if m:
        gui.create_menu() # Add the shared menu
    # main content
    gui.create_home_layout()

    # load bible content at start
    if bb and bc and bv:
        next_tab_num = gui.area1_tab_loaded + 1
        if next_tab_num > gui.area1_tab_counter:
            gui.add_tab_area1()
        gui.load_area_1_content(title=bbt, keep=k)
    elif not gui.area1_tab_loaded: # when nothing is loaded
        gui.load_area_1_content(title="NET")
    
    # load tool content at start
    if tool:
        next_tab_num = gui.area2_tab_loaded + 1
        if next_tab_num > gui.area2_tab_counter:
            gui.add_tab_area2()
        gui.load_area_2_content(title=tbt if tool == "bible" else tool, keep=k)
    elif not gui.area2_tab_loaded: # when nothing is loaded
        ... # TODO - decides later

# Settings

@ui.page('/settings')
def page_Settings(q: str | None = None, m: bool = True):
    if m:
        BibleMateGUI().create_menu()
    with ui.column().classes('w-full items-center'):
        ui.label('BibleMate AI').classes('text-2xl mt-4')
        ui.notify("This feature is currently in progress.")

# Entry_point

def main():
    # --- Run the App ---
    # Make sure to replace the secret!
    ui.run(
        reload=config.hot_reload,
        storage_secret=config.storage_secret, # e.g. generate one by running `openssl rand -hex 32` or `openssl rand -base64 32`
        port=config.port,
        title='BibleMate AI',
        favicon=config.avatar if config.avatar else os.path.join(BIBLEMATEGUI_APP_DIR, 'eliranwong.jpg')
    )

main()