# coding: utf-8

"""
    AI Hub API

    The AI Hub REST API. Please see https://platform.instabase.com/docs/aihub/ for more details.

    The version of the OpenAPI document: 0.1
    Contact: support@instabase.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class BatchInfo(BaseModel):
    """
    BatchInfo
    """ # noqa: E501
    id: StrictInt = Field(description="The batch's unique identifier.")
    name: StrictStr = Field(description="The batch's name.")
    workspace: Optional[StrictStr] = Field(default=None, description="The name of the workspace in which the batch exists.")
    mount_point: Optional[StrictStr] = Field(default=None, description="The name of the connected drive in which the batch is stored.")
    repo_owner: Optional[StrictStr] = Field(default=None, description="The owner of the workspace (also known as the repo) in which the batch exists.")
    batch_owner: Optional[StrictStr] = Field(default=None, description="Username of the user that created the batch.")
    created_at_ms: Optional[StrictInt] = Field(default=None, description="When the batch was created, in Unix time.")
    updated_at_ms: Optional[StrictInt] = Field(default=None, description="When the batch was last updated, in Unix time.")
    path_suffix: Optional[StrictStr] = Field(default=None, description="Batch path suffix from the mount point.")
    __properties: ClassVar[List[str]] = ["id", "name", "workspace", "mount_point", "repo_owner", "batch_owner", "created_at_ms", "updated_at_ms", "path_suffix"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of BatchInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of BatchInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "workspace": obj.get("workspace"),
            "mount_point": obj.get("mount_point"),
            "repo_owner": obj.get("repo_owner"),
            "batch_owner": obj.get("batch_owner"),
            "created_at_ms": obj.get("created_at_ms"),
            "updated_at_ms": obj.get("updated_at_ms"),
            "path_suffix": obj.get("path_suffix")
        })
        return _obj


