# coding: utf-8

"""
    AI Hub API

    The AI Hub REST API. Please see https://platform.instabase.com/docs/aihub/ for more details.

    The version of the OpenAPI document: 0.1
    Contact: support@instabase.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
from aihub.models.document_field import DocumentField
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Document(BaseModel):
    """
    Document
    """ # noqa: E501
    fields: Optional[Dict[str, DocumentField]] = None
    review_completed: Optional[StrictBool] = Field(default=None, description="Whether manual review has been completed.")
    class_name: Optional[StrictStr] = Field(default=None, description="The classification label of the document.")
    post_processed_paths: Optional[List[StrictStr]] = Field(default=None, description="The paths to the post-processed documents.")
    __properties: ClassVar[List[str]] = ["fields", "review_completed", "class_name", "post_processed_paths"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Document from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in fields (dict)
        _field_dict = {}
        if self.fields:
            for _key in self.fields:
                if self.fields[_key]:
                    _field_dict[_key] = self.fields[_key].to_dict()
            _dict['fields'] = _field_dict
        # set to None if class_name (nullable) is None
        # and model_fields_set contains the field
        if self.class_name is None and "class_name" in self.model_fields_set:
            _dict['class_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Document from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fields": dict(
                (_k, DocumentField.from_dict(_v))
                for _k, _v in obj.get("fields").items()
            )
            if obj.get("fields") is not None
            else None,
            "review_completed": obj.get("review_completed"),
            "class_name": obj.get("class_name"),
            "post_processed_paths": obj.get("post_processed_paths")
        })
        return _obj


