# coding: utf-8

"""
    AI Hub API

    The AI Hub REST API. Please see https://platform.instabase.com/docs/aihub/ for more details.

    The version of the OpenAPI document: 0.1
    Contact: support@instabase.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
from aihub.models.document_field_confidence import DocumentFieldConfidence
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DocumentField(BaseModel):
    """
    DocumentField
    """ # noqa: E501
    value: Optional[StrictStr] = Field(default=None, description="The extracted value of the field.")
    type: Optional[StrictStr] = Field(default=None, description="The type of the field.")
    confidence: Optional[DocumentFieldConfidence] = None
    __properties: ClassVar[List[str]] = ["value", "type", "confidence"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DocumentField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of confidence
        if self.confidence:
            _dict['confidence'] = self.confidence.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DocumentField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "value": obj.get("value"),
            "type": obj.get("type"),
            "confidence": DocumentFieldConfidence.from_dict(obj.get("confidence")) if obj.get("confidence") is not None else None
        })
        return _obj


