# coding: utf-8

"""
    AI Hub API

    The AI Hub REST API. Please see https://platform.instabase.com/docs/aihub/ for more details.

    The version of the OpenAPI document: 0.1
    Contact: support@instabase.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, field_validator
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Run(BaseModel):
    """
    Run
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Job ID.")
    status: Optional[StrictStr] = Field(default=None, description="The current state of the run.")
    start_timestamp: Optional[StrictInt] = Field(default=None, description="10-digit Unix timestamp of Job start.")
    finish_timestamp: Optional[StrictInt] = Field(default=None, description="10-digit Unix timestamp of Job end. Null if still running.")
    msg: Optional[StrictStr] = Field(default=None, description="Job error message. Present if status equals ERROR.")
    __properties: ClassVar[List[str]] = ["id", "status", "start_timestamp", "finish_timestamp", "msg"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('RUNNING', 'COMPLETE', 'PAUSED', 'FAILED', 'CANCELLED', 'STOPPED_AT_CHECKPOINT'):
            raise ValueError("must be one of enum values ('RUNNING', 'COMPLETE', 'PAUSED', 'FAILED', 'CANCELLED', 'STOPPED_AT_CHECKPOINT')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Run from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if finish_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.finish_timestamp is None and "finish_timestamp" in self.model_fields_set:
            _dict['finish_timestamp'] = None

        # set to None if msg (nullable) is None
        # and model_fields_set contains the field
        if self.msg is None and "msg" in self.model_fields_set:
            _dict['msg'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Run from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "start_timestamp": obj.get("start_timestamp"),
            "finish_timestamp": obj.get("finish_timestamp"),
            "msg": obj.get("msg")
        })
        return _obj


